/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Dimensionable;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class ASTFieldDeclarationTest
extends ParserTst {
    private static final String TEST1 = "class Foo {" + PMD.EOL + " String[] foo;" + PMD.EOL + "}";
    private static final String TEST2 = "class Foo {" + PMD.EOL + " String[][][] foo;" + PMD.EOL + "}";
    private static final String TEST3 = "interface Foo {" + PMD.EOL + " int BAR = 6;" + PMD.EOL + "}";
    private static final String TEST4 = "public enum Foo {" + PMD.EOL + " FOO(1);" + PMD.EOL + " private int x;" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$ASTFieldDeclarationTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;

    @org.junit.Test
    public void testIsArray() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST1));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        Dimensionable node = (Dimensionable)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertTrue((boolean)node.isArray());
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)node.getArrayDepth()));
    }

    @org.junit.Test
    public void testMultiDimensionalArray() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST2));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        Dimensionable node = (Dimensionable)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)node.getArrayDepth()));
    }

    @org.junit.Test
    public void testIsSyntacticallyPublic() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST3));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        ASTFieldDeclaration node = (ASTFieldDeclaration)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertFalse((boolean)node.isSyntacticallyPublic());
        Assert.assertFalse((boolean)node.isPackagePrivate());
        Assert.assertFalse((boolean)node.isPrivate());
        Assert.assertFalse((boolean)node.isProtected());
        Assert.assertTrue((boolean)node.isFinal());
        Assert.assertTrue((boolean)node.isStatic());
        Assert.assertTrue((boolean)node.isPublic());
    }

    @org.junit.Test
    public void testWithEnum() {
        JavaParser parser = new TargetJDK1_5().createParser((Reader)new StringReader(TEST4));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        ASTFieldDeclaration node = (ASTFieldDeclaration)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertFalse((boolean)node.isInterfaceMember());
    }

    @org.junit.Test
    public void testGetVariableName() {
        int id = 0;
        ASTFieldDeclaration n = new ASTFieldDeclaration(id++);
        ASTType t = new ASTType(id++);
        ASTVariableDeclarator decl = new ASTVariableDeclarator(id++);
        ASTVariableDeclaratorId declid = new ASTVariableDeclaratorId(id++);
        n.jjtAddChild((Node)t, 0);
        t.jjtAddChild((Node)decl, 0);
        decl.jjtAddChild((Node)declid, 0);
        declid.setImage("foo");
        Assert.assertEquals((Object)"foo", (Object)n.getVariableName());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$ASTFieldDeclarationTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$ASTFieldDeclarationTest = new ASTFieldDeclarationTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

