/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.RuleTst;

public class SuppressWarningsTest
extends RuleTst {
    private static final String TEST1 = "@SuppressWarnings(\"PMD\")" + PMD.EOL + "public class Foo {}";
    private static final String TEST2 = "@SuppressWarnings(\"PMD\")" + PMD.EOL + "public class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST3 = "public class Baz {" + PMD.EOL + " @SuppressWarnings(\"PMD\")" + PMD.EOL + " public class Bar {" + PMD.EOL + "  void bar() {" + PMD.EOL + "   int foo;" + PMD.EOL + "  }" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST4 = "public class Foo {" + PMD.EOL + " @SuppressWarnings(\"PMD\")" + PMD.EOL + " void bar() {" + PMD.EOL + "  int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST5 = "public class Bar {" + PMD.EOL + " @SuppressWarnings(\"PMD\")" + PMD.EOL + " public Bar() {" + PMD.EOL + "  int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST6 = "public class Bar {" + PMD.EOL + " @SuppressWarnings(\"PMD\")" + PMD.EOL + " int foo;" + PMD.EOL + " void bar() {" + PMD.EOL + "  int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST7 = "public class Bar {" + PMD.EOL + " int foo;" + PMD.EOL + " void bar(@SuppressWarnings(\"PMD\") int foo) {}" + PMD.EOL + "}";
    private static final String TEST8 = "public class Bar {" + PMD.EOL + " int foo;" + PMD.EOL + " void bar() {" + PMD.EOL + "  @SuppressWarnings(\"PMD\") int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST9 = "public class Bar {" + PMD.EOL + " int foo;" + PMD.EOL + " void bar() {" + PMD.EOL + "  @SuppressWarnings(\"PMD.NoFoo\") int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST10 = "public class Bar {" + PMD.EOL + " int foo;" + PMD.EOL + " void bar() {" + PMD.EOL + "  @SuppressWarnings(\"\") int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST11 = "public class Bar {" + PMD.EOL + " int foo;" + PMD.EOL + " void bar() {" + PMD.EOL + "  @SuppressWarnings(\"SomethingElse\") int foo;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$SuppressWarningsTest;

    @org.junit.Test
    public void testClassLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST1, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rpt.size()));
        this.runTestFromString(TEST2, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testInheritedSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST3, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testMethodLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST4, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testConstructorLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST5, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testFieldLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST6, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testParameterLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST7, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testLocalVariableLevelSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST8, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testSpecificSuppression() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST9, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testNoSuppressionBlank() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST10, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)rpt.size()));
    }

    @org.junit.Test
    public void testNoSuppressionSomethingElseS() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST11, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)rpt.size()));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$SuppressWarningsTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$SuppressWarningsTest = new SuppressWarningsTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    private static class FooRule
    extends AbstractRule {
        private FooRule() {
        }

        public Object visit(ASTClassOrInterfaceDeclaration c, Object ctx) {
            if (c.getImage().equalsIgnoreCase("Foo")) {
                this.addViolation(ctx, (SimpleNode)c);
            }
            return super.visit(c, ctx);
        }

        public Object visit(ASTVariableDeclaratorId c, Object ctx) {
            if (c.getImage().equalsIgnoreCase("Foo")) {
                this.addViolation(ctx, (SimpleNode)c);
            }
            return super.visit(c, ctx);
        }

        public String getName() {
            return "NoFoo";
        }
    }
}

