/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;
import test.net.sourceforge.pmd.testframework.MockRule;

public class RuleSetTest {
    private String javaCode = "public class Test { }";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$RuleSetTest;

    @Test
    public void testNoDFA() {
        RuleSet rs = new RuleSet();
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        rs.addRule((Rule)mock);
        Assert.assertFalse((boolean)rs.usesDFA());
    }

    @Test
    public void testIncludesRuleWithDFA() {
        RuleSet rs = new RuleSet();
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        mock.setUsesDFA();
        rs.addRule((Rule)mock);
        Assert.assertTrue((boolean)rs.usesDFA());
    }

    @Test
    public void testAccessors() {
        RuleSet rs = new RuleSet();
        rs.setName("foo");
        Assert.assertEquals((String)"name mismatch", (Object)"foo", (Object)rs.getName());
        rs.setDescription("bar");
        Assert.assertEquals((String)"description mismatch", (Object)"bar", (Object)rs.getDescription());
    }

    @Test
    public void testGetRuleByName() {
        RuleSet rs = new RuleSet();
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        rs.addRule((Rule)mock);
        Assert.assertEquals((String)"unable to fetch rule by name", (Object)mock, (Object)rs.getRuleByName("name"));
    }

    @Test
    public void testGetRuleByName2() {
        RuleSet rs = new RuleSet();
        MockRule mock = new MockRule("name", "desc", "msg", "rulesetname");
        rs.addRule((Rule)mock);
        Assert.assertNull((String)"the rule FooRule must not be found!", (Object)rs.getRuleByName("FooRule"));
    }

    @Test
    public void testRuleList() {
        RuleSet IUT = new RuleSet();
        Assert.assertEquals((String)"Size of RuleSet isn't zero.", (Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)IUT.size()));
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        IUT.addRule((Rule)rule);
        Assert.assertEquals((String)"Size of RuleSet isn't one.", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)IUT.size()));
        Collection rules = IUT.getRules();
        Iterator i = rules.iterator();
        Assert.assertTrue((String)"Empty Set", (boolean)i.hasNext());
        Assert.assertEquals((String)"Returned set of wrong size.", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rules.size()));
        Assert.assertEquals((String)"Rule isn't in ruleset.", (Object)rule, i.next());
    }

    @Test
    public void testAddRuleSet() {
        RuleSet set1 = new RuleSet();
        set1.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        RuleSet set2 = new RuleSet();
        set2.addRule((Rule)new MockRule("name2", "desc", "msg", "rulesetname"));
        set1.addRuleSet(set2);
        Assert.assertEquals((String)"ruleset size wrong", (Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)set1.size()));
    }

    @Test
    public void testApply0Rules() throws Throwable {
        RuleSet IUT = new RuleSet();
        this.verifyRuleSet(IUT, 0, new HashSet());
    }

    @Test
    public void testEquals1() {
        RuleSet s = new RuleSet();
        Assert.assertFalse((String)"A ruleset cannot be equals to null", (boolean)s.equals(null));
    }

    @Test
    public void testEquals2() {
        RuleSet s = new RuleSet();
        Assert.assertTrue((String)"A rulset must be equals to itself", (boolean)s.equals((Object)s));
    }

    @Test
    public void testEquals3() {
        RuleSet s = new RuleSet();
        s.setName("basic rules");
        Assert.assertFalse((String)"A ruleset cannot be equals to another kind of object", (boolean)s.equals((Object)"basic rules"));
    }

    @Test
    public void testEquals4() {
        RuleSet s1 = new RuleSet();
        s1.setName("my ruleset");
        s1.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        RuleSet s2 = new RuleSet();
        s2.setName("my ruleset");
        s2.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        Assert.assertEquals((String)"2 rulesets with same name and rules must be equals", (Object)s1, (Object)s2);
        Assert.assertEquals((String)"Equals rulesets must have the same hashcode", (Object)Integer_.valueOf((int)s1.hashCode()), (Object)Integer_.valueOf((int)s2.hashCode()));
    }

    @Test
    public void testEquals5() {
        RuleSet s1 = new RuleSet();
        s1.setName("my ruleset");
        s1.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        RuleSet s2 = new RuleSet();
        s2.setName("my other ruleset");
        s2.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        Assert.assertFalse((String)"2 rulesets with different name but same rules must not be equals", (boolean)s1.equals((Object)s2));
    }

    @Test
    public void testEquals6() {
        RuleSet s1 = new RuleSet();
        s1.setName("my ruleset");
        s1.addRule((Rule)new MockRule("name", "desc", "msg", "rulesetname"));
        RuleSet s2 = new RuleSet();
        s2.setName("my ruleset");
        s2.addRule((Rule)new MockRule("other rule", "desc", "msg", "rulesetname"));
        Assert.assertFalse((String)"2 rulesets with same name but different rules must not be equals", (boolean)s1.equals((Object)s2));
    }

    protected void verifyRuleSet(RuleSet IUT, int size, Set values) throws Throwable {
        RuleContext context = new RuleContext();
        HashSet<RuleViolation> reportedValues = new HashSet<RuleViolation>();
        context.setReport(new Report());
        IUT.apply(this.makeCompilationUnits(), context);
        Assert.assertEquals((String)"Invalid number of Violations Reported", (Object)Integer_.valueOf((int)size), (Object)Integer_.valueOf((int)context.getReport().size()));
        Iterator violations = context.getReport().iterator();
        while (violations.hasNext()) {
            RuleViolation violation = (RuleViolation)violations.next();
            reportedValues.add(violation);
            Assert.assertTrue((String)("Unexpected Violation Returned: " + violation), (boolean)values.contains(violation));
        }
        Iterator expected = values.iterator();
        while (expected.hasNext()) {
            RuleViolation violation = (RuleViolation)expected.next();
            Assert.assertTrue((String)("Expected Violation not Returned: " + violation), (boolean)reportedValues.contains(violation));
        }
    }

    protected List makeCompilationUnits() throws Throwable {
        ArrayList<ASTCompilationUnit> RC = new ArrayList<ASTCompilationUnit>();
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(this.javaCode));
        RC.add(parser.CompilationUnit());
        return RC;
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$RuleSetTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$RuleSetTest = new RuleSetTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

