/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.rules.UnusedLocalVariableRule;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;

public class RuleSetFactoryTest {
    private static final String REF_OVERRIDE_ORIGINAL_NAME = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + " <description>testdesc</description>" + PMD.EOL + " <rule " + PMD.EOL + "  ref=\"rulesets/unusedcode.xml/UnusedLocalVariable\" message=\"TestMessageOverride\"> " + PMD.EOL + " </rule>" + PMD.EOL + "</ruleset>";
    private static final String REF_MISPELLED_XREF = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + " <description>testdesc</description>" + PMD.EOL + " <rule " + PMD.EOL + "  ref=\"rulesets/unusedcode.xml/FooUnusedLocalVariable\"> " + PMD.EOL + " </rule>" + PMD.EOL + "</ruleset>";
    private static final String REF_OVERRIDE_ORIGINAL_NAME_ONE_ELEM = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + " <description>testdesc</description>" + PMD.EOL + " <rule ref=\"rulesets/unusedcode.xml/UnusedLocalVariable\" message=\"TestMessageOverride\"/> " + PMD.EOL + "</ruleset>";
    private static final String REF_OVERRIDE = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + " <description>testdesc</description>" + PMD.EOL + " <rule " + PMD.EOL + "  ref=\"rulesets/unusedcode.xml/UnusedLocalVariable\" " + PMD.EOL + "  name=\"TestNameOverride\" " + PMD.EOL + "  message=\"Test message override\"> " + PMD.EOL + "  <description>Test description override</description>" + PMD.EOL + "  <example>Test example override</example>" + PMD.EOL + "  <priority>3</priority>" + PMD.EOL + "  <properties>" + PMD.EOL + "   <property name=\"test2\" value=\"override2\"/>" + PMD.EOL + "   <property name=\"test3\"><value>override3</value></property>" + PMD.EOL + "   <property name=\"test4\" value=\"new property\"/>" + PMD.EOL + "  </properties>" + PMD.EOL + " </rule>" + PMD.EOL + "</ruleset>";
    private static final String EMPTY_RULESET = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "</ruleset>";
    private static final String SINGLE_RULE = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule " + PMD.EOL + "name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + "<priority>3</priority>" + PMD.EOL + "</rule></ruleset>";
    private static final String MULTIPLE_RULES = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule name=\"MockRuleName1\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + PMD.EOL + "</rule>" + PMD.EOL + "<rule name=\"MockRuleName2\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + PMD.EOL + "</rule></ruleset>";
    private static final String PROPERTIES = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + PMD.EOL + "<description>testdesc2</description>" + PMD.EOL + "<properties>" + PMD.EOL + "<property name=\"fooBoolean\" value=\"true\"/>" + PMD.EOL + "<property name=\"fooDouble\" value=\"1.0\" />" + PMD.EOL + "<property name=\"foo\" value=\"bar\"/>" + PMD.EOL + "<property name=\"fooint\" value=\"2\"/>" + PMD.EOL + "</properties>" + PMD.EOL + "</rule></ruleset>";
    private static final String XPATH = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<priority>3</priority>" + PMD.EOL + "<rule name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + PMD.EOL + "<description>testdesc2</description>" + PMD.EOL + "<properties>" + PMD.EOL + "<property name=\"xpath\">" + PMD.EOL + "<value>" + PMD.EOL + "<![CDATA[ //Block ]]>" + PMD.EOL + "</value>" + PMD.EOL + "</property>" + PMD.EOL + "</properties>" + PMD.EOL + "</rule></ruleset>";
    private static final String XPATH_PLUGINNAME = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<priority>3</priority>" + PMD.EOL + "<rule name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + PMD.EOL + "<description>testdesc2</description>" + PMD.EOL + "<properties>" + PMD.EOL + "<property name=\"xpath\" pluginname=\"true\">" + PMD.EOL + "<value>" + PMD.EOL + "<![CDATA[ //Block ]]>" + PMD.EOL + "</value>" + PMD.EOL + "</property>" + PMD.EOL + "</properties>" + PMD.EOL + "</rule></ruleset>";
    private static final String PRIORITY = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule " + PMD.EOL + "name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + "<priority>3</priority>" + PMD.EOL + "</rule></ruleset>";
    private static final String DFA = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule " + PMD.EOL + "name=\"MockRuleName\" " + PMD.EOL + "message=\"avoid the mock rule\" " + PMD.EOL + "dfa=\"true\" " + PMD.EOL + "class=\"test.net.sourceforge.pmd.testframework.MockRule\">" + "<priority>3</priority>" + PMD.EOL + "</rule></ruleset>";
    private static final String EXTERNAL_REFERENCE_RULE_SET = "<?xml version=\"1.0\"?>" + PMD.EOL + "<ruleset name=\"test\">" + PMD.EOL + "<description>testdesc</description>" + PMD.EOL + "<rule ref=\"rulesets/unusedcode.xml/UnusedLocalVariable\"/>" + PMD.EOL + "</ruleset>";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$rules$UnusedLocalVariableRule;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$RuleSetFactoryTest;

    @org.junit.Test
    public void testRefs() throws Throwable {
        InputStream in = ResourceLoader.loadResourceAsStream((String)"rulesets/favorites.xml", (ClassLoader)this.getClass().getClassLoader());
        if (in == null) {
            throw new RuleSetNotFoundException("Can't find resource   Make sure the resource is a valid file or URL or is on the CLASSPATH.  Here's the current classpath: " + System.getProperty("java.class.path"));
        }
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createSingleRuleSet("rulesets/favorites.xml");
        Assert.assertNotNull((Object)rs.getRuleByName("WhileLoopsMustUseBraces"));
    }

    @org.junit.Test(expected=RuleSetNotFoundException.class)
    public void testRuleSetNotFound() throws RuleSetNotFoundException {
        RuleSetFactory rsf = new RuleSetFactory();
        rsf.createSingleRuleSet("fooooo");
    }

    @org.junit.Test
    public void testCreateEmptyRuleSet() {
        RuleSet rs = this.loadRuleSet(EMPTY_RULESET);
        Assert.assertEquals((Object)"test", (Object)rs.getName());
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rs.size()));
    }

    @org.junit.Test
    public void testSingleRule() {
        RuleSet rs = this.loadRuleSet(SINGLE_RULE);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rs.size()));
        Rule r = (Rule)rs.getRules().iterator().next();
        Assert.assertEquals((Object)"MockRuleName", (Object)r.getName());
        Assert.assertEquals((Object)"avoid the mock rule", (Object)r.getMessage());
    }

    @org.junit.Test
    public void testMultipleRules() {
        RuleSet rs = this.loadRuleSet(MULTIPLE_RULES);
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)rs.size()));
        HashSet<String> expected = new HashSet<String>();
        expected.add("MockRuleName1");
        expected.add("MockRuleName2");
        Iterator i = rs.getRules().iterator();
        while (i.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(((Rule)i.next()).getName()));
        }
    }

    @org.junit.Test
    public void testSingleRuleWithPriority() {
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)this.loadFirstRule(PRIORITY).getPriority()));
    }

    @org.junit.Test
    public void testProps() {
        Rule r = this.loadFirstRule(PROPERTIES);
        Assert.assertTrue((boolean)r.hasProperty("foo"));
        Assert.assertEquals((Object)"bar", (Object)r.getStringProperty("foo"));
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)r.getIntProperty("fooint")));
        Assert.assertTrue((boolean)r.hasProperty("fooBoolean"));
        Assert.assertTrue((boolean)r.getBooleanProperty("fooBoolean"));
        Assert.assertTrue((boolean)r.hasProperty("fooDouble"));
        Assert.assertEquals((double)1.0, (double)r.getDoubleProperty("fooDouble"), (double)0.05);
        Assert.assertTrue((!r.hasProperty("BuggleFish") ? 1 : 0) != 0);
        Assert.assertTrue((r.getDescription().indexOf("testdesc2") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testXPathPluginnameProperty() {
        Rule r = this.loadFirstRule(XPATH_PLUGINNAME);
        Assert.assertTrue((boolean)r.hasProperty("pluginname"));
    }

    @org.junit.Test
    public void testXPath() {
        Rule r = this.loadFirstRule(XPATH);
        Assert.assertTrue((boolean)r.hasProperty("xpath"));
        Assert.assertTrue((r.getStringProperty("xpath").indexOf(" //Block ") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testFacadesOffByDefault() {
        Rule r = this.loadFirstRule(XPATH);
        Assert.assertFalse((boolean)r.usesDFA());
    }

    @org.junit.Test
    public void testDFAFlag() {
        Assert.assertTrue((boolean)this.loadFirstRule(DFA).usesDFA());
    }

    @org.junit.Test
    public void testExternalReferenceOverride() {
        Rule r = this.loadFirstRule(REF_OVERRIDE);
        Assert.assertEquals((Object)"TestNameOverride", (Object)r.getName());
        Assert.assertEquals((Object)"Test message override", (Object)r.getMessage());
        Assert.assertEquals((Object)"Test description override", (Object)r.getDescription());
        Assert.assertEquals((Object)"Test example override", (Object)r.getExample());
        Assert.assertEquals((String)"Test that both example are stored", (Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)r.getExamples().size()));
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)r.getPriority()));
        Assert.assertTrue((boolean)r.hasProperty("test2"));
        Assert.assertEquals((Object)"override2", (Object)r.getStringProperty("test2"));
        Assert.assertTrue((boolean)r.hasProperty("test3"));
        Assert.assertEquals((Object)"override3", (Object)r.getStringProperty("test3"));
        Assert.assertTrue((boolean)r.hasProperty("test4"));
        Assert.assertEquals((Object)"new property", (Object)r.getStringProperty("test4"));
    }

    @org.junit.Test
    public void testOverrideMessage() {
        Rule r = this.loadFirstRule(REF_OVERRIDE_ORIGINAL_NAME);
        Assert.assertEquals((Object)"TestMessageOverride", (Object)r.getMessage());
    }

    @org.junit.Test
    public void testOverrideMessageOneElem() {
        Rule r = this.loadFirstRule(REF_OVERRIDE_ORIGINAL_NAME_ONE_ELEM);
        Assert.assertEquals((Object)"TestMessageOverride", (Object)r.getMessage());
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testExternalRef() throws IllegalArgumentException {
        this.loadFirstRule(REF_MISPELLED_XREF);
    }

    @org.junit.Test
    public void testSetPriority() {
        RuleSetFactory rsf = new RuleSetFactory();
        rsf.setMinimumPriority(2);
        Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)rsf.createRuleSet((InputStream)new ByteArrayInputStream(SINGLE_RULE.getBytes())).size()));
        rsf.setMinimumPriority(4);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rsf.createRuleSet((InputStream)new ByteArrayInputStream(SINGLE_RULE.getBytes())).size()));
    }

    private Rule loadFirstRule(String ruleSetName) {
        RuleSet rs = this.loadRuleSet(ruleSetName);
        return (Rule)rs.getRules().iterator().next();
    }

    private RuleSet loadRuleSet(String ruleSetName) {
        RuleSetFactory rsf = new RuleSetFactory();
        return rsf.createRuleSet((InputStream)new ByteArrayInputStream(ruleSetName.getBytes()));
    }

    @org.junit.Test
    public void testExternalReferences() {
        RuleSet rs = this.loadRuleSet(EXTERNAL_REFERENCE_RULE_SET);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rs.size()));
        Class<?> clazz = class$net$sourceforge$pmd$rules$UnusedLocalVariableRule;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$rules$UnusedLocalVariableRule = new UnusedLocalVariableRule[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)clazz, rs.getRuleByName("UnusedLocalVariable").getClass());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$RuleSetFactoryTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$RuleSetFactoryTest = new RuleSetFactoryTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

