/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Before;
import test.net.sourceforge.pmd.testframework.RuleTst;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

public class ExcludeLinesTest
extends RuleTst {
    private Rule rule;
    private static final String TEST1 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int x; //NOPMD " + PMD.EOL + " } " + PMD.EOL + "}";
    private static final String TEST2 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int x;" + PMD.EOL + " } " + PMD.EOL + "}";
    private static final String TEST3 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int x; // FOOBAR" + PMD.EOL + " } " + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ExcludeLinesTest;

    @Before
    public void setUp() {
        this.rule = this.findRule("unusedcode", "UnusedLocalVariable");
    }

    @org.junit.Test
    public void testAcceptance() {
        this.runTest(new TestDescriptor(TEST1, "NOPMD should work", 0, this.rule));
        this.runTest(new TestDescriptor(TEST2, "Should fail without exclude marker", 1, this.rule));
    }

    @org.junit.Test
    public void testAlternateMarker() throws Throwable {
        PMD p = new PMD();
        p.setExcludeMarker("FOOBAR");
        RuleContext ctx = new RuleContext();
        Report r = new Report();
        ctx.setReport(r);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule(this.rule);
        rules.setLanguage(SourceTypeToRuleLanguageMapper.getMappedLanguage((SourceType)DEFAULT_SOURCE_TYPE));
        p.processFile((Reader)new StringReader(TEST3), new RuleSets(rules), ctx, DEFAULT_SOURCE_TYPE);
        Assert.assertTrue((boolean)r.isEmpty());
        Assert.assertEquals((Object)Integer_.valueOf((int)r.getSuppressedRuleViolations().size()), (Object)Integer_.valueOf((int)1));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ExcludeLinesTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ExcludeLinesTest = new ExcludeLinesTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

