/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.InputStreamReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.CommandLineOptions;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.IDEAJRenderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;

public class CommandLineOptionsTest {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$CommandLineOptionsTest;

    @org.junit.Test
    public void testTargetJDKVersion() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic"});
        Assert.assertEquals((Object)"1.5", (Object)opt.getTargetJDK());
        opt = new CommandLineOptions(new String[]{"file", "format", "ruleset", "-targetjdk", "1.3"});
        Assert.assertEquals((Object)"1.3", (Object)opt.getTargetJDK());
        opt = new CommandLineOptions(new String[]{"file", "format", "ruleset", "-targetjdk", "1.5"});
        Assert.assertEquals((Object)"1.5", (Object)opt.getTargetJDK());
        opt = new CommandLineOptions(new String[]{"file", "format", "ruleset", "-targetjdk", "1.6"});
        Assert.assertEquals((Object)"1.6", (Object)opt.getTargetJDK());
        opt = new CommandLineOptions(new String[]{"-targetjdk", "1.6", "file", "format", "ruleset"});
        Assert.assertEquals((Object)"1.6", (Object)opt.getTargetJDK());
    }

    @org.junit.Test
    public void testDebug() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic", "-debug"});
        Assert.assertTrue((boolean)opt.debugEnabled());
        opt = new CommandLineOptions(new String[]{"-debug", "file", "format", "basic"});
        Assert.assertTrue((boolean)opt.debugEnabled());
    }

    @org.junit.Test
    public void testExcludeMarker() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic", "-excludemarker", "FOOBAR"});
        Assert.assertEquals((Object)"FOOBAR", (Object)opt.getExcludeMarker());
        opt = new CommandLineOptions(new String[]{"-excludemarker", "FOOBAR", "file", "format", "basic"});
        Assert.assertEquals((Object)"FOOBAR", (Object)opt.getExcludeMarker());
    }

    @org.junit.Test
    public void testShortNames() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic", "-shortnames"});
        Assert.assertTrue((boolean)opt.shortNamesEnabled());
        opt = new CommandLineOptions(new String[]{"-shortnames", "file", "format", "basic"});
        Assert.assertTrue((boolean)opt.shortNamesEnabled());
    }

    @org.junit.Test
    public void testEncoding() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic"});
        Assert.assertTrue((boolean)opt.getEncoding().equals(new InputStreamReader(System.in).getEncoding()));
        opt = new CommandLineOptions(new String[]{"file", "format", "ruleset", "-encoding", "UTF-8"});
        Assert.assertTrue((boolean)opt.getEncoding().equals("UTF-8"));
        opt = new CommandLineOptions(new String[]{"-encoding", "UTF-8", "file", "format", "ruleset"});
        Assert.assertTrue((boolean)opt.getEncoding().equals("UTF-8"));
    }

    @org.junit.Test
    public void testInputFileName() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic"});
        Assert.assertEquals((Object)"file", (Object)opt.getInputPath());
    }

    @org.junit.Test
    public void testReportFormat() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic"});
        Assert.assertEquals((Object)"format", (Object)opt.getReportFormat());
    }

    @org.junit.Test
    public void testRulesets() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic"});
        Assert.assertEquals((Object)"rulesets/basic.xml", (Object)opt.getRulesets());
    }

    @org.junit.Test
    public void testCommaSeparatedFiles() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file1,file2,file3", "format", "basic"});
        Assert.assertTrue((boolean)opt.containsCommaSeparatedFileList());
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testNotEnoughArgs() {
        new CommandLineOptions(new String[]{"file1", "format"});
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testNullArgs() {
        new CommandLineOptions(null);
    }

    @org.junit.Test
    public void testReportFile() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic", "-reportfile", "foo.txt"});
        Assert.assertSame((Object)"foo.txt", (Object)opt.getReportFile());
        opt = new CommandLineOptions(new String[]{"-reportfile", "foo.txt", "file", "format", "basic"});
        Assert.assertSame((Object)"foo.txt", (Object)opt.getReportFile());
    }

    @org.junit.Test
    public void testCpus() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "format", "basic", "-cpus", "2"});
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)opt.getCpus()));
        opt = new CommandLineOptions(new String[]{"-cpus", "2", "file", "format", "basic"});
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)opt.getCpus()));
    }

    @org.junit.Test
    public void testRenderer() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "xml", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof XMLRenderer));
        opt = new CommandLineOptions(new String[]{"file", "html", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof HTMLRenderer));
        opt = new CommandLineOptions(new String[]{"file", "text", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof TextRenderer));
        opt = new CommandLineOptions(new String[]{"file", "emacs", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof EmacsRenderer));
        opt = new CommandLineOptions(new String[]{"file", "csv", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof CSVRenderer));
        opt = new CommandLineOptions(new String[]{"file", "vbhtml", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof VBHTMLRenderer));
        opt = new CommandLineOptions(new String[]{"file", "ideaj", "basic"});
        Assert.assertTrue((boolean)(opt.createRenderer() instanceof IDEAJRenderer));
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void illegalArgument1() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "", "basic"});
        opt.createRenderer();
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void illegalArgument2() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"file", "fiddlefaddle", "basic"});
        opt.createRenderer();
    }

    @org.junit.Test
    public void testOptionsFirst() {
        CommandLineOptions opt = new CommandLineOptions(new String[]{"-cpus", "2", "-debug", "file", "format", "basic"});
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)opt.getCpus()));
        Assert.assertEquals((Object)"file", (Object)opt.getInputPath());
        Assert.assertEquals((Object)"format", (Object)opt.getReportFormat());
        Assert.assertEquals((Object)"rulesets/basic.xml", (Object)opt.getRulesets());
        Assert.assertTrue((boolean)opt.debugEnabled());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$CommandLineOptionsTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$CommandLineOptionsTest = new CommandLineOptionsTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

