/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.util.HashMap;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.SourceFileScope;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRuleTest {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$AbstractRuleTest;

    @Test
    public void testCreateRV() {
        MyRule r = new MyRule();
        r.setRuleSetName("foo");
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        SimpleJavaNode s = new SimpleJavaNode(1);
        s.testingOnly__setBeginColumn(5);
        s.testingOnly__setBeginLine(5);
        s.setScope((Scope)new SourceFileScope("foo"));
        RuleViolation rv = new RuleViolation((Rule)r, ctx, (SimpleNode)s);
        Assert.assertEquals((String)"Line number mismatch!", (Object)Integer_.valueOf((int)5), (Object)Integer_.valueOf((int)rv.getBeginLine()));
        Assert.assertEquals((String)"Filename mismatch!", (Object)"filename", (Object)rv.getFilename());
        Assert.assertEquals((String)"Rule object mismatch!", (Object)((Object)r), (Object)rv.getRule());
        Assert.assertEquals((String)"Rule msg mismatch!", (Object)"my rule msg", (Object)rv.getDescription());
        Assert.assertEquals((String)"RuleSet name mismatch!", (Object)"foo", (Object)rv.getRule().getRuleSetName());
    }

    @Test
    public void testCreateRV2() {
        MyRule r = new MyRule();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        SimpleJavaNode s = new SimpleJavaNode(1);
        s.testingOnly__setBeginColumn(5);
        s.testingOnly__setBeginLine(5);
        s.setScope((Scope)new SourceFileScope("foo"));
        RuleViolation rv = new RuleViolation((Rule)r, ctx, (SimpleNode)s, "specificdescription");
        Assert.assertEquals((String)"Line number mismatch!", (Object)Integer_.valueOf((int)5), (Object)Integer_.valueOf((int)rv.getBeginLine()));
        Assert.assertEquals((String)"Filename mismatch!", (Object)"filename", (Object)rv.getFilename());
        Assert.assertEquals((String)"Rule object mismatch!", (Object)((Object)r), (Object)rv.getRule());
        Assert.assertEquals((String)"Rule description mismatch!", (Object)"specificdescription", (Object)rv.getDescription());
    }

    @Test
    public void testRuleExclusion() {
        MyRule r = new MyRule();
        RuleContext ctx = new RuleContext();
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(new Integer(5), "");
        ctx.setReport(new Report());
        ctx.excludeLines(m);
        ctx.setSourceCodeFilename("filename");
        SimpleJavaNode n = new SimpleJavaNode(1);
        n.testingOnly__setBeginColumn(5);
        n.testingOnly__setBeginLine(5);
        n.setScope((Scope)new SourceFileScope("foo"));
        RuleViolation rv = new RuleViolation((Rule)r, ctx, (SimpleNode)n, "specificdescription");
        ctx.getReport().addRuleViolation((IRuleViolation)rv);
        Assert.assertTrue((boolean)ctx.getReport().isEmpty());
    }

    @Test
    public void testEquals1() {
        MyRule r = new MyRule();
        Assert.assertFalse((String)"A rule is never equals to null!", (boolean)r.equals(null));
    }

    @Test
    public void testEquals2() {
        MyRule r = new MyRule();
        Assert.assertEquals((String)"A rule must be equals to itself", (Object)((Object)r), (Object)((Object)r));
    }

    @Test
    public void testEquals3() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        Assert.assertEquals((String)"Two instances of the same rule are equal", (Object)((Object)r1), (Object)((Object)r2));
        Assert.assertEquals((String)"Hashcode for two instances of the same rule must be equal", (Object)Integer_.valueOf((int)r1.hashCode()), (Object)Integer_.valueOf((int)r2.hashCode()));
    }

    @Test
    public void testEquals4() {
        MyRule myRule = new MyRule();
        Assert.assertFalse((String)"A rule cannot be equal to an object of another class", (boolean)myRule.equals("MyRule"));
    }

    @Test
    public void testEquals5() {
        MyRule myRule = new MyRule();
        MyOtherRule myOtherRule = new MyOtherRule();
        Assert.assertFalse((String)"Two rules from different classes cannot be equal", (boolean)myRule.equals((Object)myOtherRule));
    }

    @Test
    public void testEquals6() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setName("MyRule2");
        Assert.assertFalse((String)"Rules with different names cannot be equal", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void testEquals7() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setPriority(1);
        Assert.assertFalse((String)"Rules with different priority levels cannot be equal", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void testEquals8() {
        MyRule r1 = new MyRule();
        r1.setProperty(MyRule.xpath, "something");
        MyRule r2 = new MyRule();
        r2.setProperty(MyRule.xpath, "something else");
        Assert.assertFalse((String)"Rules with different properties values cannot be equal", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void testEquals9() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setProperty(MyRule.xpath, "something else");
        Assert.assertFalse((String)"Rules with different properties cannot be equal", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void testEquals10() {
        MyRule r1 = new MyRule();
        MyRule r2 = new MyRule();
        r2.setMessage("another message");
        Assert.assertTrue((String)"Rules with different messages are still equal", (boolean)r1.equals((Object)r2));
        Assert.assertTrue((String)"Rules that are equal must have the same hashcode", (r1.hashCode() == r2.hashCode() ? 1 : 0) != 0);
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$AbstractRuleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$AbstractRuleTest = new AbstractRuleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyOtherRule
    extends AbstractRule {
        private static final PropertyDescriptor pd = new StringProperty("foo", "foo property", "x", 1.0f);
        private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = MyOtherRule.asFixedMap((PropertyDescriptor[])new PropertyDescriptor[]{pd});

        protected Map<String, PropertyDescriptor> propertiesByName() {
            return propertyDescriptorsByName;
        }

        public MyOtherRule() {
            this.setName("MyOtherRule");
            this.setMessage("my other rule");
            this.setPriority(3);
            this.setProperty(pd, "value");
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyRule
    extends AbstractRule {
        private static final PropertyDescriptor pd = new StringProperty("foo", "foo property", "x", 1.0f);
        private static final PropertyDescriptor xpath = new StringProperty("xpath", "xpath property", "", 2.0f);
        private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = MyRule.asFixedMap((PropertyDescriptor[])new PropertyDescriptor[]{pd, xpath});

        protected Map<String, PropertyDescriptor> propertiesByName() {
            return propertyDescriptorsByName;
        }

        public MyRule() {
            this.setName("MyRule");
            this.setMessage("my rule msg");
            this.setPriority(3);
            this.setProperty(pd, "value");
        }
    }
}

