/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.eclipse.equinox.log.LogEntry;
import org.eclipse.equinox.log.LogEntryEventAdapter;
import org.eclipse.equinox.log.LogMsg;
import org.eclipse.equinox.log.LogReaderService;
import org.eclipse.equinox.log.LogReaderServiceFactory;
import org.eclipse.equinox.log.LogServiceFactory;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator,
EventDispatcher,
BundleListener,
FrameworkListener,
ServiceListener,
ManagedService {
    protected BundleContext context;
    protected EventListeners logEvent;
    protected EventManager eventManager;
    protected ServiceRegistration logservice;
    protected ServiceRegistration logreaderservice;
    protected ServiceRegistration logmanagedservice;
    protected LogEntryEventAdapter eventAdapter;
    protected static final int DEFAULT_LOG_SIZE = 100;
    protected static final int DEFAULT_LOG_THRESHOLD = 4;
    protected int logSize = 100;
    protected int logThreshold = 4;
    protected LogEntry[] logEntries;
    protected int head;
    protected int tail;
    protected long lastTimestamp = 0L;
    protected static final String keyLogSize = "log.size";
    protected static final String keyLogThreshold = "log.threshold";
    protected static final String LOGSERVICEPID = "org.eclipse.equinox.log.Log";
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        ThreadGroup eventGroup = new ThreadGroup("Equinox Log Service");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("Log Event Dispatcher", eventGroup);
        this.logEvent = new EventListeners();
        this.logEntries = new LogEntry[this.logSize];
        this.head = 0;
        this.tail = 0;
        String initmessage = NLS.bind((String)LogMsg.Log_created_Log_Size, (Object)String.valueOf(this.logSize), (Object)String.valueOf(this.logThreshold));
        this.logEntries[0] = new LogEntry(3, initmessage, bundleContext.getBundle(), null, null);
        bundleContext.addBundleListener((BundleListener)this);
        bundleContext.addServiceListener((ServiceListener)this);
        bundleContext.addFrameworkListener((FrameworkListener)this);
        this.registerLogService();
        if (Activator.checkEventAdmin()) {
            this.eventAdapter = new LogEntryEventAdapter(bundleContext);
            this.eventAdapter.start();
        }
        this.registerLogReaderService();
        this.registerManagedService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.logmanagedservice != null) {
            this.logmanagedservice.unregister();
            this.logmanagedservice = null;
        }
        if (this.logservice != null) {
            this.logservice.unregister();
            this.logservice = null;
        }
        if (this.logreaderservice != null) {
            this.logreaderservice.unregister();
            this.logreaderservice = null;
        }
        Activator activator = this;
        synchronized (activator) {
            if (this.eventAdapter != null) {
                this.eventAdapter.stop();
                this.eventAdapter = null;
            }
            this.context.removeBundleListener((BundleListener)this);
            this.context.removeServiceListener((ServiceListener)this);
            this.context.removeFrameworkListener((FrameworkListener)this);
            if (this.logEvent != null) {
                this.logEvent.removeAllListeners();
                this.logEvent = null;
            }
            if (this.eventManager != null) {
                this.eventManager.close();
                this.eventManager = null;
            }
            this.logEntries = null;
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int level, String message, Bundle bundle, ServiceReference reference, Throwable exception) {
        LogEntry logentry = new LogEntry(level, message, bundle, reference, exception);
        Activator activator = this;
        synchronized (activator) {
            if (this.context == null) {
                return;
            }
            if (logentry.time <= this.lastTimestamp) {
                logentry.time = ++this.lastTimestamp;
            } else {
                this.lastTimestamp = logentry.time;
            }
            if (level <= this.logThreshold) {
                this.addLogEntry(logentry);
            }
        }
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        contexts.queueListeners(this.logEvent, (EventDispatcher)this);
        contexts.dispatchEventSynchronous(0, (Object)listeners);
        listeners.dispatchEventAsynchronous(0, (Object)logentry);
    }

    public void dispatchEvent(Object l, Object lo, int action, Object object) {
        LogReaderService logreader = (LogReaderService)l;
        EventListeners listeners = logreader.logEvent;
        if (listeners != null) {
            ListenerQueue queue = (ListenerQueue)object;
            queue.queueListeners(listeners, (EventDispatcher)logreader);
        }
    }

    protected void addLogEntry(LogEntry logentry) {
        this.tail = (this.tail + 1) % this.logSize;
        this.logEntries[this.tail] = logentry;
        if (this.head == this.tail) {
            this.head = (this.head + 1) % this.logSize;
        }
    }

    protected synchronized Enumeration logEntries() {
        int tempHead = this.head;
        int tempTail = this.tail;
        int templogSize = this.logSize;
        LogEntry[] tempLogEntries = this.logEntries;
        return new Enumeration(tempHead, tempTail, tempLogEntries, templogSize){
            private int item;
            private LogEntry[] enumentries;
            {
                if (n <= n2) {
                    this.item = n2 - n + 1;
                    this.enumentries = new LogEntry[this.item];
                    System.arraycopy(logEntryArray, n, this.enumentries, 0, this.item);
                } else {
                    int firstcopy = n3 - n;
                    this.item = firstcopy + n2 + 1;
                    this.enumentries = new LogEntry[this.item];
                    System.arraycopy(logEntryArray, n, this.enumentries, 0, firstcopy);
                    System.arraycopy(logEntryArray, 0, this.enumentries, firstcopy, this.item - firstcopy);
                }
            }

            public boolean hasMoreElements() {
                if (this.item > 0) {
                    return true;
                }
                this.enumentries = null;
                return false;
            }

            public Object nextElement() {
                if (this.item > 0) {
                    --this.item;
                    LogEntry entry = this.enumentries[this.item].copy();
                    this.enumentries[this.item] = null;
                    return entry;
                }
                this.enumentries = null;
                throw new NoSuchElementException();
            }
        };
    }

    public void bundleChanged(BundleEvent event) {
        this.log(3, Activator.getBundleEventTypeName(event.getType()), event.getBundle(), null, null);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        int eventType = event.getType();
        int logType = eventType == 2 ? 4 : 3;
        this.log(logType, Activator.getServiceEventTypeName(eventType), reference.getBundle(), reference, null);
    }

    public void frameworkEvent(FrameworkEvent event) {
        int type = event.getType();
        if (type == 2) {
            this.log(1, Activator.getFrameworkEventTypeName(type), event.getBundle(), null, event.getThrowable());
        } else {
            this.log(3, Activator.getFrameworkEventTypeName(type), event.getBundle(), null, null);
        }
    }

    protected static String getBundleEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "BundleEvent INSTALLED";
            }
            case 32: {
                return "BundleEvent RESOLVED";
            }
            case 2: {
                return "BundleEvent STARTED";
            }
            case 128: {
                return "BundleEvent STARTING";
            }
            case 4: {
                return "BundleEvent STOPPED";
            }
            case 256: {
                return "BundleEvent STOPPING";
            }
            case 16: {
                return "BundleEvent UNINSTALLED";
            }
            case 64: {
                return "BundleEvent UNRESOLVED";
            }
            case 8: {
                return "BundleEvent UPDATED";
            }
        }
        return NLS.bind((String)LogMsg.BundleEvent, (Object)Integer.toHexString(type));
    }

    protected static String getServiceEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "ServiceEvent REGISTERED";
            }
            case 2: {
                return "ServiceEvent MODIFIED";
            }
            case 4: {
                return "ServiceEvent UNREGISTERING";
            }
        }
        return NLS.bind((String)LogMsg.ServiceEvent, (Object)Integer.toHexString(type));
    }

    protected static String getFrameworkEventTypeName(int type) {
        switch (type) {
            case 2: {
                return "FrameworkEvent ERROR";
            }
            case 32: {
                return "FrameworkEvent INFO";
            }
            case 4: {
                return "FrameworkEvent PACKAGES REFRESHED";
            }
            case 1: {
                return "FrameworkEvent STARTED";
            }
            case 8: {
                return "FrameworkEvent STARTLEVEL CHANGED";
            }
            case 16: {
                return "FrameworkEvent WARNING";
            }
        }
        return NLS.bind((String)LogMsg.FrameworkEvent, (Object)Integer.toHexString(type));
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (this.context != null) {
            if (properties == null) {
                return;
            }
            int size = this.logSize;
            int threshold = this.logThreshold;
            Object property = properties.get(keyLogSize);
            if (property != null) {
                if (!(property instanceof Integer)) {
                    throw new ConfigurationException(keyLogSize, "not an Integer");
                }
                size = (Integer)property;
                if (size < 10 || size > 2000) {
                    throw new ConfigurationException(keyLogSize, "must be in the range 10-2000");
                }
            }
            if ((property = properties.get(keyLogThreshold)) != null) {
                if (!(property instanceof Integer)) {
                    throw new ConfigurationException(keyLogThreshold, "not an Integer");
                }
                threshold = (Integer)property;
                if (threshold < 1 || threshold > 4) {
                    throw new ConfigurationException(keyLogThreshold, "must be one of the LogService defined Log levels");
                }
            }
            if (size != this.logSize) {
                this.updateLogSize(size);
            }
            if (threshold != this.logThreshold) {
                this.updateLogThreshold(threshold);
            }
        }
    }

    private void updateLogSize(int size) {
        int count;
        LogEntry[] newlog = new LogEntry[size];
        if (this.head <= this.tail) {
            count = this.tail - this.head + 1;
            if (size > count) {
                System.arraycopy(this.logEntries, this.head, newlog, 0, count);
                this.tail = count - 1;
            } else {
                System.arraycopy(this.logEntries, this.head + count - size, newlog, 0, size);
                this.tail = size - 1;
            }
        } else {
            count = this.tail + 1 + this.logSize - this.head;
            if (size > count) {
                int boundary = this.logSize - this.head;
                System.arraycopy(this.logEntries, this.head, newlog, 0, boundary);
                System.arraycopy(this.logEntries, 0, newlog, boundary, count - boundary);
                this.tail = count - 1;
            } else {
                if (this.tail + 1 < size) {
                    int boundary = size - (this.tail + 1);
                    System.arraycopy(this.logEntries, this.logSize - boundary, newlog, 0, boundary);
                    System.arraycopy(this.logEntries, 0, newlog, boundary, this.tail + 1);
                } else {
                    System.arraycopy(this.logEntries, this.tail + 1 - size, newlog, 0, size);
                }
                this.tail = size - 1;
            }
        }
        this.logEntries = newlog;
        this.logSize = size;
        this.head = 0;
        String changemessage = NLS.bind((String)LogMsg.Log_modified_Log_Size, (Object)String.valueOf(this.logSize));
        this.log(3, changemessage, this.context.getBundle(), null, null);
    }

    private void updateLogThreshold(int threshold) {
        this.logThreshold = threshold;
        String changemessage = NLS.bind((String)LogMsg.Log_modified_Log_Threshold, (Object)String.valueOf(this.logThreshold));
        this.log(3, changemessage, this.context.getBundle(), null, null);
    }

    protected void registerManagedService() {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", LogMsg.OSGi_Log_Service_IBM_Implementation);
        properties.put("service.pid", LOGSERVICEPID);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logmanagedservice = this.context.registerService(clazz.getName(), (Object)this, properties);
    }

    private void registerLogService() {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", LogMsg.OSGi_Log_Service_IBM_Implementation);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.log.LogServiceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        properties.put("service.pid", clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.osgi.service.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logservice = this.context.registerService(clazz2.getName(), (Object)new LogServiceFactory(this), properties);
    }

    private void registerLogReaderService() {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", LogMsg.OSGi_Log_Service_IBM_Implementation);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        properties.put("service.pid", clazz.getName());
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.osgi.service.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logreaderservice = this.context.registerService(clazz2.getName(), (Object)new LogReaderServiceFactory(this), properties);
    }

    private static boolean checkEventAdmin() {
        try {
            Class.forName(EVENT_ADMIN_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

