/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.resource;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.ObjectNamingAbstraction;
import com.openexchange.admin.rmi.OXResourceInterface;
import com.openexchange.admin.rmi.dataobjects.Resource;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public abstract class ResourceAbstraction
extends ObjectNamingAbstraction {
    protected static final String _OPT_NAME_LONG = "name";
    protected static final char _OPT_NAME_SHORT = 'n';
    protected static final String _OPT_DISPNAME_LONG = "displayname";
    protected static final char _OPT_DISPNAME_SHORT = 'd';
    protected static final String _OPT_DESCRIPTION_LONG = "description";
    protected static final char _OPT_DESCRIPTION_SHORT = 'D';
    protected static final char _OPT_AVAILABLE_SHORT = 'a';
    protected static final String _OPT_AVAILABLE_LONG = "available";
    protected static final char _OPT_EMAIL_SHORT = 'e';
    protected static final String _OPT_EMAIL_LONG = "email";
    protected static final char _OPT_RESOURCEID_SHORT = 'i';
    protected static final String _OPT_RESOURCEID_LONG = "resourceid";
    protected static final String OPT_RECIPIENT_LONG = "mailrecipients";
    protected static final char OPT_RECIPIENT_SHORT = 'm';
    protected CLIOption resourceDisplayNameOption = null;
    protected CLIOption resourceNameOption = null;
    protected CLIOption resourceAvailableOption = null;
    protected CLIOption resourceDescriptionOption = null;
    protected CLIOption resourceEmailOption = null;
    protected CLIOption resourceIdOption = null;
    protected CLIOption resourceRecipientOption = null;
    protected String resourceid = null;
    protected String resourcename = null;

    protected void setDisplayNameOption(AdminParser admp, boolean required) {
        this.resourceDisplayNameOption = this.setShortLongOpt(admp, 'd', _OPT_DISPNAME_LONG, "The resource display name", true, this.convertBooleantoTriState(required));
    }

    protected void setRecipientOption(AdminParser admp, boolean required) {
        this.resourceRecipientOption = this.setShortLongOpt(admp, 'm', OPT_RECIPIENT_LONG, "Recipient who should receive mail addressed to the resource", true, this.convertBooleantoTriState(required));
    }

    protected void setNameOption(AdminParser admp, AdminParser.NeededQuadState required) {
        this.resourceNameOption = this.setShortLongOpt(admp, 'n', _OPT_NAME_LONG, "The resource name", true, required);
    }

    protected void setAvailableOption(AdminParser admp, boolean required) {
        this.resourceAvailableOption = this.setShortLongOpt(admp, 'a', _OPT_AVAILABLE_LONG, "true/false", "Toggle resource availability", required);
    }

    protected void setDescriptionOption(AdminParser admp, boolean required) {
        this.resourceDescriptionOption = this.setShortLongOpt(admp, 'D', _OPT_DESCRIPTION_LONG, "Description of this resource", true, this.convertBooleantoTriState(required));
    }

    protected void setEmailOption(AdminParser admp, boolean required) {
        this.resourceEmailOption = this.setShortLongOpt(admp, 'e', _OPT_EMAIL_LONG, "Email of this resource", true, this.convertBooleantoTriState(required));
    }

    protected void setIdOption(AdminParser admp) {
        this.resourceIdOption = this.setShortLongOpt(admp, 'i', _OPT_RESOURCEID_LONG, "Id of this resource", true, AdminParser.NeededQuadState.eitheror);
    }

    protected final OXResourceInterface getResourceInterface() throws NotBoundException, MalformedURLException, RemoteException {
        return (OXResourceInterface)Naming.lookup(RMI_HOSTNAME + "OXResource_V2");
    }

    protected String getObjectName() {
        return "resource";
    }

    private void parseAndSetResourceAvailable(AdminParser parser, Resource res) {
        String resourceavailable = (String)parser.getOptionValue(this.resourceAvailableOption);
        if (resourceavailable != null) {
            res.setAvailable(Boolean.parseBoolean(resourceavailable));
        }
    }

    private void parseAndSetResourceDescription(AdminParser parser, Resource res) {
        String resourceDescription = (String)parser.getOptionValue(this.resourceDescriptionOption);
        if (resourceDescription != null) {
            if ("".equals(resourceDescription)) {
                resourceDescription = null;
            }
            res.setDescription(resourceDescription);
        }
    }

    private void parseAndSetResourceDisplayName(AdminParser parser, Resource res) {
        String resourceDisplayName = (String)parser.getOptionValue(this.resourceDisplayNameOption);
        if (resourceDisplayName != null) {
            res.setDisplayname(resourceDisplayName);
        }
    }

    private void parseAndSetResourceEmail(AdminParser parser, Resource res) {
        String resourceEmail = (String)parser.getOptionValue(this.resourceEmailOption);
        if (resourceEmail != null) {
            if ("".equals(resourceEmail)) {
                resourceEmail = null;
            }
            res.setEmail(resourceEmail);
        }
    }

    protected void parseAndSetResourceName(AdminParser parser, Resource res) {
        this.resourcename = (String)parser.getOptionValue(this.resourceNameOption);
        if (this.resourcename != null) {
            res.setName(this.resourcename);
        }
    }

    protected void parseAndSetMandatoryFields(AdminParser parser, Resource res) {
        this.parseAndSetResourceAvailable(parser, res);
        this.parseAndSetResourceDescription(parser, res);
        this.parseAndSetResourceDisplayName(parser, res);
        this.parseAndSetResourceEmail(parser, res);
        this.parseAndSetResourceName(parser, res);
    }

    protected void parseAndSetResourceId(AdminParser parser, Resource res) {
        this.resourceid = (String)parser.getOptionValue(this.resourceIdOption);
        if (null != this.resourceid) {
            res.setId(Integer.parseInt(this.resourceid));
        }
    }
}

