/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.group;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.group.GroupAbstraction;
import com.openexchange.admin.rmi.OXGroupInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Group;
import com.openexchange.admin.rmi.exceptions.DatabaseUpdateException;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.NoSuchGroupException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.rmi.RemoteException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCore
extends GroupAbstraction {
    protected final void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptions(parser);
        this.setCSVOutputOption(parser);
        this.searchOption = this.setShortLongOpt(parser, 's', "searchpattern", "The search pattern which is used for listing. This applies to name.", true, AdminParser.NeededQuadState.notneeded);
    }

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        try {
            parser.ownparse(args);
            Context ctx = this.contextparsing(parser);
            Credentials auth = this.credentialsparsing(parser);
            OXGroupInterface oxgrp = this.getGroupInterface();
            String pattern = (String)parser.getOptionValue(this.searchOption);
            if (null == pattern) {
                pattern = "*";
            }
            Group[] allgrps = oxgrp.list(ctx, pattern, auth);
            ArrayList<Group> grplist = new ArrayList<Group>();
            this.maincall(parser, oxgrp, ctx, grplist, allgrps, auth);
            if (parser.getOptionValue(this.csvOutputOption) != null) {
                this.precsvinfos(grplist);
            } else {
                this.sysoutOutput(grplist);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
            this.sysexit(1);
        }
    }

    protected abstract void maincall(AdminParser var1, OXGroupInterface var2, Context var3, ArrayList<Group> var4, Group[] var5, Credentials var6) throws RemoteException, InvalidCredentialsException, NoSuchContextException, StorageException, InvalidDataException, DatabaseUpdateException, NoSuchGroupException, DuplicateExtensionException;

    private void sysoutOutput(ArrayList<Group> grouplist) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Group group : grouplist) {
            this.printExtensionsError(group);
            data.add(this.makeStandardData(group));
        }
        this.doOutput(new String[]{"r", "l", "l", "l"}, new String[]{"Id", "Name", "Displayname", "Members"}, data);
    }

    private void precsvinfos(ArrayList<Group> grplist) throws RemoteException, InvalidCredentialsException, NoSuchContextException, StorageException, InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("name");
        columns.add("displayname");
        columns.add("members");
        this.extendscvscolumns(columns);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Group my_grp : grplist) {
            data.add(this.makeDataForCsv(my_grp));
            this.printExtensionsError(my_grp);
        }
        this.doCSVOutput(columns, data);
    }

    protected abstract void extendscvscolumns(ArrayList<String> var1);

    private ArrayList<String> makeDataForCsv(Group group) throws RemoteException, InvalidCredentialsException, NoSuchContextException, StorageException, InvalidDataException {
        ArrayList<String> grp_data = this.makeStandardData(group);
        this.extendmakeCSVData(group, grp_data);
        return grp_data;
    }

    private ArrayList<String> makeStandardData(Group group) {
        ArrayList<String> grp_data = new ArrayList<String>();
        grp_data.add(String.valueOf(group.getId()));
        String name = group.getName();
        if (name != null && name.trim().length() > 0) {
            grp_data.add(name);
        } else {
            grp_data.add(null);
        }
        String displayname = group.getDisplayname();
        if (displayname != null && displayname.trim().length() > 0) {
            grp_data.add(displayname);
        } else {
            grp_data.add(null);
        }
        grp_data.add(this.getObjectsAsString(group.getMembers()));
        return grp_data;
    }

    protected abstract void extendmakeCSVData(Group var1, ArrayList<String> var2);

    @Override
    protected final String getObjectName() {
        return "groups";
    }
}

