/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.group;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.ObjectNamingAbstraction;
import com.openexchange.admin.rmi.OXGroupInterface;
import com.openexchange.admin.rmi.dataobjects.Group;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public abstract class GroupAbstraction
extends ObjectNamingAbstraction {
    protected CLIOption addMemberOption = null;
    protected CLIOption removeMemberOption = null;
    protected CLIOption IdOption = null;
    protected CLIOption nameOption = null;
    protected CLIOption displayNameOption = null;
    protected CLIOption mailOption = null;
    protected static final String OPT_NAME_GROUPNAME_LONG = "name";
    protected static final char OPT_NAME_GROUPNAME = 'n';
    protected static final String OPT_NAME_GROUPDISPLAYNAME_LONG = "displayname";
    protected static final char OPT_NAME_GROUPDISPLAYNAME = 'd';
    protected static final String OPT_NAME_GROUPID_LONG = "groupid";
    protected static final char OPT_NAME_GROUPID = 'i';
    protected static final String OPT_NAME_ADDMEMBERS_LONG = "addmembers";
    protected static final char OPT_NAME_ADDMEMBERS = 'a';
    protected static final String OPT_NAME_REMOVEMEMBERS_LONG = "removemembers";
    protected static final char OPT_NAME_REMOVEMEMBERS = 'r';
    protected static final String OPT_MAILADDRESS_LONG = "mailaddress";
    protected static final char OPT_MAILADDRESS_SHORT = 'm';
    protected String groupid = null;
    protected String groupName = null;

    protected void setAddMembersOption(AdminParser admp, boolean required) {
        this.addMemberOption = this.setShortLongOpt(admp, 'a', OPT_NAME_ADDMEMBERS_LONG, "userid(s)", "List of members to add to group, separated by comma", required);
    }

    protected void setRemoveMembersOption(AdminParser admp, boolean required) {
        this.removeMemberOption = this.setShortLongOpt(admp, 'r', OPT_NAME_REMOVEMEMBERS_LONG, "List of members to be removed from group, separated by comma", true, this.convertBooleantoTriState(required));
    }

    protected void setGroupIdOption(AdminParser admp, AdminParser.NeededQuadState required) {
        this.IdOption = this.setShortLongOpt(admp, 'i', OPT_NAME_GROUPID_LONG, "The id of the group", true, required);
    }

    protected void setGroupNameOption(AdminParser admp, AdminParser.NeededQuadState required) {
        this.nameOption = this.setShortLongOpt(admp, 'n', OPT_NAME_GROUPNAME_LONG, "The group name", true, required);
    }

    protected void setGroupDisplayNameOption(AdminParser admp, boolean required) {
        this.displayNameOption = this.setShortLongOpt(admp, 'd', OPT_NAME_GROUPDISPLAYNAME_LONG, "The displayname for the Group", true, this.convertBooleantoTriState(required));
    }

    protected void setMailOption(AdminParser admp, boolean required) {
        this.mailOption = this.setShortLongOpt(admp, 'm', OPT_MAILADDRESS_LONG, "email address if the group should receive mail", true, this.convertBooleantoTriState(required));
    }

    protected final OXGroupInterface getGroupInterface() throws NotBoundException, MalformedURLException, RemoteException {
        return (OXGroupInterface)Naming.lookup(RMI_HOSTNAME + "OXGroup_V2");
    }

    protected String getObjectName() {
        return "group";
    }

    protected final void parseAndSetGroupId(AdminParser parser, Group grp) {
        this.groupid = (String)parser.getOptionValue(this.IdOption);
        if (null != this.groupid) {
            grp.setId(Integer.valueOf(this.groupid));
        }
    }

    protected void parseAndSetGroupName(AdminParser parser, Group grp) {
        this.groupName = (String)parser.getOptionValue(this.nameOption);
        if (null != this.groupName) {
            grp.setName(this.groupName);
        }
    }

    private void parseAndSetDisplayName(AdminParser parser, Group grp) {
        String displayName = (String)parser.getOptionValue(this.displayNameOption);
        if (displayName != null) {
            grp.setDisplayname(displayName);
        }
    }

    protected final void parseAndSetGroupAndDisplayName(AdminParser parser, Group grp) {
        this.parseAndSetGroupName(parser, grp);
        this.parseAndSetDisplayName(parser, grp);
    }
}

