/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.ServiceLoader;
import com.openexchange.admin.console.context.extensioninterfaces.ContextConsoleCommonInterface;
import com.openexchange.admin.console.context.extensioninterfaces.ContextConsoleCreateInterface;
import com.openexchange.admin.console.exception.OXConsolePluginException;
import com.openexchange.admin.console.user.UserAbstraction;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Database;
import com.openexchange.admin.rmi.dataobjects.Filestore;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextAbstraction
extends UserAbstraction {
    protected static int CONTEXT_INITIAL_CONSTANTS_VALUE = UserAbstraction.Constants.values().length + UserAbstraction.AccessCombinations.values().length;
    private static final char OPT_NAME_DATABASE_ID_SHORT = 'd';
    private static final String OPT_NAME_DATABASE_ID_LONG = "database";
    private static final char OPT_NAME_DBNAME_SHORT = 'n';
    private static final String OPT_NAME_DBNAME_LONG = "name";
    public static final char OPT_CONTEXT_ADD_LOGIN_MAPPINGS_SHORT = 'L';
    public static final String OPT_CONTEXT_ADD_LOGIN_MAPPINGS_LONG = "addmapping";
    public static final char OPT_CONTEXT_REMOVE_LOGIN_MAPPINGS_SHORT = 'R';
    public static final String OPT_CONTEXT_REMOVE_LOGIN_MAPPINGS_LONG = "removemapping";
    static final char OPT_FILESTORE_SHORT = 'f';
    static final String OPT_FILESTORE_LONG = "filestore";
    private CLIOption databaseIdOption = null;
    private CLIOption databaseNameOption = null;
    protected Integer dbid = null;
    protected String dbname = null;
    protected Integer filestoreid = null;
    protected CLIOption targetFilestoreIDOption = null;
    private static final String OPT_NAME_CONTEXT_QUOTA_DESCRIPTION = "Context wide filestore quota in MB.";
    private static final char OPT_QUOTA_SHORT = 'q';
    private static final String OPT_QUOTA_LONG = "quota";
    protected static final String OPT_NAME_ADMINPASS_DESCRIPTION = "master Admin password";
    protected static final String OPT_NAME_ADMINUSER_DESCRIPTION = "master Admin user name";
    protected CLIOption contextQuotaOption = null;
    protected String contextname = null;
    private ServiceLoader<? extends ContextConsoleCommonInterface> subclasses = null;

    @Override
    protected String getObjectName() {
        return "context";
    }

    protected void applyExtensionValuesFromCSV(String[] nextLine, int[] idarray, Context context) throws OXConsolePluginException {
        for (ContextConsoleCommonInterface contextConsoleCommonInterface : this.subclasses) {
            if (!(contextConsoleCommonInterface instanceof ContextConsoleCreateInterface)) continue;
            ((ContextConsoleCreateInterface)contextConsoleCommonInterface).applyExtensionValuesFromCSV(nextLine, idarray, context);
        }
    }

    protected void parseAndSetContextName(AdminParser parser, Context ctx) {
        this.contextname = (String)parser.getOptionValue(this.contextNameOption);
        if (this.contextname != null) {
            ctx.setName(this.contextname);
        }
    }

    protected void parseAndSetContextQuota(AdminParser parser, Context ctx) {
        String contextQuota = (String)parser.getOptionValue(this.contextQuotaOption);
        if (null != contextQuota) {
            ctx.setMaxQuota(Long.parseLong(contextQuota));
        }
    }

    protected void parseAndSetExtensions(AdminParser parser, Context ctx, Credentials auth) {
        try {
            for (ContextConsoleCommonInterface contextConsoleCommonInterface : this.subclasses) {
                contextConsoleCommonInterface.setAndFillExtension(parser, ctx, auth);
            }
        }
        catch (OXConsolePluginException e) {
            this.printError(null, null, "Error while parsing extension options: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
    }

    protected void extensionConstantProcessing(HashMap<String, UserAbstraction.CSVConstants> constantsMap) {
        for (ContextConsoleCommonInterface contextConsoleCommonInterface : this.subclasses) {
            if (!(contextConsoleCommonInterface instanceof ContextConsoleCreateInterface)) continue;
            ((ContextConsoleCreateInterface)contextConsoleCommonInterface).processCSVConstants(constantsMap);
        }
    }

    @Override
    protected void setAdminPassOption(AdminParser admp) {
        this.adminPassOption = this.setShortLongOpt(admp, 'P', "adminpass", OPT_NAME_ADMINPASS_DESCRIPTION, true, AdminParser.NeededQuadState.possibly);
    }

    @Override
    protected void setAdminUserOption(AdminParser admp) {
        this.adminUserOption = this.setShortLongOpt(admp, 'A', "adminuser", OPT_NAME_ADMINUSER_DESCRIPTION, true, AdminParser.NeededQuadState.possibly);
    }

    protected void setExtensionOptions(AdminParser parser, Class<? extends ContextConsoleCommonInterface> clazz) {
        try {
            this.subclasses = ServiceLoader.load(clazz);
        }
        catch (IllegalAccessException e) {
            this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        catch (InstantiationException e) {
            this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        catch (ClassNotFoundException e) {
            this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        catch (IOException e) {
            this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        try {
            for (ContextConsoleCommonInterface contextConsoleCommonInterface : this.subclasses) {
                contextConsoleCommonInterface.addExtensionOptions(parser);
            }
        }
        catch (OXConsolePluginException e) {
            this.printError(null, null, "Error while adding extension options: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
    }

    protected void setContextQuotaOption(AdminParser parser, boolean required) {
        this.contextQuotaOption = this.setShortLongOpt(parser, 'q', OPT_QUOTA_LONG, OPT_NAME_CONTEXT_QUOTA_DESCRIPTION, true, this.convertBooleantoTriState(required));
    }

    protected void sysoutOutput(Context[] ctxs, final AdminParser parser) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Context ctx : ctxs) {
            data.add(this.makeData(ctx, new ClosureInterface(){

                @Override
                public ArrayList<String> getData(Context ctx) {
                    return ContextAbstraction.this.getHumanReableDataOfAllExtensions(ctx, parser);
                }
            }));
        }
        ArrayList<String> humanReadableColumnsOfAllExtensions = this.getHumanReadableColumnsOfAllExtensions(parser);
        ArrayList<String> alignment = new ArrayList<String>();
        alignment.add("r");
        alignment.add("r");
        alignment.add("l");
        alignment.add("l");
        alignment.add("r");
        alignment.add("r");
        alignment.add("l");
        alignment.add("l");
        for (int i = 0; i < humanReadableColumnsOfAllExtensions.size(); ++i) {
            alignment.add("l");
        }
        ArrayList<String> columnnames = new ArrayList<String>();
        columnnames.add("cid");
        columnnames.add("fid");
        columnnames.add("fname");
        columnnames.add("enabled");
        columnnames.add("qmax");
        columnnames.add("qused");
        columnnames.add(OPT_NAME_DBNAME_LONG);
        columnnames.add("lmappings");
        columnnames.addAll(humanReadableColumnsOfAllExtensions);
        this.doOutput(alignment.toArray(new String[alignment.size()]), columnnames.toArray(new String[columnnames.size()]), data);
    }

    protected void precsvinfos(Context[] ctxs, final AdminParser parser) throws InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("filestore_id");
        columns.add("filestore_name");
        columns.add("enabled");
        columns.add("max_quota");
        columns.add("used_quota");
        columns.add(OPT_NAME_DBNAME_LONG);
        columns.add("lmappings");
        columns.addAll(this.getCSVColumnsOfAllExtensions(parser));
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (final Context ctx_tmp : ctxs) {
            data.add(this.makeData(ctx_tmp, new ClosureInterface(){

                @Override
                public ArrayList<String> getData(Context ctx) {
                    return ContextAbstraction.this.getCSVDataOfAllExtensions(ctx_tmp, parser);
                }
            }));
        }
        this.doCSVOutput(columns, data);
    }

    protected void setDatabaseIDOption(AdminParser parser) {
        this.databaseIdOption = this.setShortLongOpt(parser, 'd', OPT_NAME_DATABASE_ID_LONG, "The id of the database.", true, AdminParser.NeededQuadState.eitheror);
    }

    protected void setDatabaseNameOption(AdminParser parser, AdminParser.NeededQuadState required) {
        this.databaseNameOption = this.setShortLongOpt(parser, 'n', OPT_NAME_DBNAME_LONG, "Name of the database", true, required);
    }

    protected final void displayDisabledMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "disabled", parser);
    }

    protected final void displayEnabledMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "enabled", parser);
    }

    protected final void displayDowngradedMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "invisible data deleted", parser);
    }

    protected final void displayMovedMessage(String id, Integer ctxid, String text, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, text, parser);
    }

    @Override
    protected void printFirstPartOfErrorText(String id, Integer ctxid, AdminParser parser) {
        if (this.getClass().getName().matches("^.*\\.\\w*(?i)enable\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be enabled: ", parser);
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)disable\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be disabled: ", parser);
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)move\\wdatabase\\w*$")) {
            StringBuilder sb = new StringBuilder(this.getObjectName());
            if (null != id) {
                sb.append(" ");
                sb.append(id);
            }
            if (null != ctxid) {
                sb.append(" to database ");
                sb.append(ctxid);
            }
            sb.append(" could not be scheduled: ");
            System.err.println(sb.toString());
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)move\\wfilestore\\w*$")) {
            StringBuilder sb = new StringBuilder(this.getObjectName());
            if (null != id) {
                sb.append(" ");
                sb.append(id);
            }
            if (null != ctxid) {
                sb.append(" to filestore ");
                sb.append(ctxid);
            }
            sb.append(" could not be scheduled: ");
            System.err.println(sb.toString());
        } else {
            super.printFirstPartOfErrorText(id, ctxid, parser);
        }
    }

    protected void parseAndSetDatabaseID(AdminParser parser, Database db) {
        String optionvalue = (String)parser.getOptionValue(this.databaseIdOption);
        if (null != optionvalue) {
            this.dbid = Integer.parseInt(optionvalue);
            db.setId(this.dbid);
        }
    }

    protected void parseAndSetDatabasename(AdminParser parser, Database db) {
        this.dbname = (String)parser.getOptionValue(this.databaseNameOption);
        if (null != this.dbname) {
            db.setName(this.dbname);
        }
    }

    protected void setFilestoreIdOption(AdminParser parser) {
        this.targetFilestoreIDOption = this.setShortLongOpt(parser, 'f', OPT_FILESTORE_LONG, "Target filestore id", true, AdminParser.NeededQuadState.needed);
    }

    protected Filestore parseAndSetFilestoreId(AdminParser parser) {
        this.filestoreid = Integer.parseInt((String)parser.getOptionValue(this.targetFilestoreIDOption));
        Filestore fs = new Filestore(this.filestoreid);
        return fs;
    }

    @Override
    protected Context getContext(String[] nextLine, int[] idarray) throws InvalidDataException, ParseException {
        final Context context = super.getContext(nextLine, idarray);
        ContextAbstraction.setValue(nextLine, idarray, (UserAbstraction.CSVConstants)ContextConstants.contextname, new UserAbstraction.MethodStringClosure(){

            public void callMethod(String value) throws ParseException, InvalidDataException {
                context.setName(value);
            }
        });
        ContextAbstraction.setValue(nextLine, idarray, (UserAbstraction.CSVConstants)ContextConstants.lmapping, new UserAbstraction.MethodStringClosure(){

            public void callMethod(String value) throws ParseException, InvalidDataException {
                context.addLoginMapping(value);
            }
        });
        ContextAbstraction.setValue(nextLine, idarray, (UserAbstraction.CSVConstants)ContextConstants.quota, new UserAbstraction.MethodStringClosure(){

            public void callMethod(String value) throws ParseException, InvalidDataException {
                try {
                    context.setMaxQuota(Long.valueOf(value));
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("Value in field " + UserAbstraction.Constants.CONTEXTID.getString() + " is no integer");
                }
            }
        });
        return context;
    }

    public final Integer getFilestoreid() {
        return this.filestoreid;
    }

    protected ArrayList<String> getHumanReadableColumnsOfAllExtensions(AdminParser parser) {
        return new ArrayList<String>();
    }

    protected ArrayList<String> getHumanReableDataOfAllExtensions(Context ctx, AdminParser parser) {
        return new ArrayList<String>();
    }

    protected Collection<? extends String> getCSVColumnsOfAllExtensions(AdminParser parser) {
        return new ArrayList();
    }

    protected ArrayList<String> getCSVDataOfAllExtensions(Context ctx_tmp, AdminParser parser) {
        return new ArrayList<String>();
    }

    private ArrayList<String> makeData(Context ctx, ClosureInterface iface) {
        ArrayList<String> srv_data = new ArrayList<String>();
        srv_data.add(String.valueOf(ctx.getId()));
        Integer filestoreId = ctx.getFilestoreId();
        if (filestoreId != null) {
            srv_data.add(String.valueOf(filestoreId));
        } else {
            srv_data.add(null);
        }
        String filestore_name = ctx.getFilestore_name();
        if (filestore_name != null) {
            srv_data.add(filestore_name);
        } else {
            srv_data.add(null);
        }
        Boolean enabled = ctx.isEnabled();
        if (enabled != null) {
            srv_data.add(String.valueOf(enabled));
        } else {
            srv_data.add(null);
        }
        Long maxQuota = ctx.getMaxQuota();
        if (maxQuota != null) {
            srv_data.add(String.valueOf(maxQuota));
        } else {
            srv_data.add(null);
        }
        Long usedQuota = ctx.getUsedQuota();
        if (usedQuota != null) {
            srv_data.add(String.valueOf(usedQuota));
        } else {
            srv_data.add(null);
        }
        String name = ctx.getName();
        if (name != null) {
            srv_data.add(name);
        } else {
            srv_data.add(null);
        }
        HashSet<String> loginMappings = ctx.getLoginMappings();
        if (loginMappings != null && loginMappings.size() > 0) {
            srv_data.add(this.getObjectsAsString(loginMappings.toArray()));
        } else {
            srv_data.add(null);
        }
        srv_data.addAll(iface.getData(ctx));
        return srv_data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ContextConstants implements UserAbstraction.CSVConstants
    {
        contextname(CONTEXT_INITIAL_CONSTANTS_VALUE, "contextname", false),
        quota(CONTEXT_INITIAL_CONSTANTS_VALUE + 1, "quota", true),
        lmapping(CONTEXT_INITIAL_CONSTANTS_VALUE + 2, "addmapping", false);

        private final String string;
        private final int index;
        private boolean required;

        private ContextConstants(int index, String string2, boolean required) {
            this.index = index;
            this.string = string2;
            this.required = required;
        }

        @Override
        public String getString() {
            return this.string;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public void setRequired(boolean required) {
            this.required = required;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClosureInterface {
        public ArrayList<String> getData(Context var1);
    }
}

