/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.CLIIllegalOptionValueException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class CLIOption {
    private final String shortForm;
    private final String longForm;
    private final boolean wantsValue;

    protected CLIOption(String longForm, boolean wantsValue) {
        this(null, longForm, wantsValue);
    }

    protected CLIOption(char shortForm, String longForm, boolean wantsValue) {
        this(String.valueOf(shortForm), longForm, wantsValue);
    }

    protected CLIOption(String shortForm, String longForm, boolean wantsValue) {
        if (null == longForm) {
            throw new IllegalArgumentException("longForm must not be null");
        }
        this.shortForm = shortForm;
        this.longForm = longForm;
        this.wantsValue = wantsValue;
    }

    public String shortForm() {
        return this.shortForm;
    }

    public String longForm() {
        return this.longForm;
    }

    public boolean wantsValue() {
        return this.wantsValue;
    }

    public Object parseValue(String value, Locale locale) throws CLIIllegalOptionValueException {
        if (!this.wantsValue) {
            return Boolean.TRUE;
        }
        if (value == null) {
            throw new CLIIllegalOptionValueException(this, "");
        }
        return this.parseValueInternal(value, locale);
    }

    protected Object parseValueInternal(String value, Locale locale) throws CLIIllegalOptionValueException {
        return null;
    }

    public static class CLIStringOption
    extends CLIOption {
        public CLIStringOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        public CLIStringOption(String longForm) {
            super(longForm, true);
        }

        protected Object parseValueInternal(String value, Locale locale) {
            return value;
        }
    }

    public static class CLIDoubleOption
    extends CLIOption {
        public CLIDoubleOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        public CLIDoubleOption(String longForm) {
            super(longForm, true);
        }

        protected Object parseValueInternal(String value, Locale locale) throws CLIIllegalOptionValueException {
            try {
                Number num = NumberFormat.getNumberInstance(locale).parse(value);
                return num.doubleValue();
            }
            catch (ParseException e) {
                throw new CLIIllegalOptionValueException(this, value, e);
            }
        }
    }

    public static class CLILongOption
    extends CLIOption {
        public CLILongOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        public CLILongOption(String longForm) {
            super(longForm, true);
        }

        protected Object parseValueInternal(String value, Locale locale) throws CLIIllegalOptionValueException {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new CLIIllegalOptionValueException(this, value, e);
            }
        }
    }

    public static class CLIIntegerOption
    extends CLIOption {
        public CLIIntegerOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        public CLIIntegerOption(String longForm) {
            super(longForm, true);
        }

        protected Object parseValueInternal(String value, Locale locale) throws CLIIllegalOptionValueException {
            if (null == value || value.length() == 0) {
                return null;
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new CLIIllegalOptionValueException(this, value, e);
            }
        }
    }

    public static class CLISettableBooleanOption
    extends CLIOption {
        private static final String[] VALUES_FALSE = new String[]{"no", "false", "0"};
        private static final String[] VALUES_TRUE = new String[]{"", "yes", "true", "1"};

        public CLISettableBooleanOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        public CLISettableBooleanOption(String longForm) {
            super(longForm, true);
        }

        protected Object parseValueInternal(String value, Locale locale) throws CLIIllegalOptionValueException {
            for (String next : VALUES_TRUE) {
                if (!value.equalsIgnoreCase(next)) continue;
                return Boolean.TRUE;
            }
            for (String next : VALUES_FALSE) {
                if (!value.equalsIgnoreCase(next)) continue;
                return Boolean.FALSE;
            }
            throw new CLIIllegalOptionValueException(this, value);
        }
    }

    public static class CLIBooleanOption
    extends CLIOption {
        public CLIBooleanOption(char shortForm, String longForm) {
            super(shortForm, longForm, false);
        }

        public CLIBooleanOption(String longForm) {
            super(longForm, false);
        }
    }
}

