/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.BasicCommandlineOptions;
import com.openexchange.admin.console.CLIIllegalOptionValueException;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.CLIParseException;
import com.openexchange.admin.console.CLIUnknownOptionException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.MissingOptionException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJMXTools
extends BasicCommandlineOptions {
    protected static final String JMX_ADMIN_PORT = "9998";
    protected static final String JMX_SERVER_PORT = "9999";
    protected static final String OPT_HOST_LONG = "host";
    protected static final char OPT_HOST_SHORT = 'H';
    protected static final String OPT_JMX_AUTH_PASSWORD_LONG = "jmxauthpassword";
    protected static final char OPT_JMX_AUTH_PASSWORD_SHORT = 'P';
    protected static final String OPT_JMX_AUTH_USER_LONG = "jmxauthuser";
    protected static final char OPT_JMX_AUTH_USER_SHORT = 'J';
    private static final String CRLF = "\r\n";
    protected String JMX_HOST = "localhost";
    protected CLIOption host = null;
    protected CLIOption jmxpass = null;
    protected CLIOption jmxuser = null;
    JMXConnector c = null;
    String ox_jmx_url = null;

    protected void closeConnection() {
        if (this.c != null) {
            try {
                this.c.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected StringBuffer getStats(MBeanServerConnection mbc, String class_name) throws IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException, IntrospectionException {
        StringBuffer retval = new StringBuffer();
        for (ObjectInstance oin : mbc.queryMBeans(null, null)) {
            ObjectName obj = oin.getObjectName();
            MBeanInfo info = mbc.getMBeanInfo(obj);
            if (!info.getClassName().equals(class_name)) continue;
            String ocname = obj.getCanonicalName();
            MBeanAttributeInfo[] attrs = info.getAttributes();
            if (attrs.length <= 0) continue;
            for (MBeanAttributeInfo element : attrs) {
                try {
                    Object[] c;
                    Object o = mbc.getAttribute(obj, element.getName());
                    if (o == null) continue;
                    StringBuilder sb = new StringBuilder(ocname).append(",").append(element.getName()).append(" = ");
                    if (o instanceof CompositeDataSupport) {
                        c = (Object[])o;
                        sb.append("[init=").append(c.get("init")).append(",max=").append(c.get("max")).append(",committed=").append(c.get("committed")).append(",used=").append(c.get("used")).append("]");
                        retval.append((CharSequence)sb.append(CRLF));
                        continue;
                    }
                    if (o instanceof String[]) {
                        c = (String[])o;
                        retval.append((CharSequence)sb.append(Arrays.toString(c)).append(CRLF));
                        continue;
                    }
                    if (o instanceof long[]) {
                        long[] l = (long[])o;
                        retval.append((CharSequence)sb.append(Arrays.toString(l)).append(CRLF));
                        continue;
                    }
                    retval.append((CharSequence)sb.append(o.toString()).append(CRLF));
                }
                catch (RuntimeMBeanException e) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    protected MBeanServerConnection initConnection(boolean adminstats, final HashMap<String, String[]> env) throws InterruptedException, IOException {
        this.updatejmxurl(adminstats);
        long timeout = 2000L;
        final JMXServiceURL serviceurl = new JMXServiceURL(this.ox_jmx_url);
        final IOException[] exc = new IOException[1];
        final RuntimeException[] excr = new RuntimeException[1];
        Thread t = new Thread(){

            public void run() {
                try {
                    AbstractJMXTools.this.c = JMXConnectorFactory.connect(serviceurl, env);
                }
                catch (IOException e) {
                    exc[0] = e;
                }
                catch (RuntimeException e) {
                    excr[0] = e;
                }
            }
        };
        t.start();
        t.join(2000L);
        if (t.isAlive()) {
            t.interrupt();
            throw new InterruptedIOException("Connection timed out");
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        if (excr[0] != null) {
            throw excr[0];
        }
        return this.c.getMBeanServerConnection();
    }

    protected void setOptions(AdminParser parser) {
        this.host = this.setShortLongOpt(parser, 'H', OPT_HOST_LONG, OPT_HOST_LONG, "specifies the host", false);
        this.jmxuser = this.setShortLongOpt(parser, 'J', OPT_JMX_AUTH_USER_LONG, "jmx username (required when jmx authentication enabled)", true, AdminParser.NeededQuadState.notneeded);
        this.jmxpass = this.setShortLongOpt(parser, 'P', OPT_JMX_AUTH_PASSWORD_LONG, "jmx username (required when jmx authentication enabled)", true, AdminParser.NeededQuadState.notneeded);
        this.setFurtherOptions(parser);
    }

    protected abstract void setFurtherOptions(AdminParser var1);

    protected void updatejmxurl(boolean showAdminStats) {
        String jmxPort = showAdminStats ? JMX_ADMIN_PORT : JMX_SERVER_PORT;
        this.ox_jmx_url = "service:jmx:rmi:///jndi/rmi://" + this.JMX_HOST + ':' + jmxPort + "/server";
    }

    protected Object doOperation(MBeanServerConnection mbc, String fullqualifiedoperationname) throws MalformedObjectNameException, NullPointerException, IOException, InvalidDataException, InstanceNotFoundException, MBeanException, ReflectionException {
        String[] split = fullqualifiedoperationname.split("!");
        if (2 == split.length) {
            ObjectName objectName = new ObjectName(split[0]);
            Object result = mbc.invoke(objectName, split[1], null, null);
            if (result instanceof Object[]) {
                return Arrays.toString((Object[])result);
            }
            return result;
        }
        if (2 <= split.length) {
            ObjectName objectName = new ObjectName(split[0]);
            Object[] param = new String[split.length - 2];
            System.arraycopy(split, 2, param, 0, split.length - 2);
            String[] signature = new String[split.length - 2];
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = "java.lang.String";
            }
            Object result = mbc.invoke(objectName, split[1], param, signature);
            if (result instanceof Object[]) {
                return Arrays.toString((Object[])result);
            }
            return result;
        }
        throw new InvalidDataException("The given operationname is not valid. It couldn't be split at \"!\"");
    }

    protected HashMap<String, String[]> setCreds(AdminParser parser, HashMap<String, String[]> env) throws CLIIllegalOptionValueException {
        String jmxuser = (String)parser.getOptionValue(this.jmxuser);
        String jmxpass = (String)parser.getOptionValue(this.jmxpass);
        if (jmxuser != null && jmxuser.trim().length() > 0) {
            if (jmxpass == null) {
                throw new CLIIllegalOptionValueException(this.jmxpass, null);
            }
            env = new HashMap();
            String[] creds = new String[]{jmxuser, jmxpass};
            env.put("jmx.remote.credentials", creds);
        }
        return env;
    }

    protected void readAndSetHost(AdminParser parser) {
        String host = (String)parser.getOptionValue(this.host);
        if (null != host) {
            this.JMX_HOST = host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args, String commandlinetoolname) {
        AdminParser parser = new AdminParser(commandlinetoolname);
        this.setOptions(parser);
        try {
            parser.ownparse(args);
            HashMap<String, String[]> env = null;
            env = this.setCreds(parser, env);
            this.readAndSetHost(parser);
            this.furtherOptionsHandling(parser, env);
        }
        catch (CLIParseException e) {
            this.printError("Parsing command-line failed : " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        }
        catch (CLIIllegalOptionValueException e) {
            this.printError("Illegal option value : " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        }
        catch (CLIUnknownOptionException e) {
            this.printError("Unrecognized options on the command line: " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(111);
        }
        catch (MissingOptionException e) {
            this.printError(e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(104);
        }
        catch (MalformedURLException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (IOException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (InstanceNotFoundException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (AttributeNotFoundException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (IntrospectionException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (MBeanException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (ReflectionException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (InterruptedException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (MalformedObjectNameException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (NullPointerException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (InvalidDataException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        finally {
            this.closeConnection();
        }
    }

    protected abstract void furtherOptionsHandling(AdminParser var1, HashMap<String, String[]> var2) throws InterruptedException, IOException, MalformedURLException, InstanceNotFoundException, AttributeNotFoundException, IntrospectionException, MBeanException, ReflectionException, MalformedObjectNameException, InvalidDataException;
}

