/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.context.ContextAbstraction;
import com.openexchange.admin.rmi.OXContextInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Database;
import java.rmi.Naming;

public class ListContextByDatabase
extends ContextAbstraction {
    protected void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setDatabaseIDOption(parser);
        this.setDatabaseNameOption(parser, AdminParser.NeededQuadState.eitheror);
        this.setCSVOutputOption(parser);
    }

    public ListContextByDatabase(String[] args2) {
        AdminParser parser = new AdminParser("listcontext");
        this.setOptions(parser);
        String successtext = null;
        try {
            parser.ownparse(args2);
            Database db = new Database();
            this.parseAndSetDatabaseID(parser, db);
            this.parseAndSetDatabasename(parser, db);
            successtext = this.nameOrIdSetInt(db.getId(), db.getName(), "database");
            Credentials auth = this.credentialsparsing(parser);
            OXContextInterface oxctx = (OXContextInterface)Naming.lookup(RMI_HOSTNAME + "OXContext_V2");
            Context[] ctxs = oxctx.listByDatabase(db, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(ctxs, parser);
            } else {
                this.sysoutOutput(ctxs, parser);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(successtext, null, e, parser);
        }
    }

    public static void main(String[] args) {
        new ListContextByDatabase(args);
    }

    protected final String getObjectName() {
        return "contexts for database";
    }
}

