/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.ObjectNamingAbstraction;
import com.openexchange.admin.rmi.OXContextInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.NoSuchFilestoreException;
import com.openexchange.admin.rmi.exceptions.NoSuchReasonException;
import com.openexchange.admin.rmi.exceptions.OXContextException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.rmi.RemoteException;
import java.util.Arrays;

public class ContextHostingAbstraction
extends ObjectNamingAbstraction {
    private String[] remove_mappings = null;
    private String[] add_mappings = null;
    private CLIOption addLoginMappingOption = null;
    private CLIOption removeLoginMappingOption = null;

    protected String getObjectName() {
        return "context";
    }

    public void parseAndSetRemoveLoginMapping(AdminParser parser) {
        if (parser.getOptionValue(this.removeLoginMappingOption) != null) {
            this.remove_mappings = ((String)parser.getOptionValue(this.removeLoginMappingOption)).split(",");
        }
    }

    public void parseAndSetAddLoginMapping(AdminParser parser) {
        if (parser.getOptionValue(this.addLoginMappingOption) != null) {
            this.add_mappings = ((String)parser.getOptionValue(this.addLoginMappingOption)).split(",");
        }
    }

    public void setAddMappingOption(AdminParser parser, boolean required) {
        this.addLoginMappingOption = this.setShortLongOpt(parser, 'L', "addmapping", "Add login mappings.Seperated by \",\"", true, this.convertBooleantoTriState(required));
    }

    public void setRemoveMappingOption(AdminParser parser, boolean required) {
        this.removeLoginMappingOption = this.setShortLongOpt(parser, 'R', "removemapping", "Remove login mappings.Seperated by \",\"", true, this.convertBooleantoTriState(required));
    }

    public void changeMappingSetting(OXContextInterface oxres, Context ctx, Credentials auth, boolean change) throws RemoteException, InvalidCredentialsException, NoSuchContextException, StorageException, InvalidDataException {
        if (this.add_mappings != null || this.remove_mappings != null) {
            if (change) {
                Context server_ctx = oxres.getData(ctx, auth);
                ctx.setLoginMappings(server_ctx.getLoginMappings());
            } else {
                ctx.addLoginMapping(ctx.getIdAsString());
            }
            if (this.add_mappings != null) {
                ctx.addLoginMappings(Arrays.asList(this.add_mappings));
            }
            if (this.remove_mappings != null) {
                ctx.removeLoginMappings(Arrays.asList(this.remove_mappings));
            }
        }
    }

    protected void printErrors(String id, Integer ctxid, Exception e, AdminParser parser) {
        if (e instanceof NoSuchReasonException) {
            NoSuchReasonException exc = (NoSuchReasonException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof OXContextException) {
            OXContextException exc = (OXContextException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof NoSuchFilestoreException) {
            NoSuchFilestoreException exc = (NoSuchFilestoreException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else {
            super.printErrors(id, ctxid, e, parser);
        }
    }
}

