/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenPolicyValidator
extends AbstractSamlPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private Message message;

    public IssuedTokenPolicyValidator(List<WSSecurityEngineResult> signedResults, Message message) {
        this.signedResults = signedResults;
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim, WSSecurityEngineResult wser) {
        Collection issuedAis = (Collection)aim.get(SP12Constants.ISSUED_TOKEN);
        if (issuedAis != null && !issuedAis.isEmpty()) {
            for (AssertionInfo ai : issuedAis) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)wser.get((Object)"saml-assertion");
                IssuedToken issuedToken = (IssuedToken)ai.getAssertion();
                ai.setAsserted(true);
                Element template = issuedToken.getRstTemplate();
                if (template != null && !this.checkIssuedTokenTemplate(template, assertionWrapper)) {
                    ai.setNotAsserted("Error in validating the IssuedToken policy");
                    return false;
                }
                TLSSessionInfo tlsInfo = this.message.get(TLSSessionInfo.class);
                Certificate[] tlsCerts = null;
                if (tlsInfo != null) {
                    tlsCerts = tlsInfo.getPeerCertificates();
                }
                if (this.checkHolderOfKey(assertionWrapper, this.signedResults, tlsCerts)) continue;
                ai.setNotAsserted("Assertion fails holder-of-key requirements");
                return false;
            }
        }
        return true;
    }

    private boolean checkIssuedTokenTemplate(Element template, AssertionWrapper assertionWrapper) {
        Element child = DOMUtils.getFirstElement(template);
        while (child != null) {
            SAMLKeyInfo subjectKeyInfo;
            String content;
            if ("TokenType".equals(child.getLocalName())) {
                content = child.getTextContent();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
                    return false;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_20) {
                    return false;
                }
            } else if ("KeyType".equals(child.getLocalName()) && ((content = child.getTextContent()).endsWith("SymmetricKey") ? (subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getSecret() == null : content.endsWith("PublicKey") && ((subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getPublicKey() == null && subjectKeyInfo.getCerts() == null))) {
                return false;
            }
            child = DOMUtils.getNextElement(child);
        }
        return true;
    }
}

