/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.folderstorage.internal;

import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExtension;
import com.openexchange.folderstorage.FolderField;
import com.openexchange.folderstorage.FolderProperty;
import com.openexchange.folderstorage.ParameterizedFolder;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.i18n.LocaleTools;

/**
 * {@link UserizedFolderImpl} - The {@link UserizedFolder} implementation.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class UserizedFolderImpl implements UserizedFolder {

    private static final long serialVersionUID = 5090343231211791986L;

    private Folder folder;

    private Permission ownPermission;

    private Date lastModifiedUTC;

    private Locale locale;

    private Boolean deefault;

    private Integer defaultType;

    private Type type;

    private Permission[] permissions;

    private String[] subfolderIds;

    private String parentId;

    private Date creationDate;

    private Date lastModified;

    private volatile Map<FolderField, FolderProperty> properties;

    private int[] totalAndUnread;

    /**
     * Initializes a new {@link UserizedFolderImpl} from specified folder.
     *
     * @param folder The underlying folder
     * @throws IllegalArgumentException If folder is <code>null</code>
     */
    public UserizedFolderImpl(final Folder folder) {
        super();
        if (null == folder) {
            throw new IllegalArgumentException("Folder is null.");
        }
        // TODO: clone folder?
        this.folder = folder;
    }

    @Override
    public String toString() {
        return new StringBuilder(32).append("{ name=").append(folder.getName()).append(", id=").append(folder.getID()).append('}').toString();
    }

    @Override
    public Object clone() {
        try {
            final UserizedFolderImpl clone = (UserizedFolderImpl) super.clone();
            clone.folder = (Folder) clone.folder.clone();
            clone.ownPermission = ownPermission == null ? null : (Permission) ownPermission.clone();
            clone.lastModifiedUTC = null == lastModifiedUTC ? null : new Date(lastModifiedUTC.getTime());
            clone.locale = (Locale) (null == locale ? null : locale.clone());
            return clone;
        } catch (final CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public int getBits() {
        return folder.getBits();
    }

    public void setBits(final int bits) {
        folder.setBits(bits);
    }

    public int getCreatedBy() {
        return folder.getCreatedBy();
    }

    public Date getCreationDate() {
        return creationDate == null ? folder.getCreationDate() : creationDate;
    }

    public Date getLastModified() {
        return lastModified == null ? folder.getLastModified() : lastModified;
    }

    public int getModifiedBy() {
        return folder.getModifiedBy();
    }

    public void setCreatedBy(final int createdBy) {
        folder.setCreatedBy(createdBy);
    }

    public void setCreationDate(final Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    public void setLastModified(final Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }

    public void setModifiedBy(final int modifiedBy) {
        folder.setModifiedBy(modifiedBy);
    }

    public ContentType getContentType() {
        return folder.getContentType();
    }

    public String getID() {
        return folder.getID();
    }

    public String getLocalizedName(final Locale locale) {
        return folder.getLocalizedName(null == locale ? LocaleTools.DEFAULT_LOCALE : locale);
    }

    public String getName() {
        return folder.getName();
    }

    public String getParentID() {
        return null == parentId ? folder.getParentID() : parentId;
    }

    public Permission[] getPermissions() {
        return null == permissions ? folder.getPermissions() : permissions;
    }

    public String[] getSubfolderIDs() {
        return subfolderIds == null ? folder.getSubfolderIDs() : subfolderIds;
    }

    public String getTreeID() {
        return folder.getTreeID();
    }

    public Type getType() {
        return null == type ? folder.getType() : type;
    }

    public boolean isCacheable() {
        return folder.isCacheable();
    }

    public boolean isGlobalID() {
        return folder.isGlobalID();
    }

    public boolean isSubscribed() {
        return folder.isSubscribed();
    }

    public boolean hasSubscribedSubfolders() {
        return folder.hasSubscribedSubfolders();
    }

    public boolean isVirtual() {
        return folder.isVirtual();
    }

    public void setContentType(final ContentType contentType) {
        folder.setContentType(contentType);
    }

    public void setID(final String id) {
        folder.setID(id);
    }

    public void setName(final String name) {
        folder.setName(name);
    }

    public void setParentID(final String parentId) {
        this.parentId = parentId;
    }

    public void setPermissions(final Permission[] permissions) {
        this.permissions = permissions;
    }

    public void setSubfolderIDs(final String[] subfolderIds) {
        this.subfolderIds = subfolderIds;
    }

    public void setSubscribed(final boolean subscribed) {
        folder.setSubscribed(subscribed);
    }

    public void setSubscribedSubfolders(final boolean subscribedSubfolders) {
        folder.setSubscribedSubfolders(subscribedSubfolders);
    }

    public void setTreeID(final String id) {
        folder.setTreeID(id);
    }

    public void setType(final Type type) {
        this.type = type;
    }

    public Permission getOwnPermission() {
        return ownPermission;
    }

    public void setOwnPermission(final Permission ownPermission) {
        this.ownPermission = ownPermission;
    }

    public Date getLastModifiedUTC() {
        return lastModifiedUTC == null ? null : new Date(lastModifiedUTC.getTime());
    }

    public void setLastModifiedUTC(final Date lastModifiedUTC) {
        this.lastModifiedUTC = lastModifiedUTC == null ? null : new Date(lastModifiedUTC.getTime());
    }

    public int getCapabilities() {
        return folder.getCapabilities();
    }

    public int getDeleted() {
        return folder.getDeleted();
    }

    public int getNew() {
        return folder.getNew();
    }

    public String getSummary() {
        return folder.getSummary();
    }

    public int getTotal() {
        if (null == totalAndUnread) {
            if (folder instanceof FolderExtension) {
                totalAndUnread = ((FolderExtension) folder).getTotalAndUnread();
                if (null != totalAndUnread) {
                    return totalAndUnread[0];
                }
            }
        } else {
            return totalAndUnread[0];
        }
        return folder.getTotal();
    }

    public int getUnread() {
        if (null == totalAndUnread) {
            if (folder instanceof FolderExtension) {
                totalAndUnread = ((FolderExtension) folder).getTotalAndUnread();
                if (null != totalAndUnread) {
                    return totalAndUnread[1];
                }
            }
        } else {
            return totalAndUnread[1];
        }
        return folder.getUnread();
    }

    public boolean isDefault() {
        return null == deefault ? folder.isDefault() : deefault.booleanValue();
    }

    public void setCapabilities(final int capabilities) {
        folder.setCapabilities(capabilities);
    }

    public void setDefault(final boolean deefault) {
        this.deefault = Boolean.valueOf(deefault);
    }

    public void setDeleted(final int deleted) {
        folder.setDeleted(deleted);
    }

    public void setDefaultType(final int defaultType) {
        this.defaultType = Integer.valueOf(defaultType);
    }

    public int getDefaultType() {
        return null == defaultType ? folder.getDefaultType() : defaultType.intValue();
    }

    public void setNew(final int nu) {
        folder.setNew(nu);
    }

    public void setSummary(final String summary) {
        folder.setSummary(summary);
    }

    public void setTotal(final int total) {
        folder.setTotal(total);
    }

    public void setUnread(final int unread) {
        folder.setUnread(unread);
    }

    public Locale getLocale() {
        return locale;
    }

    public void setLocale(final Locale locale) {
        this.locale = locale;
    }

    public String getNewID() {
        throw new UnsupportedOperationException("UserizedFolderImpl.getNewID()");
    }

    public void setNewID(final String newId) {
        throw new UnsupportedOperationException("UserizedFolderImpl.setNewID()");
    }

    public void setProperty(final FolderField name, final Object value) {
        // Nope...
    }

    public Map<FolderField, FolderProperty> getProperties() {
        Map<FolderField, FolderProperty> map = this.properties;
        if (null == map) {
            synchronized (this) {
                map = this.properties;
                if (null == map) {
                    if (folder instanceof ParameterizedFolder) {
                        final ParameterizedFolder parameterizedFolder = (ParameterizedFolder) folder;
                        map = parameterizedFolder.getProperties();
                    } else {
                        map = Collections.emptyMap();
                    }
                    this.properties = map;
                }
            }
        }
        return map;
    }

}
