/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.folderstorage;

import java.util.Date;
import java.util.Locale;

/**
 * {@link RemoveAfterAccessFolderWrapper} - Simple wrapper for {@link Folder} to enhance with {@link RemoveAfterAccessFolder} behavior.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class RemoveAfterAccessFolderWrapper implements RemoveAfterAccessFolder {

    private static final long serialVersionUID = 5320754019338469187L;

    private final Folder folder;

    private final boolean loadSubfolders;

    private final int userId;

    private final int contextId;

    /**
     * Initializes a new {@link RemoveAfterAccessFolderWrapper}.
     */
    public RemoveAfterAccessFolderWrapper(final Folder folder, final boolean loadSubfolders, final int userId, final int contextId) {
        super();
        this.folder = folder;
        this.loadSubfolders = loadSubfolders;
        this.userId = userId;
        this.contextId = contextId;
    }

    public int getContextId() {
        return contextId;
    }
    
    public int getUserId() {
        return userId;
    }

    public boolean loadSubfolders() {
        return loadSubfolders;
    }

    @Override
    public int hashCode() {
        return folder.hashCode();
    }

    @Override
    public boolean equals(final Object obj) {
        return folder.equals(obj);
    }

    @Override
    public String toString() {
        return folder.toString();
    }

    public int getCreatedBy() {
        return folder.getCreatedBy();
    }

    public void setCreatedBy(final int createdBy) {
        folder.setCreatedBy(createdBy);
    }

    public int getModifiedBy() {
        return folder.getModifiedBy();
    }

    public void setModifiedBy(final int modifiedBy) {
        folder.setModifiedBy(modifiedBy);
    }

    public Date getCreationDate() {
        return folder.getCreationDate();
    }

    public void setCreationDate(final Date creationDate) {
        folder.setCreationDate(creationDate);
    }

    public Date getLastModified() {
        return folder.getLastModified();
    }

    public void setLastModified(final Date lastModified) {
        folder.setLastModified(lastModified);
    }

    public String getID() {
        return folder.getID();
    }

    public String getNewID() {
        return folder.getNewID();
    }

    public String getLocalizedName(final Locale locale) {
        return folder.getLocalizedName(locale);
    }

    public String getName() {
        return folder.getName();
    }

    public String getParentID() {
        return folder.getParentID();
    }

    public Permission[] getPermissions() {
        return folder.getPermissions();
    }

    public String[] getSubfolderIDs() {
        return folder.getSubfolderIDs();
    }

    public String getTreeID() {
        return folder.getTreeID();
    }

    public void setID(final String id) {
        folder.setID(id);
    }

    public void setNewID(final String newId) {
        folder.setNewID(newId);
    }

    public void setName(final String name) {
        folder.setName(name);
    }

    public void setParentID(final String parentId) {
        folder.setParentID(parentId);
    }

    public void setPermissions(final Permission[] permissions) {
        folder.setPermissions(permissions);
    }

    public void setSubfolderIDs(final String[] subfolderIds) {
        folder.setSubfolderIDs(subfolderIds);
    }

    public void setTreeID(final String id) {
        folder.setTreeID(id);
    }

    public boolean isSubscribed() {
        return folder.isSubscribed();
    }

    public void setSubscribed(final boolean subscribed) {
        folder.setSubscribed(subscribed);
    }

    public boolean hasSubscribedSubfolders() {
        return folder.hasSubscribedSubfolders();
    }

    public void setSubscribedSubfolders(final boolean subscribedSubfolders) {
        folder.setSubscribedSubfolders(subscribedSubfolders);
    }

    public boolean isVirtual() {
        return folder.isVirtual();
    }

    public String getSummary() {
        return folder.getSummary();
    }

    public void setSummary(final String summary) {
        folder.setSummary(summary);
    }

    public void setTotal(final int total) {
        folder.setTotal(total);
    }

    public int getNew() {
        return folder.getNew();
    }

    public void setNew(final int nu) {
        folder.setNew(nu);
    }

    public void setUnread(final int unread) {
        folder.setUnread(unread);
    }

    public int getDeleted() {
        return folder.getDeleted();
    }

    public void setDeleted(final int deleted) {
        folder.setDeleted(deleted);
    }

    public boolean isDefault() {
        return folder.isDefault();
    }

    public void setDefault(final boolean deefault) {
        folder.setDefault(deefault);
    }

    public int getCapabilities() {
        return folder.getCapabilities();
    }

    public void setCapabilities(final int capabilities) {
        folder.setCapabilities(capabilities);
    }

    public int getBits() {
        return folder.getBits();
    }

    public void setBits(final int bits) {
        folder.setBits(bits);
    }

    public int getUnread() {
        return folder.getUnread();
    }

    public int getTotal() {
        return folder.getTotal();
    }

    @Override
    public Object clone() {
        return folder.clone();
    }

    public boolean isCacheable() {
        return folder.isCacheable();
    }

    public ContentType getContentType() {
        return folder.getContentType();
    }

    public int getDefaultType() {
        return folder.getDefaultType();
    }

    public void setDefaultType(final int defaultType) {
        folder.setDefaultType(defaultType);
    }

    public Type getType() {
        return folder.getType();
    }

    public void setContentType(final ContentType contentType) {
        folder.setContentType(contentType);
    }

    public void setType(final Type type) {
        folder.setType(type);
    }

    public boolean isGlobalID() {
        return folder.isGlobalID();
    }

}
