/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.secret.osgi.tools;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import com.openexchange.secret.RankingAwareSecretService;
import com.openexchange.secret.SecretService;
import com.openexchange.session.Session;

/**
 * {@link WhiteboardSecretService} - Whiteboard pattern for {@link SecretService}.
 * 
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public class WhiteboardSecretService implements RankingAwareSecretService {

    private final ServiceTracker tracker;

    /**
     * Initializes a new {@link WhiteboardSecretService}.
     * 
     * @param context The bundle context
     */
    public WhiteboardSecretService(final BundleContext context) {
        tracker = new ServiceTracker(context, SecretService.class.getName(), null);
    }

    /**
     * Gets the ranking of the currently applicable {@link SecretService} reference.
     * 
     * @return The currently applicable service ranking
     */
    public int getRanking() {
        final ServiceReference reference = tracker.getServiceReference();
        if (null == reference) {
            return Integer.MIN_VALUE;
        }
        final Object ranking = reference.getProperty(org.osgi.framework.Constants.SERVICE_RANKING);
        return null == ranking ? Integer.MIN_VALUE : Integer.parseInt(ranking.toString().trim());
    }

    public String getSecret(final Session session) {
        /*-
         * If multiple services are being tracked, the service with the highest
         * ranking (as specified in its {@code service.ranking} property) is
         * returned. If there is a tie in ranking, the service with the lowest
         * service ID (as specified in its {@code service.id} property); that
         * is, the service that was registered first is returned. This is the same
         * algorithm used by {@code BundleContext.getServiceReference}.
         */
        final SecretService secretService = (SecretService) tracker.getService();
        if (secretService == null) {
            return null;
        }
        return secretService.getSecret(session);
    }

    /**
     * Open this {@link WhiteboardSecretService} and begin tracking {@link SecretService}.
     */
    public void open() {
        tracker.open();
    }

    /**
     * Close this {@link WhiteboardSecretService}.
     */
    public void close() {
        tracker.close();
    }

}
