/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.configuration.generator.test;

import java.util.Calendar;
import junit.framework.Assert;
import org.junit.Test;

import com.openexchange.mobile.configuration.generator.CabUtil;


public class CabUtilTest extends CabUtil {

    @Test
    public void testLittleEndianShort() {
        final short littleEndian = toLittleEndian((short)0x4010);
        Assert.assertTrue("Value of 0x4010 must be 0x1040, but is " + Integer.toHexString(littleEndian), littleEndian == (short)0x1040);
        System.out.println(Integer.toHexString(littleEndian));
    }

    @Test
    public void testLittleEndianShort2() {
        final short littleEndian = toLittleEndian((short)0xFFFE);
        Assert.assertTrue("Value of 0xFFFE must be 0xFEFF, but is " + Integer.toHexString(littleEndian), littleEndian == (short)0xFEFF);
    }
    
    @Test
    public void testLittleEndianShort3() {
        final short littleEndian = toLittleEndian((short)0x0FFE);
        Assert.assertTrue("Value of 0x0FFE must be 0xFE0F, but is " + Integer.toHexString(littleEndian), littleEndian == (short)0xFE0F);
    }
    
    @Test
    public void testLittleEndianShort4() {
        final short littleEndian = toLittleEndian((short)0xFFFF);
        Assert.assertTrue("Value of 0xFFFF must be 0xFFFF, but is " + Integer.toHexString(littleEndian), littleEndian == (short)0xFFFF);
    }
    
    @Test
    public void testLittleEndianInt() {
        final int littleEndian = toLittleEndian(0x4010);
        Assert.assertTrue("Value of 0x4010 must be 0x10400000, but is " + Integer.toHexString(littleEndian), littleEndian == 0x10400000);
    }
    
    @Test
    public void testLittleEndianInt2() {
        final int littleEndian = toLittleEndian(0x4010FFFF);
        Assert.assertTrue("Value of 0x4010FFFF must be 0xFFFF1040, but is " + Integer.toHexString(littleEndian), littleEndian == 0xFFFF1040);
    }

    @Test
    public void testLittleEndianInt3() {
        final int littleEndian = toLittleEndian(0xFFFEFFFF);
        Assert.assertTrue("Value of 0xFFFEFFFF must be 0xFFFFFEFF, but is " + Integer.toHexString(littleEndian), littleEndian == 0xFFFFFEFF);
    }
    
    @Test
    public void testLittleEndianInt4() {
        final int littleEndian = toLittleEndian(0xFEFFFFFF);
        Assert.assertTrue("Value of 0xFEFFFFFF must be 0xFFFFFFFE, but is " + Integer.toHexString(littleEndian), littleEndian == 0xFFFFFFFE);
    }
    
    @Test
    public void testGetDate() {
        final Calendar instance = Calendar.getInstance();
        //instance.setLenient(false);
        instance.set(2010, Calendar.MAY, 31);
        final int year = instance.get(Calendar.YEAR);
        final int month = instance.get(Calendar.MONTH);
        final int day = instance.get(Calendar.DAY_OF_MONTH);
        final short date = getDate(instance);
        System.out.println("Year: " + year + "; Month: " + month + "; Day: " + day);
        final short littleEndian = toLittleEndian(date);
        Assert.assertTrue("Date value should be 0xBF3C but is " + Integer.toHexString(littleEndian), (short)0xBF3C == littleEndian);
    }
    
    @Test
    public void testGetTime() {
        final Calendar instance = Calendar.getInstance();
        //instance.setLenient(false);
        instance.set(Calendar.HOUR_OF_DAY, 14);
        instance.set(Calendar.MINUTE, 11);
        instance.set(Calendar.SECOND, 24);
        
        final short time = getTime(instance);
        final short littleEndian = toLittleEndian(time);
        Assert.assertTrue("Date value should be 0x6C71 but is " + Integer.toHexString(littleEndian), (short)0x6C71 == littleEndian);
    }
    
//    @Test
//    public void testFileGeneration() throws FileNotFoundException, IOException, ConfigurationException, TemplateException {
//        final DataOutputStream pw = new DataOutputStream(new FileOutputStream("test.cab"));
//        writeCabFile(pw, MobileConfigServlet.write(null, "ox6-dev.open-xchange.com", "tara", "user.name"));
//        pw.close();
        
//        final BufferedInputStream bis1 = new BufferedInputStream(new FileInputStream("test.cab"));
//        final BufferedInputStream bis2 = new BufferedInputStream(new FileInputStream("testdata/test.cab"));
//        final byte[] bytes = new byte[10];
//        final byte[] bytes2 = new byte[10];
//        while (-1 != bis1.read(bytes)) {
//            if (-1 != bis2.read(bytes2)) {
//                Assert.assertTrue("The byte sequences are not equal: " + Arrays.toString(bytes) + ":" + Arrays.toString(bytes2), Arrays.equals(bytes, bytes2));
//            } else {
//                Assert.fail("Second stream not as long as the first one");
//            }
//        }
//        if (-1 != bis2.read(bytes2)) {
//            Assert.fail("Second stream is longer than the first one");
//        }
//    }
}
