/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.management.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TrustEveryoneSSLFactory
 * 
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class TrustEveryoneSSLSocketFactory extends SSLSocketFactory {

    private static final Log LOG = com.openexchange.log.Log.valueOf(LogFactory.getLog(TrustEveryoneSSLSocketFactory.class));

    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();

    private final SSLSocketFactory factory;

    /**
     * Initializes a new {@link TrustEveryoneSSLSocketFactory}.
     * 
     * @throws Exception If initialization fails for any reason
     */
    public TrustEveryoneSSLSocketFactory() throws Exception {
        final SSLContext sslcontext = SSLContext.getInstance("TLS");
        final TrustManager[] trustManagerThatTrustsEveryone = createTrustManagerThatTrustsEveryone();
        sslcontext.init(null, trustManagerThatTrustsEveryone, null);
        factory = sslcontext.getSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        if (TRACE_ENABLED) {
            LOG.trace("createSocket() to factory " + factory);
        }
        return factory.createSocket();
    }

    @Override
    public Socket createSocket(final Socket s, final String host, final int port, final boolean autoClose) throws IOException {
        return factory.createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(final String host, final int port) throws IOException, UnknownHostException {
        return factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(final InetAddress address, final int port) throws IOException {
        return factory.createSocket(address, port);
    }

    @Override
    public Socket createSocket(final String host, final int port, final InetAddress clientAddress, final int clientPort) throws IOException, UnknownHostException {
        return factory.createSocket(host, port, clientAddress, clientPort);
    }

    @Override
    public Socket createSocket(final InetAddress address, final int port, final InetAddress clientAddress, final int clientPort) throws IOException {
        return factory.createSocket(address, port, clientAddress, clientPort);
    }

    /**
     * Create TrustManager that trusts everyone.
     */
    public static TrustManager[] createTrustManagerThatTrustsEveryone() {
        return new TrustManager[] { new X509TrustManager() {

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(final X509Certificate[] certs, final String authType) {
            }

            public void checkServerTrusted(final X509Certificate[] certs, final String authType) {
            }
        } };
    }
}
