/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mail.filter;

import javax.security.auth.Subject;
import junit.framework.Assert;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import com.openexchange.config.ConfigurationService;
import com.openexchange.mailfilter.ajax.Credentials;
import com.openexchange.mailfilter.ajax.actions.MailfilterAction;
import com.openexchange.mailfilter.ajax.exceptions.OXMailfilterException;
import com.openexchange.mailfilter.internal.MailFilterProperties;
import com.openexchange.mailfilter.services.MailFilterServletServiceRegistry;


public class MailfilterActionTest extends MailfilterAction {

    public MailfilterActionTest() {
        super(null);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Common.prepare(null, null);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetRightPasswordNothing() throws OXMailfilterException {
        final ConfigurationService config = MailFilterServletServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        final String credsPW = "pw2";
        final Credentials creds = new Credentials("", credsPW, 0, 0);
        try {
            getRightPassword(config, creds);
            Assert.fail("No exception thrown");
        } catch (final OXMailfilterException e) {
            Assert.assertEquals(OXMailfilterException.Code.NO_VALID_PASSWORDSOURCE.getMessage(), e.getOrigMessage());
        }
    }

    @Test
    public void testGetRightPasswordSession() throws OXMailfilterException {
        Common.simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_PASSWORDSRC.property, MailFilterProperties.PasswordSource.SESSION.name);
        final ConfigurationService config = MailFilterServletServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        final String credsPW = "pw2";
        final Credentials creds = new Credentials("", credsPW, 0, 0);
        final String rightPassword = getRightPassword(config, creds);
        Assert.assertEquals("Password should be equal to \"" + credsPW + "\"", credsPW, rightPassword);
    }

    @Test
    public void testGetRightPasswordGlobalNoMasterPW() throws OXMailfilterException {
        Common.simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_PASSWORDSRC.property, MailFilterProperties.PasswordSource.GLOBAL.name);
        final ConfigurationService config = MailFilterServletServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        final String credsPW = "pw2";
        final Credentials creds = new Credentials("", credsPW, 0, 0);
        try {
            getRightPassword(config, creds);
            Assert.fail("No exception thrown");
        } catch (final OXMailfilterException e) {
            Assert.assertEquals(OXMailfilterException.Code.NO_MASTERPASSWORD_SET.getMessage(), e.getOrigMessage());
        }
    }

    @Test
    public void testGetRightPasswordGlobal() throws OXMailfilterException {
        final String masterPW = "masterPW";
        Common.simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_PASSWORDSRC.property, MailFilterProperties.PasswordSource.GLOBAL.name);
        Common.simConfigurationService.stringProperties.put(MailFilterProperties.Values.SIEVE_MASTERPASSWORD.property, masterPW);
        final ConfigurationService config = MailFilterServletServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        final String credsPW = "pw2";
        final Credentials creds = new Credentials("", credsPW, 0, 0);
        final String rightPassword = getRightPassword(config, creds);
        Assert.assertEquals("Password should be equal to \"" + masterPW + "\"", masterPW, rightPassword);
    }

}
