/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

function createContent() {
    var link = newnode("div", { marginTop: "2em", marginBottom: "2em" }, 0, [
        newnode("img", { verticalAlign: "middle", paddingRight: "7px" },
            { src: getFullImgSrc("img/infostore/infostore_save.gif") }),
        newnode("a", 0, { href: "#" }, [addTranslated(
            _("Download updater for the Connector for Microsoft Outlook"))])]);
    addDOMEvent(link, "click", function(e) {
        stopEvent(e);
        $("dlIframe").src =
            AjaxRoot + "/updater/installer/oxupdater-install.exe?session=" + session;
    });
    return newnode("div", 0, 0, [link,
        newnode("div", 0, 0, [addTranslated(
            _("When activating this option an installation wizard will be launched."))]),
        newnode("div", 0, 0, [addTranslated(
            _("Follow the instructions and install the updater."))]),
        newnode("div", 0, 0, [addTranslated(
            _("The updater will inform you of any updates for the Connector for Microsoft Outlook."))]),
        newnode("div", 0, 0, [addTranslated(
            _("You can download the updates from within the updater."))]),
        newnode("div", { height: "1em" }, 0, []),
        newnode("div", { fontWeight: "bold" }, 0, [addTranslated(
            _("Connector for Microsoft Outlook"))]),
        newnode("div", 0, 0, [addTranslated(
            _("Enables offline access to e-mail, calendar, tasks, and contacts folders. Any changes that are made using Microsoft Outlook offline will be automatically synchronized the next time you go online:"))]),
        newnode("div", 0, 0, [addTranslated(
            _("Client PC operating system: Windows XP, Windows Vista, Windows 7"))]),
        newnode("div", 0, 0, [addTranslated(
            _("Supported Outlook versions (Connector for Microsoft Outlook): Microsoft Outlook 2003, Microsoft Outlook 2007"))]),
        newnode("div", 0, 0, [
            addTranslated(_("Supported Outlook versions (Connector 2 for Microsoft Outlook): Latest versions of Microsoft Outlook 2003, Microsoft Outlook 2007, Outlook 2010"))
        ])
    ]);
}

if (configGetKey("modules")["com.openexchange.wizard"] && 
        configGetKey(["modules", "com.openexchange.oxupdater", "active"]) !== false) {
    
    // load CSS file
    loadCSSFile(PATH + "/style.css");
    
    var tab = {
        name: "oxupdater",
        enabled: false,
        visible: true,
        position: 0,

        headerImage: newnode("img", 0, {
            className: "oxupdater-header-wizard_d com-openexchange-oxupdater wizardHeaderImage-disabled",
            src: getFullImgSrc("img/dummy.gif")
        }),

        welcome_node: newnode("tr", 0 , 0, [
            newnode("td", { paddingTop: "5px", paddingleft: "5px" }, 0, [
                newnode("img", 0, {
                    className: "oxupdater-header-wizard_mini wizzardGridBox com-openexchange-oxupdater wizardMiniIcon",
                    src: getFullImgSrc("img/dummy.gif")
                })
            ]),
            newnode("td", { paddingTop: "5px" }, 0, [
                addTranslated(_("Download Updater"))
            ])
        ]),
        
        content: createContent(),

        draw: function(wizard) {
            $("popup.wizzard.next").value = _("Next");
            $("popup.wizzard.back").value = _("Previous");
            
            var title = $("popup.wizzard.header").getElementsByTagName("span")[0];
            removeChildNodes(title);
            if (!this.title) {
                this.title = addTranslated(format(
                    //#. %d is the step number.
                    //#, c-format
                    _("Step %d. Download Updater"), this.position));
            }
            title.appendChild(this.title);
            
            var header = document.getElementById("wizzardHeaderTitle");     
            removeChildNodes(header);
            header.appendChild(addTranslated(_("Connector for Microsoft Outlook")));
            
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_a wizardHeaderImage-active");

            var base = document.getElementById("wizzardConten");
            removeChildNodes(base);
            base.appendChild(this.content);
        },
        next: function(callback) {
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_a wizardHeaderImage");
            callback();
        },
        previous: function(callback) {
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_a wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_d wizardHeaderImage-disabled");
            callback();
        }
    };
    temporary.services.provide("com.openexchange.wizard", tab);
}

var node;

// register global event (allows better external access)
register("Feature_MicrosoftOutlook", function () {
    if (ox.upsell.matrix.hasFeature("olox") === false || node == undefined) {
        corewindow.triggerEvent("Feature_Not_Available", "modules/outlook.updater", window);
    } else {
        ox.UIController.configJump(node.id);
    }
});

var coou = "com.openexchange.oxupdater";
var menuID = "com.openexchange.synchronization.menu";
var menu = new MenuNodes.Section("com.openexchange.synchronization",
    _("Synchronization"), -1);
var button = new MenuNodes.Button(_("Microsoft Outlook"));
button.icon = "img/infostore/infostore_save.gif";
button.disabledIcon = "img/infostore/infostore_save_d.gif";
button.click = function() { triggerEvent("Feature_MicrosoftOutlook"); };
menu.add(button);
if (configGetKey(["modules", "com.openexchange.oxupdater", "active"]) === false) {
    button.button.options.mousedown = function() {
        corewindow.triggerEvent("Feature_Not_Available", "modules/outlook.updater", window);
    };
    // button disabled
    button.setEnabled(false);
}
menu.show("portal");

if (configGetKey(["modules", "com.openexchange.oxupdater", "active"]) !== false) {
    node = new ox.Configuration.LeafNode("configuration/outlook.updater",
            _("Connector for Microsoft Outlook"));
    var page = new ox.Configuration.Page(node, _("Connector for Microsoft Outlook"), false);
    page.viewModified = function() { return false; };
    var widget = new ox.UI.Widget();
    widget.content = createContent();
    widget.addContent = function() { this.parent.addRow(this.content); };
    page.addWidget(widget);
}
