/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
function PortalExternalItem(sId,sModule,oDOMContainerDiv,oDOMHeaderDiv,oParams,oAdj,oCell,oResizeDiv,sUrl){
	this.module = sModule;
	this.id = sId;
	this.resize_div = oResizeDiv;
	this.adjust = oAdj;
	
	this.autorefresh  = false;
	this.standalone = false;
	
	this.params = oParams;
	
	this.oDOMTD = oCell;
	this.container = oDOMContainerDiv;
	this.header = oDOMHeaderDiv;
	this.newportal = true;
	
	this.uwa;
	this.url = sUrl;
	
	this.privheader;
	
	this.extern = true;
}
PortalExternalItem.prototype = {
	deleteFrame: function (){
		removeChildNodes(this.container);
		this.uwa = null;
	},
	appendFrame: function () {
		this.uwa = new UWAWidget({
		    inline: false, id:this.id, container: this.container,
		    moduleUrl: this.url, standalone: this.standalone
		});
		this.uwa.setConfiguration({
		    'title':'',  'borderWidth':'0', 
			'color':'#aaaaaa', 'displayTitle':false, 'displayFooter':false
		});
		this.uwa.setPreferencesValues(this.params);
	},
	update_content:function (newdata){
		this.uwa.setPreferencesValues(newdata.parameter || newdata.parameters);
		this.uwa.moduleUrl = newdata.url;
		this.uwa.updateIframeUrl();
		removeChildNodes(this.privheader);
		this.module = newdata.title;
		var oHeaderTextNode = document.createTextNode(this.module);
		this.privheader.appendChild(newnode('div',{paddingLeft:"30px"},0,[oHeaderTextNode]));
		this.autorefresh = newdata.autorefresh;
	},
	update: function () {
		if (this.autorefresh) {
			this.uwa.updateIframeUrl();
		}
	}
};

function PortalItem(sModule, oDOMContainerDiv, oDOMHeaderDiv, limitParam, oAdj, oCell, oResizeDiv) {
	this.module = sModule;
	this.id = this.module;
	this.resize_div = oResizeDiv;
	this.adjust = oAdj;
	this.oDOMTD = oCell;
	this.container = oDOMContainerDiv;
	this.header = oDOMHeaderDiv;
	this.newportal = true;
 	this.limit_count = limitParam;
 	this.live_grid = null;

	//comma separated list of columns which be displayed
	this.columns = initColumns(sModule);
	this.sDate = 0;
	this.error;
	this.data = new Array();	
	this.id_assoc = new Object();
	this.timestamp;
	
	this.sort = initSortParam(sModule);
	this.order = initOrderParam(sModule);
	
	this.column_heads = initColHeads(sModule);
	this.column_functions = initColFunctions(sModule);
	this.col_width = getArrayWidth(sModule);
	var Self = this;
	this.style = getStyle(sModule);
	this.ranges = getRanges(sModule);
	var UserArray = new Array();
	function getRanges(sModule) {
		var aRanges = new Array();
		switch (sModule){
			case "calendar":
					var t = new Date(now());
					t.setUTCHours(0);	
					t.setUTCMinutes(0);
					t.setUTCSeconds(0);
					t.setUTCMilliseconds(0);
					var nStartDay = t.getUTCDay();
					tend = new Date(t);
					tend.setUTCDate(tend.getUTCDate() + 1);
					for(var nIndx=nStartDay;nIndx<=7;nIndx++)
					{
						if(nIndx == nStartDay)
							var sHeadName = "Today"; /*i18n*/
						else
							var sHeadName = weekdays.untranslated[t.getUTCDay()];
						var lgObj = Self.createLg(sHeadName);
						aRanges.push({name:sHeadName,range:{start:t.getTime(),end:tend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});
						t.setUTCDate(t.getUTCDate()+1);						
						tend.setUTCDate(tend.getUTCDate()+1);
					}
					// check for limitations
					if (Self.limit_count !== undefined) {
						// show this week elements only?
						if (Self.limit_count !== -2) {
							tend.setUTCDate(tend.getUTCDate()-1);
							tnextend = new Date(tend);
							tnextend.setUTCDate(tnextend.getUTCDate()+7);
							var lgObj = Self.createLg("Next Week");
							aRanges.push({
								name:"Next Week", /*i18n*/
							    range: {
									start: tend.getTime(),
									end: tnextend.getTime()		
								},
								limit: Infinity,
								lg: lgObj.lg, 
								section: lgObj.section
							});
						}
						// show later elements?
						if (Self.limit_count > 0 || Self.linit_count === -2) {
	    					var tnextyear = new Date();
	    					tnextyear.setUTCHours(0);
	    					tnextyear.setUTCMinutes(0);
	    					tnextyear.setUTCSeconds(0);
	    					tnextyear.setUTCMilliseconds(0);
	    					tnextyear.setUTCFullYear(tnextyear.getUTCFullYear()+1);
	    					tnextyear.setUTCDate(tnextyear.getUTCDate()+1);
	    					var lgObj = Self.createLg("Later");	
	    					aRanges.push({
	    						name: "Later", /*i18n*/
	    					    range: {
	    							start: tnextend.getTime(),
	    							end: tnextyear.getTime(),
	    							limit: Self.limit_count
	    						},
	    						lg: lgObj.lg,
	    						section: lgObj.section	
	    					});
						}
					}
					break;
			case "tasks":
					var t = new Date();		
					t.setUTCHours(0);	
					t.setUTCMinutes(0);
					t.setUTCSeconds(0);
					var nStartDay = t.getUTCDay();
					tend = new Date(t);
					tend.setUTCDate(tend.getUTCDate()+1);					
					for(var nIndx=nStartDay;nIndx<=7;nIndx++)
					{
						if(nIndx == nStartDay)
							var sHeadName = "Today"; /*i18n*/
						else
							var sHeadName = weekdays.untranslated[t.getUTCDay()];						
						var lgObj = Self.createLg(sHeadName);
						aRanges.push({name:sHeadName,range:{start:t.getTime(),end:tend.getTime()},limit:Infinity,lg:lgObj.lg,section:lgObj.section});							
						t.setUTCDate(t.getUTCDate()+1);						
						tend.setUTCDate(tend.getUTCDate()+1);
					}
					// check for limitations
					if (Self.limit_count !== undefined) {
						// show this week elements only?
						if (Self.limit_count !== -2) {
							tend.setUTCDate(tend.getUTCDate()-1);
							tnextend = new Date(tend);
							tnextend.setUTCDate(tnextend.getUTCDate()+7);
							var lgObj = Self.createLg("Next Week");
							aRanges.push({
								name:"Next Week", /*i18n*/
							    range: {
									start: tend.getTime(),
									end: tnextend.getTime()		
								},
								limit: Infinity,
								lg: lgObj.lg, 
								section: lgObj.section
							});
						}
						// show later elements?
						if (Self.limit_count > 0 || Self.linit_count === -2) {
	    					var tnextyear = new Date();
	    					tnextyear.setUTCHours(0);
	    					tnextyear.setUTCMinutes(0);
	    					tnextyear.setUTCSeconds(0);
	    					tnextyear.setUTCMilliseconds(0);
	    					tnextyear.setUTCFullYear(tnextyear.getUTCFullYear()+1);
	    					tnextyear.setUTCDate(tnextyear.getUTCDate()+1);
	    					var lgObj = Self.createLg("Later");	
	    					aRanges.push({
	    						name: "Later", /*i18n*/
	    					    range: {
	    							start: tnextend.getTime(),
	    							end: tnextyear.getTime(),
	    							limit: Self.limit_count
	    						},
	    						lg: lgObj.lg,
	    						section: lgObj.section	
	    					});
						}
					}
					break;				
			case "mail": 
					var lgObj = Self.createLg("Inbox" /*i18n*/);				
					aRanges = [{name:"Inbox" /*i18n*/, range:{folder:"INBOX"}, limit:Self.limit_count,lg:lgObj.lg,section:lgObj.section}];			
					break;			
			case "infostore": 
					var lgObjMy = Self.createLg("My Infostore");						
					var lgObjAll = Self.createLg("All folders");							
					aRanges = [{name:"My Infostore", /*i18n*/
					    range:{folder:configGetKey("folder.infostore")},limit:Self.limit_count,lg:lgObjMy.lg,section:lgObjMy.section},
													{name:"All folders", /*i18n*/
													    range:{},limit:Self.limit_count,lg:lgObjAll.lg,section:lgObjAll.section}];
					break;
			case "contacts":
			        var obj = Self.createLg(null);
			        aRanges = [ { 
			            name: "Contacts",
			            range: { 
			                folder: configGetKey("folder.contacts")
			            },
			            lg: obj.lg, 
                        section: obj.section
			        }];
			        break;
		}
		
		applyEmptyHeader(sModule);
		
		return aRanges;
	}
	
	function applyEmptyHeader(sModule) {
	    Self.portletEmptyMSG =  newnode("div",
                { display: "none", position: "absolute", textAlign: "center",
                 width: "100%", marginTop: "5px"}, { className:"font-color-disabled" },
                [ addTranslated(getEmptyText(sModule)) ]);
	    Self.container.appendChild(Self.portletEmptyMSG);
	}
	
	function doNothing(arg) {
		return document.createTextNode(arg || "");
	}
	
	function setUser(arg,DOMtd) {
		var aIds = new Array();
		var TT = DOMtd;
		aIds.push(arg);
		function fillTds(result){
		    jQuery(TT).text(result[arg].display_name); 
		}
		internalCache.getUsers(aIds,fillTds);
		return document.createTextNode("");
	}
	
	function setDate(arg) {
		var dateString = "";
		if (null != arg) dateString = formatDate(arg, "date");
		return document.createTextNode(dateString);
	}
	
	function setDateTime(arg) {
		var dateString = "";
		if (null != arg) dateString = formatDate(arg, "date")  + " " + formatDate(arg, "time");
		return document.createTextNode(dateString);
	}
	
	function setTime(arg) {
		var timeString = '';
		if (null != arg) timeString = formatDate(arg, "time");
		return document.createTextNode(timeString);
	}
	
	function setPriority(arg,td) {
		var DOMImg;
		if (arg == 3) 
		{
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio3.gif") });
		}
		else if (arg == 1) 
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio1.gif") });
		else 
			DOMImg = newnode('img',0,{ src: getFullImgSrc("img/tasks/taskprio2.gif") });
		return DOMImg;
	}
	
	function setGroupIcon(arg,td) {
	    return (jQuery("<img>").css({ verticalAlign: "middle" }).attr({ width: 16, height: 16, src: 
	        getFullImgSrc((isGroupAppointment(arg) ? "img/calendar/group.gif" : "img/dummy.gif"))}))[0];
	}
	
	function setMailAdress(arg) {
	    var text = arg ? getAdressString(arg, true) : "";
		return document.createTextNode(text.replace(/(^"|"$)/g, ""));
	}
	
	function getArrayWidth(sModuleParam) {
		var aWidth = new Array();
		switch (sModuleParam){
			case "calendar": aWidth = {201:"7em",401:"6em",200:""};break;
			case "tasks": aWidth ={200:"",202:"7em",220:"2.3em",309:"4em"};break;
			case "mail": aWidth = {603:"",607:"",610:"12em"};break;
			case "infostore": aWidth = {700:"",3:"",5:"8em"};break;
			default: oFunctions = new Object();
		}
		return aWidth;
	}
	
	function getStyle(sModuleParam) {
		var aWidth = new Array();
		switch (sModuleParam){
			case "calendar": aWidth = {201:{color:"gray"},401:{color:"gray"},200:{}};break;
			case "tasks": aWidth ={200:{},201:{},202:{color:"gray"},220:{}, 309:{}};break;
			case "mail": aWidth = {603:{},607:{color:"gray"},610:{color:"gray"}};break;
			case "infostore": aWidth = {700:{},3:{color:"gray"},5:{color:"gray"}};break;
			default: oFunctions = new Object();
		}
		return aWidth;
	}
	
	function initColFunctions(sModuleParam) {
		var oFunctions;
		switch (sModuleParam){
			case "calendar": oFunctions = {201:setDate,401:setTime,200:doNothing};break;
			case "tasks": oFunctions = {201:setDate,200:doNothing,202:setDate,220:setGroupIcon,309:setPriority};break;
			case "mail": oFunctions = {603:setMailAdress,607:doNothing,610:setDateTime};break;	
			case "infostore": oFunctions ={700:doNothing,3:setUser,5:setDate};break;
			default: oFunctions = new Object();
		}
		return oFunctions;
	}
	
	function initColHeads(sModuleParam) {
		var oHeads;
		switch (sModuleParam){
            case "calendar":
                oHeads = { 201: _("Start date"), 401: _("Start time"),
                           200: _("Description") };
                break;
            case "tasks":
                oHeads = { 201: _("Start date"), 200: _("Subject"),
                           202: _("End date"), 220: _("Group Task"),
                           309: _("Priority") };
                break;
            case "contacts":
                oHeads = { 500: _("Display name") };
                break;
            case "mail":
			    oHeads = { 603: pgettext("who", "From"), 607: _("Subject"),
                           610: _("Received") };
                break;
			case "infostore":
			    oHeads = { 700: pgettext("description", "Title"),
			               3: _("Changed by"), 5: _("Changed on") };
			    break;
			default: oHeads = new Object();
		}
		return oHeads;
	}
	
	function initSortParam(sModuleParam) {
		var nSortColumn;
		switch (sModuleParam) {
			case "calendar": nSortColumn = '201';break;
			case "tasks": nSortColumn = '202';break;
			case "mail": nSortColumn = "610";break;	
			//4 = creation date
			case "infostore": nSortColumn = "5";break;
			default: nSortColumn = null;
		}
		return nSortColumn;
	}
	
	function initOrderParam(sModuleParam) {
		var sSortOrder = 'asc';
		if (sModuleParam == 'infostore' || sModuleParam == 'mail') {
			sSortOrder = 'desc';
		}
		return sSortOrder;
	}
	
	function initColumns(sModuleParam) {
		var sColumns;
		switch (sModuleParam) {
			case "calendar": sColumns = "1,20,201,401,200,207"; break;
			case "tasks": sColumns = "1,20,202,220,309,200,301"; break;
			case "mail": sColumns = "600,601,603,607,610,611"; break;
			case "infostore": sColumns = "1,20,700,3,5"; break;
			case "contacts": sColumns = "1,20,602,500"; break;
			default: sColumns = "";
		}
		return sColumns;
	}	
}

PortalItem.prototype = {
	setColumns: function(sColumns) {
		this.columns = sColumns;
	},
	
	setError: function (oRespData) {
		this.error = oRespData;
	},
	
	// set data
	setData: function (oData, index, nTimestamp, limit) {
	    // mail?
	    if (this.module === "mail") {
	        var sortByFlag = function (a, b) {
	            var aSeen = a[5] & 32, bSeen = b[5] & 32;
	            return aSeen !== bSeen ? aSeen - bSeen : b[4] - a[4];
	        };
	        oData.sort(sortByFlag);
	    }
	    
	    // truncate
	    if (limit != undefined) {
	        oData = oData.slice(0, limit);
	    }
	    // set
		this.data = oData;
		this.timestamp = nTimestamp;
		this.ranges[index]["data"] = oData;
		this.ranges[index]["timestamp"] = nTimestamp;
	},
	
	update: function () {
		if (this.error) {
			newServerError(this.error);
			return;
		}

		var bContentPresent = false;
		for (var dataIndx in this.ranges) {
		    if (this.ranges[dataIndx] == undefined) continue;

			if (this.ranges[dataIndx].data.length > 0) {
				bContentPresent = true;
			}
			if (this.ranges[dataIndx]["lg"] == undefined) {
				this.createLg(this.ranges[dataIndx]);
			} else {
				this.update_grid(this.ranges[dataIndx]);
			}
		}
		
		if (this.portletEmptyMSG) {
			// show/hide "empty" message
		    this.portletEmptyMSG.style.display = bContentPresent ? "none" : "block";
		    // contacts need fixed height
			if (this.module === "contacts") {
			    jQuery(this.container).css({
			        height: bContentPresent ? "315px" : "",
			        overflow: "auto",
			        overflowX: "hidden",
			        overflowY: "auto",
			        margin: "5px 7px 0 0"
			    });
			}
		}
	},
	
	disable : function () {
		for (var dataIndx in this.ranges) {
			if (this.ranges[dataIndx]["lg"]) {
				this.ranges[dataIndx]["lg"].disable();
			}
		}
	},
	
	getRequests : function () {
		//reset old data
		this.data = new Array();
		var aAllRequests = new Array();
		for (var nRange=0; nRange < this.ranges.length; nRange++) {
			//create request objects
			var oRequestObj = new Object();
			var oRequestBody = new Object();
			oRequestBody['pattern'] = "";
			oRequestObj['module'] = this.module;
			if (this.module == 'mail' || this.module == 'contacts') {
				oRequestObj['action'] = 'all'; // instead of newmsgs
				oRequestObj['folder'] = this.ranges[nRange].folder;
                if (this.module == "mail") {
                    oRequestObj["left_hand_limit"] = 0;
                    oRequestObj["right_hand_limit"] = 100; // do not fetch all
                }
				oRequestBody = null;
			} else if(this.module == 'calendar') {
				oRequestObj['action'] = 'newappointments';
			} else {
				oRequestObj['action'] = 'search';
			}
			oRequestObj['columns'] = this.columns;
			if (this.sort != null) {
    			oRequestObj['sort'] = this.sort;
    			oRequestObj['order'] = this.order;
			}

			//limit required
			if (this.ranges[nRange].limit) {
			    oRequestObj['limit'] = this.ranges[nRange].limit == Infinity ? 9999 : this.ranges[nRange].limit;
			}
			
			if (this.module == 'calendar' || this.module == 'tasks') {
				var oDate = new Date();
				oDate.setUTCHours(0);
				oDate.setUTCMinutes(0);
				oDate.setUTCSeconds(0);
				oRequestObj['start'] = oDate.getTime();
				oDate.setUTCFullYear(oDate.getUTCFullYear()+1);
				oDate.setUTCDate(oDate.getUTCDate() + 1);
				oRequestObj['end'] = oDate.getTime();
			}
			for(var nProp in this.ranges[nRange].range){
				oRequestObj[nProp] = this.ranges[nRange].range[nProp];
			}
			if (oRequestBody) {
			    oRequestObj['data'] = oRequestBody;
			}
			aAllRequests.push(oRequestObj);
		}
		return aAllRequests;
	},
	
	getLgColDef: function (nColumnNum,index) {
		var fn = this.column_functions[nColumnNum];
		var resObj = new Object();
		if (nColumnNum == 401) {
			resObj =  {
				text: this.column_heads[nColumnNum],
				width: this.col_width[nColumnNum],
				style: this.style[nColumnNum],
				set: function  (div, text){
					removeChildNodes(div);
					div.appendChild((text[3]) ? document.createTextNode("") : fn(text[2],div));
				},
				clear: LiveGrid.makeClear("")
			};
		} else if (nColumnNum == 200 && this.module == "tasks") {
			resObj =  {		
				text: this.column_heads[nColumnNum],
				width: this.col_width[nColumnNum],
				style: this.style[nColumnNum],
				set: function  (div, content) {
					if (!div.firstChild) {
						div.appendChild(document.createTextNode("\u00a0"));
					}
					if (content[5]) {
						div.firstChild.data = content[5];
						if (content[6] && content[6] == 100) {
							div.className = "cell font-color-disabled";
							div.style.textDecoration = "line-through";
						} else if (content[2] && getDays(new Date()-new Date(content[2])) > 0) {
							div.style.textDecoration = "line-through";
							div.style.color = "red";
						} else {
							div.className = "cell";
							div.style.textDecoration = "none";
						}
					} else {
						div.firstChild.data = "\u00a0";
					}
				},
				clear: LiveGrid.makeClear("")
			};
		} else if (this.module === "mail") {
		    resObj =  {
                index: index,   
                text: this.column_heads[nColumnNum],
                style: this.style[nColumnNum],      
                width: this.col_width[nColumnNum],
                set: function  (div, text, data) {
		            var node = jQuery(div), flags = data[5];
		            // unread?
                    if ((flags & 32) !== 32) {
                        node.css({ fontWeight: "bold", color: "black" });
                    } else {
                        node.css({ fontWeight: "", color: index >= 3 ? "gray" : "" });
                    }
                    // deleted?
                    node.css({ textDecoration: (flags & 2) !== 2 ? "" : "line-through" });
                    // update
                    removeChildNodes(div);
                    div.appendChild(fn(text, div));
                },
                clear: LiveGrid.makeClear("")
            };
		} else if (this.module === "contacts") {
		    resObj = {
		        text: "\u00a0",
		        sortable: false,
		        height: "70px",
		        style: { height: "70px" },
    		    set: function (div, data) {
		            
		            // shortcut
		            var $ = jQuery,
		                node,
		                src,
		                address,
		                hasImage,
		                obj, css, img;
		            
		            // clear
		            div = $(div).removeClass("cell").empty();
		            
		            // container
		            node = $("<div/>").css({
		                position: "relative",
		                height: "64px",
		                lineHeight: "1.4em",
		                borderBottom: "1px solid #f5f5f5"
		            });
		            
		            // set image
		            hasImage = !!data[7];
		            src = hasImage ? data[7] : getFullImgSrc("img/contacts/dummypicture.gif");
		            css = {
		                position: "absolute",
                        top: "5px",
                        left: "5px",
                        height: "50px",
                        width: "50px",
                        border: hasImage ? "0px none" : "1px solid #ddd",
                        opacity: hasImage ? 1.0 : 0.15,
                        overflow: "hidden"
		            };
		            if (IE <= 7) {
		                img = $("<img/>", { src: src, alt: "", width: "50px", height: "auto" });
		            } else {
		                $.extend(css, {
		                    background: "url('" + src + "') no-repeat scroll 50% 50% transparent",
                            MozBackgroundSize: "100% 100%",
                            WebkitBackgroundSize: "100% 100%",
                            backgroundPosition: "center center",
                            backgroundSize: "cover"
		                });
		                img = $();
		            }
                    $("<div/>")
                        .css(css)
                        .append(img)
                        .appendTo(node);
                    
		            // address
                    node.append(
    		            address = $("<div/>").css({
    		                position: "absolute",
    		                top: "4px",
    		                right: "5px",
    		                bottom: "5px",
    		                left: "65px",
    		                whiteSpace: "nowrap"
                        })
                    );
		            
		            // display name
                    obj = {
                        first_name: trimStr(data[8]),
                        last_name: trimStr(data[9]),
                        //title: trimStr(data[10]),
                        display_name: trimStr(data[3])
                    };
                    if (obj.last_name) {
                        obj.display_name = obj.last_name;
                        if (obj.first_name) {
                            obj.display_name += ", " + obj.first_name
                        }
                    }
	                address.append(
                        $("<div/>").css({
                            fontSize: "10pt",
                            fontWeight: "bold",
                            overflow: "hidden",
                            textOverflow: "ellipsis"
                        }).text(obj.display_name)
                    );
	                
		            // email
		            if (data[5]) {
		                address.append(
                            $("<div/>")
                                .addClass("font-color-person")
                                .css({
                                    overflow: "hidden",
                                    textOverflow: "ellipsis",
                                    cursor: "pointer"
                                })
                                // might be missing in custom themes
//                                .append(
//                                    $("<img/>").css({
//                                        marginRight: "5px"
//    		                        }).attr({
//                                        src: getFullImgSrc("icons/16/unread.png"),
//                                        align: "absmiddle"
//                                    })
//                                )
                                .append(
                                    newtext(data[5])
                                )
                                .hover(
                                    function () {
                                        $(this).css("textDecoration", "underline");
                                    },
                                    function () {
                                        $(this).css("textDecoration", "");
                                    }
                                )
                                .bind("click", false) // keep this! strange? yeah
                                .bind("mousedown", data[5], function (e) {
                                    setTimeout(function () {
                                        ox.api.mail.compose({
                                            data: {
                                                to: [[e.data]]
                                            }
                                        });
                                    }, 0);
                                    return false;
                                })
                        );
		            }
		            
		            // business phone
		            if (data[6]) {
		                address.append(
	                        $("<div/>")
	                            .css({
                                    overflow: "hidden",
                                    textOverflow: "ellipsis"
                                })
                                // might be missing in custom themes
//    	                        .append(
//                                    $("<img/>").css({
//                                        marginRight: "5px"
//                                    }).attr({
//                                        src: getFullImgSrc("img/menu/call.png"),
//                                        align: "absmiddle"
//                                    })
//    	                        )
    	                        .append(
                                    newtext(data[6])
                                )
                        );
		            }
		            
		            node.appendTo(div);
		        },
    		    clear: LiveGrid.makeClear("")
		    };
		} else {
			resObj =  {
				index: index,	
				text: this.column_heads[nColumnNum],
				style: this.style[nColumnNum],		
				width: this.col_width[nColumnNum],
				set: function  (div, text, data) {
					removeChildNodes(div);
					div.appendChild(fn(text,div));	
				},
				clear: LiveGrid.makeClear("")
			};
		}
		
		if (resObj["width"] == '') {
			delete resObj["width"];
		}
		
		return resObj;
	},
	
	createLg: function (sHeadName) {
		var oDOMHead, oDOMBody;
		var oTableNewSection = newnode("table",{width:"100%",height:"100%",display:"none"},{ cellpadding:"0",cellspacing:"0"},
								[newnode("tbody",0,0
											,[newnode('tr',0,0,[oDOMHead = newnode('td')]),
														newnode('tr',0,0,[oDOMBody = newnode('td')])])]);
		
		//create live grid definition array
		var aColumnNums = this.columns.split(',');
		var aColDefs = new Array();
		for (var nColumn=0; nColumn < aColumnNums.length; nColumn++) {
			if (aColumnNums[nColumn].length > 0 && nColumn > 1 && 
			        this.column_heads[aColumnNums[nColumn]] != undefined) {
				aColDefs.push(this.getLgColDef(aColumnNums[nColumn], nColumn));
			}
		}
		var hover = { calendar: OXAppointmentHover, tasks: OXTaskHover,
		    contacts: OXContactHover, infostore: OXInfostoreHover,
		    mail: OXMailHover }[this.module];
		var hoverFunction = {
            calendar: function(object) {
                hover.actualHover = hv;
                sectionLG.storage.newIterate([object], emptyFunction, set);
                function set(i, data) {
                    hover.refillContent(object.id, object.folder,
                                        object.recurrence_position);
                }
            },
            mail: function(object, manual) {
                OXMailHover.accordion.setHover(hv);
                sectionLG.storage.newIterate([object], emptyFunction, set);
                function set(i, data) {
                    hover.refillContent(object.id, object.folder);
                }
            }
        }[this.module] || function(object) {
            hover.actualHover = hv;
            sectionLG.storage.newIterate([object], emptyFunction, set);
            function set(i, data) {
                hover.refillContent(object.id, object.folder);
            }
        };
		aColDefs.push({
		    text: "\xa0",
		    width: "20px",
		    style: { padding: 0, verticalAlign: "top" },
		    clear: function(div) {
		        if (div.firstChild) {
		            div.firstChild.style.visibility = "hidden";
		        }
		    },
		    set: function(div, data) {
		        div.oxHoverID = sectionLG.storage.makeID(data);
		        if (div.firstChild) {
		            div.firstChild.style.visibility = "visible";
		        } else {
		            var button = jQuery.button({
		                title: noI18n(IE ? "\xa0\xa0\xa0\xa0" : "\xa0\xa0"),
		                click: function(e) {
		                    e.stopPropagation();
		                    e.preventDefault();
		                    pulldown.manualShow();
		                }
		            }).mousedown(function(e) {
		                e.stopPropagation();
	                }).addClass("context-button hover-only").appendTo(div)[0];
                    var pulldown = new PulldownPopup(button,
                        hover.getContent().node, true);
                    var oldHide;
                    pulldown.onShow = function() {
                        oldHide = hover.hide;
                        hover.hide = function() { pulldown.hide(); };
                        hoverFunction(div.oxHoverID);
                    };
                    pulldown.onHide = function() { hover.hide = oldHide; };
		        }
		    }
		});
		
		var selection =new Selection();
		var sectionLG = new LiveGrid(aColDefs, selection);
		sectionLG.autoWidth = false;
		sectionLG.key_cb = emptyFunction;
		sectionLG.keydown_cb = emptyFunction;
		sectionLG.keypress_cb = emptyFunction;
		sectionLG.mousedown_cb = function (e) {
		    if (e.button == LeftButton) {
		        sectionLG.mousedown(e);
		    }
		};
		sectionLG.selected_cb = function(count, e) {
		    sectionLG.events.trigger("Selected", count, e);
		};
		
		//no style update to disable visible selection
		sectionLG.updateStyles = function () {};
		sectionLG.insertRow = function(index) {
			var row = this.rows[index] = this.rowcache.length ? this.rowcache.pop() : this.createRow();
			row.tr.className = "tr context-button-hover-parent";
			row.tr.style.display = "";
			row.tr.style.top = (index * this.rowHeight) + "px";
			row.tr.oxRowIndex = index;
			this.unfetched[index] = true;
		};
		
		var Self = this;
		sectionLG.events.register("Selected",
		        function (ids, e) {
    				if (sectionLG.selection.getSelected()[0]) {
    					var object = sectionLG.selection.getSelected()[0];
    					//TMP MUST BE REMOVED WHEN OBJECTCACHE IS USED
    					if (Self.module) {
    					    object["module"] = Self.module;
    					}
    					object.folder_id = object.folder;
    					triggerEvent('OX_Portal_Click_Item', Self.module, object);
    				}
		});
		sectionLG.emptylivegridtext = "";
		
		if (sHeadName) {
    		if (!this.newportal) {
    			this.header.appendChild(sectionLG.getHeader());
    		} else {
    			sectionLG.getHeader();
    			var newportalHeader = newnode('div',{borderBottom:"1px solid",paddingLeft:"2px",textAlign:"left",
    							height:"1.6em",width:"100%",overflow:"hidden",whiteSpace:"nowrap"},{className:"font-style-lable border-color-design"});
    			newportalHeader.appendChild(addTranslated(_(sHeadName)));
    			oDOMHead.appendChild(newportalHeader);
    		}
		} else {
		    sectionLG.getHeader();
		    // clean header node if no name given
		    jQuery(oDOMHead).parent().empty();
		}
		
		if (this.module == "contacts") {
		    sectionLG.getTable(this.container);
		} else {
    		this.container.appendChild(oTableNewSection);
    		sectionLG.getTable(oDOMBody);
		}
		sectionLG.heightDiv.style.cursor = "pointer";
		sectionTB = oTableNewSection;
		
        var hv = sectionLG.addHover(hover.getContent().node, hoverFunction);
        hv.setSize(hover.contentobject.node);
 		return { lg: sectionLG, section: sectionTB };
	},
	
	update_grid: function (aData) {
	    var serialize = this.module === "calendar" ? function(x) {
	        return x.folder + "." + x.id + "." + x.recurrence_position;
        } : function(x) {
            return x.folder + "." + x.id;
        };
        var makeID = this.module === "calendar" ? function(x) {
            return { id: x[0], folder: x[1], recurrence_position: x[5] };
        } : function(x) {
            return { id: x[0], folder: x[1] };
        };
        var url = null, data = [];
        if (this.module === "contacts") {
            url = AjaxRoot + "/contacts?action=list&columns=1,20,602,500,569,555,542,606,501,502,505&session=" + session;
            jQuery.each(aData.data, function(i, x) {
                // null/false is okay
                if (x[2] === null || x[2] === false) {
                    data.push({ id: x[0], folder:  x[1] });
                }
            });
        }
        
	    var storage = new Storage(0, data, url, null, null, serialize, makeID);
	    // only non-contact modules 
	    if (this.module !== "contacts") {
            storage.append(aData.data);
	    }
	    
		aData['section'].style.display = "";
		if (aData.data.length == 0) {
			aData['section'].style.display = "none";
		}
		aData['lg'].disablehover = !configGetKey("gui.effects.hover.portal");
		aData['lg'].enable(storage);
	}
};

function getEmptyText(sModule) {
	var sModuleName;
	switch (sModule){
		case 'calendar' : sModuleName = _("No appointments today"); break;
		case 'mail' : sModuleName = _("No new E-Mails in this folder"); break;
		case 'tasks' : sModuleName = _("No tasks today"); break;
		case 'infostore' : sModuleName = _("No Info Items in this folder"); break;
		case 'contacts' : sModuleName = _("No contacts in this folder"); break;
		default: sModuleName = noI18n("");
	}
	return sModuleName;
}

function getNameModule(sModule) {
	var sModuleName;
	switch (sModule){
		case 'calendar' : sModuleName = _("Calendar"); break;
		case 'mail' : sModuleName = _("E-Mail"); break;
		case 'tasks' : sModuleName = _("Tasks"); break;
		case 'infostore' : sModuleName = _("InfoStore"); break;
		case 'contacts': sModuleName = _("Contacts"); break;
		default: sModuleName = noI18n("&#xa0;");
	}
	return sModuleName;
}

fileloaded();