/**
 *
 * All content on this website (including text, images, source code and any
 * other original works), unless otherwise noted, is licensed under a Creative
 * Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012 Mail: info@open-xchange.com
 *
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 *
 */

/*global jQuery, corewindow, AlertPopup, AutoComplete, addDOMEvent, ox, urlify,
tinyMCE, tinymce, $ALL, newConfirm, _, $, url : true, getFullImgSrc, removeCSSFilesForNewWindow,
activemodule : true, initContents, initAll, loadingComplete, triggerEvent, resizeEvents,
Join, attachmentDialog, infostoreDialog, resizeSplit, pxPerEm, SearchListAddressBook,
registerView, unregister, quotePersonalAddr, ComboBox3, noI18n, register, JSONX, AjaxRoot,
newAlert, formatError, trimStr, IE, isEmpty, newInput, removeChildNodes, cancelDefault,
newnode, format, bytesToString, newServerError, centerPopupWindow, addOnClose,
addressbookFolderPath, addTranslated, windowController : true, WindowController */

/*jslint devel: true, browser: true, forin: true, continue: true, unparam: true, maxerr: 50, indent: 4 */

// local vars
var selAttachment,
    priority,
    senderAddress,
    signature,
    tmp_attachmentDialog,
    tmp_attachmentInfostoreDialog,
    defaultSignature = -1,
    action = "new",
    myListAddressBook = null,
    distruGrid = null,
    msgref = null,
    autosave = null,
    undoActive = false,
    internalCache,
    defaultSignature = -1,
    activeMailAccount,
    oMailFunctionsNew,
    // references
    refToMain = corewindow,
    configContainsKey = corewindow.configContainsKey,
    configGetKey = corewindow.configGetKey,
    configSetKey = corewindow.configSetKey,
    options = configGetKey("gui.mail.newmail_options") || { "from": true,
		"replyto": ox.api.config.get("ui.mail.replyTo.configurable", false),
		"cc": true, "bcc": false, "options": false },
    messageFormat = configGetKey("gui.mail.formatmessage"),
    editorEnabled = (!messageFormat.match(/text\/plain/i)),
    // get font settings
    default_font_tynmce = configGetKey("gui.mail.defaul_mail_font"),
    default_font_size_tynmce = configGetKey("gui.mail.defaul_mail_font_size"),
    // required for joining initializing processes
    cb_initMessageContent = null,
    cb_initAddressBook = null,
    // passed via window
    aInfoMailAttachmentFile,
    aInfoMailAttachmentLink,
    multiForward,
    intervals = [],
    // trigger
    triggerReady = jQuery.noop,
    // window controller
    ctrl;

if (options.toolbar === undefined) options.toolbar = true;

// cache TinyMCE's popup CSS
var prefetch = jQuery.get(urlify(
    "3rdparty/tinymce/jscripts/tiny_mce/themes/advanced/skins/default/dialog.css"));

// not valid for all circumstances but sufficient here

function isSafari() {
    return navigator.userAgent.indexOf("AppleWebKit") >= 0;
}

function isFirefox() {
    return navigator.userAgent.indexOf('Gecko') > -1 && navigator.userAgent.indexOf('KHTML') === -1;
}

function isIE() {
    var test = navigator.appVersion.match(/MSIE (\d+\.\d+)/, '');
    return (test !== null && Number(test[1]) >= 5.5);
}

var ums = false;
function setBeforeUnload(on) {
    ums = on;
}

function onChange() {
    setBeforeUnload(true);
}

/**
 * TinyMCE Helper
 */

var splitContent,
    splitContent_IE,
    splitContent_W3C,
    initMessageHeader,
    initMessageContent,
    cb_mailComboChanged,
    setMailFields,
    setRecipients,
    setSubject,
    setMessageText,
    setInitialFocus,
    firefox_setInitialFocus,
    setDefaultFont,
    applyDefaultFontOnNode,
    getStyleTextOfDefaultFont,
    stripReservedAttributes,
    trimLastBlockquote,
    callback_new,
    searchEmailAddress,
    newmailContact,
    closeAddressbookNewEmail,
    getURL,
    addImg2Poll;

function isInsideBlockquote(range) {
    // get ancestor/parent container
    var container = range.commonAncestorContainer || range.parentElement();
    // loop for blockquote
    var bq = jQuery(container).parents('blockquote').last();
    return bq.length > 0;
}

//this one takes care of splitting the preset content
splitContent = function (ed, e) {
    // get current range
    var range = ed.selection.getRng();
    // in preset content?
    if (isInsideBlockquote(range)) {
        // W3C or IE?
        if (range.startContainer) {
            // strategy #1 (W3C compliant)
            splitContent_W3C(ed);
        } else {
            // strategy #2 (IE-specific / IE7 & IE8)
            splitContent_IE(ed);
        }
        tinymce.dom.Event.cancel(e);
    }
};

//this only works for IE
splitContent_IE = function (ed) {
    // get current range
    var range = ed.selection.getRng();
    // get body
    var body = ed.getBody();
    // get two text ranges
    var before = body.createTextRange();
    var after = body.createTextRange();
    // initialize first range & get its content
    before.setEndPoint("EndToStart", range);
    before = before.htmlText;
    // initialize second range & get its content
    after.setEndPoint("StartToEnd", range);
    // BR fix (remove unwanted newline)
    // leading white space in regexp is necessary (don't ask)
    after = after.htmlText.replace(/^(\s*<[^>]+>\s*)<BR\s*\/?>(.*)$/im, '$1$2');
    // create an unique mark
    var mark = "#cursor~mark^";
    // check uniqueness
    while (before.indexOf(mark) >= 0 || after.indexOf(mark) >= 0) {
        // add random characters until its unique
        mark += String.fromCharCode(64 + Math.random() * 63);
    }
    // replace editor content
    var markHTML = '<div>' + mark + '</div>';
    body.innerHTML = before + markHTML + after;
    // select mark
    range.findText(mark);
    range.select();
    // delete mark (this way!)
    range.pasteHTML("");
    range.collapse(true);
};

// works for FF and Safari
splitContent_W3C = function (ed) {
    // get current range
    var range = ed.selection.getRng();
    // range collapsed?
    if (!range.collapsed) {
        // delete selected content now
        ed.execCommand("Delete", false, null);
        // reselect new range
        range = ed.selection.getRng();
    }
    // do magic
    var container = range.commonAncestorContainer;
    var lastBR = null,
        traverse;
    // helper
    traverse = function (node) {
        var i;
        if (node) {
            if (node.hasChildNodes()) {
                // skip text nodes
                for (i = 0; i < node.childNodes.length; i++) {
                    if (node.childNodes[i].nodeType === 1) {
                        // follow this node
                        traverse(node.childNodes[i]);
                        return;
                    } else if (node.childNodes[i].nodeType === 3) {
                        // remove zero width space (good for safari)
                        node.childNodes[i].nodeValue = node.childNodes[i].nodeValue.replace('\u200B', '');
                    }
                }
            } else if (node.nodeName === "BR") {
                // remember node
                lastBR = node;
            }
        }
    };
    while (container && container.nodeName !== "BODY") {
        // set range to end of container
        range.setEndAfter(container);
        // get parent node
        var p = container.parentNode;
        // add range content before next sibling (or at the end of the parent
        // node)
        var contents = range.extractContents();
        // BR fix (remove unwanted newline)
        traverse(contents.firstChild);
        // now insert contents
        if (jQuery(contents).text().length > 0) {
            // insert this content only if it includes something visible
            // Actually this allows to split a quote after the very last
            // character
            // without getting empty gray blocks below the split
            p.insertBefore(contents, container.nextSibling);
        }
        // climb up
        container = p;
    }
    // last BR?
    if (lastBR) {
        try {
            lastBR.parentNode.removeChild(lastBR);
        } catch (e) {
        }
    }
    // create new elements
    var dummySpan = ed.getDoc().createElement("span");
    dummySpan.innerHTML = "&nbsp;";
    var para = ed.getDoc().createElement("p");
    // and both elements to editor
    para.appendChild(dummySpan);
    range.insertNode(para);
    // select the span
    ed.selection.select(dummySpan);
    // and delete it
    ed.execCommand("Delete", false, null);
};

// -----------------------------------------------------------------------------
// modal dialog
function setModalBusy(state) {
    if (state === true) {
        ox.api.setModal(true);
        jQuery("#modal-dialog-decorator").addClass("busy");
    } else {
        ox.api.setModal(false);
        jQuery("#modal-dialog-decorator").removeClass("busy");
    }
}

// -----------------------------------------------------------------------------

var askToClose = function () {
    function cbyes() {
        oMailFunctionsNew.cleanUp();
        ctrl.close(true);
    }
    if (ums) {
        newConfirm(_("Close Window"),
            _("Do you really want to discard your changes and close the window?"),
            AlertPopup.YESNO, null, null, cbyes, null, null, null, function () {});
    } else {
        cbyes();
    }
};

/**
 * handles resizing of the tinyMCE editor and will be called each time the
 * resized event got triggered
 */
function cb_resize_tinyMCE() {
    /*
     * getting the iframe element of the editor
     */
    if (tinyMCE && tinyMCE.activeEditor) { // double check that!
        var editor = $ALL(tinyMCE.activeEditor.id + "_ifr");
        if (!editor) {
            return; // ups, no editor!?
        }
    } else {
        return;
    }

    /*
     * calculates the plain editor height without toolbar and setting the new
     * height (if it really changed)
     */
    var editorHeight = $('mailsplitbottom').clientHeight - $ALL("editor_content_tbl").getElementsByTagName("td")[0].offsetHeight;
    if (editorHeight > 0 && editorHeight !== editor.offsetHeight) {
        editor.style.height = editorHeight - 1 + "px";
    }
}

// local functions
var finalizeGUI,
    newMailWindowOnload,
    newMailOnload,
    initAddressBook,
    cb_attachmentDialog,
    setSignatureText,
    isNewline,
    createNewLine;

/**
 * will be executed if the body onload event gots triggered
 */
newMailWindowOnload = function () {

    // get passed data
    var wd = ox.api.window.getData(url.guid);
    aInfoMailAttachmentFile = wd.aInfoMailAttachmentFile;
    aInfoMailAttachmentLink = wd.aInfoMailAttachmentLink;
    multiForward = wd.multiForward;

    // add default theme (should be in browser cache)
    var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };
    ox.gui.themePath = getFullImgSrc("");
    removeCSSFilesForNewWindow(themeStyle.path);
    $("attachments_note").style.display="";

    activemodule = 'mail_new';
    initContents('mail_new');
    initAll();
};



/**
 * handles the initialization of all necessary events, parameter and load
 * contents for the new mail window
 */
newMailOnload = function () {

    loadingComplete();

    // extend url object
    url = jQuery.extend((url || {}), ox.api.window.getData(url.guid));

    // map url given addresses to valid objects
    var tAddr = [ "to", "cc", "bcc" ],
        i = 0;
    for (; i < tAddr.length; i++) {
        if (jQuery.isArray(url[tAddr[i]]) === false) {
            url[tAddr[i]] = [[ null, url[tAddr[i]]]];
        }
    }

    // prepare url object and take care
    // everything set correctly
    if (!url.attachments) {
        url.attachments = [{}];
    }
    // wrap any mailtext parameter into valid object
    if (url.mailtext) {
        var attach = url.attachments[0];
        attach.content_type = "text/plain";
        attach.content = url.mailtext;
        url.action = "new";
    }

    triggerEvent("OX_Switch_View", "mail_new");

    internalCache = corewindow.internalCache;
    action = url.action || "new";

    // get active mail account
    // default is
    var acc =  "0";
    // account via url?
    if (url.account) {
        acc = url.account;
    } else {
        // account via folder/id in url?
        if (url.folder && url.folder.length !== 0) {
            acc = ox.api.account.derive(url.folder); // use folder (e.g. default0/INBOX)
        } else if (url.id && url.id.length !== 0) {
            acc = ox.api.account.derive(url.id); // use id (e.g. default0/INBOX/23893)
        }
    }

    // get account data (relies on account being already cached);
    activeMailAccount = ox.api.account.get(acc);

    /*
     * attach autocomplete to recipient dialogs if enabled in the user options
     */
    if (configGetKey("gui.mail.autocomplete")) {
        var dummy; // for jslint
        dummy = new AutoComplete($('to'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));
        dummy = new AutoComplete($('cc'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));
        dummy = new AutoComplete($('bcc'), $('AutoCompleteContent'), 25, configGetKey("minimumSearchCharacters"));
        dummy = null;
    }

    // add simple context menu for attachments
    var menu = globalContextMenus.simpleAttachments = new ContextMenu(),
        open, save, menuContext, menuSelection;

    open = new MenuItem(_("Open"), function () { corewindow.openAttachment("OPEN", menuContext, menuSelection); });
    open.setIcon("img/menu/attachment_open.gif", "img/menu/attachment_open_d.gif");
    menu.addItem(open);

    save = new MenuItem(_("Save as"), function () { corewindow.openAttachment("SAVE", menuContext, menuSelection); });
    save.setIcon("img/menu/attachment_save.gif", "img/menu/attachment_save_d.gif");
    menu.addItem(save);

    menu.onShow = function (obj) {
        if (obj && obj.disp === 'attachment') {
            menuContext = { folder: url.folder, id: url.id };
            menuSelection = [{ data: obj }];
            open.setEnabled(true);
            save.setEnabled(true);
        } else {
            open.setEnabled(false);
            save.setEnabled(false);
        }
    };

    /*
     * register to resizing event for setting the new height of the tinyMCE
     * editor when the user resizes the window
     */
    resizeEvents.register("Resized", cb_resize_tinyMCE);
    
    // adding new menu
    ox.gui.initToolBarNewWindowMail();
    
    // wait for tinyMCE
    jQuery.when(setMessageFormat(messageFormat), prefetch).done(function() {
        // join handlers
        var joint = new Join(finalizeGUI),
            lock = joint.add();
        // initialize header (sync)
        initMessageHeader();
        // initialize header (async)
        cb_initMessageContent = joint.add();
        // initialize address book (async)
        cb_initAddressBook = joint.add();
        // go!
        initMessageContent(action);

        // disable attachments first
        triggerEvent("SubSelected", []);

        // init cb for attachment dialog
        tmp_attachmentDialog = new attachmentDialog(0, cb_attachmentDialog);
        tmp_attachmentInfostoreDialog = new infostoreDialog(0, cb_attachmentDialog);

        addDOMEvent($('addAddressTo'), "mousedown", function () { searchEmailAddress('to'); });
        addDOMEvent($('addAddressCc'), "mousedown", function () { searchEmailAddress('cc'); });
        addDOMEvent($('addAddressBcc'), "mousedown", function () { searchEmailAddress('bcc'); });

        /*
         * if enabled in the user options initialize auto save and register
         * timer which saves the message each n minutes to the drafts folder
         */
        if (!isNaN(configGetKey("gui.mail.auto_save_drafts")) && configGetKey("gui.mail.auto_save_drafts") !== 0) {
            var iv = window.setInterval(
                "oMailFunctionsNew.autosaveMessage()",
                (configGetKey("gui.mail.auto_save_drafts") * 60000)
            );
            intervals.push(iv);
        }

        // init address book
        setTimeout(function () {
            initAddressBook();
            lock();
        }, 100);
    });
};

finalizeGUI = function () {

    // set focus
    setInitialFocus();

    triggerReady = function (object) {
        // if available set the reply-to address, otherwise it will be the primary address
        if (action !== "draft"
                && ox.api.config.get("ui.mail.replyTo.configurable", false) === true) {
            var address = activeMailAccount.reply_to || "";
            if (address.length) {
                $("replyTo").value = activeMailAccount.reply_to;
            }
            if (options.replyto !== (address.length !== 0)) {
                options.replyto = !options.replyto;
            }
        }

        // adjust view states
        for (i in options) {
            oMailFunctionsNew.showAdditionalHeaderField(i, options[i]);
        }

        resizeEvents.register("Resized", function () {
            // ugly hack to fix bug #18051.
            // check to get rif of the toolbar resize race condition,
            if (oMailFunctionsNew.attachObj.length &&
                    jQuery("#mailsplitbottom").css("bottom") === "0px") {
                // force a redraw of the attachment panel if it seems that the
                // bottom
                // height does not match with the attachment counter
                resizeSplit("newMailAttachmentDiv", Math.round(pxPerEm * 3.2) + "px");
            }
        });

        // THIS MUST be called before Window READY !!!
        triggerEvent("OX_menu_Change_Height");

        var metaData = {
            module: "mail",
            activemodule: activemodule,
            handle: url.guid,
            id: url.id ? url.id : null,
            folder_id: url.folder ? url.folder : null,
            title: (url.id && url.id !== "" ? $("subject").value : corewindow._("New E-Mail")),
            action: action
        };;

        ox.api.window.core.triggerEvent("OX_Window_Ready", metaData, window);

        // this is the final resize! however, this potentially is risky because
        // we assume that any possible registered plugin already finished its work
        setTimeout(function() {
            oMailFunctionsNew.drawAttachmentPanel(true);
            // disable loading screen
            $("loading_data_bg").style.display = "none";
        }, 50);
        
        object = metaData = null;
    };

    triggerReady();
};

/**
 * The attachment dialog callback. We take the given objects and convert them
 * into unique attachment objects.
 *
 * @param {attachments}
 *            the attachment object
 */
cb_attachmentDialog = function (attachments) {
    // nothing to do
    if (!attachments && !attachments.length) {
        return;
    }
    // fetch objects and add to global attach obj
    for (var i = 0; i < attachments.length; i++) {
        if (!oMailFunctionsNew.attachmentExists(attachments[i].id)) {
            var attach = {
                id: attachments[i].id,
                filename: attachments[i].filename,
                size: null,
                content_type: attachments[i].content_type || null,
                msgref: attachments[i].msgref || null,
                selected: false,
                infostore: attachments[i].infostore || false
            };
            if (attachments[i].cid) {
                attach.cid = attachements[i].cid;
            }
            oMailFunctionsNew.addAttachment(attach);
            setBeforeUnload(true);
            delete(attach);
        }
    }
};

registerView(
    "mail_new",
    null,
    function () {
        // set focus
        setInitialFocus();
    },
    null,
    function () {
        unregister("cb_mailComboChanged", cb_mailComboChanged);
    },
    function () {
        // set focus
        setInitialFocus();
    }
);



// -----------------------------------------------------------------------------
var currentSignature = null;
setSignatureText = function (sig, initial) {
    
    if (editorEnabled) {
        // shortcut to active editor / body
        var ae = tinyMCE.activeEditor;
        // find old signature
        var signature = jQuery('#ox-signature', ae.getDoc());

        // quick path to remove the signature
        if (!sig) {
            currentSignature = sig;
            signature.remove();
            return;
        }
        
        var newSignature = jQuery('<div id="ox-signature">' +
                sig.signature_text.replace(/\n/g, '<br>') + '</div>');
        
        // Signatures with the same position are replaced in-place
        if (signature.length && currentSignature && sig &&
            sig.position === currentSignature.position)
        {
            signature.replaceWith(newSignature);
        } else {
            signature.remove();
            if (sig.position === "above") {
                newSignature.prependTo(ae.getBody());
            } else {
                newSignature.appendTo(ae.getBody());
            }
        }
        
        currentSignature = sig;
        
        // special case for initialization: add an empty line for top-posting
        // instead of scrolling to the new signature
        if (initial) return jQuery('<div><br></div>').prependTo(ae.getBody());
        
        jQuery('#ox-signature', ae.getDoc())[0].scrollIntoView(false);
    } else {
        var text = jQuery("#editor_content");
        var content = text.val();
        var signature = '', above = true, i = -1, before = '', after = '';
        
        // find current signature
        if (currentSignature) {
            var indexFn = currentSignature.position === "above" ? "indexOf"
                                                                : "lastIndexOf";
            i = content[indexFn](currentSignature.signature_text);
            if (i >= 0) {
                before = content.slice(0, i);
                after = content.slice(i +
                    currentSignature.signature_text.length);
                // don't replace signatures with different positions
                if (sig && sig.position !== currentSignature.position) {
                    content = joinLines([before, after]);
                    i = -1;
                }
            }
            above = currentSignature.position == "above";
        }
        
        currentSignature = sig;
        if (sig) {
            signature = sig.signature_text;
            above = sig.position === "above";
        }
        
        // if not replacing, compute the new position
        if (i < 0) {
            before = above ? '' : content;
            after = above ? content : '';
        }
        
        var padding = initial && action !== "new" ? '\n' : '';
        text.val(joinLines([padding, before, signature, after]));
        if (initial) return
        text.scrollTop(above ? 0 : text.prop('scrollHeight') - text.height());
    }
};

/**
 * Joins an array of strings by adding newlines only when necessary to prevent
 * merging of lines from different strings.
 * @param {Array of String} lines An array of strings to join
 * @type String
 * @returns The joined strings.
 */
function joinLines(lines) {
    var out = [], prev = '';
    for (var i = 0; i < lines.length; i++) {
        var line = lines[i];
        if (line) {
            if (prev && prev.slice(-1) !== '\n' && line.charAt(0) !== '\n') {
                out.push('\n');
            }
            out.push(line);
        }
        prev = line;
    }
    return out.join('');
}

// -----------------------------------------------------------------------------
var accountAliases = {}; // aliases mapping
initMessageHeader = function () {

    var defaultName = quotePersonalAddr(corewindow.getPersonalFullName()) + " ",
        reply_to = null, primaryAddress = configGetKey("mail.sendaddress");

    // adding e-mail addresses from external accounts to sender addresses list
    if (configGetKey("modules.mailaccount.module")) {
        // get all accounts
        ox.api.account.all(function (list) {
            var i = 0, $i = list.length, data, personal;
            for (; i < $i; i++) {
                data = list[i];
                // need some setting from the main account
                if (data.id == 0) {
                    reply_to = data.reply_to;
                }
                var personal = defaultName;
                // personal name used for internal aliases later
                if (data.personal) {
                    personal = quotePersonalAddr(data.personal) + " ";
                    if (data.id == 0) {
                        defaultName = personal;
                    }
                }
                accountAliases[data.id] = {
                        address: data.primary_address,
                        personal: personal,
                        value: data.primary_address + " (" + data.name + ")",
                        id: data.id,
                        reply_to: data.reply_to
                };
                if (data.primary_address == primaryAddress) {
                    // address matched to the default sender address
                    primaryAddress = data.id;
                }
            }
        });
    }

    // adding regular aliases from the gui config
    var aliases = {}, i;
    if (configContainsKey("mail.addresses")) {
        var addrs = configGetKey("mail.addresses");
        for (i = 0; i < addrs.length; i++) {
            var address = addrs[i], found = false;
            // iterating through existing mailacounts
            // search for a matching address
            for (var a in accountAliases) {
                if (accountAliases[a].address == address) {
                    found = true;
                    break;
                }
            }
            // not found, adding to tmp list
            if (found == false) {
                aliases[address] = {
                        address: address,
                        personal: defaultName,
                        value: address,
                        reply_to: reply_to
                };
            }
        }
    }

    // merge internal aliases with mail account addresses
    jQuery.extend(accountAliases, aliases);

    var scrollBar = ObjectToArray(accountAliases).length > 5 ? 6 : null;
    senderAddress = window.heinz = new ComboBox3(window, "mail.fromCombo", "25em", 0,
            true, "cb_mailComboChanged", scrollBar, { type: "sender" });
    // add to combo-box
    for (var i in accountAliases) {
        senderAddress.addElement(noI18n(accountAliases[i].value), i);
    }
    senderAddress.sort();
    senderAddress.getDomNode();

    if (activeMailAccount && activeMailAccount.primary_address &&
            (activeMailAccount.id && activeMailAccount.id > 0)) {
        primaryAddress = activeMailAccount.id;
    }

    // set the default selected address
    senderAddress.setKey(primaryAddress, true);

    priority = new ComboBox3(window, "mail.priorityCombo", "13em", 1, true, "cb_mailComboChanged", 3, { type: "priority" });
    priority.addElement(_("Low"), "4");
    priority.addElement(_("Normal"), "3");
    priority.addElement(_("High"), "2");
    priority.getDomNode();
    register("cb_mailComboChanged", cb_mailComboChanged);

    // get number of signatures (+1 = "None")
    var signature_count = configGetKey("gui.mail.signatures").length + 1;
    // add combobox (height depends on number of signatures (max 4 rows)
    signature = new ComboBox3(window, "mail.signatureCombo", "15em", 0, true, "setSignature", Math.min(signature_count, 5));
    // fill combobox
    if (configContainsKey("gui.mail.signatures")) {
        signature.addElement(_("None"), "");
        var a = 0;
        for (; a < configGetKey("gui.mail.signatures").length; a++) {
            var signatures = configGetKey("gui.mail.signatures")[a];
            var sig_name = signatures.signature_name.length === 0 ?
                _("Unnamed signature") :
                noI18n(signatures.signature_name);
            signature.addElement(sig_name, signatures);
            if (configGetKey("gui.mail.signatures")[a].signature_default && url.default_signature !== false) {
                defaultSignature = a;
                signature.selected = a + 1;
            }
        }
    } else {
        signature.addElement("No signature", "");
    }
    signature.getDomNode();

    if (!configGetKey("gui.mail.signatures") || ((configGetKey("gui.mail.signatures") && configGetKey("gui.mail.signatures").length === 0))) {
        setTimeout(function () { signature.disable(); }, 0);
    }

    if (configGetKey("mail.vcard")) {
        document.getElementsByName("mail.attachVCard")[0].checked = true;
    }
};

cb_mailComboChanged = function (key, args) {
    // set reply-to address
    if (ox.api.config.get("ui.mail.replyTo.configurable") === true
    		&& accountAliases.length != 0 && args.type === "sender") {
        var address = "";
        if (accountAliases[key] && accountAliases[key].reply_to) {
            address = accountAliases[key].reply_to;
        }
        $("replyTo").value = address;
        oMailFunctionsNew.showAdditionalHeaderField("replyto", (address.length !== 0));
    }
    setBeforeUnload(true);
};

initMessageContent = function (m_action) {

    var addParam = messageFormat.toUpperCase() === "TEXT/PLAIN" ? "&view=text" : "&view=html";

    if (m_action && m_action === "draft") {
        m_action = "get";
        addParam += "&edit=1";
    }

    // attached objects?
    var i;
    var wd = ox.api.window.getData(url.guid);
    if (wd.attachedObjects !== undefined) {
        // loop objects
        for (i = 0; i < wd.attachedObjects.length; i++) {
            var obj = wd.attachedObjects[i];
            // attach:
            oMailFunctionsNew.addObject(obj);
        }
    }

    // headers
    if (wd.headers) {
        for (i in wd.headers) {
            oMailFunctionsNew.headers[i] = wd.headers[i];
        }
    }

    if (m_action && m_action !== "" && m_action !== "new") {
        var sObj = [{ "folder": url.folder, "id": url.id }];
        // multi forward?
        if (jQuery.isArray(multiForward) && multiForward.length) {
            sObj = multiForward;
        }
        (new JSONX()).put(
            AjaxRoot + "/mail?action=" + m_action + "&session=" + corewindow.session + addParam,
            sObj,
            null,
            function (cb) {
                if (cb && cb.data) {
                    if (action !== "draft") {
                        delete cb.data.disp_notification_to;
                    }
                    if (action === "forward") {
                        cb.data.to = url.to ? url.to : [];
                    }
                    setMailFields(cb.data);
                }
                // callback
                cb_initMessageContent();
            },
            function (cb) {
                // mail no longer exists so show alert and then close window
                if (cb && cb.code === "MSG-0032") {
                    newAlert(
                        _("Error"),
                        formatError(cb),
                        function () {
                            oMailFunctionsNew.cleanUp();
                            corewindow.triggerEvent("OX_Mail_Delete");
                            ctrl.close();
                        }
                    );
                    finalizeGUI();
                    return true;
                } else {
                    finalizeGUI();
                    return false;
                }
            }
        );

    } else {

        setMailFields(url);
        if (aInfoMailAttachmentFile !== undefined) {
            setMessageText(aInfoMailAttachmentFile);
        } else if (aInfoMailAttachmentLink !== undefined) {
            setMessageText(aInfoMailAttachmentLink);
        }
        // callback
        cb_initMessageContent();
    }
};

setMailFields = function (mailobject) {
    setRecipients(mailobject.to, "to");
    setRecipients(mailobject.cc, "cc");
    setRecipients(mailobject.bcc, "bcc");
    setSubject(mailobject.subject);
    msgref = mailobject.msgref;
    if (mailobject.nested_msgs && mailobject.nested_msgs.length > 0) {
        var i, nobj, textAttachment;
        for (i = 0; i < mailobject.nested_msgs.length; i++) {
            nobj = mailobject.nested_msgs[i];
            textAttachment = nobj.subject || _("attachment");
            oMailFunctionsNew.addAttachment({
                id: nobj.id || "message/rfc822",
                filename: textAttachment,
                size: null,
                content_type: "message/rfc822",
                msgref: nobj.msgref || null,
                selected: false,
                disk: nobj.disk || null
            });
        }
    }
    setMessageText(mailobject.attachments);

    var prio = "3";
    switch (String(mailobject.priority)) {
        case "1":
        case "2":
            prio = "2";
            break;
        case "4":
        case "5":
            prio = "4";
            break;
    }
    priority.setKey(prio, true);

    if (mailobject.disp_notification_to && $("acknowledge")) {
        $("acknowledge").checked = true;
    }
};

setRecipients = function (to, field) {
    if (to && to.length && $(field)) {
        $(field).value = corewindow.getAdressString(to, false);
        if (field !== "to" && trimStr($(field).value).length !== 0) {
            // don't use trigger event because we won't store the settings!
            oMailFunctionsNew.showAdditionalHeaderField(field, true);
        }
    }
};

var setWindowTitle = function () {
    var title = _("New E-Mail");
    if (url.id && url.id !== "") {
    	title += ": " + $("subject").value;
    }
    if (document) {
    	document.title = title;
    }
};

setSubject = function (subject) {
    if (subject) {
        // set text fields
        $("subject").value = subject;
    }
    // set document title as well
    setWindowTitle();
};

function processAttachments(attachments) {
    var cnn = "", conArr, ct, con, idfield;
    for (idfield in attachments) {
        conArr = attachments[idfield];
        ct = conArr.content_type ? conArr.content_type.toLowerCase() : "application/unknown";
        con = conArr.content;
        if (ct.search(/text\//) !== -1 && con && con !== undefined) {
            if (editorEnabled) {
                cnn += con;
            } else {
                cnn += unescapeHTML(con.replace(/<br\s*\/?>/g, '\n'));
            }
        } else {
            if (conArr.filename && !oMailFunctionsNew.attachmentExists(conArr.id)) {
                oMailFunctionsNew.addAttachment({
                    id: conArr.id || null,
                    filename: conArr.filename || null,
                    size: conArr.size || null,
                    content_type: conArr ? conArr.content_type : null,
                    disp: conArr.disp || null,
                    content: conArr.content || null,
                    disk: conArr.disk || null,
                    selected: false,
                    infostore: conArr.infostore || null,
                    cid: conArr.cid || null
                });
            }
        }
    }
    return cnn;
}

setMessageText = function (attachments) {

    var cnn = processAttachments(attachments);
    if (editorEnabled) {
        // shortcut to active editor
        var ae = tinyMCE.activeEditor;
        
        // separate styles from the body using an iframe
        var iframe = jQuery("<iframe/>").attr("src", "javascript:false");
        // append to body, otherwise contentWindow is empty!
        iframe.appendTo("body");
        // append original html to iframe
        iframe[0].contentWindow.document.open();
        iframe[0].contentWindow.document.write(cnn);
        iframe[0].contentWindow.document.close();
        // filter required style and body elements
        var styles = iframe.contents().find("style");
        var cnn = iframe.contents().find("body").html();
        iframe.remove();
       
        // add styles and body to the editor
        styles.appendTo(ae.dom.select("head"));
        if (!cnn && action === "draft") cnn = '<div></div>';
        ae.setContent(cnn);
        
        // set default font
        jQuery(ae.dom.getRoot()).attr("style", getStyleTextOfDefaultFont());
        // remove quoted signature ids
        if (action !== "draft") {
            jQuery('#ox-signature', ae.getDoc()).removeAttr("id");
        }
    } else {
        if (!cnn && action === "draft") cnn = '\n';
        jQuery('#editor_content').val(cnn);
    }
    // add default signature
    if (action !== "draft") {
        setSignatureText(configGetKey("gui.mail.signatures")[defaultSignature],
                         true);
    }
};

setInitialFocus = function () {
    window.focus();
    // first, focus the editor and move the cursor to the top
    if (editorEnabled) {
        var ae = tinyMCE.activeEditor;
        if (!ae) return;
        ae.focus();
        var sel = ae.selection;
        sel.select(ae.getBody().firstChild, true);
        sel.collapse(true);
    } else {
        var textarea = jQuery('#editor_content').focus().get(0);
        if ("selectionStart" in textarea) {
            textarea.selectionStart = 0;
            textarea.selectionEnd = 0;
        } else {
            var tr = textarea.createTextRange();
            tr.setEndPoint('EndToStart', tr);
            tr.select();
        }
    }
    // now, eventually focus the recipient field
    if (url.action !== "reply" && url.action !== "replyall") {
        // set focus on "To" field
        // ok for FF and IE (take care if input not visible, possible
        // problem e.g. when using the fax plugin together with IE)
        jQuery("#to:visible").focus();
    }
};

getStyleTextOfDefaultFont = function () {
    var styleText = "";
    // set font family
    if (default_font_tynmce && default_font_tynmce !== 'default') {
        styleText += "font-family: " + default_font_tynmce + "; ";
    }
    // convert index to PT and set font size
    if (default_font_size_tynmce && default_font_size_tynmce !== 'default') {
        var PT = [8, 10, 12, 14, 18, 24, 36];
        styleText += "font-size: " + PT[default_font_size_tynmce - 1] + "pt; ";
    }
    return styleText;
};

function MailFunctions() {
    this.oo = {};
    this.headers = {};
    this.ooA = {};
    this.attachContainer = [];
    this.attachObj = [];
    this.savePending = false;
}

MailFunctions.prototype = {

    sendMessage: function (param, silent) {
        var Self = this;
        if (this.savePending) {
            return;
        }
        if (!param) {
            Self.getMailValues();
        }
        function cb_ok() {
            Self.savePending = true;
            if (action === "forward") {
                Self.oo.sendtype = 2;
            } else if (action === "reply" || action === "replyall") {
                Self.oo.sendtype = 1;
            } else if (action === "draft") {
                Self.oo.sendtype = 4;
            }
            Self.sAction = AjaxRoot + "/mail?action=new&session=" + corewindow.session;
            var sTargetParam = 'mailSendCB';
            if (!isEmpty(Self.headers)) {
                Self.oo.headers = Self.headers;
            }
            setModalBusy(true);
            tmp_attachmentDialog.do_post(Self.oo, callback_new, Self.sAction, sTargetParam, setModalBusy);
        }
        if (!silent && trimStr(Self.oo.subject).length === 0) {
            newInput(
                _("Send"),
                _("You did not enter a subject. Would you like to enter a subject now?"),
                null,
                "",
                AlertPopup.OKCANCEL,
                function () {
                    $("subject").value = $("create_window_text_field").value;
                    Self.oo.subject = $("create_window_text_field").value;
                    cb_ok();
                },
                null,
                null,
                null,
                "input",
                null
            );
        } else {
            cb_ok();
        }
    },

    saveMessageAsDraft: function (callback, silent) {

        var self = this;

        this.getMailValues();
        this.oo.flags = 4;

        if (msgref) {
            this.oo.msgref = msgref;
        }

        // magic global callback
        callback_new_cb = function (data) {
            callback_new_cb = null;
            self.savePending = false;
            // remember msgref
            msgref = data;
            action = 'draft';
            setBeforeUnload(false);
            corewindow.updateDraftsFolderCache(url.id, data);
            if (!silent && (self.attachObj.length ||
                editorEnabled && tinyMCE.activeEditor.dom.select("img").length))
            {
                cb_initMessageContent = callback || jQuery.noop;
                url.folder = data.replace(/\/[^\/]+$/, "");
                url.id = data.replace(/.*\//, "");
                var ids = [];
                for (var i = 0; i < self.attachObj.length; i++) {
                    ids.push(self.attachObj[i].id);
                }
                tmp_attachmentDialog.removeFiles(ids);
                self.attachObj.length = 0;
                initMessageContent(action);
            } else if (callback) callback();
        };

        // save draft
        this.sendMessage("fromDraft", silent);
    },

    autosaveMessage: function () {
        var self = this;
        if (!ums) {
            return; // nothing changed, so no need to save anything
        }
        this.getMailValues();
        delete this.oo.attachments;
        delete this.oo.infostore_ids;
        if (autosave) {
            this.oo.msgref = autosave;
        } else {
            delete this.oo.msgref;
        }
        this.oo.flags = 4;
        // refill message text
        this.oo.attachments = [{
            content_type: messageFormat,
            content: editorEnabled ? tinyMCE.activeEditor.getContent()
                                   : jQuery('#editor_content').val()
        }];
        // send to server
        (new JSONX()).put(
            AjaxRoot + "/mail?action=autosave&session=" + corewindow.session,
            this.oo,
            null,
            function (reply) {
                if (!reply.error && reply.data) {
                    corewindow.updateDraftsFolderCache(autosave, reply.data);
                    autosave = reply.data;
                    if (autosave.indexOf("/") !== -1) {
                        // have to update mail id for all inline images
                        self.updateInlineImages(
                            autosave.substr(autosave.lastIndexOf("/")+1, autosave.length)
                        );
                    }
                    self = null;
                }
            }
        );
    },
    
    /**
     * 
     * @param id - the new mail id
     */
    updateInlineImages: function(id) {
        if (editorEnabled) {
            // getting all images in editor
            jQuery("img", tinyMCE.activeEditor.dom.select("body")).filter(function() {
                // filter just only for inline-images
                return this.src.match(/picture?/);
            }).each(function (i, node) {
                var url = this.src.split("?");
                if (url.length === 2) {
                    var hash  = ox.util.deserialize(url[1]);
                    if ("id" in hash && "uid" in hash) {
                        hash.id = id;
                        var url = url[0] + "?" + ox.util.serialize(hash);
                        jQuery(this).attr({ src: url, "data-mce-src": url});
                        url = null;
                    }
                }
            });
        }
    },

    cleanUp: function () {
        // reset intervals, specially IE does not reset
        // them when closing the iframe
        for (var i=0; i < intervals.length; i++) {
            window.clearInterval(intervals[i]);
        }
        // delete autosave message if necessary
        if (autosave) {
            corewindow.deleteAutosaveMessage(
                configGetKey("mail.folder.drafts"),
                String(autosave.match(/[0-9]+$/g)),
                true
            );
        }
    },

    getEditorContent: function () {
        if (editorEnabled) {
            var ae = tinyMCE.activeEditor;
            var style = jQuery(ae.dom.select('style')).text();
            if (style) {
                style = '<head><style type="text/css">' + style +
                        '</style></head>';
            }
            return '<html>' + style + '<body style="' +
                getStyleTextOfDefaultFont() + '">' +
                tinyMCE.activeEditor.getContent() + '</body></html>';
        } else {
            return replaceSpaces(escapeHTML(jQuery('#editor_content').val()),
                                 true);
        }
    },

    getMailValues : function () {

        var i;

        this.clearObjectContent();
        var sender = accountAliases[senderAddress.getKey()];
        this.oo.from = sender.personal + "<" + sender.address + ">";
        // set reply_to address if configureable
        if (ox.api.config.get("ui.mail.replyTo.configurable") === true
                && $("replyTo")) {
            var reply_to = trimStr($("replyTo").value || "");
            if (reply_to.length !== 0) {
                this.oo.reply_to = reply_to;
            }
        }
        this.oo.to = $("to").value;
        this.oo.cc = $("cc").value;
        this.oo.bcc = $("bcc").value;
        this.oo.subject = $("subject").value;
        this.oo.priority = priority.getKey();

        if (msgref !== null && msgref !== undefined) {
            this.oo.msgref = msgref;
        }

        if (document.getElementsByName("acknowledge")[0].checked) {
            this.oo.disp_notification_to = document.getElementsByName("acknowledge")[0].checked;
        }

        if (document.getElementsByName("mail.attachVCard")[0].checked) {
            this.oo.vcard = 1;
        }

        // get content type
        this.ooA.content_type = messageFormat;
        // get content
        this.ooA.content = this.getEditorContent();

        // build the final attachment object
        var tmp_attachObj = [],
            infoAttaches = [],
            attachObj;
        tmp_attachObj.push(this.ooA); // always message text first
        for (i = 0; i < this.attachObj.length; i++) {
            attachObj = this.attachObj[i];
            if (attachObj.infostore) {
                infoAttaches.push(attachObj.id);
            } else if (attachObj.type === "file" && attachObj.content_type !== null) {
                tmp_attachObj.push(attachObj);
            }
        }
        this.oo.attachments = tmp_attachObj;

        // attach infostore references
        if (infoAttaches.length !== 0) {
            this.oo.infostore_ids = infoAttaches;
        }

        // build the final data source object
        tmp_attachObj = [];
        for (i = 0; i < this.attachObj.length; i++) {
            attachObj = this.attachObj[i];
            if (attachObj.type === "datasource") {
                tmp_attachObj.push(attachObj.data);
            }
        }
        this.oo.datasources = tmp_attachObj;
    },

    clearObjectContent: function () {
        this.oo = {};
        this.ooA = {};
    },

    addAttachment: function (attachObj) {
        if (!attachObj || !attachObj.id) {
            return;
        }
        // set type
        attachObj.type = "file";
        // add
        this.attachObj.push(attachObj);
        this.drawAttachmentPanel();
    },

    getObjectID: function (obj) {
        // create id
        var keys = [], key;
        for (key in obj.compositeID) {
            keys.push(key);
        }
        keys.sort();
        var values = [], i;
        for (i in keys) {
            values.push(obj.compositeID[keys[i]]);
        }
        return values.join(".");
    },

    addObject: function (obj) {
        if (!obj || !obj.compositeID) {
            return;
        }
        // get id
        obj.id = this.getObjectID(obj);
        // set type
        obj.type = "datasource";
        obj.selected = false;
        // add
        this.attachObj.push(obj);
        this.drawAttachmentPanel();
    },

    getAttachment: function (id) {
        var i;
        for (i = 0; i < this.attachObj.length; i++) {
            if (this.attachObj[i].id === id) {
                return this.attachObj[i];
            }
        }
        return null;
    },

    removeAttachment: function (id) {
        var i;
        for (i = this.attachObj.length - 1; i >= 0; --i) {
            if (this.attachObj[i].id === id) {
                var obj = this.attachObj[i];
                this.attachObj.splice(i, 1);
                tmp_attachmentDialog.removeFiles([id]);
                // remove inline image when cid is available
                if ("cid" in obj && obj.cid !== null) {
                    // prepare id
                    var cid = obj.cid.replace(/^<|>$/g, "");
                    if (editorEnabled) {
                        var dom = tinyMCE.activeEditor.dom.select("body");
                        // find any reference and remove them
                        jQuery(dom[0]).find("img").each(function () {
                            if (this.id === cid) {
                                jQuery(this).remove();
                            };
                        });
                    }
                }
                obj = null;
            }
        }
        this.drawAttachmentPanel();
    },

    attachmentExists: function (id) {
        return (this.getAttachment(id) !== null ? true : false);
    },

    drawAttachmentPanel: function (forceResize) {

        var mda = $("newMailAttachmentDiv");
        removeChildNodes(mda);

        var fnSelect = function (id, oMailFunctionsNew) {
            return function (e) {
                cancelDefault(e);
                oMailFunctionsNew.selectAttachment(id);
            };
        };

        var i, attach, label, imgSrc;
        for (i = 0; i < this.attachObj.length; i++) {
            attach = this.attachObj[i];
            label = "";
            imgSrc = "";
            // get label of attachment
            switch (attach.type) {
            case "file":
                label = attach.filename;
                imgSrc = getFullImgSrc("img/mail/" + (this.attachObj[i].content_type && this.attachObj[i].content_type.match(/^message\/rfc822/gi) ? "unread.gif" : "attachment.gif"));
                break;
            case "datasource":
                switch (attach.objectType) {
                case "vCard":
                    label = attach.name + " (vCard)";
                    imgSrc = getFullImgSrc("img/infostore/mimetypes/vcard.gif");
                    break;
                case "default":
                    label = attach.name;
                    imgSrc = getFullImgSrc("/img/mail/attachment.gif");
                    break;
                }
                break;
            }
            var oDOMDiv = newnode("div", 0, { id: this.attachObj[i].id, className: "mailDetailAttachmentsCont" + (this.attachObj[i].selected ? "Sel background-color-PMG-selection-elements" : "") },
                [ newnode("img", 0,
                    { src: imgSrc, align: "absmiddle", padding: "3px"}),
                      newnode("span", 0, {className: "_nothing"},
                          [ document.createTextNode(this.attachObj[i].size ?
                            //#. Displayed label for attachments
                            //#. %1$s is the file name.
                            //#. %2$s is the file size.
                            //#, c-format
                            format(_(" %1$s (%2$s); "), label,
                                     bytesToString(this.attachObj[i].size)) :
                            //#. Displayed label for attachments without file size
                            //#. %1$s is the file name.
                            //#, c-format
                            format(_(" %1$s; "), label))]
                          )
                    ]
                );

            addDOMEvent(oDOMDiv, "mousedown", fnSelect(this.attachObj[i].id, oMailFunctionsNew));

            addDOMEvent(oDOMDiv, "dblclick", (function (obj) {
                return function(e) {
                    stopEvent(e);
                    if (obj) {
                        if (obj.disp === 'attachment') {
                            corewindow.openAttachment("OPEN", { folder: url.folder, id: url.id }, [{ data: obj }] );
                        } else {
                            globalalert.header = _("Note");
                            globalalert.buttons = 514;
                            globalalert.text = _("To view attachment you must first save your e-mail as a draft.");
                            globalalert.cbsave = function() {
                                triggerEvent("OX_Save_Template_Object");
                            };
                            AlertPopup.open();
                        }
                    }
                };
            }(this.attachObj[i])));

            addDOMEvent(oDOMDiv, "contextmenu", (function (obj) {
                return function(e) {
                    stopEvent(e);
                    globalContextMenus.simpleAttachments.display(e.clientX, e.clientY, obj);
                };
            }(this.attachObj[i])));

            mda.appendChild(oDOMDiv);
        }

        var os = 0;
        if (this.attachObj.length > 0) {
            os = Math.round(pxPerEm * 3.2);
        }

        // only resize if really changed
        if (forceResize === true || jQuery(mda).height() !== os) {
            resizeSplit(mda.id, os + "px");
        }
    },

    /*
     * @private
     *
     */
    selectAttachment: function (id) {
        var i;
        for (i = 0; i < this.attachObj.length; i++) {
            this.attachObj[i].selected = false;
            if (this.attachObj[i].id === id) {
                this.attachObj[i].selected = true;
                triggerEvent("SubSelected", [this.attachObj[i]]);
            }
            document.getElementById(this.attachObj[i].id).className =
                "mailDetailAttachmentsCont" + (this.attachObj[i].selected ? "Sel background-color-PMG-selection-elements" : "");
        }
    },

    showAdditionalHeaderField: function (field, selected) {
    	if (field === "replyto" && ox.api.config.get("ui.mail.replyTo.configurable", false) === false) {
    		// looks like replyto is disabled, so we have to take care about it :)
    		selected = false;
    		// do we have to set it in options as well?
    		if (options[field]) {
    			options[field] = false;
    		}
    	}

    	// take care that checkbox of the toolbar item is in sync
    	if (ox.widgets) {
        	var node = ox.widgets.toolBar.menuItems["mail_new-" + field];
            if (node && node.stateChecked !== selected) {
                node.setChecked(selected);
                node.validate();
            }
            delete(node);
    	}

        // to, cc, bcc, options
        if (!$ALL(field + "_row") || $ALL(field + "_row").style.display === (selected ? "" : "none")) {
            return;
        }
        $ALL(field + "_row").style.display = selected ? "" : "none";
        this.drawAttachmentPanel(true);
    }
};

oMailFunctionsNew = new MailFunctions();

callback_new_cb = null;

callback_new = function (cb) {

    oMailFunctionsNew.savePending = false;

    if (cb) {
        if (cb.data && !cb.error) {
            // use custom callback?
            if (callback_new_cb) {
                setModalBusy(false);
                callback_new_cb(cb.data);
            } else {
                // default callback
                switch (action) {
                case "reply":
                case "replyall":
                    corewindow.updateMailFlagsInternal(url.folder, url.id, { flag: 1, bool: true });
                    break;
                case "forward":
                    corewindow.updateMailFlagsInternal(url.folder, url.id, { flag: 256, bool: true });
                    break;
                case "draft":
                    corewindow.updateDraftsFolderCache(url.id, cb.data);
                    break;
                }
                oMailFunctionsNew.cleanUp();
                window.setTimeout(function () {
                    // vars
                    var core = corewindow,
                        inbox = ox.api.config.get("mail.folder.inbox"),
                        sent = ox.api.config.get("mail.folder.sent");
                    // update sent folder
                    core.ox.api.folder.getMultiple({
                        list: [inbox, sent],
                        cache: false,
                        success: function () {
                            // update tree
                            try {
                                ox.api.folder.dispatcher.trigger("modify");
                            } catch (e) {
                                // psst - strange IE...
                            }
                            core.triggerEvent("OX_New_Unread_Mail");
                            // trigger update - refrehes mail views (see bug #18104)
                            core.OXCache.update();
                             // close window
                            ctrl.close(true);
                        }
                    });
                }, 500); // wait a bit so that mails can arrive in INBOX/Sent
                            // items
            }
        } else {
            // check for special errors
            if (cb.code === "MSG-0084") {
                // attachment has been published, let the user knows about it :)
                newAlert(
                    _("Info"),
                    _(cb.error),
                    function () {
                        // sending was fine, so remove the error
                        // and let the callback re-do the rest
                        setModalBusy(true);
                        delete cb.error;
                        callback_new(cb);
                    }
                );
            } else {
                newServerError(cb);
                setModalBusy();
            }
        }
    } else {
        triggerEvent("OX_New_Error", 4, _("The server didn't respond!"));
    }
};

initAddressBook = function () {
    // initialized?
    if (!myListAddressBook) {
        var myFields = ["to", "cc", "bcc"];
        // initialize
        myListAddressBook = new SearchListAddressBook(
            null,
            "addressbookNewEmail",
            "newmailSearchResult",
            null,
            "newmail_add_list",
            "newmail_search",
            closeAddressbookNewEmail
        );
        myListAddressBook.setAllFolders(
            $("newmail-search-all-folders"),
            $("but_folder")
        );
    }
    
    myListAddressBook.makeGrid();
    
    myListAddressBook.clearList = function() {
        jQuery("select[id^=newmail_add_list_]").empty();
    };
    
    // join
    cb_initAddressBook();
};

/* search EmailAddresses */
searchEmailAddress = function (recipientField) {
    myListAddressBook.recipientType = recipientField;
    myListAddressBook.openDiv();
    myListAddressBook.getResult();
};

newmailContact = function () {
    var searchString = $('newmail_search').value;
    myListAddressBook.searchstring = searchString;
    myListAddressBook.getResult();
};

closeAddressbookNewEmail = function (ok) {
    if (ok) {
        // fill address fields
        for (var suffix in { to: 1, cc: 1, bcc: 1}) {
            var addresses = jQuery("#" + myListAddressBook.divAddContact + "_" + suffix)
            .children()
            .map(function() {
                return this.value;
            }).get().join(", ");
            if (addresses.length !== 0) {
                var value = jQuery("#" + suffix).attr("value");
                if (value.length !== 0) {
                    addresses = value + (value.match(/;|,[\s]?$/) ? "" : ", ") + addresses;
                }
                jQuery("#" + suffix).attr("value", addresses + ", ");
                value = null;
            }
            addresses = null;
        }
    }
    // clear lists
    myListAddressBook.clearList();
    
    // set focus
    var _ftj = myListAddressBook.tmpIdsForSave &&
        myListAddressBook.tmpIdsForSave.length !== 0 ? "subject" : myListAddressBook.recipientType;
    setTimeout(function () {
        if (document.getElementById(_ftj) && document.getElementById(_ftj).focus()) {
            document.getElementById(_ftj).focus();
        }
        _ftj = null;
    }, 0);
};

function addnewmailToList(field) {
    if (myListAddressBook) {
        myListAddressBook.addToList(field);
    }
}

getURL = function () {
    var URL = window.location.pathname;
    URL = URL.substring(0, URL.lastIndexOf("/") + 1);
    return URL;
};

/**
 * File browser for adding images as Inline Content. Will be added to the Image
 * selection dialog.
 *
 * @param field_name
 * @param url
 * @param type
 * @param win
 */
function cb_mailFileBrowser(field_name, url, type, win) {
    if (!win || !win.document) {
        return false;
    }

    var URL = getURL();

    var doc = win.document;
    if (doc.getElementById("oxmainBG")) {
        doc.getElementById("oxmainBG").parentNode.removeChild(doc.getElementById("oxmainBG"));
    }
    if (doc.getElementById("oxmain")) {
        doc.getElementById("oxmain").parentNode.removeChild(doc.getElementById("oxmain"));
    }

    // build div for file browser
    var nd1, nd2, nd3, nd4, nd5, pURL;
    nd1 = newnode("div", { zIndex: 2, width: "100%", height: "100%", top: 0, left: 0, position: "fixed", background: "#FFFFFF none repeat scroll 0 0", opacity: 0.6 }, { id: "oxmainBG" }, null, doc);
    pURL = AjaxRoot + "/file?action=new&module=mail&type=image&session=" + corewindow.session;
    nd2 = newnode("div", { position: "absolute", zIndex: 3, top: 0, left: 0, width: "100%", height: "100%" }, { id: "oxmain" }, null, doc);

    // uploading an image when adding a link doesn't make sense.
    // Unfortunately there's no way to prevent the upload button so
    // have to show a feature not available dialog.
    if (field_name === "href") {
        nd3 = newnode("div", { width: "90%", position: "absolute", zIndex: "99", top: "85px", left: "12px", padding: "5px", textAlign: "center", border: "1px solid gray", backgroundColor: "white", id: "oxmainContent" }, null, null, doc);
        nd4 = newnode("input", { marginTop: "5px" }, { type: "button", name: _("OK"), value: _("OK") }, null, doc);
        addDOMEvent(nd4, "click", function () {
            jQuery(nd1).remove();
            jQuery(nd2).remove();
        }, win);
        nd3.appendChild(addTranslated(_("Feature not available!")));
        nd3.appendChild(newnode("br"));
        nd3.appendChild(nd4);
        nd2.appendChild(nd3);
    } else {
        // processing with the OX specific upload dialog
        var nd_form;
        if (IE < 9) {
            nd_form = doc.createElement('<form action="' + pURL + '" method="POST" enctype="multipart/form-data" target="hiddenNMFrame" name="mailUploadImage" id="mailUploadImage">');
        } else {
            nd_form = newnode("form", null, { enctype: "multipart/form-data", method: "post", action: pURL, acceptCharset: "UTF-8", target: "hiddenNMFrame", id: "mailUploadImage", name: "mailUploadImage" }, null, doc);
        }

        nd3 = newnode("div", { width: "90%", position: "absolute", zIndex: "99", top: "85px", left: "12px", padding: "5px", textAlign: "right", border: "1px solid gray", backgroundColor: "white", id: "oxmainContent" }, null, null, doc);
        nd3.appendChild(newnode("div", { width: "90%", textAlign: "left" }, null, [doc.createTextNode(_("Select a File:"))], doc));
        nd3.appendChild(newnode("input", { border: "solid 1px gray", width: "100%" }, { type: "file", size: "30", name: "file", id: "file" }, null, doc));

        nd4 = newnode("input", { marginTop: "5px" }, { type: "button", name: _("OK"), value: _("OK") }, null, doc);
        addDOMEvent(nd4, "click", function () { win.sendOXFile(); }, win);
        nd3.appendChild(nd4);

        nd5 = newnode("input", { margin: "5px 0px 0px 5px" }, { type: "button", name: _("Cancel"), value: _("Cancel") }, null, doc);
        addDOMEvent(nd5, "click", function () { win.disableOXBG(); }, win);
        nd3.appendChild(nd5);

        nd_form.appendChild(nd3);
        nd2.appendChild(nd_form);
    }
    doc.body.appendChild(nd1);
    doc.body.appendChild(nd2);

    doc.body.appendChild(newnode("script", null, { language: "javascript", type: "text/javascript", src: URL + "mailFileBrowser.js" }, null, doc));
    doc.body.appendChild(newnode("iframe", { display: "none" }, { scrolling: "no", frameBorder: "0", src: URL + "newInfoItemHidden.html", name: "hiddenNMFrame", id: "hiddenNMFrame"}, null, doc));

    /* *** Ugly workaround for IE Only *** */
    if (win.frames.hiddenNMFrame.name !== "hiddenNMFrame") {
        win.frames.hiddenNMFrame.name = "hiddenNMFrame";
    }

    var ielem = win.document.getElementById("insert");
    if (ielem) {
        ielem.onmousedown = function () {
            if (win.oxFile) {
                addImg2Poll(win.oxFile);
            }
        };
    }

    return false;
}

addImg2Poll = function (id) {
    var timeout = configGetKey("maxUploadIdleTimeout") ? configGetKey("maxUploadIdleTimeout") : 200000;
    timeout = Math.round(timeout * 0.9);
    var iv = window.setInterval(function () {
        (new JSONX()).get(AjaxRoot + "/file?action=keepalive&session=" + corewindow.session + "&id=" + id,
            null, function (cb) { }, function (cb) { return true; });
    }, timeout);
    intervals.push(iv);
    timeout = iv = null;
};

/*
 * Initialize TinyMCE
 */

/**
 * callback when tinyMCE get initialized
 */
function cb_initTiny() {
    /*
     * setting tabindex on the editor iframe content
     */
    if ($ALL(tinyMCE.activeEditor.id + "_ifr")) {
        $ALL(tinyMCE.activeEditor.id + "_ifr").setAttribute("tabIndex", "5");
    }
    /*
     * hide the editor toolbar if it has been disabled
     */
    if (!options.toolbar) {
        var tdContent = $ALL("editor_content_tbl").getElementsByTagName("td");
        tdContent[0].style.display = "none";
        tdContent[1].className = "tiny_mceFirst";
    }
    
    loadTinyMCE.def.resolve();
}

/*
 * initialize tinyMCE editor
 */

var tinyMCELanguage = "en"; // fallback
var tinyMCEInit = function () {

    // default tiny settings
    var tinySettings = {
        mode: "none",
        theme: "advanced",
        language: tinyMCELanguage,
        plugins: "inlinepopups,table,paste,lists"
            + (Boolean(ox.api.config.get("modules.mail.spellcheck")) ? ",spellchecker" : ""),
        content_css: getURL() + "newmail.css",
        theme_advanced_toolbar_location: "top",
        theme_advanced_toolbar_align: "left",
        theme_advanced_statusbar_location: "none",
        theme_advanced_resize_horizontal: false,
        extended_valid_elements:
            "a[name|href|target|title|onclick]," +
            "img[id|class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name]," +
            "hr[class|width|size|noshade]," +
            "span[class|align|style]," +
            "blockquote[type|style],style[type]",
        forced_root_block: 'div',
        formats: {
            blockquote: {
                block: "blockquote",
                wrapper: 1,
                remove: "all",
                attributes: { type: "cite" },
                styles: {
                    "margin-left": "0px",
                    "padding-left": "10px",
                    // The border style is split because each style must match
                    // exactly with the style extracted from DOM nodes and
                    // browsers may change the order in a shorthand style.
                    "border-left-style": "solid",
                    "border-left-width": "1px",
                    "border-left-color": "blue"
                }
            }
        },
        gecko_spellcheck: true,
        button_tile_map: true,
        entity_encoding: "numeric", // lately changed from "raw" to "numeric"
        relative_urls: false,
        convert_urls: false,
        init_instance_callback : "cb_initTiny",
        file_browser_callback : "cb_mailFileBrowser",
        font_size_style_values : "8pt,10pt,12pt,14pt,18pt,24pt,36pt",
        width: "100%",
        height: "100%",
        setup: function (ed) {
            // key: enter
            ed.onKeyDown.add(function (ed, e) {
                // wrote something
                setBeforeUnload(true);
                // pressed enter?
                if ((e.keyCode || e.which) === 13) splitContent(ed, e);
            });
            // click into editor to take care about context menus
            ed.onClick.add(function(ed, e) {
                if (globalContextMenus && globalContextMenus.simpleAttachments) {
                    globalContextMenus.simpleAttachments.hide();
                }
            });
        }
    };
    // start with empty controls
    tinySettings.theme_advanced_buttons3 = "";
    tinySettings.theme_advanced_buttons2 = "";
    tinySettings.theme_advanced_buttons1 = "";
    // set controls depending on the choosen feature set
    switch (String(configGetKey("gui.mail.editor_featureset"))) {
        case "2":
            // default
            tinySettings.theme_advanced_buttons3 = "tablecontrols,|,sub,sup,|,print|,ltr,rtl";
            tinySettings.plugins += ",directionality";
        case "1":
            // enhanced
            tinySettings.theme_advanced_buttons2 =
                (ox.browser.WebKit || ox.browser.Gecko ? '' : 'cut,copy,paste,pastetext,') +
                "pasteword,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,image,link,unlink,|,hr,|,charmap,|,blockquote" +
                (Boolean(ox.api.config.get("modules.mail.spellcheck")) ? ",|,spellchecker" : "");
        case "3":
            // minimized
            tinySettings.theme_advanced_buttons1 = "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,formatselect,fontselect,fontsizeselect,|,forecolor,backcolor";
            break;
    }
    // init tiny
    tinyMCE.init(tinySettings);
    tinyMCE.execCommand("mceAddControl", true, "editor_content");
};

function loadTinyMCE() {
    if (loadTinyMCE.def) {
        tinyMCE.execCommand("mceAddControl", true, "editor_content");
        return loadTinyMCE.def.promise();
    }
    loadTinyMCE.def = jQuery.Deferred();
    if (corewindow && configGetKey("language")) {
        var tmp = configGetKey("language").toLowerCase().split("_");
        // using two letter iso lang code only is evil :(
        if (configGetKey("language") == "zh_CN") {
            tinyMCELanguage = tmp[0] + "-" + tmp[1];
        } else {
            tinyMCELanguage = tmp[0];
        }
    }
    
    if (/^(de|en|fr)$/.test(tinyMCELanguage) === false) {
        // check that language pack exists
        jQuery.ajax({
            url: urlify("3rdparty/tinymce/jscripts/tiny_mce/langs/" +
                        tinyMCELanguage + ".js"),
            success: function () {
                tinyMCEInit();
            },
            error: function () {
                tinyMCELanguage = "en";
                tinyMCEInit();
            }
        });
    } else {
        tinyMCEInit();
    }
    return loadTinyMCE.def.promise();
}
/*
 * Register events
 */

register("Loaded", newMailOnload);
register("OX_Cancel_Object", askToClose);
register("setSignature", setSignatureText);

// The attachment remove callback
register("OX_Object_Attachment_Delete", function () {
    // loop over selection
    var i = 0, list = oMailFunctionsNew.attachObj, removed = false;
    while (i < list.length) {
        if (list[i].selected) {
            oMailFunctionsNew.removeAttachment(list[i].id);
            removed = true;
        } else {
            i++;
        }
    }
    if (removed) {
        triggerEvent("SubSelected", []);
    }
});

register("OX_SAVE_OBJECT", function () {
    oMailFunctionsNew.sendMessage();
});

register("OX_Save_Template_Object", function (callback, silent) {
    action = "draft";
    oMailFunctionsNew.saveMessageAsDraft(callback, silent);
});

register("OX_New_Mail_Toggle_Additional_Header", function (id) {
    // toggle state
    options[id] = !options[id];
    // update config
    configSetKey("gui.mail.newmail_options", options);
    // apply
    oMailFunctionsNew.showAdditionalHeaderField(id, options[id]);
});

function showEditorToolbar(state) {
    // apply flag
    jQuery("#editor_content_tbl").find("td").eq(0)
        .css("display", state ? "" : "none");
    // resize
    var id = "newMailAttachmentDiv";
    resizeSplit(id, jQuery("#" + id).height() + "px");
}

register("OX_New_Mail_Toggle_Toolbar", function () {
    // toggle state
    options.toolbar = !options.toolbar;
    ox.api.config.set("gui.mail.newmail_options.toolbar", options.toolbar);
    showEditorToolbar(options.toolbar);
});

register("OX_New_Mail_Set_Format", setMessageFormat);

function setMessageFormat(format) {
    messageFormat = format;
    var content, toHTML = format.toUpperCase() !== "TEXT/PLAIN";
    if (toHTML != editorEnabled) content = oMailFunctionsNew.getEditorContent();
    if (toHTML) {
        jQuery('#editor_content').off('change', onChange);
        return loadTinyMCE().pipe(function() {
            if (!editorEnabled) return convertContent(content);
        }).done(function() {
            showEditorToolbar(options.toolbar);
            ox.widgets.toolBar.menuItems["mail_new-editorToolbar"].show();
        });
    } else {
        return jQuery.when().pipe(function() {
            if (editorEnabled) {
                tinyMCE.execCommand('mceRemoveControl', true,
                                    'editor_content');
                return convertContent(content);
            }
        }).done(function() {
            ox.widgets.toolBar.menuItems["mail_new-editorToolbar"].hide();
            jQuery('#editor_content').on('change', onChange);
        });
    }
}

function convertContent(content) {
    setModalBusy(true);
    editorEnabled = !editorEnabled;
    var boundary = uuid();
    return jQuery.ajax({
        type: "POST",
        url: AjaxRoot + "/mail?action=new&session=" + session,
        contentType: "multipart/form-data; boundary=" + boundary,
        data: '--' + boundary +
              '\r\nContent-Disposition: form-data; name="json_0"\r\n\r\n' +
              JSONX.serialize({
                  sendtype: 4,
                  flags: 4,
                  from: configGetKey("modules.mail.defaultaddress"),
                  attachments: [{
                      content_type: editorEnabled ? "text/plain" : "text/html",
                      content: content
                  }]
              }) + '\r\n--' + boundary + '--'
    }).pipe(function(response) {
        var data = Function("return " + response.match(/\((\{.*\})\)/)[1])();
        if (data.error) {
            triggerEvent("OX_New_Error", 4, formatError(data));
            return jQuery.Deferred().reject(data).promise();
        }
        var index = data.data.lastIndexOf('/');
        var def = jQuery.Deferred();
        ox.api.http.GET({
            module: "mail",
            params: {
                action: "get",
                folder: data.data.slice(0, index),
                id: data.data.slice(index + 1),
                edit: 1,
                view: editorEnabled ? "html" : "text"
            },
            success: function(data) { def.resolve(data); }
        });
        return def.promise();
    }).done(function(mail) {
        ox.api.http.PUT({
            module: "mail",
            params: { action: "delete", harddelete: 1 },
            data: [{ folder: mail.folder_id, id: mail.id }]
        });
        var a = action;
        action="draft";
        setMessageText(mail.attachments);
        action = a;
        setModalBusy(false);
    });
}

/*
 * init window controller
 */
ctrl = windowController = new WindowController();

ctrl.set("beforeunload", function () {
    if (ums && !isIE()) {
        // ask
        return String(_("Do you really want to discard your changes and close the window?"));
    }
});

ctrl.set("confirm", askToClose);
