/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

var limg = new Image();
limg.src = "themes/default/img/ox_animated_withoutbg.gif";
var match = /(\w+)([-_](\w+))?/.exec(navigator.language || navigator.userLanguage);
var lang = "en_US";
if (match) {
	if (match[2]) {
		lang = match[1].toLowerCase() + "_" + match[3].toUpperCase();
		if (!{"de_DE": true, "en_US": true, "fr_FR": true, "sk_SK": true, "zh_CN": true, "lv_LV": true, "pl_PL": true, "it_IT": true, "es_ES": true, "cs_CZ": true, "hu_HU": true, "nl_NL": true, "ja_JP": true}[lang]) {
			lang = {de: "de_DE", en: "en_US", fr: "fr_FR", sk: "sk_SK", zh: "zh_CN", lv: "lv_LV", pl: "pl_PL", it: "it_IT", es: "es_ES", cs: "cs_CZ", hu: "hu_HU", nl: "nl_NL", ja: "ja_JP"}[match[1].toLowerCase()] || "en_US";
		}
	} else {
		lang = {de: "de_DE", en: "en_US", fr: "fr_FR", sk: "sk_SK", zh: "zh_CN", lv: "lv_LV", pl: "pl_PL", it: "it_IT", es: "es_ES", cs: "cs_CZ", hu: "hu_HU", nl: "nl_NL", ja: "ja_JP"}[match[1].toLowerCase()] || "en_US";
	}
}
var i18n = { de_DE:[], en_US:[], fr_FR:[], sk_SK: [], zh_CN: [], lv_LV: [], pl_PL: [], it_IT: [], es_ES: [], cs_CZ: [], hu_HU: [], nl_NL: [], ja_JP: [] };
function addlTag(lcode, id, val) { i18n[lcode][id]=val; }
function getlTag(lcode, id) {
    var text = i18n[lcode] && i18n[lcode][id] ? i18n[lcode][id] : i18n["en_US"][id];
    if (id === "t1") {
        text += "<br><br>Firefox - <a href=\"http://www.firefox.com/\" target=\"_blank\">www.firefox.com</a><br>"
            + "Chrome - <a href=\"http://www.google.com/chrome/\" target=\"_blank\">www.google.com</a><br>"
            + "Internet Explorer - <a href=\"http://www.microsoft.com/ie/\" target=\"_blank\">www.microsoft.com</a><br>"
            + "Safari - <a href=\"http://www.apple.com/safari/\" target=\"_blank\">www.apple.com</a>";
    }
    return text; 
}

addlTag("fr_FR", "t1", "<b>Information :</b><br>Vous n'utilisez pas le meilleur navigateur web pour cette application. Pour utiliser sans heurts l'application et obtenir les meilleures performances possibles, nous recommandons d'utiliser la dernière version de l'un des navigateurs suivants :");
addlTag("en_US", "t1", "<b>Information:</b><br>You do not use the best browser for this application. For a smooth operation of the application and the best possible performance we recommend to use the latest version of one of the following browsers:");
addlTag("de_DE", "t1", "<b>Information:</b><br>Sie verwenden nicht den optimalen Browser f&uuml;r diese Applikation. F&uuml;r einen reibungslosen Einsatz der Applikation und zum Erzielen bestm&ouml;glicher Performance empfehlen wir den Einsatz der jeweils aktuellen Version folgender Browser:");
addlTag("sk_SK", "t1", "<b>Informácia:</b><br>Nepoužívate najvhodnejší prehliadač pre túto aplikáciu. Bezproblémový beh aplikácie a najlepší možný výkon dosiahnete použitím najnovšej verzie niektorého z týchto prehliadačov:");
addlTag("zh_CN", "t1", "<b>信息：</b><br>你正在使用的浏览器不是该应用的最佳浏览器。为了让该应用操作平滑并达到最优性能，我们推荐使用如下浏览器的最新版本:");
addlTag("lv_LV", "t1", "<b>Information:</b><br>Jūs pašreiz neizmantojat labāko tīmekļa pārlūkprogrammu šai aplikācijai. Lai nodrošinātu netraucētu aplikācijas darbību un augstu veiktspēju mēs iesakām izmantot kādu no sekojošu pārlūkprogrammu jaunķajām versijām:");
addlTag("pl_PL", "t1", "<b>Informacja:</b><br>Używana przeglądarka nie jest optymalna do danej aplikacji. Aby zapewnić płynną pracę aplikacji\ni jej najwyższą wydajność, użyj jednej z najnowszej wersji jednej z następujących przeglądarek:");
addlTag("it_IT", "t1", "<b>Informazioni:</b><br>Non utilizzi il browser più adatto a questa applicazione. Per un buon funzionamento dell'applicazione e per ottenere le prestazioni migliori, ti consigliamo di utilizzare\n l'ultima versione di uno dei browser seguenti:");
addlTag("es_ES", "t1", "<b>Información:</b><br>No está usando el mejor navegador para esta aplicación. Para un funcionamiento suave de la aplicación y el mejor rendimiento posible recomendamos usar la última versión de uno de los siguientes navegadores:");
addlTag("cs_CZ", "t1", "<b>Informace:</b><br>Nepoužíváte nejvhodnější prohlížeč pro tuto aplikaci. Pro hladký provoz aplikace a nejvyšší možný výkon doporučujeme poslední verzi jednoho z následujících prohlížečů:");
addlTag("hu_HU", "t1", "<b>Információ:</b><br>Nem a legmegfelelőbb böngészőt használja ehhez az alkalmazáshoz. Az alkalmazás megfelelő működéséhez és a lehető legjobb teljesítmény eléréséhez az alábbi böngészők legfrissebb verziójának használatát:");
addlTag("nl_NL", "t1", "<b>Informatie:</b><br>U heeft niet de meest optimale browser voor deze toepassing. Voor een vloeiende werking van de applicatie en de best mogelijke prestaties raden we de laatste versie van de volgende browsers aan:");
addlTag("ja_JP", "t1", "<b>情報 :</b><br>お使いのブラウザは、このアプリケーションを利用するのに最適ではありません。アプリケーションをスムーズに操作し、パフォーマンスを最大限に引き出すには、以下に示すいずれかのブラウザの最新バージョンをお使いになることをお勧めします。");
addlTag("en_US", "t5", "Loading Scripts and Content ... Please Wait ...");
addlTag("de_DE", "t5", "Skripte und Inhalt werden geladen... bitte warten...");
addlTag("fr_FR", "t5", "Chargement des scripts et du contenu en cours, veuillez patienter...");
addlTag("sk_SK", "t5", "Načítavajú sa skripty a obsah... Prosím, čakajte...");
addlTag("zh_CN", "t5", "正在载入脚本和内容 ... 请稍候 ...");
addlTag("pl_PL", "t5", "Trwa ładowanie skryptu i zawartości... proszę czekać");
addlTag("it_IT", "t5", "Caricamento script e contenuti... Attendere...");
addlTag("es_ES", "t5", "Cargando scripts y contenido ... Espere, por favor ...");
addlTag("cs_CZ", "t5", "Nahrávám skripty a obsah... Počkejte, prosím…");
addlTag("hu_HU", "t5", "Tartalom betöltése ... Kérem várjon ...");
addlTag("nl_NL", "t5", "Inlezen Scripts en Inhoud ... een ogenblik geduld alstublieft ...");
addlTag("ja_JP", "t5", "スクリプトとコンテンツをロードしています ... 少々お待ちください ...");
addlTag("en_US", "t6", "Don't show again");
addlTag("de_DE", "t6", "Nicht erneut anzeigen");
addlTag("fr_FR", "t6", "Ne plus afficher");
addlTag("sk_SK", "t6", "Už nezobrazovať");
addlTag("zh_CN", "t6", "不再显示");
addlTag("pl_PL", "t6", "Nie wyświetlaj ponownie");
addlTag("it_IT", "t6", "Non mostrare ancora");
addlTag("es_ES", "t6", "No mostrar otra vez");
addlTag("cs_CZ", "t6", "Znovu nezobrazovat");
addlTag("hu_HU", "t6", "Ne mutassa újra");
addlTag("nl_NL", "t6", "Dit scherm niet meer tonen");
addlTag("ja_JP", "t6", "次回は表示しない");
addlTag("en_US", "t8", "You have to enable cookies to use this application.");
addlTag("de_DE", "t8", "Die Verwendung dieser Applikation setzt das Aktivieren von Cookies voraus.");
addlTag("fr_FR", "t8", "Vous devez activer les cookies pour utiliser cette application.");
addlTag("sk_SK", "t8", "Aby ste mohli používať túto aplikáciu, musíte mať povolené cookies.");
addlTag("zh_CN", "t8", "您必须启用 cookie 才能使用此应用。");
addlTag("pl_PL", "t8", "Aby użyć tej aplikacji, musisz włączyć obsługę plików cookie.");
addlTag("it_IT", "t8", "Per utilizzare questa applicazione è necessario attivare i cookies.");
addlTag("es_ES", "t8", "Tiene que activar las cookies para usar esta aplicación");
addlTag("cs_CZ", "t8", "Abyste mohli používat tuto aplikaci, musíte povolit příjem cookies.");
addlTag("hu_HU", "t8", "Engedélyeznie kell a sütiket az alkalmazás használatához.");
addlTag("nl_NL", "t8", "U moet cookies accepteren om deze toepassing te gebruiken.");
addlTag("ja_JP", "t8", "このアプリケーションを使用するにはクッキーを有効にする必要があります。");

function testAJAX() {
	try {
		return new XMLHttpRequest();
	} catch (e) {
		try {
			return new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				return new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {
				return false;
			}
		}
	}
	return false;
}

function write(text, allow) {
	document.getElementById("browserchecktext_id").innerHTML=text;
	if (allow) {
		document.getElementById("browsercheck_okbutton").onkeydown=checkKey;
		document.getElementById("browsercheck_button").style.display="";
		document.getElementById("browser_dsagain_text").firstChild.data = getlTag(lang, "t6");
		document.getElementById("browser_dsagain").style.display="";
		document.getElementById("browser_dsagain").parentNode.style.height="2.6em";
	} else {
		document.getElementById("browser_dsagain").parentNode.style.height="1.6em";
		document.getElementById("browsercheck_button").style.display="none";
		document.getElementById("browser_dsagain").style.display="none";
	}
}

function checkKey(event) {
	if (event) {
        switch (event.keyCode || event.which) {
            case 32:
            case 13:
                redirect();
                break;
            default:
                return false;
        }
    }
}

function redirect() {
    var cb = function() {
        write("<img src=\"" + limg.src + "\" width=\"25\" height=\"25\" align=\"absmiddle\"> " + getlTag(lang, "t5"));
        window.setTimeout(function() {
            window.location = "ox.html" + window.location.search + window.location.hash; 
        }, 0);
    };
	try {
		if (ox.browser.cookieEnabled === true) {
		    if (document.getElementById("bcheck1").checked === true) { 
    	        var exp = new Date();
    	        exp.setTime(exp.getTime() + 700 * 24 * 60 * 60 * 1000);
    	        document.cookie="oxbwcheck=true; expires="+exp.toGMTString();
		    }
		    cb();
	    } else {
	        write(getlTag(lang, "t8"), false);
	    }
	} catch (e) { 
	    cb();
	} finally {
	    delete(cb);
	}
}

function check() {
 	if (navigator.appName == "Microsoft Internet Explorer") {
		var version = Number(navigator.appVersion.match(/MSIE (\d+\.\d+)/)[1]);
		if (version <= 7) {
            var xml = testAJAX();
            if (xml && version <= 6) {
                xml.open("GET", "ie6/js/check.js", false);
                xml.send(null);
                if (xml.status == 200) {
                    setTimeout(function() { window.location="ie6/"; }, 0);
                    return;
                }
            } 
            if (version >= 7 && document.cookie && document.cookie.match(/oxbwcheck=true/g)) {
                redirect();
            } else {
                write(getlTag(lang, "t1"), version >= 7);
            }
		} else redirect();
    } else if (document.cookie && document.cookie.match(/oxbwcheck=true/g)) {
        redirect();
	} else if (navigator.appName == "Netscape" && navigator.userAgent.indexOf("rv:") >= 0) {
		var version = Number(navigator.userAgent.match(/rv:(\d+\.\d+)/)[1]);
		if (version < 1.9) {
			var xml = testAJAX();
			if (xml) {
				xml.open("GET", "ie6/js/check.js", false);
				xml.send(null);
				if (xml.status == 200) {
					setTimeout(function() { window.location="ie6/"; }, 0);
					return;
				}
			}
		    write(getlTag(lang, "t1"), false);
		}
		else redirect();
	} else if (navigator.userAgent.indexOf("AppleWebKit") >= 0) {		
        var match = navigator.userAgent.match(/(?:Version|Chrome)\/(\d+\.\d+)/);
        if (match) {
            var version = Number(match[1]);
            if (version < 3.1)
                write(getlTag(lang, "t1"), true);
            else
                redirect();
        } else
            write(getlTag(lang, "t1"), true);
    } else if (!testAJAX()) {
		write(getlTag(lang, "t1"), false);
	} else {
		write(getlTag(lang, "t1"), true);
	}
}