/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
// TEST DATA
var nNumCharAppointmentView = 10;
var calendarJson = new JSONX();
//Global Vars
var monthViewCreated = false;
var calendarObjects;
var tmptimeOutSingle = null;
var aAppointmentAssoc = new Object();
var sAssocMonthArray = new Object();
var aSelectedAppArray = new Array();
var oMonthViewObj;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//GUI Actions

function showAllAppointmentsMonth(){
	if(!$("allAppointmentMonthView").checked){
		configSetKey("gui.calendar.allfolders",false);
		oMonthViewObj.refreshMonthView(false);
	} else {
		configSetKey("gui.calendar.allfolders",true);
		oMonthViewObj.refreshMonthView(true);
	}
}

function refreshMonthView(changeFolder) {
	if (changeFolder === true) {
		oMonthViewObj.refreshMonthView(calendar_getAllFoldersAttribute());
	}
}

function resizeWeekSections() {	
	var calendar = $("calmain");
	var numWeeks=oMonthViewObj.oCalendarTool.getNumWeeks();
	var workWeekHeight = 0;
	var weekEndHeight = 0;
	var height = (calendar.offsetHeight - pxPerEm)/numWeeks;
	for(var indx=0;indx<calendar.childNodes.length;indx++)
	{
		var oCurrentNode =calendar.childNodes[indx];
		for(var subIndx=0;subIndx<oCurrentNode.childNodes.length;subIndx++)
		{
			var oCurrentSubNode = oCurrentNode.childNodes[subIndx];
			if(oCurrentSubNode && oCurrentSubNode.tagName == "DIV" && height>0)
			{
				if((height)>0)
				{
					oCurrentSubNode.style.height = (height) + "px";	
					workWeekHeight = (height);
				}

				if(oCurrentSubNode.className.indexOf("weekendInMonthView") != -1)
				{
					for(var subSubIndx=0;subSubIndx<oCurrentSubNode.childNodes.length;subSubIndx++)
					{
						var oCurrentSubSubNode = oCurrentSubNode.childNodes[subSubIndx];
						if(oCurrentSubSubNode && oCurrentSubSubNode.tagName == "DIV")
						{
							if((height/2)>0)
							{
								oCurrentSubSubNode.style.height = (height/2) + "px";	
								weekEndHeight = (height/2);	
							}
						}
					}
				}				
			}				
		}
		var aSplittId = oCurrentNode.id ? oCurrentNode.id.split("_") : [];
		if(aSplittId[0] == "weekmonth" || true) {
			if((height)>0 && oCurrentNode.style)
				oCurrentNode.style.height = (height) + "px";
		}
	}
	oMonthViewObj.redrawAppointments(workWeekHeight,weekEndHeight);
}

function loadMonthView() {
	if (!oMonthViewObj) {
		oMonthViewObj = new monthView();
		oMonthViewObj.loadMonthView(calendar_getAllFoldersAttribute());
		//resizeEvents.register("Resized",resizeWeekSections);	
	} else {
		if (oMonthViewObj.oCalendarTool.nMonth == activeMonth &&
		    oMonthViewObj.oCalendarTool.nYear == activeYear) {
			function fn() {
				oMonthViewObj.refreshMonthView(calendar_getAllFoldersAttribute());
			}
			oMonthViewObj.getStorage(fn);
		} else {
			goToActiveMonth();
		}
	}
}

function goToActiveMonth() {
	if (monthViewCreated) {
		aSelectedAppArray = new Array();
		var oDateLoc = new Date();
		oDateLoc.setFullYear(activeYear);
		oDateLoc.setDate(1);	
		oDateLoc.setMonth(activeMonth); 		
		oMonthViewObj.oCalendarTool = new calendarTool(activeMonth, activeYear);	
		oMonthViewObj.updateMonthView();
	}
}

function goToNextMonth(nDirection) {
	if (monthViewCreated) {
		aSelectedAppArray = new Array();
		var oDateLoc = new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0)); 
		oDateLoc.setUTCDate(1);   
        oDateLoc.setUTCMonth(oDateLoc.getUTCMonth()+(nDirection));
        activeMonth = oDateLoc.getUTCMonth();
        activeYear = oDateLoc.getUTCFullYear();
        activeDay = oDateLoc.getUTCDate();
        triggerEvent("Date_Changed", activeYear, activeMonth, activeDay);
		if (oMiniCalendar) oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
		oMonthViewObj.oCalendarTool = new calendarTool(activeMonth, activeYear);	
		oMonthViewObj.updateMonthView();
	}
}

function monthAction(evt) {	
	var sId = '';
	var DOMTarget = (evt.target)?evt.target:evt.srcElement;	
	if (DOMTarget.id.substr(0,4) == 'but_') {
		if(evt.type == "click") {
			sId = DOMTarget.id.substr(4) + '_num';
			if (tmptimeOutSingle != null) {
				clearTimeout(tmptimeOutSingle);
				tmptimeOutSingle = null;
				stopEvent(evt);	
				return;
			}
			tmptimeOutSingle = setTimeout(function (){
				        var oDate = new Date();
						oDate.setDate(1);		
						oDate.setFullYear(sAssocMonthArray[sId].year);				
						oDate.setMonth(sAssocMonthArray[sId].month);				
						oDate.setDate(sAssocMonthArray[sId].day.nDate);		
						if (sAssocMonthArray[sId].day.nCurrMonth == 0)
							oDate.setMonth(oDate.getMonth()-1);
						else if (sAssocMonthArray[sId].day.nCurrMonth == 2)			
							oDate.setMonth(oDate.getMonth()+1);
						activeDay = oDate.getDate();
						activeMonth = oDate.getMonth();
						activeYear = oDate.getFullYear();				
						triggerEvent("OX_Switch_View","calendar/calendar/day");
						tmptimeOutSingle = null;				
					}, 300);
			stopEvent(evt);		
			return;
		}
	} else {
		sId = DOMTarget.id;
	}

	if (sId.substr(0,1) == 'd' && sId.split('_')[3] == 'num') {		
		if (evt.type == "dblclick") {
			if (tmptimeOutSingle != null) {
				clearTimeout(tmptimeOutSingle);			
			}
			if (sId.substr(0,1) == 'd' && sId.split('_')[3] == 'num') {
				var oDate = new Date();
				oDate.setUTCDate(1);		
				oDate.setUTCFullYear(sAssocMonthArray[sId].year);				
				oDate.setUTCMonth(sAssocMonthArray[sId].month);					
				if (sAssocMonthArray[sId].day.nCurrMonth == 0) {
					oDate.setUTCMonth(oDate.getUTCMonth()-1);
				} else if(sAssocMonthArray[sId].day.nCurrMonth == 2) {											
					oDate.setUTCMonth(oDate.getUTCMonth()+1);
				}
				oDate.setUTCDate(sAssocMonthArray[sId].day.nDate);						
				activeDay = oDate.getUTCDate();
				activeMonth = oDate.getUTCMonth();
				activeYear = oDate.getUTCFullYear();		
				calendar_activedate=new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0));
				calendar_wholeday=true;		
				triggerEvent('OX_Before_Create_Calendar');
				stopEvent(evt);		
			}				
		}
		
	} else if (sId.substr(0,1) == 'd' && sId.split('_')[4] != 'app' && 
	           sId.split('_')[3] != 'title' && sId.split('_')[3] != 'headcontainer') {
		sId = DOMTarget.id+'_num';
		var oDate = new Date();
		oDate.setUTCDate(1);		
		oDate.setUTCFullYear(sAssocMonthArray[sId].year);				
		oDate.setUTCMonth(sAssocMonthArray[sId].month);				
		if (sAssocMonthArray[sId].day.nCurrMonth == 0)
			oDate.setUTCMonth(oDate.getUTCMonth()-1);
		else if (sAssocMonthArray[sId].day.nCurrMonth == 2)			
			oDate.setUTCMonth(oDate.getUTCMonth()+1);
		oDate.setUTCDate(sAssocMonthArray[sId].day.nDate);					
		activeDay = oDate.getUTCDate();
		activeMonth = oDate.getUTCMonth();
		activeYear = oDate.getUTCFullYear();
		var startTime = configGetKey("gui.calendar.starttime") || 8;
		calendar_activedate=new Date(Date.UTC(activeYear,activeMonth,activeDay,startTime,0,0));
		calendar_wholeday=false;		
		triggerEvent('OX_Before_Create_Calendar');
		stopEvent(evt);
		
	} else if (sId.substr(0,1) == 'd' && sId.split('_')[4] != 'app' && 
	           sId.split('_')[3] == 'title' && sId.split('_')[3] != 'headcontainer') {
		var sFakeId = sId.split('_')[0]+'_'+sId.split('_')[1] + '_' + sId.split('_')[2] + '_num';
		var oDate = new Date();
		oDate.setDate(1);		
		oDate.setFullYear(sAssocMonthArray[sFakeId].year);				
		oDate.setMonth(sAssocMonthArray[sFakeId].month);				
		oDate.setDate(sAssocMonthArray[sFakeId].day.nDate);		
		if (sAssocMonthArray[sFakeId].day.nCurrMonth == 0)
			oDate.setMonth(oDate.getMonth()-1);
		else if (sAssocMonthArray[sFakeId].day.nCurrMonth == 2)			
			oDate.setMonth(oDate.getMonth()+1);
		activeDay = oDate.getDate();
		activeMonth = oDate.getMonth();
		activeYear = oDate.getFullYear();		
	    var startTime = configGetKey("gui.calendar.starttime") || 8;
		calendar_activedate = new Date(Date.UTC(activeYear,activeMonth,activeDay,startTime,0,0));
		calendar_wholeday = false;		
		triggerEvent('OX_Before_Create_Calendar');
		stopEvent(evt);
	}
	
	stopEvent(evt);		
}

function selectDayInMonthView(evt) {
	var DOMTarget = (evt.target) ? evt.target : evt.srcElement;    
	var sDOMId = DOMTarget.id || DOMTarget.parentNode.id || null;
	if (sDOMId == null) return;
	var sId = sDOMId.match(/^[a-z]_[0-9]_[0-9]/)[0] + "_num";
	for (var i in sAssocMonthArray) {
	    if (sAssocMonthArray[i].active && sAssocMonthArray[i].active == true) {
	        sAssocMonthArray[i].active=false;
	        $2(i.substr(0,5)+"_headcontainer").className="headerContStyle";
	    } 
	}
	sAssocMonthArray[sId].active=true;
	$2((sDOMId.match(/^[a-z]_[0-9]_[0-9]/)[0]) + "_headcontainer").className = 
	       "headerContStyle background-color-PMG-selection-elements";

	var oDate = new Date();
	oDate.setUTCDate(1);        
	oDate.setUTCFullYear(sAssocMonthArray[sId].year);               
	oDate.setUTCMonth(sAssocMonthArray[sId].month);             
	if (sAssocMonthArray[sId].day.nCurrMonth == 0)
	    oDate.setUTCMonth(oDate.getUTCMonth()-1);
	else if (sAssocMonthArray[sId].day.nCurrMonth == 2)          
	    oDate.setUTCMonth(oDate.getUTCMonth()+1);
	oDate.setUTCDate(sAssocMonthArray[sId].day.nDate);                  
	activeDay = oDate.getUTCDate();
	activeMonth = oDate.getUTCMonth();
	activeYear = oDate.getUTCFullYear();
	var startTime = configGetKey("gui.calendar.starttime") || 8;
	calendar_activedate=new Date(Date.UTC(activeYear,activeMonth,activeDay,startTime,0,0));
	calendar_wholeday=false;
	
	if (!sDOMId.match(/_app$/gi)) {
        if (calendarSelection.count != 0) calendarSelection.reset();
        deselectAppointments();
        triggerEvent("Selected",aSelectedAppArray);
	}
	//stopEvent(evt);
}

function monthView() {
	this.dateIdAssoc = new Object();
	this.aAppointmentAssoc = new Object();
	this.calendarwfields = new Array(200, 201, 202, 203, 209, 221, 401, 402, 102, 400, 100, 101);
	this.oCalendarTool = new calendarTool(activeMonth, activeYear);
	this.oCalendar;
	this.storage = null;	
	this.timestamp = null;
	this.show_all = false;
	this.today = new Date();
	this.calendar_start = null;
	this.calendar_end = null;	
	this.redraw = function (){};
	this.show_we = 1;
	this.show_ww = 2;
	// month headline
	this.headline = new I18nNode(function() {
        return formatDateTime("MMMM yyyy", new Date(Date.UTC(activeYear,activeMonth,activeDay,0,0,0)));
    });
	if (!$("monthviewheader").firstChild) {
	    $("monthviewheader").appendChild(this.headline.node);
	}
}

function moveAppToNewStart(objc, startTimeParam, endTimeParam, fn_opt) {
	if (objc["full_time"])
		editAppointment(objc,{start_date:startTimeParam.getTime(),end_date:endTimeParam.getTime(),full_time:true},fn_opt);
	else
		editAppointment(objc,{start_date:startTimeParam.getTime(),end_date:endTimeParam.getTime()},fn_opt);
}

monthView.prototype = {
	updateHeader: function() {
	    this.headline.update();
	},
	
	loadMonthView: function(bAll) {
		this.show_all = bAll;
		if(calendar_getAllFoldersAttribute()){
			$("allAppointmentMonthView").checked = true;
		}
		else
			$("allAppointmentMonthView").checked = false;
		this.createMonthView(activeMonth, activeYear);
	},
	
	updateMonthView:function() {
	    //Old, use refresh function
		calendarObjects = new Array();
		this.dateIdAssoc = new Object();
		this.aAppointmentAssoc = aAppointmentAssoc= new Object();
		sAssocMonthArray = new Object();
		var calendar = $("calmain");
		while (calendar.childNodes.length>0) {
			calendar.removeChild(calendar.firstChild);
		}
		monthViewCreated = false;
		this.createMonthView(activeMonth, activeYear);
	},
	
	createMonthView: function(nMonth, nYear) {
		var Self = this;
		if (!monthViewCreated) {
			for(var i=0;$2("kwnumber_"+i);i++) {
				removeTMPId("kwnumber_"+i);
			}	
			for(var i=0;$2("weekmonth_"+i);i++) {
				removeTMPId("weekmonth_"+i);
			}	
			for(var i=0;$2("d_"+i+"_0");i++) {
				for(var i2=0;$2("d_"+i+"_"+i2);i2++) {
					removeTMPId("d_"+i+"_"+i2);
				}
			}	
			this.updateHeader();
			var numWeeks=this.oCalendarTool.getNumWeeks(); 
			var weektmpl = $("weekmonth_tmpl");
			var calendar = $("calmain");
			var sIdPrefix = weektmpl.id.split('_');
	//		var height = (98 / numWeeks) + "%";
			addDOMEvent(calendar, "selectstart", function(evt) { cancelBubbling(evt); });
			addDOMEvent(calendar, "drag" , function(evt) { cancelBubbling(evt); });
			var height = -1;
			if(calendar.offsetHeight != undefined && calendar.offsetHeight>0)
				height = (((calendar.offsetHeight - pxPerEm) / numWeeks));		
				
			function drawpreviewDragandDrop(evt,type,object) {	
                stopEvent(evt);
				var subObject = object;
				if(object && object.currentObjects && object.currentObjects.length>0) {
						subObject = object.currentObjects[0]; 
				}
				if(!$2("dnd_div_")) {
					var iconNode = Self.getAppointmentDiv(subObject);			
					iconNode.id = "dnd_div_";
					iconNode.style.left = (evt.clientX + iconOffset) + "px";	
					iconNode.style.top = (evt.clientY + iconOffset)+ "px";	
					body.appendChild(iconNode);
					iconNode.style.width = "120px";
					iconNode.style.position = "absolute";							
					addTMPId(iconNode);
				} else {
					var iconNode = $2("dnd_div_");
					iconNode.style.left = (evt.clientX + iconOffset) + "px";
					iconNode.style.top = (evt.clientY + iconOffset)+ "px";	
				}
				var DOMTarget = (evt.target)?evt.target:evt.srcElement;
				var sId = DOMTarget.id;
				if(!sId) return false;
				if(sId.split('_')[3] != 'num' && sId.split('_')[3] != 'title' 
						&& sId.split('_')[4] != 'app'
								 && sId.split('_')[3] != 'headcontainer')			
					DOMTarget.className += " dndSelectionCalendarBG";
				DOMTarget.style.cursor = "move";
				return false;							
			}
			function removeDDPreviewDivs(evt,type,object) {
				if($2("dnd_div_")) {
					body.removeChild($2("dnd_div_"));
					removeTMPId($2("dnd_div_"));
				}
				var DOMTarget = (evt.currentTarget)?evt.currentTarget:evt.srcElement;
				var DOMTarget2 = (evt.target)?evt.target:evt.srcElement;
				DOMTarget2.style.cursor = "default";
				var sId = DOMTarget.id;
				DOMTarget.className = removeClass(DOMTarget.className,"dndSelectionCalendarBG");
			}					
	
			function dropCallBack(evt, dragType, object, mousepos, targetNode) {
				var subObject = object;
				if (object && object.currentObjects && object.currentObjects.length>0) {
				    subObject = object.currentObjects[0]; 
				}
				var DOMTarget = targetNode;
				var DOMTarget2 = (evt.target) ? evt.target : evt.srcElement;
				DOMTarget2.style.cursor = "default";			
				var sId = DOMTarget.id;	
				
				if (!sId || !sAssocMonthArray[sId+'_num']) {
					return;
				}
				var assoc = sAssocMonthArray[sId + '_num'];
				var month = assoc.month;
				
				if (assoc.day.nCurrMonth == 0) {
					month--;
				} else if(assoc.day.nCurrMonth == 2) {
					month++;
				}
				
				var oDate = new Date(Date.UTC(assoc.year, month, assoc.day.nDate, 0, 0, 0));
				
				// getting super object holding the real app data
				var oDateEnd = new Date(oDate.getTime());
				for (var i in oMonthViewObj.aMonthBtAppointments) {
				    var obj = oMonthViewObj.aMonthBtAppointments[i];
				    if (obj.id === subObject.id) {
				        oDate.setUTCHours(new Date(obj.start_date).getUTCHours());
		                oDate.setUTCMinutes(new Date(obj.start_date).getUTCMinutes());
		                oDateEnd=new Date(oDate.getTime() + (obj.end_date - obj.start_date));
				        break;
				    }
				}
				
				moveAppToNewStart(subObject, oDate, oDateEnd);
				DOMTarget.className = removeClass(DOMTarget.className, "dndSelectionCalendarBG");
				if ($2("dnd_div_") != undefined) {
					body.removeChild($2("dnd_div_"));
					removeTMPId($2("dnd_div_"));
				}
			}
			for (ind=0; ind<numWeeks; ind++) {
				//clone
				var nextWeekNumber = ind;
				obj = weektmpl.cloneNode(true);
				obj.style.display = "block";
				if (height > 0) obj.style.height = height + "px";
				obj.id = sIdPrefix[0]+'_'+nextWeekNumber;
				addTMPId(obj);	
				//change Ids here		
				for (numNode=0; numNode<obj.childNodes.length; numNode++) {
					if (obj.childNodes[numNode].id == "kwnumber_0") {
						newId = 'kwnumber_'+ nextWeekNumber;
						obj.childNodes[numNode].id = newId;
						addTMPId(obj.childNodes[numNode]);	
					} else if (obj.childNodes[numNode].id && obj.childNodes[numNode].id.substr(0,1) == "d") {
						var id = 'd_'+nextWeekNumber+'_'+obj.childNodes[numNode].id.substr(4,1);					
						//set new id d_(currentWeek)_(currentDay)
						obj.childNodes[numNode].id = id;
						addTMPId(obj.childNodes[numNode]);
																	
						addDOMEvent(obj.childNodes[numNode], "click", selectDayInMonthView);
						addDOMEvent(obj.childNodes[numNode], "dblclick", monthAction);
						
						registerTarget(obj.childNodes[numNode],{calendar:dropCallBack},null,null,
							drawpreviewDragandDrop,	//drawpreviewDragandDrop
							drawpreviewDragandDrop,	//drawreviewDragandDrop
							removeDDPreviewDivs );//removeDDPreviewDivs

					} else {						
						for (numSubNode=0; numSubNode<obj.childNodes[numNode].childNodes.length; numSubNode++)	{
							if (obj.childNodes[numNode].childNodes[numSubNode].id && 
							    obj.childNodes[numNode].childNodes[numSubNode].id.substr(0,1)=="d") {
								//set new id d_(currentWeek)_(currentDay)
								addDOMEvent(obj.childNodes[numNode].childNodes[numSubNode], "click", selectDayInMonthView);
								addDOMEvent(obj.childNodes[numNode].childNodes[numSubNode],'dblclick',monthAction);
								obj.childNodes[numNode].childNodes[numSubNode].id 
										= 'd_'+nextWeekNumber+'_'+obj.childNodes[numNode].childNodes[numSubNode].id.substr(4,1);
								addTMPId(obj.childNodes[numNode].childNodes[numSubNode]);																	
								registerTarget(obj.childNodes[numNode].childNodes[numSubNode],
									{ calendar:dropCallBack },null,null,
										drawpreviewDragandDrop,	//drawpreviewDragandDrop
										drawpreviewDragandDrop,	//drawreviewDragandDrop
										removeDDPreviewDivs 
								);
							}
							else if(obj.childNodes[numNode].childNodes[numSubNode].id 
										&& obj.childNodes[numNode].childNodes[numSubNode].id.substr(0,2)=="wd")							
							{
								for(weindex=0;weindex<obj.childNodes[numNode].childNodes[numSubNode].childNodes.length;weindex++)
								{
									if(obj.childNodes[numNode].childNodes[numSubNode].childNodes[weindex].id 
										&& obj.childNodes[numNode].childNodes[numSubNode].childNodes[weindex].id.substr(0,1)=="d")				
										{			
												//set new id d_(currentWeek)_(currentDay)
												addDOMEvent(obj.childNodes[numNode].childNodes[numSubNode],'dblclick',monthAction);
												obj.childNodes[numNode].childNodes[numSubNode].childNodes[weindex].id 
																	= 'd_'+nextWeekNumber+'_'+obj.childNodes[numNode].childNodes[numSubNode].childNodes[weindex].id.substr(4,1);
												addTMPId(obj.childNodes[numNode].childNodes[numSubNode]);																	
												 																
										}
								}
							}
							else if(obj.childNodes[numNode].childNodes[numSubNode].id 
										&& obj.childNodes[numNode].childNodes[numSubNode].id=="kwnumber_0")								
							{
								newId = 'kwnumber_'+ nextWeekNumber;
								obj.childNodes[numNode].id = newId;
								addTMPId(obj.childNodes[numNode]);																	
							}
						}
					}				
				}			
				calendar.appendChild(obj);			
			}				
			this.initMonthView();		
		}	
	},
	
	attachAppointments:function (index,	calendarObjects) {
		/////////////////////////////////////////////////////////////////////////////////////////////////
		//	aAppointments = this.getAppointments(currentDay.nDate,oCalendarTool.nMonth,
		//															currentDay.nCurrMonth,aAllAppointments);
	
		var id = calendarObjects.id;
		var folder_id = calendarObjects.folder;
		var selectedAppointmentWeek={id : id, folder : folder_id};
		var divAppId = 'appInWeekView' + folder_id + "_" + id;

		var title = calendarObjects.title;
		var start_date = calendarObjects.start_date;
		var end_date = calendarObjects.end_date;	
		var full_time = calendarObjects.full_time;
		
		// Setze Startzeit des Termins um , falls er vor der Anzeige beginnt
		if (start_date < this.calendar_start.getTime()) {
			start_date=this.calendar_start.getTime();
		}
		
		// Setze Endzeit des Termins um , falls er nach der Anzeige endet
		if (end_date > this.calendar_end.getTime()) {
			end_date = this.calendar_end.getTime();		
		}
	
		var startDate = new Date(start_date);	
		var endDate = new Date(end_date);	
		
		var MULTstartDate = new Date(start_date);	
		MULTstartDate.setUTCHours(0);
		
		var MULTendDate = new Date(end_date);		
		MULTendDate.setUTCHours(0);
	
		//Create multiday appointments here
		var nDaysMultiDay = Math.round((((MULTendDate.getTime() - MULTstartDate.getTime()))  / 1000 / 60 / 60 / 24));
		if (nDaysMultiDay > 0) {
			if(endDate.getUTCHours() == 0 &&
					endDate.getUTCMinutes() == 0 &&
								endDate.getUTCMilliseconds() == 0) {
				nDaysMultiDay--;
			}	
			var oCurrDayIter = new Date(startDate);				
			for (var nNumDay=0; nNumDay<=nDaysMultiDay; nNumDay++) {
				//do nothing at start day - that's default case
				if (nNumDay != 0) {
					this.doDrawAppointment(oCurrDayIter, calendarObjects, index, nNumDay<nDaysMultiDay);				
				}
				oCurrDayIter.setUTCDate(oCurrDayIter.getUTCDate()+1);
                oCurrDayIter.setTime(Math.floor(oCurrDayIter.getTime() / 864e5) * 864e5); // ms / day
			}
		}
		
		this.doDrawAppointment(startDate, calendarObjects, index, false);
	},
	
	redrawAppointments: function(workWeekHeight,weekEndHeight) {
		var constHeader = pxPerEm*1.1;
		var constBottom = 7;
		var constBottomBorder = 1;
		var constAppointmentPlusBorderPlusMargin = pxPerEm*1.1 + 4 + 1;	
	    var calc_ww = (workWeekHeight - constHeader - constBottom - constBottomBorder) / constAppointmentPlusBorderPlusMargin;
	    var calc_we = (weekEndHeight - constHeader - constBottom - constBottomBorder) / constAppointmentPlusBorderPlusMargin;
		this.show_ww = IE6 ? Math.floor(calc_ww) : Math.ceil(calc_ww);
		this.show_we = IE6 ? Math.floor(calc_we) : Math.ceil(calc_we);
		this.redraw();
	},
	
	doDrawAppointment: function(startDate, calendarObjects, index, isMultiday) {
		var isMultiday = isMultiday;
		var id = calendarObjects.id;
		var folder_id = calendarObjects.folder;
		var created_by = calendarObjects.created_by;
		var selectedAppointmentWeek={id : id, folder : folder_id};
		var divAppId = 'appInWeekView' + folder_id + "_" + id;
		var shown_as = calendarObjects.shown_as;
		var title = calendarObjects.title;
		var start_date = calendarObjects.start_date;
        if (startDate.getTime() > start_date) start_date = startDate.getTime();
		var end_date = calendarObjects.end_date;	
		var full_time = calendarObjects.full_time;	
		var nRecPosition = calendarObjects.recurrence_position;	
		var oViewObj = this.dateIdAssoc[startDate.getUTCDate() + '_' + startDate.getUTCMonth() + '_' + startDate.getUTCFullYear()];
	
		if (!oViewObj) return;
		var sCurrId = oViewObj.id;
		
		if (oViewObj.app < this.show_ww && !oViewObj.day.bWeekend || 
		    oViewObj.app < this.show_we && oViewObj.day.bWeekend) {
			
	        var sAppId = sCurrId + "_" + oViewObj.app + (full_time ? "f_app" : "_app");
			var dAppDiv = this.getAppointmentDiv(				
			     new CalendarWorkWeekObject(
			             calendarObjects.id, calendarObjects.folder, calendarObjects.recurrence_position, 
			             calendarObjects.recurrence_id, calendarObjects.created_by, calendarObjects.title,
			             start_date, calendarObjects.end_date, calendarObjects.note,
			             calendarObjects.recurrence_type, calendarObjects.participants, 
			             calendarObjects.full_time, calendarObjects.shown_as, calendarObjects.color_label, 
			             calendarObjects.location, calendarObjects.private_flag, null, calendarObjects.categories),
	             sAppId, full_time, isMultiday);
			
			$2(sCurrId).appendChild(dAppDiv);
			addTMPId(dAppDiv);
			calendarObjects["index"] = index;
			this.aAppointmentAssoc[sAppId] = calendarObjects;
		}
		oViewObj.app++;
		
		if (oViewObj.app == (this.show_ww + 1) && !oViewObj.day.bWeekend || 
		    oViewObj.app == (this.show_we + 1) && oViewObj.day.bWeekend ) {
			
			var oButtonDiv = getContentAsDiv('','expandButton','but_'+sCurrId);
			addDOMEvent(oButtonDiv,'click',monthAction);
			$2(sCurrId).appendChild(oButtonDiv);
			addTMPId(oButtonDiv);
			oViewObj.app++;
		}
		
		if (oViewObj.day.bWeekend && oViewObj.app > 0 && $2(sCurrId+'_0_app')) {
			$2(sCurrId+'_0_app').style.height = "1.0em";
			$2(sCurrId+'_0_app').style.lineHeight = "1.0em";
		}					
	
		var aSelected = calendarSelection.getSelected();
		for (var nindx=0; nindx < aSelected.length; nindx++) {
			if(id == aSelected[nindx].id && folder_id == aSelected[nindx].folder && $2(sAppId)) {
				$2(sAppId).className = removeClass($2(sAppId).className,
				'border-color-image');
				$2(sAppId).className += ' selectedAppMonth border-color-selection-elements';
				aSelectedAppArray.push(sAppId);
				break;
			}
		}
	},
	
	getDateFromDay: function(nCurrDay) {
		oCompMonth = new Date();
		oCompMonth.setTime(0);					
		oCompMonth.setUTCDate(1);				
		oCompMonth.setUTCFullYear(this.oCalendarTool.nYear);	
		oCompMonth.setUTCMonth(this.oCalendarTool.nMonth);			
		
		
		if(nCurrDay.nCurrMonth==0)
			oCompMonth.setUTCMonth(oCompMonth.getUTCMonth()-1);
		else if(nCurrDay.nCurrMonth==2)
		{
			var getMonthReturns = oCompMonth.getUTCMonth();
			if(getMonthReturns!=0)
			{
				oCompMonth.setUTCMonth(oCompMonth.getUTCMonth()+1);
			}
			else
				oCompMonth.setUTCMonth(1);		
		}
		oCompMonth.setUTCDate(nCurrDay.nDate);	
		currMonth = oCompMonth.getUTCMonth();	
		currYear = oCompMonth.getUTCFullYear();
		return oCompMonth;	
	},
	
	//Initialize month view with calendar data, add Appointments
	initMonthView: function() {
		    var Self = this;	
			var aAppointments = new Array();
			this.oCalendar = new cCalendar(this.oCalendarTool.nMonth,this.oCalendarTool.nYear);
			this.aMonthBtAppointments = new Array();
			var aAllAppointments = 	calendarObjects;	
			for (var indexWeek=0; indexWeek<this.oCalendar.aWeeks.length; indexWeek++) {
				var sTableId = 'table_'+indexWeek;	//Nicht mehr benutzt ?				
				var currentWeek = this.oCalendar.aWeeks[indexWeek];
				for(indexDay=0;indexDay<7;indexDay++)
				{
					var nDisplayedAppToday = 0;
					var nAppCount=0;
					var bDisplayFirst = false;
					var sCurrId = 'd_'+indexWeek+'_'+indexDay;
					var currentDay = currentWeek.aDays[indexDay];				
					
					sAssocMonthArray[sCurrId+'_num'] = {day:currentDay,month:this.oCalendarTool.nMonth,
																			year:this.oCalendarTool.nYear};
				
					var currDateObj = this.getDateFromDay(currentDay);
					this.dateIdAssoc[currDateObj.getUTCDate() + '_' + currDateObj.getUTCMonth() + '_' + currDateObj.getUTCFullYear()] 
							= {id:sCurrId, app:0,fdapp:0,day:currentDay};
					//disable			
					if(currentDay.nCurrMonth==0 || currentDay.nCurrMonth==2)
					{
						$2(sCurrId).className += " wholeDayBackground";
					}
					var ShowFullTimeDiv =  newnode('div',0,{id:sCurrId+'_title',
																className:"fullTimeAppointmentMonthTitle"});														
					
					
					var dDiv = getContentAsDiv(currentDay.nDate,"dateCalendarFontSize dateAlignMonthView", sCurrId+'_num');
					var oHeadDiv = newnode('div',0,{className:"headerContStyle",id:sCurrId+"_headcontainer"});
		
					oHeadDiv.appendChild(ShowFullTimeDiv);
					addTMPId(ShowFullTimeDiv);
					oHeadDiv.appendChild(dDiv);
					addTMPId(dDiv);
					addDOMEvent(dDiv,"selectstart",function (e) {
						stopEvent(e);
						return false;
					});
					addDOMEvent(dDiv,"click",monthAction);
					addDOMEvent(dDiv,"dblclick",monthAction);
					
					if (isLocalToday(currDateObj)) {
						$2(sCurrId).className += " todayBackground";
					}
					
					$2(sCurrId).appendChild(oHeadDiv);
					addTMPId(oHeadDiv);
					
					if(indexWeek == this.oCalendar.aWeeks.length-1 &&
																indexDay != 6 && !currentDay.bWeekend)
					{
						try{
							$2(sCurrId).className += " grayBorderCalendarMonth border-color-image";
						}catch(e){}
					}
	
					if(indexWeek == 0 && indexDay == 0)
					{
						//set start date of month				
						this.calendar_start = new Date(currDateObj);
					}				
					if(indexWeek == (this.oCalendar.aWeeks.length-1) && indexDay == 6)
					{	
						//set date date of month
						this.calendar_end = new Date(currDateObj);
						this.calendar_end.setDate(this.calendar_end.getDate()+1);
						try{
							$2(sCurrId).parentNode.style.borderBottom = "1px solid";
							$2(sCurrId).parentNode.className += " border-color-image";
						}catch(e){}					
					}								
					/////////////////////////////////////////////////////////////////////////////////////////////////7
				}				
				myTablePH = getContentAsDiv("","placeHolderKWCenter",'kw_place_'+indexWeek);
				myTable = getContentAsDiv(currentWeek.nKW,"",'kw_month_'+indexWeek);
				$2('kwnumber_'+indexWeek).appendChild(myTablePH);							
				addTMPId(myTablePH);	
				$2('kwnumber_'+indexWeek).appendChild(myTable);	
				
				/* add click and mousover on kw numbers to allow direct jump into week view */
				addDOMEvent($2('kwnumber_'+indexWeek), "click", (function(oCalendar, indexWeek) {
					return function(e) {		
						if (oCalendar == undefined || indexWeek == undefined) {
							return false;
						}
						var mDate = Self.getDateFromDay(oCalendar.aWeeks[indexWeek].aDays[0]);
						activeDay = mDate.getUTCDate();
                        activeMonth = mDate.getUTCMonth();
                        activeYear = mDate.getUTCFullYear();               
						objWeekCalendarTool.init(activeYear, activeMonth, activeDay);
						objWeekCalendarTool.setKW();
                        if (oMiniCalendar) { 
                            oMiniCalendar.setSelectedByDate(activeYear, activeMonth, activeDay);
                        }
                        $2('kwnumber_'+indexWeek).className = removeClass($2('kwnumber_'+indexWeek).className, "background-color-PMG-selection-elements");
						triggerEvent('OX_Switch_View','calendar/calendar/week');
					};
                })(this.oCalendar, indexWeek));
                addDOMEvent($2('kwnumber_'+indexWeek), "mouseover", (function(indexWeek) {
                	return function(e) {
                        $2('kwnumber_'+indexWeek).className += " background-color-PMG-selection-elements";
                	};
                })(indexWeek));
                addDOMEvent($2('kwnumber_'+indexWeek), "mouseout", (function(indexWeek) {
                	return function(e) {
                        $2('kwnumber_'+indexWeek).className = removeClass($2('kwnumber_'+indexWeek).className, "background-color-PMG-selection-elements");
                	};
                })(indexWeek));
                
											
				addTMPId(myTable);
			}		
			this.getStorage();
	},
	
	buildAppointments: function(index, object) {
        var newObject = convertAppointmentArray(object);
        newObject["indxxx"] = index;
        object["indxxx"] = index;
        this.aMonthBtAppointments[index] = newObject;
	},
	
	sortAppointments: function () {
	    // vars
	    var apps = this.aMonthBtAppointments, i = 0, $i = apps.length, app;
	    // sort appointments (for whatever reason; would be nice to know)
	    function monthSorter(a, b) {
	        if (a.full_time) {
                return -1;
            } else if (b.full_time) {
                return 1;
            } else {
                return a.start_date < b.start_date ? -1 : 1;
            }
	    }
		apps.sort(monthSorter);
		// loop over appointments
		for (; i < $i; i++) {
		    app = apps[i];
			this.attachAppointments(app.indxxx, app);
		}
	},

	getStorage: function(fnParamComplete) {
	    var Self = this;
        if (this.storage) {
            this.storage.events.unregister("Changed", function() {
                Self.updateView();
            });
        }
        this.clearMonthView();
        var oChDate = this.getDateFromDay(this.oCalendar.aWeeks[0].aDays[0]);
        var starttime = oChDate.getTime();
        oChDate = this.getDateFromDay(this.oCalendar.aWeeks[this.oCalendar.aWeeks.length-1].aDays[6]);
        oChDate.setUTCDate(oChDate.getUTCDate()+1);
        var endtime = oChDate.getTime();
        if (Self.show_all) {
            var oParameters = { action:"all", start:starttime, end:endtime, columns:"1,20,207,206,2" };
        } else {        
            var oParameters = { action:"all", start:starttime, end:endtime, folder:activefolder, columns:"1,20,207,206,2" };
        }   
        oParameters.showPrivate = true;
        storageCache.get(AjaxRoot + "/calendar", 
                oParameters, 
                function(storage) {
                    storageCache.current = storage;
                    calendarSelection.setStorage(storage);
                    calendarSelection.reset();
                    storageCache.update();
                    Self.iterateStorage(storage);
                    lastUpdateOfCalendarTimestamp  = storage.timestamp;
                    if (fnParamComplete !== undefined) {
                        fnParamComplete();
                    }
                },
                 this.calendarwfields.toString(),
                 true,
                 calendar_serializeid,
                 calendar_makeID);
    },
    
    updateView: function() {
        this.clearMonthView();
        this.iterateStorage();
        lastUpdateOfCalendarTimestamp = storageCache.current.timestamp;
        calendar_HeaderUpdate(this.storage.ids.length);
    },
    
    iterateStorage: function(storage) {
        var Self = this;
        if (storage) {
            Self.storage = storage;
            Self.storage.events.register("Changed", function() {
                Self.updateView();
            });
        }
        Self.storage.newIterate(Self.storage.ids, emptyFunction, function(x,y) {
            Self.buildAppointments(x,y);
        },function(){
            Self.sortAppointments();
        });
        monthViewCreated = true;
    }, 

	clearMonthView: function() {
		//loop day divs
		for (var id in sAssocMonthArray) {
		    var nodes = jQuery($2(id.slice(0, -4))).children();
		    nodes.filter('[id$="_app"],[id^="but_"]').remove();
		    nodes.filter('[id$="_headcontainer"]>[id$="_title"]')
		        .empty().attr('class', 'fullTimeAppointmentMonthTitle');
		}
		this.aAppointmentAssoc = new Object();
		this.aMonthBtAppointments = new Array();
		this.aSelectedAppArray = aSelectedAppArray = new Array();
		monthViewCreated = false;	
		for(var i in this.dateIdAssoc) {
			this.dateIdAssoc[i].app = 0;
			this.dateIdAssoc[i].fdapp = 0;
		}
	},
	
	refreshMonthView: function(bAll) {
		this.show_all = bAll;
		if (calendar_getAllFoldersAttribute()){
			$("allAppointmentMonthView").checked = true;
		} else {
			$("allAppointmentMonthView").checked = false;
		}
		oMonthViewObj.getStorage();
	},
	
	getAppointments: function(currDate, currMonth, currCurrMonth, aAppointmentsArray) {
		var aAppointmentsToday = new Array();
		var nIndex=0;
		var nLength = parseInt(aAppointmentsArray.length);
		oCompMonth = new Date();
		oCompMonth.setMonth(currMonth);		
		if(currCurrMonth==0)
			oCompMonth.setMonth(oCompMonth.getMonth()-1);
		else if(currCurrMonth==2)
			oCompMonth.setMonth(oCompMonth.getMonth()+1);
		currMonth = oCompMonth.getMonth();	
		for(var nNumAppX=0;nNumAppX < nLength;nNumAppX++)	
		{		
			var aTMP = aAppointmentsArray[nNumAppX].day.split('.');
			var nAppDay = parseInt(aTMP[0]);
			var nAppMonth = parseInt(aTMP[1]);
			if(nAppDay == parseInt(currDate) && nAppMonth == parseInt(currMonth))
			{
				aAppointmentsToday[nIndex] = aAppointmentsArray[nNumAppX];
				nIndex++;
			}
		}
		return aAppointmentsToday;
	},
	
	getAppointmentDiv: function(calendarObjects,sId,fullday,isMultiday) {
		var owner = activeFolderOwner;
		var isPrivateShared = (owner !== configGetKey('identifier') && calendarObjects.private_flag === true);
		
		var appointmentDate = new Date(calendarObjects.start_date);
		if (isMultiday) appointmentDate.setUTCMinutes(0);
		var formattedTime = formatDate(appointmentDate, "time");	
		var shownDiv = getShownDiv(calendarObjects.shown_as);
	
		var datDIV = newnode("div", {border: "1px solid"}, 
					{ className: (fullday ? 
						"showFullTimeAppointmentMonth wholeDayBackground border-color-image" : 
						"appInMonthView border-color-image")} );
		
		// setting background color depending on categories, if set
		var backColor = "";
		if (calendarObjects.categories) {
			// getting the first color out of the categories list
			var cat = ox.categories.getFirstMatch(calendarObjects.categories);
			if (cat.color != 0) {
				backColor = " colorLabel" + cat.color;
			}
		}
		datDIV.className += backColor;
						
		var textDiv = newnode("div", { overflow: "hidden" }, 
					{ className: "showAppointmentTextMonth" + (fullday ? "Full" : "") + " dateCalendarFontSize" });
	
		var timeDisplayString = (!fullday && !isMultiday ? formattedTime : "") + " " + (calendarObjects.title || "");		
		
		if (calendarObjects.location) {
			timeDisplayString += " - " + calendarObjects.location;
		}
		
		var owner = activeFolderOwner;
		
		// setting confirmation styles
		if (calendarObjects.participants.length) {
			for (var i in calendarObjects.participants) {
				if (calendarObjects.participants[i].id == owner) {
					switch(calendarObjects.participants[i].confirmation) {
						case 0:
							datDIV.style.opacity = ".6";
							textDiv.style.fontStyle = "italic";
							timeDisplayString += " (" + _("waiting") + ")";
							break;
						case 2:
							textDiv.style.textDecoration = "line-through";
							break;
						case 3:											
							textDiv.style.fontStyle = "italic";
							timeDisplayString += " (" + _("tentative") + ")";
							break;
					}
					break;
				}
			}
		}

		textDiv.appendChild(document.createTextNode(timeDisplayString));
		
		datDIV.appendChild(shownDiv);		
		datDIV.appendChild(textDiv);	
		datDIV.id = sId;	
	
	 	var oInplEdit = new inplaceEdit(textDiv, calendarObjects.title, 
	          function(sStr, oObj){
			      editAppointment(calendarObjects, {title:sStr});
			  }
	    );
	 	oInplEdit.style.height = "1em";
		oInplEdit.style.fontSize = "8pt"
			
	 	if (isPrivateShared == false) {
	 		registerSource(datDIV, "calendar", function () { 
				objMoveCopy.begin("calendar", [calendarObjects]);
				return objMoveCopy;
			}, null, null, calendardefaultdisabled, defaultdisabledremove);
	 		
	 		addDOMEvent(datDIV, "contextmenu", function(e) {
	            stopEvent(e);
	            getSelectMonthView(e);
	            globalContextMenus.calendar.display(e.clientX, e.clientY,
	                                                calendarSelection);
	        });
		
		    addDOMEvent(datDIV, "click", function(e) {
		        var SelObj = calendarSelection.getID();
		        if (SelObj && SelObj.id == calendarObjects.id &&
		            SelObj.folder == calendarObjects.folder_id &&
		            SelObj.recurrence_position == calendarObjects.recurrence_position) {
		            if (window.event) {
		                e = window.event;
		            }
		            oInplEdit.on();
		            cancelBubbling(e);      
		        } else {
		            getSelectMonthView(e);
		        }
		    });   
		    addDOMEvent(datDIV, "dblclick", openAppointmentPopup);
		    datDIV.oxcalobj = "" + calendarObjects.folder_id + "-" + calendarObjects.id 
            	+ "-" + calendarObjects.recurrence_position;
	 	} else {
	 		// private app in shared folder, so default cursor
	 		datDIV.style.cursor = "default";
	 	}

		return datDIV;
	}
}

function getShownDiv(shown_as) {
	var shownDiv = newnode('div');
	switch (shown_as) {
		case 1:
			shownDiv.className = "appointmentRESERVED";
			break;
		case 2:
			shownDiv.className = "appointmentTEMPORARY";
			break;
		case 3:
			shownDiv.className = "appointmentABSENT";
			break;
		case 4:
			shownDiv.className = "appointmentFREE";
			break;
		default:
			shownDiv.className = "appointmentNONE";
			break;
	}
	shownDiv.className += " showAppointmentShownMonth";
	return shownDiv;
}

function getContentAsDiv(sContent,CSSClass,sId) {
	sContent = sContent.toString();
	var datDIV = document.createElement("div");
	datDIV.className = CSSClass;
	if(sContent.length > 0) {		
		datDIV.appendChild(document.createTextNode(sContent));
	}
	datDIV.id=sId;		
	addTMPId(datDIV)
	return datDIV;
}

function getSelectMonthView(evt){
	var DOMTarget = (evt.target) ? evt.target : evt.srcElement;	
	var sDOMId = DOMTarget.parentNode.id;
	if(!sDOMId || sDOMId.split('_')[4] != 'app')
		return;	
	var oObj = oMonthViewObj.aAppointmentAssoc[sDOMId];		
	deselectAppointments(oObj.full_time);	
	$2(sDOMId).className = removeClass($2(sDOMId).className, "border-color-image");
	$2(sDOMId).className += " selectedAppMonth border-color-selection-elements";
	$2(sDOMId).style.borderWidth = "2px";
	setTimeout((function(sDOMId) {
        return function() {
            aSelectedAppArray.push(sDOMId);
        }
    })(sDOMId), 20);	
	if (calendarSelection.count != 0) {
		calendarSelection.reset();
	}
	selectedAppointment = { 
        id:oObj.id, folder:oObj.folder, recurrence_position:oObj.recurrence_position, 
        recurrence_id:oObj.recurrence_id, created_by:oObj.created_by, 
        participants: oObj.participants
    };
	calendarSelection.click(oMonthViewObj.aAppointmentAssoc[sDOMId].index);
	triggerEvent("Selected", [ selectedAppointment ]);
}

function deselectAppointments(fullday) {
	for (var nSelApp=0; nSelApp < aSelectedAppArray.length; nSelApp++) {
		if($2(aSelectedAppArray[nSelApp])) {
			$2(aSelectedAppArray[nSelApp]).className = 
				removeClass($2(aSelectedAppArray[nSelApp]).className,'border-color-selection-elements');
			$2(aSelectedAppArray[nSelApp]).className = 
				removeClass($2(aSelectedAppArray[nSelApp]).className,'selectedAppMonth');			
			$2(aSelectedAppArray[nSelApp]).className += " border-color-image";
			$2(aSelectedAppArray[nSelApp]).style.borderWidth = "1px";
		}
	}
	aSelectedAppArray = new Array();
}

fileloaded();