/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var key= "appointments"; /*i18n*/
key= "tasks"; /*i18n*/
SeriesObject.NOSERIES= 0;
SeriesObject.DAILY= 1;
SeriesObject.WEEKLY= 2;
SeriesObject.MONTHLY= 3;
SeriesObject.YEARLY= 4;

SeriesObject.SUNDAY=1;
SeriesObject.MONDAY=2;
SeriesObject.THUESDAY=4;
SeriesObject.WEDNESDAY=8;
SeriesObject.THURSDAY=16;
SeriesObject.FRIDAY=32;
SeriesObject.SATURDAY=64;

SeriesObject.JANUARY=1;
SeriesObject.FEBRUARY=2;
SeriesObject.MARCH=3;
SeriesObject.APRIL=4;
SeriesObject.MAY=5;
SeriesObject.JUNE=6;
SeriesObject.JULY=7;
SeriesObject.AUGUST=8;
SeriesObject.SEPTEMBER=9;
SeriesObject.OCTOBER=10;
SeriesObject.NOVEMBER=11;
SeriesObject.DECEMBER=12;

function SeriesObject (object,createseries) {
	this.disabled=false;
	this.old_recurrence_type=null;
	this.old_days=null;
	this.old_day_in_month=null;
	this.old_month=null;
	this.old_interval=null;
	this.old_until=null;
	this.old_occurrences=null;
	/*
	 * NOSERIES= 0 ; DAILY= 1; WEEKLY= 2; MONTHLY= 3; YEARLY= 4;
	 */
	this.recurrence_type = 0;
	/*
	 * Null not set.
	 * Add up integer of in week days; or the day of series in monthview;
	 */
	this.days=null; //WEEK,MONTH,YEAR
	/*
	 * Null not set.
	 * which day of a month is part of the sequence. Counting starts with 1. counting all days set in days or if days not set all days.
	 */	
	this.day_in_month=null; //MONTH,YEAR
	 /*
	  * Null not set.
	  * Month of series
	  */
	this.month=null; //YEAR
	 /*
	  * Interval of series each number week,month,day 
	  */
    this.interval=null; //DAY,WEEK,MONTH || YEAR=1
    /*
     * Null not set 
     * End date of the series, if not set and occcurences not set series is unlimited
     */
     this.until=null; //DATE OF END
     /*
      * Null not set
      * Count of series not set
      */
     this.occurrences=null; //COUNT OF OCCURENCES
     
     if(object) {
     	this.setParameters(object,createseries);
     }
}
SeriesObject.prototype = {
	hasNoChanges : function () {
		if(this.old_recurrence_type != this.recurrence_type) { return false; }
		else if(this.old_days != this.days) { return false; }
		else if(this.old_day_in_month != this.day_in_month) { return false; }
		else if(this.old_month != this.month) { return false; }
		else if(this.old_interval != this.interval) { return false; }
		else if(this.old_until != this.until) { return false; }
		else if(this.old_occurrences != this.occurrences) { return false; }
		return true;		
	},
	setParameters : function(responseobject,createseries, forceNew) {
		if(!responseobject) {
			return;
		}
		if(responseobject.recurrence_position && !createseries) {
			this.disabled=true;
			//REMOVE IF IS VALID TO CREATE SERIES
			return;
		}
		if(responseobject.recurrence_type != undefined) {
			if (!forceNew) this.old_recurrence_type=parseInt(responseobject.recurrence_type);
			this.recurrence_type=parseInt(responseobject.recurrence_type);
		}
		if(responseobject.days != undefined) {
		    if (!forceNew) this.old_days=parseInt(responseobject.days);
			this.days=parseInt(responseobject.days);
		}
		if(responseobject.day_in_month != undefined) {
		    if (!forceNew) this.old_day_in_month=parseInt(responseobject.day_in_month);
			this.day_in_month=parseInt(responseobject.day_in_month);
		}
		if(responseobject.month != undefined) {
		    if (!forceNew) this.old_month=parseInt(responseobject.month);
			this.month=parseInt(responseobject.month);
		}
		if(responseobject.interval != undefined) {
		    if (!forceNew) this.old_interval=parseInt(responseobject.interval);
			this.interval=parseInt(responseobject.interval);
		}
		if(responseobject.until != undefined) {
		    if (!forceNew) this.old_until=responseobject.until;
			this.until=responseobject.until;
		}
		if(responseobject.occurrences != undefined) {
		    if (!forceNew) this.old_occurrences=parseInt(responseobject.occurrences);
			this.occurrences=parseInt(responseobject.occurrences);
		}
	},
	getSeriesString : function() {
		function getCountString (countint) {
			switch (countint) {
				case 1:
					return _("first");
				case 2:
					return _("second");
				case 3:
					return _("third");
				case 4:
					return _("fourth");
				case 5:
				case -1:
					return _("last"); 
			}
		}
		function getMonthString(monthint) {
			var mymonth=[_("January"),_("February"),_("March"),_("April"),_("May"),_("June"),_("July"),_("August"),_("September"),_("October"),_("November"),_("December")];
			return mymonth[monthint];
		}
		function getDayString(daysint) {
			var daystring="";
			switch (daysint) {
				case 62:
				    daystring=_("Work Day");
				    break;
				case 65:
                    daystring=_("Weekend Day");
                    break;
                case 127:
                    daystring=_("Day");
                    break;
				default:
					if (((daysint % SeriesObject.MONDAY) / SeriesObject.SUNDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Sunday") : daystring=daystring + ", "+_("Sunday"); 
					}					
					if (((daysint % SeriesObject.THUESDAY) / SeriesObject.MONDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Monday") : daystring=daystring + ", "+_("Monday"); 
					}					
					if (((daysint % SeriesObject.WEDNESDAY) / SeriesObject.THUESDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Tuesday") : daystring=daystring + ", "+_("Tuesday"); 
					}					
					if (((daysint % SeriesObject.THURSDAY) / SeriesObject.WEDNESDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Wednesday") : daystring=daystring + ", "+_("Wednesday"); 
					}					
					if (((daysint % SeriesObject.FRIDAY) / SeriesObject.THURSDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Thursday") : daystring=daystring + ", "+_("Thursday"); 
					}					
					if (((daysint % SeriesObject.SATURDAY) / SeriesObject.FRIDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Friday") : daystring=daystring + ", "+_("Friday"); 
					}					
					if ((daysint / SeriesObject.SATURDAY) >= 1) {
						(daystring=="") ? daystring=daystring + _("Saturday") : daystring=daystring + ", "+_("Saturday"); 
					}
			}
			return daystring;
		}
		var returnstring;
		var interval=this.interval;
		var recurrence_type=this.recurrence_type;
		var days=this.days;
		var day_in_month=this.day_in_month;
		var month=this.month;
		var until=this.until;
		var occurences=this.occurences;
		if(this.hasNoChanges()) {
			interval=this.old_interval;
			recurrence_type=this.old_recurrence_type;
			days=this.old_days;
			day_in_month=this.old_day_in_month;
			month=this.old_month;
			until=this.old_until;
			occurrences=this.old_occurrences;
		}
		switch (this.recurrence_type) {
			case 0:
				returnstring = _("No recurrence");
				break;
			case 1:	
				returnstring = format(_("Each %s Day"),interval);
				break;
			case 2:
				returnstring = format(_("Each %s Week(s) on %s"),[interval, getDayString(days)]);
				break;
	  		case 3:
	  			if(this.days==null) {
	  				returnstring = format(_("On day %s every %s month(s)"),[day_in_month,interval]);
	  			} else {
	  				returnstring = format(_("On %s %s each %s months"),[getCountString(day_in_month),getDayString(days),interval]);
	  			}
	  			break;
	  		case 4:
	  			if(this.days==null) {
	  				returnstring = format(_("Each %s %s"),[day_in_month,getMonthString(month)]);
	  			} else {
	  				returnstring = format(_("On %s %s in %s"),[getCountString(day_in_month), getDayString(days),getMonthString(month)]);
	  			}
			    break;
		}
		return returnstring;
	}
}
function SeriesView () {
	this.seriesobject=new SeriesObject();
	this.series_content_month_day_in_month1;
	this.series_content_month_days1;
	this.series_content_year_month0;
	this.series_content_year_month1;
	this.series_content_year_days1;
	this.series_content_year_day_in_month1;
	this.sequenceStart;
	this.sequenceEnd;
	this.actualnode;
}
SeriesView.prototype = {
	toggleMiniSequenceStart : function() {
		var tmp = $("series_duration_calendar_start");
		if(tmp.style.display!="block") {
			centerPopupWindow(tmp);
			tmp.style.height = 210 + "px";
			tmp.style.width = 228 + "px";
			tmp.style.display = "block";
		} else {
			tmp.style.display = "none";
		}
	},
	toggleMiniSequenceEnd : function() {
		var tmp = $("series_duration_calendar_end");
		if(tmp.style.display!="block") {
			centerPopupWindow(tmp);
			tmp.style.height = 210 + "px";
			tmp.style.width = 228 + "px";
			tmp.style.display = "block";
			if ($("series_ending_date_2")) {
			    $("series_ending_date_2").checked = "checked";
		    }
		} else {
			tmp.style.display = "none";
		}
	},
	setParameters : function(responseobject, forceNew) {
		this.seriesobject.setParameters(responseobject, false, forceNew);
		triggerEvent("OX_Series_Data_Init", this.getSeriesString());
	},
	getParameters : function(responseobject, moduleCase) {
		if (!responseobject) {
			responseobject=new Object();
		}
		if (!this.seriesobject.hasNoChanges() || (moduleCase && moduleCase == "duplicate")) {
			if (this.seriesobject.recurrence_type != null) { 
				responseobject["recurrence_type"]= this.seriesobject.recurrence_type; 
			}
			if (this.seriesobject.days != null) { 
				responseobject["days"]=this.seriesobject.days; 
			} else if (this.seriesobject.old_days != null) {
				responseobject["days"]=null;
			}
			if (this.seriesobject.day_in_month != null) { 
				responseobject["day_in_month"]=this.seriesobject.day_in_month; 
			}
			if (this.seriesobject.month != null) { 
				responseobject["month"]=this.seriesobject.month; 
			}
			if (this.seriesobject.interval != null) { 
				responseobject["interval"]=this.seriesobject.interval; 
			}
			if (this.seriesobject.occurrences != null) { 
				responseobject["occurrences"]=this.seriesobject.occurrences; 
			} else {
			    delete responseobject.occurrences;
			}
			if (this.seriesobject.until != null) { 
				var tmpdate=new Date(this.seriesobject.until);
				tmpdate=new Date(Date.UTC(tmpdate.getUTCFullYear(),tmpdate.getUTCMonth(),tmpdate.getUTCDate(),0,0,0));
				responseobject["until"]=tmpdate.getTime(); 
			} else {
			    delete responseobject.until;
			}
			if (this.seriesobject.until == null && this.seriesobject.occurrences == null) {
	            if (this.seriesobject.old_until != null) {
	                responseobject["until"] = null;
	            } else if (this.seriesobject.old_occurrences != null) {
	                responseobject["occurrences"] = null;
	            }
            }
		}
		return responseobject;
	},
	initView : function() {
		var Self=this;
		function createCalendar() {
			Self.sequenceStart = new cMiniCalendar(	$("begin_header_sequence"),$("begin_sequence"), 
									series_setSequenceStartDate,false,'seq_begin',$("seq_begin_header_month"),$("seq_begin_header_year"));

			Self.sequenceEnd = new cMiniCalendar(	$("end_header_sequence"), $("end_sequence"), 
										series_setSequenceEndDate,false,'seq_end',$("seq_end_header_month"),$("seq_end_header_year"));
		}
		function createCombos() {
			Self.series_content_month_day_in_month1 = new ComboBox3(window, "series_content_month_day_in_month:1", "7em", 0, true, null, 4);
			Self.series_content_month_day_in_month1.addElement(_("first"),1);
			Self.series_content_month_day_in_month1.addElement(_("second"),2);
			Self.series_content_month_day_in_month1.addElement(_("third"),3);
			Self.series_content_month_day_in_month1.addElement(_("fourth"),4);
			Self.series_content_month_day_in_month1.addElement(_("last"),5);
			Self.series_content_month_day_in_month1.getDomNode();
			Self.series_content_month_days1 = new ComboBox3(window, "series_content_month_days:1", "9em", 0, true, null, 4);
			Self.series_content_month_days1.addElement(_("Monday"),2);
			Self.series_content_month_days1.addElement(_("Tuesday"),4);
			Self.series_content_month_days1.addElement(_("Wednesday"),8);
			Self.series_content_month_days1.addElement(_("Thursday"),16);
			Self.series_content_month_days1.addElement(_("Friday"),32);
			Self.series_content_month_days1.addElement(_("Saturday"),64);
			Self.series_content_month_days1.addElement(_("Sunday"),1);
			Self.series_content_month_days1.addElement(_("Day"),127);
			Self.series_content_month_days1.addElement(_("Weekend Day"),65);
			Self.series_content_month_days1.addElement(_("Work Day"),62);
			Self.series_content_month_days1.getDomNode();
			Self.series_content_year_month0 = new ComboBox3(window, "series_content_year_month:0", "9em", 0, true, null, 4);
			Self.series_content_year_month0.addElement(_("January"),0);
			Self.series_content_year_month0.addElement(_("February"),1);
			Self.series_content_year_month0.addElement(_("March"),2);
			Self.series_content_year_month0.addElement(_("April"),3);
			Self.series_content_year_month0.addElement(_("May"),4);
			Self.series_content_year_month0.addElement(_("June"),5);
			Self.series_content_year_month0.addElement(_("July"),6);
			Self.series_content_year_month0.addElement(_("August"),7);
			Self.series_content_year_month0.addElement(_("September"),8);
			Self.series_content_year_month0.addElement(_("October"),9);
			Self.series_content_year_month0.addElement(_("November"),10);
			Self.series_content_year_month0.addElement(_("December"),11);
			Self.series_content_year_month0.getDomNode();
			Self.series_content_year_month1 = new ComboBox3(window, "series_content_year_month:1", "9em", 0, true, null, 4);
			Self.series_content_year_month1.addElement(_("January"),0);
			Self.series_content_year_month1.addElement(_("February"),1);
			Self.series_content_year_month1.addElement(_("March"),2);
			Self.series_content_year_month1.addElement(_("April"),3);
			Self.series_content_year_month1.addElement(_("May"),4);
			Self.series_content_year_month1.addElement(_("June"),5);
			Self.series_content_year_month1.addElement(_("July"),6);
			Self.series_content_year_month1.addElement(_("August"),7);
			Self.series_content_year_month1.addElement(_("September"),8);
			Self.series_content_year_month1.addElement(_("October"),9);
			Self.series_content_year_month1.addElement(_("November"),10);
			Self.series_content_year_month1.addElement(_("December"),11);
			Self.series_content_year_month1.getDomNode();
			Self.series_content_year_days1 = new ComboBox3(window, "series_content_year_days:1", "9em", 0, true, null, 4);
			Self.series_content_year_days1.addElement(_("Monday"),2);
			Self.series_content_year_days1.addElement(_("Tuesday"),4);
			Self.series_content_year_days1.addElement(_("Wednesday"),8);
			Self.series_content_year_days1.addElement(_("Thursday"),16);
			Self.series_content_year_days1.addElement(_("Friday"),32);
			Self.series_content_year_days1.addElement(_("Saturday"),64);
			Self.series_content_year_days1.addElement(_("Sunday"),1);
			Self.series_content_year_days1.addElement(_("Day"),127);
			Self.series_content_year_days1.addElement(_("Weekend Day"),65);
			Self.series_content_year_days1.addElement(_("Work Day"),62);
			Self.series_content_year_days1.getDomNode();
			Self.series_content_year_day_in_month1 = new ComboBox3(window, "series_content_year_day_in_month:1", "7em", 0, true, null, 4);
			Self.series_content_year_day_in_month1.addElement(_("first"),1);
			Self.series_content_year_day_in_month1.addElement(_("second"),2);
			Self.series_content_year_day_in_month1.addElement(_("third"),3);
			Self.series_content_year_day_in_month1.addElement(_("fourth"),4);
			Self.series_content_year_day_in_month1.addElement(_("last"),5);
			Self.series_content_year_day_in_month1.getDomNode();
		}

		createCombos();
		createCalendar();
	},
	showView : function (module,startdate,enddate) {
		if(!this.seriesobject.disabled) {
		    ox.api.setModal(true);
//			showNode("modal-dialog");
//			$("modal-dialog").style.display="block";
			showNode("series_window");
			centerPopupWindow($("series_window"));
			$("series_window").style.display="block";
			this.openView(module,startdate,enddate);
		} else {
			triggerEvent("OX_New_Error",4,_("You can't create a new recurrence in a modified appointment."));
		}
		
		
		
	},
	openView : function (module,startdate,enddate) {
		this.seriesobject.tmp_recurrence_type=this.seriesobject.recurrence_type;
		this.recurrenceType(this.seriesobject.recurrence_type,startdate);
		switch(parseInt(this.seriesobject.recurrence_type)) {
			case 0:
				break;
			case 1:
				$("series_interval_day").value=parseInt(this.seriesobject.interval);
				break;
			case 2:
				$("series_interval_week").value=parseInt(this.seriesobject.interval);
				setCheckBoxinWeek(parseInt(this.seriesobject.days));
				break;
			case 3:
				if(this.seriesobject.days == null) {
					$("series_content_month_option:0").checked=true;
					if(this.seriesobject.day_in_month != null) $("series_content_month_day_in_month:0").value=parseInt(this.seriesobject.day_in_month);
					if(this.seriesobject.interval != null) $("series_interval_month:0").value=	parseInt(this.seriesobject.interval);
				} else  {
					$("series_content_month_option:1").checked=true;
					if(this.seriesobject.day_in_month != null) this.series_content_month_day_in_month1.setKey(parseInt(this.seriesobject.day_in_month));
				  	if(this.seriesobject.days != null) this.series_content_month_days1.setKey(parseInt(this.seriesobject.days));
				   	if(this.seriesobject.interval != null) $("series_interval_month:1").value=	parseInt(this.seriesobject.interval);
				}
			    break;
			case 4:	
				if(this.seriesobject.days == null) {	
					$("series_content_year_option:0").checked=true;			
					if(this.seriesobject.day_in_month != null) $("series_content_year_day_in_month:0").value=parseInt(this.seriesobject.day_in_month);
					if(this.seriesobject.month != null) this.series_content_year_month0.setKey(parseInt(this.seriesobject.month));
				} else {
					$("series_content_year_option:1").checked=true;			
					if(this.seriesobject.days != null) this.series_content_year_days1.setKey(parseInt(this.seriesobject.days));
					if(this.seriesobject.day_in_month != null) this.series_content_year_day_in_month1.setKey(parseInt(this.seriesobject.day_in_month));
					if(this.seriesobject.month != null) this.series_content_year_month1.setKey(parseInt(this.seriesobject.month));			
				} 
				break;
		}
		if(this.seriesobject.recurrence_type != 0) {
			setRadioBoxEndingDate(this.seriesobject.occurrences,this.seriesobject.until);
			var mytype=getRadioBoxValue($("series_window_form").ending_date);
			switch(mytype) {
				case 1:
					$("series_duration_endsafter").value=this.seriesobject.occurrences;
					break;
				case 2:
					var mydate=new Date(this.seriesobject.until);
					globalseries.sequenceEnd.setSelectedByDate(mydate.getUTCFullYear(),mydate.getUTCMonth(),mydate.getUTCDate());
					$("series_duration_enddate").value= formatDate(mydate, "date");
					break;
			}
		}
		if(enddate && !this.seriesobject.until) { 
			$("series_duration_enddate").value= formatDate(enddate, "date");
			globalseries.sequenceEnd.setSelectedByDate(enddate.getUTCFullYear(),enddate.getUTCMonth(),enddate.getUTCDate()); 
		} else {
			$("series_duration_enddate").value= formatDate(globalseries.sequenceEnd.selectedTime, "date");
		}
		if(startdate) {	
			$("series_duration_startdate").value= formatDate(startdate, "date"); 
			globalseries.sequenceStart.setSelectedByDate(startdate.getUTCFullYear(),startdate.getUTCMonth(),startdate.getUTCDate()); 
		} else {
			$("series_duration_startdate").value= formatDate(globalseries.sequenceStart.selectedTime, "date"); 
		}
		if(module) {
			$("endsAfterType").firstChild.data=_(module);
		}
		
		if (this.seriesobject.days == null) {
			var prefill_date = parseDateString($("series_duration_startdate").value, "date");

			/* Pre Fill Weekly View */
			var prefill_dayOfWeek = prefill_date.getDay();				
			if(prefill_dayOfWeek) {	
				switch(parseInt(prefill_dayOfWeek)) {
				case 0:
					this.series_content_month_days1.setKey(parseInt(1));
					this.series_content_year_days1.setKey(parseInt(1));
					setCheckBoxinWeek(1);
					break;
				case 1:
					this.series_content_month_days1.setKey(parseInt(2));
					this.series_content_year_days1.setKey(parseInt(2));
					setCheckBoxinWeek(2);
					break;
				case 2:
					this.series_content_month_days1.setKey(parseInt(4));
					this.series_content_year_days1.setKey(parseInt(4));
					setCheckBoxinWeek(4);				
					break;
				case 3:
				this.series_content_month_days1.setKey(parseInt(8));
					this.series_content_year_day_in_month1.setKey(parseInt(8));
					setCheckBoxinWeek(8);
				    break;
				case 4:
					this.series_content_month_days1.setKey(parseInt(16));
					this.series_content_year_days1.setKey(parseInt(16));
					setCheckBoxinWeek(16);
				    break;
				case 5:
					this.series_content_month_days1.setKey(parseInt(32));
					this.series_content_year_days1.setKey(parseInt(32));
					setCheckBoxinWeek(32);
				    break;
				case 6:
					this.series_content_month_days1.setKey(parseInt(64));
					this.series_content_year_days1.setKey(parseInt(64));
					setCheckBoxinWeek(64);
				    break;
				}									
			}
			
			/* Pre Fill Monthly View */
			
			var prefill_dayOfMonth = prefill_date.getUTCDate();
			if ($("series_content_month_day_in_month:0") && prefill_dayOfMonth){
				$("series_content_month_day_in_month:0").value = parseInt(prefill_dayOfMonth);
			}
			
			if (prefill_dayOfMonth){
				if (prefill_dayOfMonth <= 7){						
					this.series_content_month_day_in_month1.setKey(parseInt(1));
					this.series_content_year_day_in_month1.setKey(parseInt(1));
				} else if (prefill_dayOfMonth <= 14 && prefill_dayOfMonth > 7){
					this.series_content_month_day_in_month1.setKey(parseInt(2));
					this.series_content_year_day_in_month1.setKey(parseInt(2));
				} else if (prefill_dayOfMonth <= 21 && prefill_dayOfMonth > 14){
					this.series_content_month_day_in_month1.setKey(parseInt(3));
					this.series_content_year_day_in_month1.setKey(parseInt(3));
				} else if (prefill_dayOfMonth <= 28 && prefill_dayOfMonth > 21){
					this.series_content_month_day_in_month1.setKey(parseInt(4));
					this.series_content_year_day_in_month1.setKey(parseInt(4));
				} else if (prefill_dayOfMonth > 28){
					this.series_content_month_day_in_month1.setKey(parseInt(5));
					this.series_content_year_day_in_month1.setKey(parseInt(5));
				}				
			}
		}
	},
	hideView : function () {
		hideNode("series_window");
		$("series_window").style.display="none";
		hideNode("series_window");
		ox.api.setModal(false);
//		$("modal-dialog").style.display="none";
	},
	cancelView : function() {
		this.seriesobject.recurrence_type=this.seriesobject.tmp_recurrence_type;
		this.hideView();
	},
	closeView : function () {
		switch (this.seriesobject.recurrence_type) {
			case 0:
				this.seriesobject.days=null;
				this.seriesobject.day_in_month=null;
				this.seriesobject.month=null;
    			this.seriesobject.interval=null;
                break;
			case 1:
				this.seriesobject.days=null;
				this.seriesobject.day_in_month=null;
				this.seriesobject.month=null;
    			this.seriesobject.interval=parseInt($("series_interval_day").value, 10);
			    break; 	
			case 2:
				this.seriesobject.days=getCheckBoxInt($("series_window_form").series_days);	
				if(this.seriesobject.days == 0) {
					//TODO SHOW ERROR
					return;
				}
				this.seriesobject.interval=parseInt($("series_interval_week").value, 10);
				this.seriesobject.day_in_month=null;
				this.seriesobject.month=null;
			    break;
			case 3:
			  	var myoption=getRadioBoxValue($("series_window_form").series_content_month_option);
			   	this.seriesobject.interval =parseInt($("series_interval_month:"+myoption).value, 10);
				this.seriesobject.month=null;
				if(myoption==0) {
					this.seriesobject.day_in_month=parseInt($("series_content_month_day_in_month:"+myoption).value, 10);
				  	this.seriesobject.days=null;
				} else if(myoption == 1) {
					this.seriesobject.day_in_month=parseInt(this.series_content_month_day_in_month1.getKey());
				  	this.seriesobject.days=parseInt(this.series_content_month_days1.getKey());
				} else {
					return;
				}
			    break;
			case 4:	
				var myoption=getRadioBoxValue($("series_window_form").series_content_year_option);
				if(myoption == 0) {
					this.seriesobject.day_in_month=parseInt($("series_content_year_day_in_month:"+myoption).value, 10);
					this.seriesobject.days=null;
					this.seriesobject.month=parseInt(this.series_content_year_month0.getKey());
				} else if(myoption == 1) {
					this.seriesobject.days=parseInt(this.series_content_year_days1.getKey());
					this.seriesobject.day_in_month=parseInt(this.series_content_year_day_in_month1.getKey());
					this.seriesobject.month=parseInt(this.series_content_year_month1.getKey());			
				} else {
					//TODO THROW ERROR
					return;
				}
				this.seriesobject.interval=1;
				break;
		}
		if(this.seriesobject.recurrence_type != 0) {
			var mytype=getRadioBoxValue($("series_window_form").ending_date);
			switch(mytype) {
				case 0:
					 this.seriesobject.until=null; 
				     this.seriesobject.occurrences=null; 
					break;
				case 1:
					this.seriesobject.until=null;
					this.seriesobject.occurrences=parseInt($("series_duration_endsafter").value, 10);
					break;
				case 2:
					this.seriesobject.until=this.sequenceEnd.selectedTime;
					this.seriesobject.occurrences=null;
					break;
			}
		}
		triggerEvent("OX_Series_Data_Changed", this.getSeriesString()); 
		this.hideView();
	},
	recurrenceType : function (type) {		
		type=parseInt(type);
		this.seriesobject.recurrence_type=type;
		if(type == 4) {
			var tmp = parseDateString($("series_duration_startdate").value, "date");
			
			if(this.seriesobject.day_in_month == null) $("series_content_year_day_in_month:0").value=tmp.getUTCDate();
			if(this.seriesobject.month == null) this.series_content_year_month0.setKey(tmp.getUTCMonth());
			if(this.seriesobject.month == null) this.series_content_year_month1.setKey(tmp.getUTCMonth());
			else this.series_content_year_month1.setKey(parseInt(this.seriesobject.month));
		}
		for(var i=0;i<5;i++) {
			if(this.seriesobject.recurrence_type != i) {
				$("series_content:"+i).style.display= "none";
			} else {
				$("series_content:"+i).style.display= "block";
				$("series_recurrence_type:"+i).checked=true;
			}
		}
		for (var i = 0; i < 3; i++) {
	       $("series_ending_date_" + i).parentNode.parentNode.style.visibility =
	           type ? "" : "hidden";
		}
	},
	getSeriesString : function() {
		return this.seriesobject.getSeriesString();
	},
	getStartDate : function() {
		return new Date(this.sequenceStart.selectedTime);	
		
	}
}
function series_parseValue(value,type) {
	var returnvalue;
	switch (type) {
		case "integer":
			returnvalue=parseInt(value, 10);
			if(isNaN(value) || returnvalue < 1 || (value == "") ) {
				returnvalue=1;
			}
			break;
	}
	return returnvalue;	
}
function getCheckBoxInt(checkboxarray) {
	var returnvalue = 0;
	for (var i=0; i<checkboxarray.length; i++) {
		if (checkboxarray[i].checked) {
			returnvalue = returnvalue + parseInt(checkboxarray[i].value);
		} 
	}
	return returnvalue;	
}
function getRadioBoxValue(radioboxarray) {
	var returnvalue = 0;
	for (var i=0; i<radioboxarray.length; i++) {
		if (radioboxarray[i].checked) {
			return parseInt(radioboxarray[i].value);
		} 
	}
	return returnvalue;	
}

function setRadioBoxEndingDate(occurence,until) {
	if(!occurence && !until) {
		$("series_ending_date_0").checked=true;
	} else if (occurence) {
		$("series_ending_date_1").checked=true;
	} else {
		$("series_ending_date_2").checked=true;
	}
}
function setCheckBoxinWeek(mydays) {
	var tmpdays=mydays;
	if(tmpdays>=SeriesObject.SATURDAY) {
		$("series_days_"+SeriesObject.SATURDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.SATURDAY;
	} else {
		$("series_days_"+SeriesObject.SATURDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.FRIDAY) {
		$("series_days_"+SeriesObject.FRIDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.FRIDAY;
	} else {
		$("series_days_"+SeriesObject.FRIDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.THURSDAY) {
		$("series_days_"+SeriesObject.THURSDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.THURSDAY;
	} else {
		$("series_days_"+SeriesObject.THURSDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.WEDNESDAY) {
		$("series_days_"+SeriesObject.WEDNESDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.WEDNESDAY;
	} else {
		$("series_days_"+SeriesObject.WEDNESDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.THUESDAY) {
		$("series_days_"+SeriesObject.THUESDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.THUESDAY;
	} else {
		$("series_days_"+SeriesObject.THUESDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.MONDAY) {
		$("series_days_"+SeriesObject.MONDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.MONDAY;
	} else {
		$("series_days_"+SeriesObject.MONDAY).checked=false;
	}
	if(tmpdays>=SeriesObject.SUNDAY) {
		$("series_days_"+SeriesObject.SUNDAY).checked=true;
		tmpdays=tmpdays-SeriesObject.SUNDAY;
	} else {
		$("series_days_"+SeriesObject.SUNDAY).checked=false;
	}
}
function series_setSequenceStartDate () {
	globalseries.sequenceStart.setSelected(this.id);
	$("series_duration_startdate").value= formatDate(globalseries.sequenceStart.selectedTime, "date");
	$("series_duration_calendar_start").style.display = "none";
}
function series_setSequenceEndDate () {
	globalseries.sequenceEnd.setSelected(this.id);
	$("series_duration_enddate").value= formatDate(globalseries.sequenceEnd.selectedTime, "date");
	$("series_duration_calendar_end").style.display = "none";
}
function setSequenceStartDateOnBlur(){
	var tmp = parseDateString($("series_duration_startdate").value, "date");
	if(tmp) {
		globalseries.sequenceStart.setSelectedByDate(tmp.getUTCFullYear(), tmp.getUTCMonth(), tmp.getUTCDate());
	} else {
		$("series_duration_startdate").value= formatDate(globalseries.sequenceStart.selectedTime, "date");	
	}
}
function setSequenceEndDateOnBlur(){
	var tmp = parseDateString($("series_duration_enddate").value, "date");
	if(tmp) {
		globalseries.sequenceEnd.setSelectedByDate(tmp.getUTCFullYear(), tmp.getUTCMonth(), tmp.getUTCDate());
	} else {
		$("series_duration_enddate").value= formatDate(globalseries.sequenceEnd.selectedTime, "date");
	}
}
fileloaded();