
# norootforbuild

Name:           open-xchange-gui-wizard-plugin
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:        6.20.8.0
%define         ox_release 0
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Open-Xchange GUI Wizard Server Plug-In
Requires:       open-xchange-server >= 6.20.8.0
#

%package gui
Group:          Applications/Productivity
Requires:       open-xchange-gui >= 6.20.8.0
Summary:        Open-Xchange GUI Wizard Plug-In

%description
Open-Xchange GUI Wizard Plug-In

Authors:
--------
    Open-Xchange

%description gui
Open-Xchange GUI Wizard Plug-In

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

ant -Dguiprefix=%{docroot}/ox6 -Dlib.dir=/opt/open-xchange/lib -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%post

if [ ${1:-0} -eq 2 ]; then
   # only when updating
   . /opt/open-xchange/etc/oxfunctions.sh

   # prevent bash from expanding, see bug 13316
   GLOBIGNORE='*'

  # SoftwareChange_Request-956
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
  if ! ox_exists_property "ui/wizard/launchOnStart" $pfile; then
      ox_set_property "ui/wizard/launchOnStart" "true" $pfile
  fi

  # SoftwareChange_Request-866
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
  if ! ox_exists_property "ui/wizard/launchOnStartDefault" $pfile; then
      ox_set_property "ui/wizard/launchOnStartDefault" "true" $pfile
  fi

  # SoftwareChange_Request-675
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
  if ! ox_exists_property "ui/wizard/firstrunmode" $pfile; then
      ox_set_property "ui/wizard/firstrunmode" "false" $pfile
  fi

  # SoftwareChange_Request-652
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
  if ! ox_exists_property "ui/wizard/mailaccounts" $pfile; then
      ox_set_property "ui/wizard/mailaccounts" "GoogleMail,gmx.de,web.de,t-online.de,yahoo.com" $pfile
  fi

  # SoftwareChange_Request-279
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
  if ! ox_exists_property "modules/com.openexchange.wizard/module" $pfile; then
      val=$(ox_read_property "modules/com.openexchange.wizard/show" $pfile)
      ox_set_property "modules/com.openexchange.wizard/module" $val $pfile
      ox_remove_property "modules/com.openexchange.wizard/show" $pfile
  fi

fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/etc/groupware/settings
%config(noreplace) /opt/open-xchange/etc/groupware/settings/open-xchange-gui-wizard-plugin.properties
%files gui
%defattr(-,root,root)
%{docroot}/ox6/plugins/com.openexchange.wizard/images
%{docroot}/ox6/plugins/com.openexchange.wizard/lang
%{docroot}/ox6/plugins/com.openexchange.wizard/*.css
%{docroot}/ox6/plugins/com.openexchange.wizard/*.html
%{docroot}/ox6/plugins/com.openexchange.wizard/register.js
%{docroot}/ox6/plugins/com.openexchange.wizard/code.js
%{docroot}/ox6/plugins/com.openexchange.wizard/mailconfig.js
%config(noreplace) %{docroot}/ox6/plugins/com.openexchange.wizard/config.js

%changelog
* Mon Jul 02 2012 - wolfgang.rosenauer@open-xchange.com
  - Implemented story 32096937 : Do not use green checkmarks anymore for configured services
* Mon Jun 04 2012 - stefan.preuss@open-xchange.com
  - Removed the term oAuth from the display name used when adding a social account
* Thu Mar 29 2012 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #21877 :  [L3] personaldata tab can be skipped in firstrunmode after latest bugfix
* Wed Mar 07 2012 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #18958 : personaldata tab in wizard always sends updates
* Tue Feb 28 2012 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #21239 : Multiple "Import" labels at Yahoo crawler
  - Fixed bug #18635 : Wizard shows almost only orange "INFO" popups
* Tue Feb 14 2012 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #21547 : [L3] wizard's automatic startup cannot be disabled
* Tue Jan 31 2012 - stefan.preuss@open-xchange.com
  - Disable the selection for pop3 connections if the required pop3 bundle is not installed
* Tue Jan 24 2012 - stefan.preuss@open-xchange.com
  - Fixed bug #21163 : [L3] Footer in wizard not themable because of hard-coded "!important" in style tag
* Mon Jan 23 2012 - stefan.preuss@open-xchange.com
  - Fixed bug #19368 : LinkedIn-text cut at wizard
* Fri Jan 20 2012 - stefan.preuss@open-xchange.com
  - Disabled crawler options for some services because they don't work right now (bug #2100)
* Fri Jan 13 2012 - viktor.pracht@open-xchange.com
  - Fixed bug #20565 : [L3] While creating yahoo remote account through wizard, option to import Emails only is not selected by default.
* Tue Oct 25 2011 - wolfgang.rosenauer@open-xchange.com
  - New property for the launchOnStart checkbox default
* Wed Oct 19 2011 - wolfgang.rosenauer@open-xchange.com
  - TA7794 for US6970 : Google Calendar subscription support
* Mon Oct 17 2011 - wolfgang.rosenauer@open-xchange.com
  - Do not try to import contacts for non gmx.de accounts
* Tue Oct 11 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #20558 : [L3] Hide close buttons in firstrun mode completely
* Mon Aug 22 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #20151 : clean up Yahoo mail subscription options
* Tue Jul 19 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #19750 : [L3] personal tab can be left w/o filling mandatory fields
* Tue Jul 19 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #19873 : Some fields of "personal data" get removed when clicking through the wizard
* Wed Jul 13 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #19704 : [L3] Mandatory field in wizard not translated
* Mon Jul 11 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19759 : [L3] Yahoo wiztab not loaded due to JS error
* Thu Jul 07 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #19727 : error:JSONObject["messagingService"] not found.. after twitter configuration in wizard
* Wed Jul 06 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19649 : [L3] Displayname set through wizard is not directly used for mails
* Tue Jul 05 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19708 : typo in wizard pot
* Mon Jul 04 2011 - viktor.pracht@open-xchange.com
  - TA6429 for US6138 : Wizard: Japanese Support for the Wizard
* Thu Jun 30 2011 - viktor.pracht@open-xchange.com
  - TA7317 for US9594 : Replace Yahoo-Webcrawler with OAuth-Implementation
* Fri Jun 24 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19354 : No success icon for t-online subscription in the wizard
* Thu Jun 16 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #14900 : Wizard buttons only works when clicking them in the middle
* Wed Jun 08 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #19449 : [L3] no iphone 4 mentioned in the "standard" wizard tab
* Mon Jun 06 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #19266 : [L3] Mandatory fields in Wizard and Personal Data are not marked
* Tue May 31 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #19132 : [L3] Google contact folder should be named gmail
* Mon May 30 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19383 : User configuration gets reset
* Fri May 20 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #18926 : [L3] If display name is changed in a session the new name isn't used on the start page
* Wed May 18 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #19282 : [L3] T-Online SMTP is no SSL port
* Thu May 12 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #19188 : [L3] personal tab in wizard empty in firstrunmode if going
                       backwards in tabs
* Thu May 12 2011 - ben.pahne@open-xchange.com
  - Fixed bug #19194 : [L3] Changing language in wizard has no effect
* Mon May 09 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #19176 : [L3] custom mail accounts are not displayed in wizard
  - Follow up for US6136 : Allow to modify the hostname used in HTML docs
* Tue May 03 2011 - ben.pahne@open-xchange.com
  - TA6774 for US6327 : Additional information text about services
* Tue May 03 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #19110 : Disable hide checkbox in closeLock mode
* Thu Apr 14 2011 - wolfgang.rosenauer@open-xchange.com
  - Allow extra overrides for mail, subscription and messaging in config.js
  - Fixed callback in personaldata page
* Tue Apr 12 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #18907 : wrong step count in wizard
* Mon Apr 11 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #18920 : Error message shows up twice
* Fri Apr 08 2011 - wolfgang.rosenauer@open-xchange.com
  - TA6136 for US6179 : Added event listener to open wizard in a certain tab 
* Thu Apr 07 2011 - wolfgang.rosenauer@open-xchange.com
  - TA6672 for US6229 : Disable Publishing tab by default
* Tue Apr 05 2011 - ben.pahne@open-xchange.com
  - Fixed bug #18863 : IE7: Mobile online help not shown at the wizard
* Mon Apr 04 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #17652 : [L3] Send button does not fit in Wizard
* Thu Mar 24 2011 - wolfgang.rosenauer@open-xchange.com
  - TA6520 for US6144 : Implement optional firstrun mode
* Thu Mar 17 2011 - wolfgang.rosenauer@open-xchange.com
  - TA6134 for US6136 : Introduce OX_WIZARD_CLOSED event
* Tue Mar 15 2011 - ben.pahne@open-xchange.com
  - TA6133 for US6136 : Wizard themeing
* Mon Mar 14 2011 - wolfgang.rosenauer@open-xchange.com
  - Split config.js into two files config.js, mailconfig.js where config.js is meant to be changeable by the admin
* Wed Mar 09 2011 - ben.pahne@open-xchange.com
  - Fixed bug #18559 : Wizard does not subscribe facebook messaging
  - TA5363 for US5424 : Make variable names in the Doku
* Tue Mar 08 2011 - ben.pahne@open-xchange.com
  - Fixed bug #18511 : Wizard does not use new OAuth workflow
* Fri Mar 04 2011 - wolfgang.rosenauer@open-xchange.com
  - For preconfigured combined (mail+crawler) services it is now possible to enable/disable them separately 
* Mon Feb 28 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #18282 : [L3] Email accounts set up via wizard do not show up in settings afterwards
* Fri Feb 25 2011 - wolfgang.rosenauer@open-xchange.com
  - Some refactoring to avoid duplicated code (more to come)
  - Allow additional mail accounts to be configured through config.js
  - Allow T-Online mail subscription again
* Fri Feb 25 2011 - viktor.pracht@open-xchange.com
  - Fixed on-demand loading of code.js
* Wed Feb 23 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #18128 : [L3] the "Save" button is not appropriated showed in subscription service page
  - Moved wizard code into code.js; register.js just determines whether or not to open immediately
* Tue Jan 04 2011 - ben.pahne@open-xchange.com
  - Fixed bug #18234 : external link in the wizard's t-online tab should open in a new page/tab
* Mon Dec 13 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17059 : LinkedIn subscription loads forever (temporary)
* Wed Dec 08 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17590 : [L3] Custom Sun crawler throws error while trying to subscribe to source system
* Tue Nov 16 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17282 : Wizard "publication" area becomes duplicated when selecting it again
* Thu Nov 11 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #17505 : Mobile Autoconfig Plugin does not work
* Tue Nov 09 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17454 : Unable to subscribe OXMF at the wizard
* Wed Oct 06 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17080 : Publish section at the wizard does not work
* Mon Oct 04 2010 - ben.pahne@open-xchange.com
  - Fixed bug #17112 : IE: T-Online crawler input fields at the wizard are shown at the right border
* Fri Aug 27 2010 - ben.pahne@open-xchange.com
  - TA4159 for US4333 : User kann Zeitzone und Sprache im Wizard auswählen
* Thu Aug 26 2010 - karsten.will@open-xchange.com
  - TA4272 for US4927 : Switch T-Online and MSN to contacts-only in the wizard and activate them again
* Fri Aug 06 2010 - matthias.biggeleben@open-xchange.com
  - Fixed bug #16660 : Wizard(s) broken with 6.18.1
* Tue Jul 27 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #16581 : "Close" button at the Wizard is missing
* Fri May 28 2010 - karsten.will@open-xchange.com
  - Fixed bug #15726 : GoogleMail crawler reports success when saving even if the account is invalid
* Thu Apr 22 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15772 : wizard: bracket missing State business)
* Thu Apr 22 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15939 : "error" settings/open-xchange-gui-wizard-plugin.properties config file
* Wed Apr 21 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15797 : Wizard: unable to subscribe to Web.de and GMX
* Tue Apr 20 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15906 :  zip and State instead of Post code and County for UK users in the wizard for personal settings
* Fri Apr 16 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15891 : [L3] webmail users without global adressbook can't set own contact attributes
* Tue Apr 06 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15779 : [L3] wizard: creds. get saved even if they are wrong for services with external mail accounts
  - Fixed bug #15792 : subscribe to web.de throws JS error
* Tue Apr 06 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15773 : wizard: "do not show on start" some times not translated
  - Fixed bug #15791 : Unable to subscribe yahoo
  - Fixed bug #15795 : wizard: OXMF subscription configured for a folder OXMF instead of a unique subscription name
* Mon Apr 05 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15751 : save button disabled but fields active in case of an successfull saved xing account
* Thu Apr 01 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15745 : [L3] Inconsistent field names in personal settings in wizard and GUI setup area
* Thu Apr 01 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15748 : [L3] wording issues in wizard
* Wed Mar 31 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15742 : [L3] Using newly created external mail account requires relogin/config refresh
* Tue Mar 30 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15729 : New subscriptions done through wizard get parent folder permissions
* Fri Mar 26 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15687 : gmail Account cannot be created using the wizard
* Tue Mar 23 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15644 : wizard: ZIP / City Field Problem
* Thu Mar 11 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #15586 : Unable to stop wizard from starting after login
* Thu Mar 04 2010 - viktor.pracht@open-xchange.com
  - Fixed external pages from other plugins
* Tue Mar 02 2010 - ben.pahne@open-xchange.com
  - TA2748 for US4204 : Two New Services MSN and T-Online
  - TA2749 for US4204 : Improved mobility handling, config-switch for each device
  - TA2750 for US4204 : i18n changes
* Wed Feb 24 2010 - ben.pahne@open-xchange.com
  - TA2690 for US4180 : Create a configfile and export important wizard settings
  - TA2691 for US4180 : Replace static Open-Xchange title with the title from the configuration
* Thu Feb 18 2010 - ben.pahne@open-xchange.com
  - Fixed bug #14857 : Wizard throws ugly error message when creating a duplicate subscription
  - Fixed bug #14931 : Wizard buttons are clickable even if they are shown disabled
  - Fixed bug #14859 : Wizard settings are not visible immediately after finishing the wizard
  - Fixed bug #15180 : [L3] Wizzard status messages not translated
* Wed Feb 17 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15409 : Upsell information is always shown at the wizard 
* Tue Feb 16 2010 - ben.pahne@open-xchange.com
  - Fixed bug #15189 : GUI Wizard does not take care of ENABLE_INTERNAL_USER_EDIT setting
  - Fixed bug #14868 : Wizard pops up after login even if deactivated before
  - Fixed bug #15407 : Wizard shows mobility part, even if no usm or usm-online-help is installed
* Thu Feb 04 2010 - ben.pahne@open-xchange.com
  - TA2535 of US4098 : Make a progress bar
  - TA2536 of US4098 : Make highlight icons
* Tue Jan 26 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #15447 : Wizard pops up below the bottom browser border
* Mon Jan 25 2010 - ben.pahne@open-xchange.com
  - TA2087 of US3847 : Each device gets its own frame on the mobility tab 
  - TA2288 of US3976 : New Tab called Upsell Layer
  - TA2289 of US3976 : Create Icon for Upsell Layer
* Tue Jan 12 2010 - stefan.preuss@open-xchange.com
  - Fixed bug #14954 : Wizard radiobuttons don't have any defaults with IE
  - Fixed bug #15043 : Publication link produced by the wizard link to dead pages
* Fri Dec 04 2009 - stefan.preuss@open-xchange.com
  - It's no longer required to press a save button on the 'Personal Data' tab
* Fri Nov 27 2009 - choeger@open-xchange.com
  - Fixed bug #14989 -  open-xchange-gui-wizard-plugin does not work on SLES and RHEL
* Wed Nov 25 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14971 : Subscribing to web.de does not work through the wizard
* Wed Nov 25 2009 - choeger@open-xchange.com
  - Fixed bug #14920 :  Wizard package deploys server related configuration file
* Fri Nov 20 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14921 : Wizard: Unable to configure external mail accounts if Pub/Sub is disabled
* Thu Nov 19 2009 - stefan.preuss@open-xchange.com
  - Fixed bug #14841 : Wizard throws SQL error, Column 'spam_handler' cannot be null
* Thu Nov 19 2009 - ben.pahne@open-xchange.com
  - Fixed bug #14916 : Wizard broken with IE7
