
# norootforbuild
%define plugname com.openexchange.social.accounts

Name:           open-xchange-gui-social-accounts-plugin
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:        6.20.8.0
%define         ox_release 0
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Open-Xchange Social Accounts Plugin
Requires:       open-xchange-gui >= 6.20.8.0
#

%description
Open-Xchange Social Accounts Plugin

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

mkdir -p %{buildroot}/opt/open-xchange/etc/guiplugin.d
echo %{plugname} > %{buildroot}/opt/open-xchange/etc/guiplugin.d/%{name}.name
ant -Dguiprefix=%{docroot}/ox6 -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%clean
%{__rm} -rf %{buildroot}

%post
. /opt/open-xchange/etc/guipluginfunctions.sh
test ${1:-0} -eq 1 && addPlug %{name} || true

%preun
. /opt/open-xchange/etc/guipluginfunctions.sh
test ${1:-0} -eq 0 && removePlug %{name} || true

%files
%defattr(-,root,root)
%dir %{docroot}/ox6/plugins/%{plugname}
%{docroot}/ox6/plugins/%{plugname}/*
%dir /opt/open-xchange/etc/guiplugin.d/
/opt/open-xchange/etc/guiplugin.d/*

%changelog
* Mon Jul 30 2012 - viktor.pracht@open-xchange.com
  - Fixed bug #22616 : [L3] IE 8: Stack overflow error on selecting any radio button in the 'Add Feed' window
* Wed Jun 20 2012 - viktor.pracht@open-xchange.com
  - Initial import
