/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2004-2012 Open-Xchange, Inc.
 * Mail: info@open-xchange.com
 *
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

/*global jQuery, ox, requireOAuth, OAuthAccounts, createOAuthAccount, AjaxRoot, session, _, addTranslated */
/*jslint white: true, devel: true, plusplus: true, nomen: true, browser: true, undef: true, forin: true, maxerr: 50, indent: 4 */

(function () {

    'use strict';

    // require oAuth
    requireOAuth();

    var $ = jQuery,
        WIDTH = "500px",
        selectBox = $(),
        form = null,
        addAccount, add,
        getServiceId,
        changeSection,
        closePopup,
        openPopup,
        cancel,
        refreshAccounts;
    
    function text2HTML(str) {
        var result = $(), lines = str.split('\n');
        for (var i = 0; i < lines.length; i++) {
            if (i) result = result.add($('<br>'));
            result = result.add($(newtext(lines[i])));
        }
        return result;
    }
    
    closePopup = function () {
        form.parent().css("overflow", "auto");
        form.parent().parent().removeClass("busy-spinner-white");
        form.popup("disable");
        form.remove();
        form = null;
    };

    cancel = function () {
        closePopup();
    };

    refreshAccounts = function (serviceId) {
        OAuthAccounts.then(function (accounts) {
            selectBox.empty();
            var i, $i = accounts.length, account, opt, first = true;
            for (i = 0; i < $i; i++) {
                account = accounts[i];
                if (account.serviceId === "com.openexchange.oauth." + serviceId) {
                    opt = { value: account.id };
                    if (first) {
                        opt.selected = "selected";
                    }
                    selectBox.append(
                        $("<option>", opt).text('\u00A0' + account.displayName)
                    );
                    first = false;
                }
            }
        });
    };

    // store new account on server
    addAccount = function (data, cont) {
        ox.JSON.put(
            AjaxRoot + "/messaging/account/?action=new&session=" + session,
            data,
            function () {
                // refresh folder tree
                ox.api.folder.getSubFolders({
                    folder: 1,
                    cache: false,
                    success: function() {
                        ox.api.folder.dispatcher.trigger("modify");
                    }
                });
                ox.util.call(cont);
            });
    };

    // when user clicks on "Add" button...
    add = function () {
        var id = getServiceId(),
            oAuthAccountId = parseInt(selectBox.val(), 10) || 0,
            displayName = $.trim(form.find('.add-feed-display-name input[type=text]').val()) || "New feed",
            rssURL = $.trim(form.find('.add-feed-section-rss input[type=text]').val()),
            cont = function () {
                ox.UINotifier.ok(_('Feed has been added'));
                closePopup();
            };
        switch (id) {
            case 'facebook':
                if (oAuthAccountId) {
                    addAccount({
                        displayName: displayName,
                        messagingService: "com.openexchange.messaging.facebook",
                        configuration: { account: oAuthAccountId }
                    }, cont);
                }
                break;
            case 'twitter':
                if (oAuthAccountId) {
                    addAccount({
                        displayName: displayName,
                        messagingService: "com.openexchange.messaging.twitter",
                        configuration: { account: oAuthAccountId }
                    }, cont);
                }
                break;
            case 'rss':
                if (rssURL) {
                    addAccount({
                        displayName: displayName,
                        messagingService: "com.openexchange.messaging.rss",
                        configuration: { url: rssURL }
                    }, cont);
                }
                break;
        }
    };

    getServiceId = function () {
        return form.find('input[name=add-social-account]:checked').val();
    };

    // when user changes radio buttons...
    changeSection = function () {
        var id = getServiceId();
        if (id === 'facebook' || id === 'twitter') {
            // Facebook / Twitter
            // show proper section
            form.find('.add-feed-section-rss').hide();
            form.find('.add-feed-section-social').show();
            // set display name
            form.find('.add-feed-display-name input[type=text]').val(id === 'facebook' ? _("Facebook") : _("Twitter"));
            // update select box
            refreshAccounts(id);
        } else {
            // RSS Feeds
            // show proper section
            form.find('.add-feed-section-social').hide();
            form.find('.add-feed-section-rss').show();
            // set display name
            form.find('.add-feed-display-name input[type=text]').val(_("RSS Feed"));
        }
        // set focus
        form.find('.add-feed-display-name input[type=text]').focus().select();
    };

    // start here
    openPopup = function () {

        if (form !== null) {
            form.empty();
        }

        form = $("<div>")
            .addClass("plain")
            .append(
                $("<h1>")
                    .css({ marginTop: "0.5em", whiteSpace: "nowrap" })
                    .text(String(_("Add feed")))
            )
            .append(
                $('<div>')
                .css('lineHeight', '3em')
                // facebook radio button
                .append(
                    $('<input>', {
                        type: 'radio',
                        name: 'add-social-account',
                        id: 'add-social-account-facebook',
                        value: 'facebook',
                        checked: 'checked',
                        tabindex: '1'
                    })
                    .css('border', '0px none')
                )
                .append(
                    $('<label>', { 'for': 'add-social-account-facebook' })
                    .append(addTranslated(_('Facebook')))
                )
                .append(
                    document.createTextNode('\u00A0\u00A0 ')
                )
                // twitter radio button
                .append(
                    $('<input>', {
                        type: 'radio',
                        name: 'add-social-account',
                        id: 'add-social-account-twitter',
                        value: 'twitter',
                        tabindex: '1'
                    })
                    .css('border', '0px none')
                )
                .append(
                    $('<label>', { 'for': 'add-social-account-twitter' })
                    .append(addTranslated(_('Twitter')))
                )
                .append(
                    document.createTextNode('\u00A0\u00A0 ')
                )
                // RSS radio button
                .append(
                    $('<input>', {
                        type: 'radio',
                        name: 'add-social-account',
                        id: 'add-social-account-rss',
                        value: 'rss',
                        tabindex: '1'
                    })
                    .css('border', '0px none')
                )
                .append(
                    $('<label>', { 'for': 'add-social-account-rss' })
                    .append(addTranslated(_('RSS Feed')))
                )
                .append(
                    document.createTextNode('\u00A0\u00A0 ')
                )
            )
            // feed's display name
            .append(
                $('<div>')
                .addClass('add-feed-display-name')
                .css('margin', '5px 0 5px 0px')
                .append(
                    $("<label>")
                    .text(_("Folder name for new feed:"))
                )
                .append(
                    $("<br>")
                )
                .append(
                    $('<input>', {
                        type: 'text',
                        tabindex: '2',
                        value: _('Facebook')
                    })
                    .addClass('monospace')
                    .css({ width: "300px", padding: '5px 10px 5px 10px' })
                )
            )
            // facebook / twitter section
            .append(
                $('<div>')
                .addClass('add-feed-section-social')
                .append(
                    $("<label>")
                    .text(expectI18n(_("Choose the proper account:")))
                )
                .append(
                    $("<br>")
                )
                .append(
                    selectBox = $("<select>", { size: 3, tabindex: '3' })
                    .addClass('monospace')
                    .css("width", "322px")
                )
                .append(
                    // controls
                    $("<div>")
                        .css({ margin: "10px 0 0 0" })
                        .append(
                            $.button({
                                title: _("... or create a fresh one for your profile"),
                                click: function () {
                                    // create oAuth account
                                    var serviceId = getServiceId();
                                    createOAuthAccount(
                                        {
                                            serviceId: "com.openexchange.oauth." + serviceId,
                                            displayName: serviceId === 'facebook' ? _("Facebook") : _("Twitter")
                                        },
                                        function () {
                                            refreshAccounts(serviceId);
                                        }
                                    );
                                },
                                tabIndex: '3'
                            })
                            .css({
                                "float": "left",
                                backgroundColor: "#3B5998",
                                fontWeight: "bold",
                                color: "white"
                            })
                            .css("backgroundImage", "-webkit-gradient(linear, left bottom, left top, color-stop(0.25, rgb(57,86,143)), color-stop(0.97, rgb(80,119,199)))")
                            .css("backgroundImage", "-moz-linear-gradient(center bottom, rgb(57,86,143) 25%, rgb(80,119,199) 97%)")
                        )
                        .append(
                            $.button({
                                title: _("Add"),
                                click: add,
                                tabIndex: '5'
                            })
                            .addClass("default")
                            .css({ "float": "right", margin: "0 0 0 0.5em" })
                        )
                        .append(
                            $.button({
                                title: _("Cancel"),
                                click: cancel,
                                tabIndex: '4'
                            })
                            .css({ "float": "right", margin: "0 0 0 0.5em" })
                        )
                )
                .append(
                    $("<div>").css({ clear: "both", padding: "0.5em 0 0 0", color: "#888" })
                    .append($('<i>').append(text2HTML(
                        _("Some browsers might block opening the authentication popup.\nIn this case, configure your browser's popup blocker to allow this site."))))
                )
            )
            // RSS feed section
            .append(
                $('<div>').addClass('add-feed-section-rss')
                .hide()
                .append(
                    $('<label>')
                    .append(addTranslated(_('RSS Feed URL:'))
                )
                .append(
                    $('<br>')
                )
                .append(
                    $('<input>', {
                        type: 'text',
                        name: 'add-feed-rss-url',
                        placeholder: 'http://...',
                        tabindex: '2'
                    })
                    .addClass('monospace')
                    .css({ width: "300px", padding: '5px 10px 5px 10px' })
                )
                .append(
                    // controls
                    $("<div>")
                    .css({ margin: "10px 0 0 0" })
                    .append(
                        $.button({
                            title: _("Add"),
                            click: add,
                            tabIndex: '4'
                        })
                        .addClass("default")
                        .css({ "float": "right", margin: "0 0 0 0.5em" })
                    )
                    .append(
                        $.button({
                            title: _("Cancel"),
                            click: cancel,
                            tabIndex: '3'
                        })
                        .css({ "float": "right", margin: "0 0 0 0.5em" })
                    )
                )
            )
        );
        form.find("input[type=radio]")
            .each(function() { this.onclick = changeSection; });

        form.popup({
            width: WIDTH,
            modal: true,
            center: true
        });

        form.find('.add-feed-display-name input[type=text]').focus().select();

        // list accounts via deferred object
        refreshAccounts('facebook');
    };

    ox.mail.addFeed = function () {
        openPopup();
    };

}());