
# norootforbuild
%define plugname com.openexchange.mail.accounts

Name:           open-xchange-gui-mail-accounts-plugin
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:        6.20.8.0
%define         ox_release 0
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Open-Xchange Mail Accounts Plugin
Requires:       open-xchange-gui >= 6.20.8.0
#

%description
Open-Xchange Mail Accounts Plugin

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

mkdir -p %{buildroot}/opt/open-xchange/etc/guiplugin.d
echo %{plugname} > %{buildroot}/opt/open-xchange/etc/guiplugin.d/%{name}.name
ant -Dguiprefix=%{docroot}/ox6 -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%clean
%{__rm} -rf %{buildroot}

%post
. /opt/open-xchange/etc/guipluginfunctions.sh
test ${1:-0} -eq 1 && addPlug %{name} || true

%preun
. /opt/open-xchange/etc/guipluginfunctions.sh
test ${1:-0} -eq 0 && removePlug %{name} || true

%files
%defattr(-,root,root)
%dir %{docroot}/ox6/plugins/%{plugname}
%{docroot}/ox6/plugins/%{plugname}/*
%dir /opt/open-xchange/etc/guiplugin.d/
/opt/open-xchange/etc/guiplugin.d/*

%changelog
* Thu Sep 15 2011 - matthias.biggeleben@open-xchange.com
  - Fixed bug #20409 : [L3] Edited display name is not getting reflected on remote account window while configuring the remote account
* Wed Sep 14 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #20188 : [L3] Email address is not auto populated on ‘Configure custom account” page if user provides email address which is not configured automatically.
* Wed Sep 07 2011 - choeger@open-xchange.com
  - Fixed bug #20281 - [L3] package update removes com.openexchange.mail.accounts from static.conf 
* Mon Aug 22 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #20151 : clean up Yahoo mail subscription options
* Mon Apr 11 2011 - matthias.biggeleben@open-xchange.com
  - Fixed configuration file
* Sat Apr 09 2011 - matthias.biggeleben@open-xchange.com
  - Fixed button margins (firefox)
  - Fixed logo height issue (firefox)
* Fri Apr 08 2011 - matthias.biggeleben@open-xchange.com
  - Configuration now supports products (instead of just pop3 vs imap)
  - Added support for service logos
  - Notification about running validation process
  - Warning if password is empty
* Wed Apr 06 2011 - matthias.biggeleben@open-xchange.com
  - Check email address format to look for potential typos
  - Tested and fixed config for googlemail, gmx.com, gmx.de, yahoo, t-online
* Tue Apr 05 2011 - matthias.biggeleben@open-xchange.com
  - Added build support
  - Added basic conf/packaging file structure
  - Added description support for service
  - Added backend control over services (enable/extend)
  - Added "back" button
  - Polishing (e.g. long email addresses)
  - Added color support (e.g., magenta for Telekom)
  - Renamed from "com.openexchange.mailaccounts" to "com.openexchange.mail.accounts"
  - List defined services in dialog (user can click to pick one)
  - Added common email service providers like gmx.com, hotmail.com, etc.
  - Added smart preselection of email field
  - Changed button layout to match UI design guidelines
* Mon Apr 04 2011 - matthias.biggeleben@open-xchange.com
  - Added support for separate config file
  - Initial check-in
