package com.openexchange.file.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.openexchange.file.storage.File.Field;
import com.openexchange.file.storage.FileStorageFileAccess.IDTuple;
import com.openexchange.groupware.AbstractOXException;
import com.openexchange.groupware.results.AbstractTimedResult;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.Results;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tx.TransactionException;

public abstract class AbstractFileAccess implements FileStorageFileAccess {
	
	protected FileStorageServiceFactory factory;
	protected Session session;
	protected String accountId;

	public AbstractFileAccess(FileStorageServiceFactory factory, Session session, String accountId) {
		this.factory = factory;
		this.session = session;
		this.accountId = accountId;
	}

	public void startTransaction() throws TransactionException {

	}

	public void commit() throws TransactionException {

	}

	public void rollback() throws TransactionException {

	}

	public void finish() throws TransactionException {

	}

	public void setTransactional(boolean transactional) {

	}

	public void setRequestTransactional(boolean transactional) {

	}

	public void setCommitsTransaction(boolean commits) {

	}

	public void saveFileMetadata(File file, long sequenceNumber,
			List<Field> modifiedFields) throws FileStorageException {
		saveFileMetadata(file, sequenceNumber);
	}

	public IDTuple copy(IDTuple source, String destFolder, File update,
			InputStream newFil, List<Field> modifiedFields)
			throws FileStorageException {
		File fileMetadata = new DefaultFile(getFileMetadata(source.getFolder(), source.getId(), CURRENT_VERSION));
		saveDocument(fileMetadata, getDocument(source.getFolder(), source.getId(), CURRENT_VERSION), DISTANT_FUTURE);
		return new IDTuple(fileMetadata.getFolderId(), fileMetadata.getId());
	}

	public void saveDocument(File file, InputStream data, long sequenceNumber,
			List<Field> modifiedFields) throws FileStorageException {
		saveDocument(file, data, sequenceNumber);
	}



	public int[] removeVersion(String folderId, String id, int[] versions)
			throws FileStorageException {
		return new int[0];
	}

	public void unlock(String folderId, String id) throws FileStorageException {

	}

	public void lock(String folderId, String id, long diff)
			throws FileStorageException {

	}

	public void touch(String folderId, String id) throws FileStorageException {

	}


	public TimedResult<File> getDocuments(String folderId, List<Field> fields)
			throws FileStorageException {
		return getDocuments(folderId);
	}

	public TimedResult<File> getDocuments(String folderId, List<Field> fields,
			Field sort, SortDirection order) throws FileStorageException {
		TimedResult<File> documents = getDocuments(folderId, fields);
		if (!fields.contains(sort)) {
			fields = new ArrayList<Field>(fields);
			fields.add(sort);
		}
		return sortTimedResult(sort, order, documents);
	}

	private TimedResult<File> sortTimedResult(Field sort, SortDirection order,
			TimedResult<File> documents) throws FileStorageException {
		List<File> files = null;
		try {
			SearchIterator<File> results = documents.results();
			files = SearchIteratorAdapter.toList(results);
			
		} catch (AbstractOXException e) {
			throw new FileStorageException(e);
		}
		if (sort != null) {
			order.sort(files, sort);
		}
		
		return new AbstractTimedResult<File>(new SearchIteratorAdapter<File>(files.iterator())) {

			@Override
			protected long extractTimestamp(File object) {
				return object.getLastModified().getTime();
			}
		};
	}

	public TimedResult<File> getVersions(String folderId, String id)
			throws FileStorageException {
		return Results.emptyTimedResult();
	}

	public TimedResult<File> getVersions(String folderId, String id,
			List<Field> fields) throws FileStorageException {
		return getVersions(folderId, id);
	}

	public TimedResult<File> getVersions(String folderId, String id,
			List<Field> fields, Field sort, SortDirection order)
			throws FileStorageException {
		
		if (!fields.contains(sort)) {
			fields = new ArrayList<Field>(fields);
			fields.add(sort);
		}
		
		TimedResult<File> versions = getVersions(folderId, id, fields);
		
		return sortTimedResult(sort, order, versions);
	}

	public TimedResult<File> getDocuments(List<IDTuple> ids, List<Field> fields)
			throws FileStorageException {
		final Iterator<IDTuple> iterator = ids.iterator();
		
		return new AbstractTimedResult<File>(new SearchIterator<File>() {
			
			public boolean hasNext() throws AbstractOXException {
				return iterator.hasNext();
			}

			public File next() throws AbstractOXException {
				IDTuple next = iterator.next();
				
				return getFileMetadata(next.getFolder(), next.getId(), CURRENT_VERSION);
			}

			public void close() throws AbstractOXException {
				
			}

			public int size() {
				return -1;
			}

			public boolean hasWarnings() {
				return false;
			}

			public void addWarning(AbstractOXException warning) {
				
			}

			public AbstractOXException[] getWarnings() {
				return null;
			}
			
		}) {

			@Override
			protected long extractTimestamp(File object) {
				return object.getLastModified().getTime();
			}
		};
	}

	public Delta<File> getDelta(String folderId, long updateSince,
			List<Field> fields, boolean ignoreDeleted)
			throws FileStorageException {
		return Results.emptyDelta();
	}

	public Delta<File> getDelta(String folderId, long updateSince,
			List<Field> fields, Field sort, SortDirection order,
			boolean ignoreDeleted) throws FileStorageException {
		return Results.emptyDelta();
	}

	public SearchIterator<File> search(String pattern, List<Field> fields,
			String folderId, Field sort, SortDirection order, int start, int end)
			throws FileStorageException {
		return SearchIteratorAdapter.emptyIterator();
	}

	public FileStorageAccountAccess getAccountAccess() {
		return factory.getAccountAccess(accountId, session);
	}

}
