/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;

public class TNEF {
    public static int extractContent(TNEFInputStream in, String outputdir) throws IOException {
        return TNEF.extractContent(new Message(in), outputdir);
    }

    public static int extractContent(Message message, String outputdir) throws IOException {
        if (!outputdir.endsWith(File.separator)) {
            outputdir = outputdir + File.separator;
        }
        System.out.println("\nMessage Attributes:\n");
        List attributes = message.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            System.out.println(attributes.get(i).toString());
        }
        System.out.println("\nMessage Attachments:\n");
        List attachments = message.getAttachments();
        int count = 0;
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment attachment = (Attachment)attachments.get(i);
            System.out.println(attachment.toString());
            if (attachment.getNestedMessage() != null) {
                count += TNEF.extractContent(attachment.getNestedMessage(), outputdir);
                continue;
            }
            String attachFilename = attachment.getFilename();
            String filename = outputdir + (attachFilename == null ? "attachment" + ++count : attachFilename);
            System.out.println("\n>>> Writing attachment #" + count + " to " + filename + "\n");
            attachment.writeTo(filename);
        }
        System.out.println("\nWrote " + count + " attachments.");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: java net.freeutils.tnef.TNEF <tneffile> [outputdir]");
            System.out.println("\nexample: java net.freeutils.tnef.TNEF c:\\temp\\winmail.dat c:\\temp\\attachments");
            System.exit(1);
        }
        String tneffile = args[0];
        String outputdir = args.length < 2 ? "." : args[1];
        System.out.println("Processing TNEF file " + tneffile);
        System.out.println();
        RawInputStream ris = null;
        TNEFInputStream in = null;
        try {
            ris = new RawInputStream(tneffile);
            in = new TNEFInputStream(ris);
            TNEF.extractContent(in, outputdir);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Operation aborted.");
            System.exit(-1);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (ris != null) {
                    ris.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        System.out.println();
        System.out.println("Finished processing TNEF file " + tneffile);
    }
}

