/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class Message {
    List attributes = new ArrayList();
    List attachments = new ArrayList();

    public Message() {
    }

    public Message(TNEFInputStream in) throws IOException {
        this();
        this.read(in);
    }

    protected void read(TNEFInputStream in) throws IOException {
        Attr attr;
        Attachment attachment = null;
        block10: while ((attr = in.readAttr()) != null) {
            switch (attr.getLevel()) {
                case 2: {
                    switch (attr.getID()) {
                        case 36866: {
                            if (attachment != null) {
                                this.attachments.add(attachment);
                            }
                            attachment = new Attachment();
                            attachment.addAttribute(attr);
                            continue block10;
                        }
                        case 36869: {
                            MAPIProps props = new MAPIProps((RawInputStream)attr.getValue());
                            attachment.setMAPIProps(props);
                            continue block10;
                        }
                        case 32783: {
                            attachment.setRawData((RawInputStream)attr.getValue());
                            continue block10;
                        }
                        case 36865: {
                            RawInputStream data = (RawInputStream)attr.getValue();
                            String filename = TNEFUtils.removeTerminatingNulls(new String(data.toByteArray(), this.getOEMCodePage()));
                            attachment.setFilename(filename);
                            continue block10;
                        }
                    }
                    attachment.addAttribute(attr);
                    continue block10;
                }
                case 1: {
                    this.attributes.add(attr);
                    continue block10;
                }
            }
            throw new IOException("Invalid attribute level: " + attr.getLevel());
        }
        if (attachment != null) {
            this.attachments.add(attachment);
        }
    }

    public MAPIProps getMAPIProps() throws IOException {
        Attr attr = this.getAttribute(36867);
        return attr != null ? (MAPIProps)attr.getValue() : null;
    }

    public String getOEMCodePage() {
        Attr attr = this.getAttribute(36871);
        if (attr == null) {
            return null;
        }
        try {
            RawInputStream data = (RawInputStream)attr.getValue();
            return "Cp" + data.readU16();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public Attr getAttribute(int ID) {
        return Attr.findAttr(this.attributes, ID);
    }

    public List getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List attachments) {
        this.attachments = attachments;
    }

    public void addAttribute(Attr attr) {
        this.attributes.add(attr);
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("Message:");
        s.append("\n  Attributes:");
        for (i = 0; i < this.attributes.size(); ++i) {
            s.append("\n    ").append(this.attributes.get(i));
        }
        s.append("\n  Attachments:");
        for (i = 0; i < this.attachments.size(); ++i) {
            s.append("\n    ").append(this.attachments.get(i));
        }
        return s.toString();
    }
}

