/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import java.util.Date;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIValue {
    int type;
    RawInputStream rawData;

    public MAPIValue(int type, RawInputStream data, int length) throws IOException {
        if ((type & 0x1000) != 0) {
            throw new IllegalArgumentException("multivalue is not allowed in single MAPIValue");
        }
        this.type = type;
        this.rawData = new RawInputStream(data, 0L, (long)length);
        data.skip(length);
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return (int)this.rawData.getLength();
    }

    public byte[] getData() {
        byte[] b = null;
        try {
            b = this.rawData.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b;
    }

    public RawInputStream getRawData() throws IOException {
        return new RawInputStream(this.rawData);
    }

    public String toString() {
        try {
            Object o = this.getValue();
            if (o instanceof RawInputStream) {
                o = o.toString();
            } else if (o instanceof byte[]) {
                o = TNEFUtils.toHexString((byte[])o, 512);
            }
            return String.valueOf(o);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue() throws IOException {
        Object o = null;
        RawInputStream ris = new RawInputStream(this.rawData);
        try {
            switch (this.type) {
                case 1: {
                    return o;
                }
                case 2: {
                    o = new Short((short)ris.readU16());
                    return o;
                }
                case 3: {
                    o = new Integer((int)ris.readU32());
                    return o;
                }
                case 11: {
                    o = ris.readU32() != 0L;
                    return o;
                }
                case 4: {
                    o = new Float(Float.intBitsToFloat((int)ris.readU32()));
                    return o;
                }
                case 10: {
                    o = new Integer((int)ris.readU32());
                    return o;
                }
                case 7: 
                case 64: {
                    if (ris.getLength() != 8L) return o;
                    long time = ris.readU64();
                    time = time / 10L / 1000L;
                    o = new Date(time -= 11644473600000L);
                    return o;
                }
                case 5: {
                    o = new Double(Double.longBitsToDouble(ris.readU64()));
                    return o;
                }
                case 6: 
                case 20: {
                    o = new long[]{ris.readU32(), ris.readU32()};
                    return o;
                }
                case 72: {
                    o = ris.toByteArray();
                    return o;
                }
                case 30: {
                    o = ris.readString((int)ris.getLength());
                    return o;
                }
                case 31: {
                    o = ris.readStringUnicode((int)ris.getLength());
                    return o;
                }
                case 0: 
                case 258: {
                    o = ris;
                    ris = null;
                    return o;
                }
                case 13: {
                    GUID iid = new GUID(ris.readBytes(16));
                    o = ris;
                    ris = null;
                    if (!iid.equals(MAPIProp.IID_IMESSAGE)) return o;
                    o = new TNEFInputStream((RawInputStream)o);
                    return o;
                }
                default: {
                    throw new IOException("Unknown MAPI type: " + this.type);
                }
            }
        }
        finally {
            if (ris != null) {
                ris.close();
            }
        }
    }
}

