package com.openexchange.calendar.itip.generators.changes.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import com.openexchange.calendar.AppointmentDiff;
import com.openexchange.calendar.itip.Messages;
import com.openexchange.calendar.itip.generators.AttachmentMemory;
import com.openexchange.calendar.itip.generators.Sentence;
import com.openexchange.calendar.itip.generators.changes.ChangeDescriptionGenerator;
import com.openexchange.groupware.AbstractOXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;

public class Attachments implements ChangeDescriptionGenerator {

	private AttachmentMemory memory;
	
	
	public Attachments(AttachmentMemory memory) {
		this.memory = memory;
	}
	
	public String[] getFields() {
		return null;
	}

	public List<Sentence> getDescriptions(Context ctx, Appointment original,
			Appointment updated, AppointmentDiff diff, Locale locale,
			TimeZone timezone) throws AbstractOXException {
		List<Sentence> sentences = new ArrayList<Sentence>(1);
		if (memory.hasAttachmentChanged(updated.getObjectID(), ctx.getContextId())) {
			sentences.add(new Sentence(Messages.ATTACHMENTS_CHANGED));
		}
		return sentences;
	}

}
