package com.openexchange.calendar.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import com.openexchange.api.OXObjectNotFoundException;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.api2.OXException;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.AppointmentSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;

public class TransactionallyCachingCalendar implements AppointmentSQLInterface {
	private AppointmentSQLInterface delegate;
	private Map<Integer, CalendarDataObject> cached = new HashMap<Integer, CalendarDataObject>();

	public TransactionallyCachingCalendar(CalendarSql calendarSql) {
		this.delegate = calendarSql;
	}

	public void setIncludePrivateAppointments(boolean include) {
		delegate.setIncludePrivateAppointments(include);
	}

	public boolean getIncludePrivateAppointments() {
		return delegate.getIncludePrivateAppointments();
	}

	public SearchIterator<Appointment> getAppointmentsBetweenInFolder(
			int folderId, int[] cols, Date start, Date end, int orderBy,
			Order order) throws OXException, SQLException {
		return delegate.getAppointmentsBetweenInFolder(folderId, cols, start,
				end, orderBy, order);
	}

	public SearchIterator<Appointment> getAppointmentsBetweenInFolder(
			int folderId, int[] cols, Date start, Date end, int from, int to,
			int orderBy, Order orderDir) throws OXException, SQLException {
		return delegate.getAppointmentsBetweenInFolder(folderId, cols, start,
				end, from, to, orderBy, orderDir);
	}

	public boolean[] hasAppointmentsBetween(Date start, Date end)
			throws OXException {
		return delegate.hasAppointmentsBetween(start, end);
	}

	public SearchIterator<Appointment> getModifiedAppointmentsInFolder(int fid,
			int[] cols, Date since) throws OXException {
		return delegate.getModifiedAppointmentsInFolder(fid, cols, since);
	}

	public SearchIterator<Appointment> getModifiedAppointmentsBetween(
			int userId, Date start, Date end, int[] cols, Date since,
			int orderBy, Order orderDir) throws OXException, SQLException {
		return delegate.getModifiedAppointmentsBetween(userId, start, end,
				cols, since, orderBy, orderDir);
	}

	public SearchIterator<Appointment> getModifiedAppointmentsInFolder(int fid,
			Date start, Date end, int[] cols, Date since) throws OXException,
			SQLException {
		return delegate.getModifiedAppointmentsInFolder(fid, start, end, cols,
				since);
	}

	public SearchIterator<Appointment> getDeletedAppointmentsInFolder(
			int folderId, int[] cols, Date since) throws OXException,
			SQLException {
		return delegate.getDeletedAppointmentsInFolder(folderId, cols, since);
	}

	public SearchIterator<Appointment> getAppointmentsByExtendedSearch(
			AppointmentSearchObject searchObject, int orderBy, Order orderDir,
			int[] cols) throws OXException, SQLException {
		return delegate.getAppointmentsByExtendedSearch(searchObject, orderBy,
				orderDir, cols);
	}

	public SearchIterator<Appointment> searchAppointments(
			AppointmentSearchObject searchObj, int orderBy, Order orderDir,
			int[] cols) throws OXException {
		return delegate.searchAppointments(searchObj, orderBy, orderDir, cols);
	}

	public CalendarDataObject getObjectById(int objectId) throws OXException,
			SQLException, OXObjectNotFoundException {
		CalendarDataObject cachedAppointment = cached.get(objectId);
		if (cachedAppointment != null) {
			return cachedAppointment.clone();
		}
		CalendarDataObject loaded = delegate.getObjectById(objectId);
		cached.put(objectId, loaded);
		return loaded;
	}

	public CalendarDataObject getObjectById(int objectId, int inFolder)
			throws OXException, SQLException, OXObjectNotFoundException {
		return delegate.getObjectById(objectId, inFolder);
	}

	public SearchIterator<Appointment> getObjectsById(
			int[][] objectIdAndInFolder, int[] cols) throws OXException {
		return delegate.getObjectsById(objectIdAndInFolder, cols);
	}

	public Appointment[] insertAppointmentObject(CalendarDataObject cdao)
			throws OXException {
		return delegate.insertAppointmentObject(cdao);
	}

	public Appointment[] updateAppointmentObject(CalendarDataObject cdao,
			int inFolder, Date clientLastModified) throws OXException {
		cached.remove(cdao.getObjectID());
		return delegate.updateAppointmentObject(cdao, inFolder,
				clientLastModified);
	}

	public Appointment[] updateAppointmentObject(CalendarDataObject cdao,
			int inFolder, Date clientLastModified, boolean checkPermissions)
			throws OXException {
		cached.remove(cdao.getObjectID());
		return delegate.updateAppointmentObject(cdao, inFolder,
				clientLastModified, checkPermissions);
	}

	public void deleteAppointmentObject(CalendarDataObject appointmentObject,
			int inFolder, Date clientLastModified) throws OXException {
		cached.remove(appointmentObject.getObjectID());
		delegate.deleteAppointmentObject(appointmentObject, inFolder,
				clientLastModified);
	}

	public void deleteAppointmentObject(CalendarDataObject appointmentObject,
			int inFolder, Date clientLastModified, boolean checkPermissions)
			throws OXException {
		cached.remove(appointmentObject.getObjectID());
		delegate.deleteAppointmentObject(appointmentObject, inFolder,
				clientLastModified, checkPermissions);
	}

	public void deleteAppointmentsInFolder(int inFolder) throws OXException,
			SQLException {
		cached.clear();
		delegate.deleteAppointmentsInFolder(inFolder);
	}

	public void deleteAppointmentsInFolder(int inFolder, Connection writeCon)
			throws OXException, SQLException {
		cached.clear();
		delegate.deleteAppointmentsInFolder(inFolder, writeCon);
	}

	public boolean checkIfFolderContainsForeignObjects(int user_id, int inFolder)
			throws OXException, SQLException {
		return delegate.checkIfFolderContainsForeignObjects(user_id, inFolder);
	}

	public boolean checkIfFolderContainsForeignObjects(int user_id,
			int inFolder, Connection readCon) throws OXException, SQLException {
		return delegate.checkIfFolderContainsForeignObjects(user_id, inFolder,
				readCon);
	}

	public boolean isFolderEmpty(int uid, int fid) throws OXException,
			SQLException {
		return delegate.isFolderEmpty(uid, fid);
	}

	public boolean isFolderEmpty(int uid, int fid, Connection readCon)
			throws OXException, SQLException {
		return delegate.isFolderEmpty(uid, fid, readCon);
	}

	public Date setUserConfirmation(int object_id, int folderId, int user_id,
			int confirm, String confirm_message) throws OXException {
		cached.remove(object_id);
		return delegate.setUserConfirmation(object_id, folderId, user_id,
				confirm, confirm_message);
	}

	public Date setExternalConfirmation(int oid, int folderId, String mail,
			int confirm, String message) throws OXException {
		cached.remove(oid);
		return delegate.setExternalConfirmation(oid, folderId, mail, confirm,
				message);
	}

	public long attachmentAction(int objectId, int uid, int folderId,
			Session session, Context c, int numberOfAttachments)
			throws OXException {
		cached.remove(objectId);
		return delegate.attachmentAction(objectId, uid, folderId, session, c,
				numberOfAttachments);
	}

	public SearchIterator<Appointment> getFreeBusyInformation(int id, int type,
			Date start, Date end) throws OXException {
		return delegate.getFreeBusyInformation(id, type, start, end);
	}

	public SearchIterator<Appointment> getActiveAppointments(int user_uid,
			Date start, Date end, int[] cols) throws OXException {
		return delegate.getActiveAppointments(user_uid, start, end, cols);
	}

	public SearchIterator<Appointment> getAppointmentsBetween(int user_uid,
			Date start, Date end, int[] cols, int orderBy, Order order)
			throws OXException, SQLException {
		return delegate.getAppointmentsBetween(user_uid, start, end, cols,
				orderBy, order);
	}
    
    public SearchIterator<Appointment> getAppointmentsBetween(Date start, Date end, int cols[], int orderBy, Order order) throws OXException, SQLException {
        return delegate.getAppointmentsBetween(start, end, cols, orderBy, order);
    }

	public int resolveUid(String uid) throws OXException {
		return delegate.resolveUid(uid);
	}

	public int getFolder(int objectId) throws OXException {
		return delegate.getFolder(objectId);
	}
	
	
}
