/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Deployable;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuilder
extends DescriptionBuilder {
    private AxisModule module;

    public ModuleBuilder(InputStream serviceInputStream, AxisModule module, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
        this.module = module;
    }

    private void loadModuleClass(AxisModule module, String moduleClassName) throws DeploymentException {
        block4: {
            try {
                Class moduleClass;
                if (moduleClassName == null || "".equals(moduleClassName)) break block4;
                final Class fmoduleClass = moduleClass = Loader.loadClass(module.getModuleClassLoader(), moduleClassName);
                final AxisModule fmodule = module;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IllegalAccessException, InstantiationException {
                            Module new_module = (Module)fmoduleClass.newInstance();
                            fmodule.setModule(new_module);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    public void populateModule() throws DeploymentException {
        try {
            OMElement localPolicyAssertionElement;
            OMElement supportedPolicyNamespaces;
            OMElement outFaultFlow;
            OMElement inFaultFlow;
            OMElement outFlow;
            OMElement inFlow;
            Iterator policyRefElements;
            OMElement descriptionElement;
            String moduleName;
            OMAttribute nameAtt;
            String moduleClass;
            OMElement moduleElement = this.buildOM();
            OMAttribute moduleClassAtt = moduleElement.getAttribute(new QName("class"));
            Iterator itr = moduleElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.module, this.module.getParent());
            Parameter childFirstClassLoading = this.module.getParameter("EnableChildFirstClassLoading");
            if (childFirstClassLoading != null) {
                DeploymentClassLoader deploymentClassLoader = (DeploymentClassLoader)this.module.getModuleClassLoader();
                if (JavaUtils.isTrueExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(true);
                } else if (JavaUtils.isFalseExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(false);
                }
            }
            if (moduleClassAtt != null && (moduleClass = moduleClassAtt.getAttributeValue()) != null && !"".equals(moduleClass)) {
                this.loadModuleClass(this.module, moduleClass);
            }
            if ((nameAtt = moduleElement.getAttribute(new QName("name"))) != null && (moduleName = nameAtt.getAttributeValue()) != null && !"".equals(moduleName)) {
                this.module.setName(moduleName);
            }
            if ((descriptionElement = moduleElement.getFirstChildWithName(new QName("Description"))) != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize((Writer)writer);
                    writer.flush();
                    this.module.setModuleDescription(writer.toString());
                } else {
                    this.module.setModuleDescription(descriptionElement.getText());
                }
            } else {
                this.module.setModuleDescription("module description not found");
            }
            Iterator phaseItr = moduleElement.getChildrenWithName(new QName("phase"));
            this.processModulePhase(phaseItr);
            Iterator policyElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, this.module.getPolicySubject());
            }
            if ((policyRefElements = moduleElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null && policyElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, this.module.getPolicySubject());
            }
            if ((inFlow = moduleElement.getFirstChildWithName(new QName("InFlow"))) != null) {
                this.module.setInFlow(this.processFlow(inFlow, this.module));
            }
            if ((outFlow = moduleElement.getFirstChildWithName(new QName("OutFlow"))) != null) {
                this.module.setOutFlow(this.processFlow(outFlow, this.module));
            }
            if ((inFaultFlow = moduleElement.getFirstChildWithName(new QName("InFaultFlow"))) != null) {
                this.module.setFaultInFlow(this.processFlow(inFaultFlow, this.module));
            }
            if ((outFaultFlow = moduleElement.getFirstChildWithName(new QName("OutFaultFlow"))) != null) {
                this.module.setFaultOutFlow(this.processFlow(outFaultFlow, this.module));
            }
            if ((supportedPolicyNamespaces = moduleElement.getFirstChildWithName(new QName("supported-policy-namespaces"))) != null) {
                this.module.setSupportedPolicyNamespaces(this.processSupportedPolicyNamespaces(supportedPolicyNamespaces));
            }
            if ((localPolicyAssertionElement = moduleElement.getFirstChildWithName(new QName("local-policy-assertions"))) != null) {
                this.module.setLocalPolicyAssertions(this.getLocalPolicyAssertionNames(localPolicyAssertionElement));
            }
            Iterator op_itr = moduleElement.getChildrenWithName(new QName("operation"));
            ArrayList<AxisOperation> operations = this.processOperations(op_itr);
            for (AxisOperation op : operations) {
                this.module.addOperation(op);
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        catch (AxisFault e) {
            throw new DeploymentException(e);
        }
    }

    private ArrayList<AxisOperation> processOperations(Iterator operationsIterator) throws DeploymentException {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            Iterator policyRefElements;
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            String opname = operation.getAttributeValue(new QName("name"));
            if (opname == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            String mepURL = operation.getAttributeValue(new QName("mep"));
            if (mepURL == null) {
                op_descrip = new InOnlyAxisOperation();
            } else {
                try {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepURL);
                }
                catch (AxisFault axisFault) {
                    throw new DeploymentException(Messages.getMessage(Messages.getMessage("op_error", axisFault.getMessage())));
                }
            }
            op_descrip.setName(new QName(opname));
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, op_descrip, this.module);
            this.processActionMappings(operation, op_descrip);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.module.getModuleClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(mepURL, null);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            Iterator policyElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, op_descrip.getPolicySubject());
            }
            if ((policyRefElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, this.module.getPolicySubject());
            }
            PhasesInfo info = this.axisConfig.getPhasesInfo();
            try {
                info.setOperationPhases(op_descrip);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
            operations.add(op_descrip);
        }
        return operations;
    }

    private void processModulePhase(Iterator phases) throws AxisFault {
        if (phases == null) {
            return;
        }
        while (phases.hasNext()) {
            String[] flows;
            String flowName;
            String before;
            OMElement element = (OMElement)phases.next();
            String phaseName = element.getAttributeValue(new QName("name"));
            Deployable d = new Deployable(phaseName);
            String after = element.getAttributeValue(new QName("after"));
            if (after != null) {
                String[] afters;
                for (String s : afters = after.split(",")) {
                    d.addPredecessor(s);
                }
            }
            if ((before = element.getAttributeValue(new QName("before"))) != null) {
                String[] befores;
                for (String s : befores = before.split(",")) {
                    d.addSuccessor(s);
                }
            }
            if ((flowName = element.getAttributeValue(new QName("flow"))) == null) {
                throw new DeploymentException("Flow can not be null for the phase name " + phaseName);
            }
            for (String flow : flows = flowName.split(",")) {
                int flowIndex;
                if ("InFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 1;
                } else if ("OutFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 2;
                } else if ("OutFaultFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 4;
                } else if ("InFaultFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 3;
                } else {
                    throw new DeploymentException("Unknown flow name '" + flow + "'");
                }
                this.axisConfig.insertPhase(d, flowIndex);
            }
        }
    }
}

