
# norootforbuild
%define         configfiles     configfiles.list

Name:           open-xchange-admin
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant open-xchange-server >= 6.20.8.0 open-xchange-sql >= 6.20.8.0
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
Version:	6.20.8.0
%define		ox_release 0
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        The Open-Xchange Admin Daemon
Requires:	open-xchange-admin-lib >= 6.20.8.0
Requires:	open-xchange >= 6.20.8.0 open-xchange-publish-basic >= 6.20.8.0 open-xchange-subscribe >= 6.20.8.0 open-xchange-config-cascade >= 6.20.8.0 open-xchange-config-cascade-context >= 6.20.8.0 open-xchange-config-cascade-user >= 6.20.8.0
%if 0%{?suse_version}
Requires:  mysql-client >= 5.0.0
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:  mysql >= 5.0.0
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
#

%package -n	open-xchange-admin-client
Group:          Applications/Productivity
Summary:	The Open Xchange Admin Daemon RMI client library
Requires:       open-xchange-admin >= 6.20.8.0


%description -n open-xchange-admin-client
The Open Xchange Admin Daemon RMI client library

Authors:
--------
    Open-Xchange

%package -n	open-xchange-admin-lib
Group:          Applications/Productivity
Summary:	The Open Xchange Admin Daemon Bundle client library
Requires:       open-xchange-server >= 6.20.8.0


%description -n open-xchange-admin-lib
The Open Xchange Admin Daemon Bundle client library

Authors:
--------
    Open-Xchange

%package -n	open-xchange-admin-doc
Group:          Applications/Productivity
Summary:	Documentation for the Open Xchange RMI client library.


%description -n open-xchange-admin-doc
Documentation for the Open Xchange RMI client library.

Authors:
--------
    Open-Xchange



%description
Open Xchange Admin Daemon containing commandline tools and provisioning
interface to manage users, groups, resources and Open Xchange database and
storage related setup information.

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
mkdir -p %{buildroot}/sbin

ant -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange -Ddistribution=lsb doc install
ant -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange -Ddistribution=lsb install-client
ant -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange -Ddistribution=lsb install-bundle
mv doc javadoc
ln -sf ../etc/init.d/open-xchange-admin %{buildroot}/sbin/rcopen-xchange-admin

rm -f %{configfiles}
find %{buildroot}/opt/open-xchange/etc/admindaemon \
        -maxdepth 1 -type f \
        -not -name mpasswd \
        -printf "%%%config(noreplace) %p\n" > %{configfiles}
perl -pi -e 's;%{buildroot};;' %{configfiles}
perl -pi -e 's;(^.*?)\s+(.*/configdb\.properties)$;$1 %%%attr(640,root,root) $2;' %{configfiles}
cat %{configfiles}

%clean
%{__rm} -rf %{buildroot}

%post


if [ ${1:-0} -eq 2 ]; then
   # only when updating
   . /opt/open-xchange/etc/oxfunctions.sh

   GLOBIGNORE='*'

   # SoftwareChange_Request-884
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/system.properties
   if ! ox_exists_property com.openexchange.config.cascade.scopes $pfile; then
       ox_set_property com.openexchange.config.cascade.scopes "user, context, contextSets, server" $pfile
   fi

   # Bugfix #20726
   pfile=/opt/open-xchange/etc/admindaemon/User.properties
   tmpf=/opt/open-xchange/etc/admindaemon/User.properties.$$
   if grep "_DE_DE=Apstiprin" > /dev/null $pfile; then
        grep -v "_DE_DE=Apstiprin" $pfile > $tmpf
        mv $tmpf $pfile
   fi

   # SoftwareChange_Request-834
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
   for key in jcs.region.Filestore.cacheattributes.MaxMemoryIdleTimeSeconds \
         jcs.region.Filestore.elementattributes.IdleTime \
         jcs.region.OXDBPoolCache.cacheattributes.MaxMemoryIdleTimeSeconds \
         jcs.region.OXDBPoolCache.elementattributes.IdleTime; do
         val=$(ox_read_property $key $pfile)
         if [ "$val" != "360" ]; then
             ox_set_property $key "360" $pfile
         fi
   done
   for key in jcs.region.Filestore.elementattributes.MaxLifeSeconds \
         jcs.region.OXDBPoolCache.elementattributes.MaxLifeSeconds; do
         val=$(ox_read_property $key $pfile)
         if [ "$val" != "-1" ]; then
             ox_set_property $key "-1" $pfile
         fi
   done

   # SoftwareChange_Request-833
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
   for key in jcs.region.User.cacheattributes.MaxMemoryIdleTimeSeconds \
         jcs.region.User.elementattributes.IdleTime \
         jcs.region.UserConfiguration.cacheattributes.MaxMemoryIdleTimeSeconds \
         jcs.region.UserConfiguration.elementattributes.IdleTime \
         jcs.region.Context.cacheattributes.MaxMemoryIdleTimeSeconds \
         jcs.region.Context.elementattributes.IdleTime; do
         val=$(ox_read_property $key $pfile)
         if [ "$val" != "360" ]; then
             ox_set_property $key "360" $pfile
         fi
   done
   val=$(ox_read_property jcs.auxiliary.LTCP.attributes.IssueRemoveOnPut $pfile)
   if [ "$val" != "false" ]; then
         ox_set_property jcs.auxiliary.LTCP.attributes.IssueRemoveOnPut "false" $pfile
   fi

   # SoftwareChange_Request-830
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
   for key in jcs.region.Context.elementattributes.MaxLifeSeconds \
              jcs.region.User.elementattributes.MaxLifeSeconds \
              jcs.region.UserConfiguration.elementattributes.MaxLifeSeconds; do
         val=$(ox_read_property $key $pfile)
         if [ "$val" != "-1" ]; then
             ox_set_property $key "-1" $pfile
         fi
   done

   # bug 18298
   pfile=/opt/open-xchange/etc/admindaemon/ox-admin-scriptconf.sh
   if grep "OSGIBUNDLE" $pfile > /dev/null; then
      ox_remove_property OSGIBUNDLE $pfile
   fi

   # SoftwareChange_Request-579
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/User.properties
   if grep "Spam=" $pfile > /dev/null; then
      ox_set_property SPAM_MAILFOLDER_JA_JP "\u8FF7\u60D1\u30E1\u30FC\u30EB" $pfile
   fi

   # SoftwareChange_Request-542
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/User.properties
   if ox_exists_property DISPLAYNAME_UNIQUE $pfile; then
      ox_remove_property DISPLAYNAME_UNIQUE $pfile
   fi

   # -----------------------------------------------------------------------
   # bugfix id#16667
   # SoftwareChange_Request-587 IT_IT
   # SoftwareChange_Request-726 ZH_CN
   # SoftwareChange_Request-740 CS_CZ HU_HU
   # SoftwareChange_Request-777 SK_SK
   # # SoftwareChange_Request-872 LV_LV
   pfile=/opt/open-xchange/etc/admindaemon/User.properties
   ox_system_type
   type=$?
   if [ $type -eq $DEBIAN ]; then
      ofile="${pfile}.dpkg-dist"
   else
      ofile="${pfile}.rpmnew"
   fi
   if [ -n "$ofile" ] && [ -e "$ofile" ]; then
      for ll in JA_JP PL_PL IT_IT ZH_CN CS_CZ HU_HU SK_SK LV_LV; do
	  nl=
	  vstr="SENT_MAILFOLDER TRASH_MAILFOLDER DRAFTS_MAILFOLDER SPAM_MAILFOLDER CONFIRMED_SPAM_MAILFOLDER CONFIRMED_HAM_MAILFOLDER"
	  for pp in $vstr; do
	      llpp="${pp}_${ll}"
	      if ! ox_exists_property $llpp $pfile; then
		  if [ -z "$nl" ]; then
		      echo >> $pfile
		  fi
		  defv=$(ox_read_property $llpp $ofile)
		  ox_set_property $llpp "$defv" $pfile
		  nl=true
	      fi
	  done
      done
   fi

   # SoftwareChange_Request-282, SoftwareChange_Request-533, SoftwareChange_Request-645
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/ModuleAccessDefinitions.properties
   ox_system_type
   type=$?
   if [ $type -eq $DEBIAN ]; then
      ofile="${pfile}.dpkg-dist"
   else
      ofile="${pfile}.rpmnew"
   fi
   for prop in webmail pim pim_infostore pim_mobility groupware_standard groupware_premium; do
      if [ -n "$ofile" ] && [ -e "$ofile" ]; then
	  oval=$(ox_read_property $prop $ofile)
	  if [ -n "$oval" ]; then
	      ox_set_property $prop "$oval" $pfile
	  fi
      fi
   done

   # SoftwareChange_Request-194
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
   val=0$(ox_read_property jcs.region.User.cacheattributes.MaxObjects $pfile)
   if [ $val -lt 40000 ]; then
      ox_set_property jcs.region.User.cacheattributes.MaxObjects 40000 $pfile
   fi
   val=0$(ox_read_property jcs.region.UserConfiguration.cacheattributes.MaxObjects $pfile)
   if [ $val -lt 20000 ]; then
      ox_set_property jcs.region.UserConfiguration.cacheattributes.MaxObjects 20000 $pfile
   fi
   val=0$(ox_read_property jcs.region.UserSettingMail.cacheattributes.MaxObjects $pfile)
   if [ $val -lt 20000 ]; then
      ox_set_property jcs.region.UserSettingMail.cacheattributes.MaxObjects 20000 $pfile
   fi
   val=0$(ox_read_property jcs.region.OXDBPoolCache.cacheattributes.MaxObjects $pfile)
   if [ $val -lt 20000 ]; then
      ox_set_property jcs.region.OXDBPoolCache.cacheattributes.MaxObjects 20000 $pfile
   fi
   val=0$(ox_read_property jcs.region.MailAccount.cacheattributes.MaxObjects $pfile)
   if [ $val -lt 100000 ]; then
      ox_set_property jcs.region.MailAccount.cacheattributes.MaxObjects 100000 $pfile
   fi

  # SoftwareChange_Request-124
  # -----------------------------------------------------------------------
  pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
  grep jcs.region.GlobalFolderCache $pfile >/dev/null || {
cat<<EOF >> $pfile
# Pre-defined cache regions for global folder objects.
jcs.region.GlobalFolderCache=LTCP
jcs.region.GlobalFolderCache.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes
jcs.region.GlobalFolderCache.cacheattributes.MaxObjects=10000000
jcs.region.GlobalFolderCache.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache
jcs.region.GlobalFolderCache.cacheattributes.UseMemoryShrinker=true
# Disable MaxMemoryIdleTimeSeconds cause some entries can be eternal
# Shrinker removal works as follows:
# 1. Check 'Eternal', 'MaxLifeSeconds' AND 'IdleTime' for element-attribute-caused removal
# 2. Check 'MaxMemoryIdleTime' for cache-attribute-caused removal
jcs.region.GlobalFolderCache.cacheattributes.MaxMemoryIdleTimeSeconds=180
jcs.region.GlobalFolderCache.cacheattributes.ShrinkerIntervalSeconds=60
jcs.region.GlobalFolderCache.elementattributes=org.apache.jcs.engine.ElementAttributes
jcs.region.GlobalFolderCache.elementattributes.IsEternal=false
jcs.region.GlobalFolderCache.elementattributes.MaxLifeSeconds=300
jcs.region.GlobalFolderCache.elementattributes.IdleTime=180
jcs.region.GlobalFolderCache.elementattributes.IsSpool=false
jcs.region.GlobalFolderCache.elementattributes.IsRemote=false
jcs.region.GlobalFolderCache.elementattributes.IsLateral=false
EOF
}
  grep jcs.region.UserFolderCache $pfile >/dev/null || {
cat<<EOF >> $pfile
# Pre-defined cache regions for user-sensitive folder objects.
jcs.region.UserFolderCache=LTCP
jcs.region.UserFolderCache.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes
jcs.region.UserFolderCache.cacheattributes.MaxObjects=10000000
jcs.region.UserFolderCache.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache
jcs.region.UserFolderCache.cacheattributes.UseMemoryShrinker=true
# Disable MaxMemoryIdleTimeSeconds cause some entries can be eternal
# Shrinker removal works as follows:
# 1. Check 'Eternal', 'MaxLifeSeconds' AND 'IdleTime' for element-attribute-caused removal
# 2. Check 'MaxMemoryIdleTime' for cache-attribute-caused removal
jcs.region.UserFolderCache.cacheattributes.MaxMemoryIdleTimeSeconds=180
jcs.region.UserFolderCache.cacheattributes.ShrinkerIntervalSeconds=60
jcs.region.UserFolderCache.elementattributes=org.apache.jcs.engine.ElementAttributes
jcs.region.UserFolderCache.elementattributes.IsEternal=false
jcs.region.UserFolderCache.elementattributes.MaxLifeSeconds=300
jcs.region.UserFolderCache.elementattributes.IdleTime=180
jcs.region.UserFolderCache.elementattributes.IsSpool=false
jcs.region.UserFolderCache.elementattributes.IsRemote=false
jcs.region.UserFolderCache.elementattributes.IsLateral=false
EOF
}
  grep jcs.region.MailAccount $pfile >/dev/null || {
cat<<EOF >> $pfile
# Pre-defined cache region for mail account
jcs.region.MailAccount=LTCP
jcs.region.MailAccount.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes
jcs.region.MailAccount.cacheattributes.MaxObjects=1000
jcs.region.MailAccount.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache
jcs.region.MailAccount.cacheattributes.UseMemoryShrinker=true
jcs.region.MailAccount.cacheattributes.MaxMemoryIdleTimeSeconds=180
jcs.region.MailAccount.cacheattributes.ShrinkerIntervalSeconds=60
jcs.region.MailAccount.cacheattributes.MaxSpoolPerRun=500
jcs.region.MailAccount.elementattributes=org.apache.jcs.engine.ElementAttributes
jcs.region.MailAccount.elementattributes.IsEternal=false
jcs.region.MailAccount.elementattributes.MaxLifeSeconds=300
jcs.region.MailAccount.elementattributes.IdleTime=180
jcs.region.MailAccount.elementattributes.IsSpool=false
jcs.region.MailAccount.elementattributes.IsRemote=false
jcs.region.MailAccount.elementattributes.IsLateral=false
EOF
}

   # SoftwareChange_Request-70
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/admindaemon/system.properties
   if ox_exists_property configDB $pfile; then
      ox_remove_property configDB $pfile
   fi

   # -----------------------------------------------------------------------
   # bugfix id#12517
   pfile=/opt/open-xchange/etc/admindaemon/cache.ccf
   if ! ox_exists_property jcs.region.OXFolderCache.elementattributes.IsLateral $pfile; then
      ox_set_property jcs.region.OXFolderCache.elementattributes.IsLateral false $pfile
   else
      oldval=$(ox_read_property jcs.region.OXFolderCache.elementattributes.IsLateral $pfile)
      if [ "$oldval" != "false" ]; then
          ox_set_property jcs.region.OXFolderCache.elementattributes.IsLateral false $pfile
      fi
   fi

   pfile=/opt/open-xchange/etc/admindaemon/configdb.properties
   if ox_exists_property writeOnly $pfile; then
      wonly=$(ox_read_property writeOnly $pfile)
      if [ "$wonly" != "true" ]; then
         ox_set_property writeOnly true $pfile
      fi
   else
      ox_set_property writeOnly true $pfile
   fi

   # -----------------------------------------------------------------------
   # bugfix id#12576
   for pname in User Group; do
      pfile=/opt/open-xchange/etc/admindaemon/${pname}.properties
      ox_system_type
      type=$?
      if [ $type -eq $DEBIAN ]; then
	  ofile="${pfile}.dpkg-dist"
      else
	  ofile="${pfile}.rpmnew"
      fi
      if [ -n "$ofile" ] && [ -e "$ofile" ]; then
	  for ll in NL_NL SV_SV ES_ES; do
	      nl=
	      if [ "$pname" == "User" ]; then
		  vstr="SENT_MAILFOLDER TRASH_MAILFOLDER DRAFTS_MAILFOLDER SPAM_MAILFOLDER CONFIRMED_SPAM_MAILFOLDER CONFIRMED_HAM_MAILFOLDER"
	      else
		  vstr="DEFAULT_CONTEXT_GROUP"
	      fi
	      for pp in $vstr; do
		llpp="${pp}_${ll}"
		if ! ox_exists_property $llpp $pfile; then
		    if [ -z "$nl" ]; then
			echo >> $pfile
		    fi
		    defv=$(ox_read_property $llpp $ofile)
		    ox_set_property $llpp "$defv" $pfile
		    nl=true
		fi
	      done
	  done
      fi
   done

   ox_update_permissions "/opt/open-xchange/etc/admindaemon/configdb.properties" root:root 640
   ox_update_permissions "/opt/open-xchange/etc/admindaemon/mpasswd" root:root 640
fi



%files -f %{configfiles}
%defattr(-,root,root)
%dir /opt/open-xchange/etc/admindaemon
%dir /opt/open-xchange/etc/admindaemon/osgi
%dir /opt/open-xchange/etc/admindaemon/osgi/bundle.d
/etc/init.d/*
/sbin/*
%config(noreplace) %attr(600,root,root) /opt/open-xchange/etc/admindaemon/mpasswd
/opt/open-xchange/etc/admindaemon/mysql
/opt/open-xchange/etc/admindaemon/osgi/config.ini.template
/opt/open-xchange/etc/admindaemon/osgi/bundle.d/*


%files -n open-xchange-admin-client
%defattr(-,root,root)
%dir /opt/open-xchange/lib/
%dir /opt/open-xchange/sbin
/opt/open-xchange/lib/*
/opt/open-xchange/sbin/*

%files -n open-xchange-admin-lib
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*

%files -n open-xchange-admin-doc
%defattr(-,root,root)
%doc javadoc
%changelog
* Tue Jul 03 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21743: Retry on detected MySQL deadlock
* Fri May 04 2012 - marcus.klein@open-xchange.com
 - Fix for bug 21826: Logging every create, change and delete operation of contexts, users, groups and resources.
* Wed Apr 04 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21903/21904: Ensure IDN presentation of obtained E-Mail address
* Sun Mar 11 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21633: Honor mail account tables when changing names of mail standard folders (drafts, sent, trash, ...)
 - Fix for bug 21787: Using JavaMail tooling when composing LIST/LSUB commands
 - Fix for bug 21791: Improved error message if a published document has been deleted in the meantime
* Fri Feb 24 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21643: Fixed possible NoSuchElementException in Unified Mail
* Thu Feb 23 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21626: Resolving dependencies for IDN support
* Thu Feb 09 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21508: Checking for duplicate display name on user change
* Mon Feb 06 2012 - choeger@open-xchange.com
 - Fix for bug 14517: RMI javadoc broken
* Tue Jan 17 2012 - thorben.betten@open-xchange.com
 - Fix for 19846: Fixed extraction of host name out of a JDBC URL
* Fri Jan 13 2012 - thorben.betten@open-xchange.com
 - Fix for bug 20379: Don't fail listcontext CLI if a context cannot be loaded
* Thu Jan 12 2012 - thorben.betten@open-xchange.com
 - Fix for bug 21198: Checking for context existence on listuser invocation
* Mon Jan 02 2012 - marcus.klein@open-xchange.com
 - Fix for bug 21096: Installed bundle containing templating service description into administration daemon process.
 - Fix for bug 19809: Ignoring null values in group member list.
* Thu Dec 29 2011 - tobias.friedrich@open-xchange.com
 - Fix for bug 21083: Populating uid field during contact insertion for users 
* Wed Dec 14 2011 - thorben.betten@open-xchange.com
 - Fix for bug 20833: Dropping cached global address book folder on user creation
* Mon Dec 12 2011 - marcus.klein@open-xchange.com
 - Fix for bug 19764: Added a check if the client sent duplicate users for the delete multiple user request.
* Wed Dec 07 2011 - marcus.klein@open-xchange.com
 - Fix for bug 19733: Catching NumberFormatException when trying to get IMAP port.
* Thu Nov 10 2011 - marcus.klein@open-xchange.com
 - Fix for bug 20369: Removing publicFolderEditable permissions for non context administrator users.
 - Fix for bug 20635: Fixed with new solution for bug 20369.
* Mon Nov 07 2011 - marcus.klein@open-xchange.com
 - Fix for bug 20724: Corrected mail folder name properties for latvian.
* Fri Oct 28 2011 - marcus.klein@open-xchange.com
 - Fix for bug 20673: listcontext CLT now also outputs information about context attributes.
* Wed Sep 14 2011 - marcus.klein@open-xchange.com
 - Fix for bug 20335: Retry with one-by-one table creation if batch creation failed
* Fri Sep 09 2011 - marcus.klein@open-xchange.com
 - Fix for bug 19234: Writing fileAs for contacts when it is empty and the displayName is changed. Added update task to correct wrong
   contacts.
* Thu Jul 21 2011 - dennis.sieben@open-xchange.com
 - Bugfix #19913 - [L3] defaults for csv und direct user creation differ
* Thu Jun 30 2011 - marcus.klein@open-xchange.com
 - Bugfix #19653: Not starting administration daemon with GMT timezone anymore.
* Mon Jun 20 2011 - marcus.klein@open-xchange.com
 - Bugfix #19495: listfilestore now works again if server_id something else than 2.
* Thu Jun 16 2011 - thorben.betten@open-xchange.com
 - Bugfix #19492: Enhanced DatabaseService with a method to get a no-timeout connection for administrative access to contexts
* Thu Jun 09 2011 - thorben.betten@open-xchange.com
 - Bugfix #18481: Introduced config parameter to signal whether POP3 bundle is enabled or not
 - Bugfix #19438: Properly cleaning system-wide known folders from virtual tree tables
* Wed Jun 08 2011 - thorben.betten@open-xchange.com
 - Bugfix #19455: Introduced command-line parameter to switch off portal (--access-denied-portal)
* Fri Jun 03 2011 - marcus.klein@open-xchange.com
 - Added Czech and Hungarian translations for default mail folders.
* Tue May 24 2011 - marcus.klein@open-xchange.com
 - Bugfix #17858: Writing now a stack trace if a runtime exception occurs.
* Fri May 20 2011 - marcus.klein@open-xchange.com
 - Bugfix #19184: Improved Spanish name for the Spam folder.
* Wed May 11 2011 - tobias.prinz@open-xchange.com
 - Bugfix #19047: Chinese names for default mail folders have been added to User.properties
* Fri Apr 08 2011 - choeger@open-xchange.com
 - Bugfix #18880: createadmin of reseller package does not work when no masterpw set
* Thu Mar 31 2011 - marcus.klein@open-xchange.com
 - Bugfix #18788: Not dropping an existing schema if MySQL does not generate proper unique identifier.
* Thu Mar 31 2011 - martin.herfurth@open-xchange.com
 - Bugfix #18821: [L3] "changeaccessglobal" mentioned in Release Notes but
   isn't available on system
* Thu Mar 31 2011 - marcus.klein@open-xchange.com
 - Bugfix #18788: Using database connection without timeout to create new schemas.
* Wed Mar 16 2011 - marcus.klein@open-xchange.com
 - Bugfix #18666: CLT listuser is now capable to work with IPv6 IMAP and SMTP backends.
* Tue Mar 15 2011 - marcus.klein@open-xchange.com
 - Bugfix #16324: Supporting IPv6 addresses for IMAP and SMTP backend connections.
* Tue Mar 01 2011 - marcus.klein@open-xchange.com
 - Bugfix #18465: Compiling sources everywhere to Java5 compatible class files.
 - Bugfix #18479: OLOX2 should not be enabled for PIM mobility users.
* Thu Jan 27 2011 - marcus.klein@open-xchange.com
 - Added Italian translations for standard mail folder names.
* Thu Jan 20 2011 - marcus.klein@open-xchange.com
 - Bugfix #18029: Corrected ENGINE to InnoDB of a table in ConfigDB.
* Sun Jan 09 2011 - choeger@open-xchange.com
 - Bugfix #18298 - admin does not start after update
* Mon Dec 20 2010 - choeger@open-xchange.com
 - Bugfix #17849: An infostore folder named XXXXXX already exists below folder userstore SoftwareChange_Request-542: Removed
   DISPLAYNAME_UNIQUE
* Mon Dec 13 2010 - thorben.betten@open-xchange.com
 - Bugfix #17600: Added missing keys to contact tables
* Thu Dec 09 2010 - thorben.betten@open-xchange.com
 - Bugfix #17766: Made fields static to be accessible in a static method
* Wed Dec 08 2010 - thorben.betten@open-xchange.com
 - Bugfix #17762: Allowing "editpassword" module access for all module access combinations (webmail, pim, etc.)
* Mon Dec 06 2010 - francisco.laguna@open-xchange.com
 - Bugfix #17727: Make user attributes removable in CLT.
* Sat Oct 23 2010 - francisco.laguna@open-xchange.com
 - Bugfix #16844: Only update module access permissions on change call if they have been changed.
* Wed Sep 22 2010 - marcus.klein@open-xchange.com
 - Bugfix #16981: When listing context misses some filestore usage entry a hint is returned to update the corresponding schema.
* Mon Sep 06 2010 - choeger@open-xchange.com
 - Bugfix #16812: Updating on RHEL or SLES fails if admin modified
 /opt/open-xchange/etc/admindaemon/User.properties
* Tue Aug 24 2010 - marcus.klein@open-xchange.com
 - Bugfix #16576: Prefer command line password if environment password and command line password are defined.
* Tue Aug 10 2010 - choeger@open-xchange.com
 - Bugfix #16667: [L3] No Polish translations for default mail folders in User.properties
   added japanese and polish translations to configfile and added postinst code
* Fri Jul 30 2010 - marcus.klein@open-xchange.com
 - Bugfix #16608: Created prepared statements batches but only executed the last one. Now the complete batch is executed.
* Thu Jul 29 2010 - choeger@open-xchange.com
 - Bugfix #16586: Creating context via RMI without quota set throws NPE
* Tue Jul 27 2010 - dennis.sieben@open-xchange.com
 - Bugfix #16542: Timezone setting available twice in the command line help for createuser and changeuser
   - removed second Timezone setting
 - added CSV import option to createuser
* Tue Jul 27 2010 - marcus.klein@open-xchange.com
 - Bugfix #16166: Updating the last modified timestamp of all users added or removed to a group or being member of a created or deleted
   group.
* Wed Jul 21 2010 - marcus.klein@open-xchange.com
 - Bugfix #15999: Checking if for the user are some features enabled conflicting with a disabled global address book.
* Fri Jul 09 2010 - marcus.klein@open-xchange.com
 - Bugfix #16112: Administration daemon now writes the users display name into the fileAs attribute used by some clients.
* Thu Jul 08 2010 - karsten.will@open-xchange.com
 - Bugfix #15200 - [L3] After changing contextadmin password in the GUI pw not in sync with CLT
* Tue Jun 29 2010 - karsten.will@open-xchange.com
 - Bugfix #15762 - Enabled/Disabled features are ignored on user creation
* Wed Jun 23 2010 - marcus.klein@open-xchange.com
 - Bugfix #16353: Listing contexts now works with multiple threads to improve performance.
* Wed Jun 09 2010 - choeger@open-xchange.com
 - Bugfix #14500 - Warnings due to missing LSB information
  added LSB Headers to debian init-script, which are not interpreted at all...
* Thu Apr 15 2010 - tobias.prinz@open-xchange.com
 - Bugfix #15886 - Deleting a user should be logged within the admin logfile as INFO (not DEBUG as previous)
* Wed Apr 14 2010 - marcus.klein@open-xchange.com
 - Bugfix #15786: Checking if primary mail is changed before looking into database if that primary email already is used.
* Thu Apr 01 2010 - marcus.klein@open-xchange.com
 - Bugfix #15667: Ignoring user switchable beta flag when accessing the feature permissions.
* Mon Jan 11 2010 - choeger@open-xchange.com
 - Bugfix #15174:  Empty directory /opt/open-xchange/libexec is useless
* Mon Jan 11 2010 - choeger@open-xchange.com
 - Bugfix #14977:  Reset autocommit on connections before returning them.
* Fri Dec 18 2009 - marcus.klein@open-xchange.com
 - Bugfix #15077: Increased default max object count for some user related caches to increase performance in large contexts.
* Mon Dec 14 2009 - marcus.klein@open-xchange.com
 - Bugfix #15066: Removed mail account tables from list of created tables by sql scripts.
* Tue Dec 08 2009 - choeger@open-xchange.com
 - Bugfix #15045 -  missing common shell functions file
* Tue Dec 08 2009 - marcus.klein@open-xchange.com
 - Bugfix #14289: Toggling boolean value check to get it the correct way around when primary email is unchangeable.
* Wed Nov 25 2009 - marcus.klein@open-xchange.com
 - Bugfix #13634: Using same generic use checks as for creating normal users.
* Tue Nov 24 2009 - marcus.klein@open-xchange.com
 - Bugfix #14935: Fixed CLI parser to deal with trailing empty string
* Mon Nov 23 2009 - marcus.klein@open-xchange.com
 - Toggled the user permission bit for access to the global address book, so the user still has permission to it although the client may
   have no information about that permission bit.
 - Bugfix #14953: Correctly configuring disabled access to global address book when using access combination names.
* Wed Nov 04 2009 - marcus.klein@open-xchange.com
 - Bugfix #14773: Corrected SQL statement to find matching user.
* Mon Nov 02 2009 - marcus.klein@open-xchange.com
 - Bugfix #14510: Refusing start of administration daemon if master credentials are not configured properly.
* Fri Oct 30 2009 - thorben.betten@open-xchange.com
 - Bugfix #14730: Fixed command-line parsing
* Tue Oct 20 2009 - marcus.klein@open-xchange.com
 - Bugfix #14637: Creating a context is now as far as possible a transaction. This avoids breaking a schema.
* Mon Oct 05 2009 - marcus.klein@open-xchange.com
 - Bugfix #14631: Added 2 new columns for contact collector settings to schema creating SQL script.
* Mon Sep 07 2009 - marcus.klein@open-xchange.com
 - Bugfix #14458: Added user permission flags for USM and ActiveSync to all CLTs.
* Thu Sep 03 2009 - marcus.klein@open-xchange.com
 - Bugfix #14389: Administration daemon is now more resistant on context deletion if the context information is not complete.
 - Bugfix #14432: Added ActiveSync and USM to access combination all.
* Tue Sep 01 2009 - marcus.klein@open-xchange.com
 - Bugfix #14178: Additionally to check on the database a String.equals() check is added. The collation is changed to utf_8_bin on column
   uid of table login2user.
* Mon Aug 31 2009 - thorben.betten@open-xchange.com
 - Bugfix #14421: Added new virtual folder tables to SQL initialization scripts
* Fri Aug 28 2009 - marcus.klein@open-xchange.com
 - Bugfix #13874: Cached information where context is stored must be invalidated if context is removed.
* Thu Jul 30 2009 - dennis.sieben@open-xchange.com
 - Bugfix #14257: allpluginsloaded doesn't honor fragment bundles
     added handling for fragment bundles
* Mon Jul 27 2009 - marcus.klein@open-xchange.com
 - Bugfix #14213: Setting configuration file permissions to reduce readability to OX processes.
* Wed Jul 15 2009 - marcus.klein@open-xchange.com
 - Bugfix #14158: Setting attribute value to alias using the PreparedStatement instead of error prone quoting in SQL statement.
* Tue Jun 30 2009 - marcus.klein@open-xchange.com
 - Bugfix #13477: If a user is deleted a connection without timeout is used because a lot of data must be moved taking a lot of time.
* Fri Jun 26 2009 - marcus.klein@open-xchange.com
 - Bugfix #13951: Writing understandable exception to RMI client if database is updated.  
* Thu Jun 25 2009 - marcus.klein@open-xchange.com
 - Bugfix #13987: Removed using of general classes that are not available in command line tools.  
* Tue Jun 23 2009 - marcus.klein@open-xchange.com
 - Bugfix #13852: Adding OSGi services for creating and removing genconf, publish and subscribe tables to admin.
* Mon Jun 15 2009 - marcus.klein@open-xchange.com
 - Bugfix #6692: Renamed group 0 to "All users" and group 1 to "Standard group". An update task fixes values in the database.
* Fri Jun 12 2009 - marcus.klein@open-xchange.com
 - Bugfix #13849: Added missing primary mail account identifier when updating it.
* Thu May 28 2009 - dennis.sieben@open-xchange.com
 - Bugfix #13733: antispam plugin cannot be enabled via soap
     renamed variable inside of user object
* Thu May 21 2009 - dennis.sieben@open-xchange.com
 - Bugfix #13606: [L3] Admin doesn't provide parameters to edit a user's mail_upload quota settings
* Thu Apr 23 2009 - marcus.klein@open-xchange.com
 - Bugfix #13440: Clearing string values with the CLT can be done with an empty string.
* Tue Feb 24 2009 - choeger@open-xchange.com
 - Bugfix #12517: [L3] Foldercache does not synchronize properly
     set jcs.region.OXFolderCache.elementattributes.IsLateral=false on update
* Mon Feb 23 2009 - marcus.klein@open-xchange.com
 - Bugfix #13248: Checking existance of a group on already existing connection to prevent problems with not committed groups. 
* Fri Feb 20 2009 - thorben.betten@open-xchange.com
 - Bugfix #12791: Checking existence of user's default group prior to performing a storage insert
* Thu Jan 29 2009 - choeger@open-xchange.com
 - Bugfix ID#13087 Credentials cache not cleared when deleting a context
* Wed Jan 07 2009 - marcus.klein@open-xchange.com
 - Bugfix #12864: Only creating the statement if the available flag is set.
* Wed Jan 07 2009 - choeger@open-xchange.com
 - Bugfix ID#12576: add new translations for swedish, dutch and spanish with update
* Thu Dec 18 2008 - francisco.laguna@open-xchange.com
 - Bugfix ID#12576: Added translations for swedish, dutch and spanish to config files.
* Tue Dec 16 2008 - francisco.laguna@open-xchange.com
 - Bugfix ID#9782: Abort with an error on invalid values for boolean fields. Be clearer in describing allowed values for boolean fields.
 - Bugfix ID#12012: Added JAVA_XTRAOPTS to createcontext, createuser, oxreport, allpluginsloaded and showruntimestats scripts.
* Mon Dec 15 2008 - francisco.laguna@open-xchange.com
 - Bugfix ID#12052: Throw NoSuchContextException if authentication is not enough to stop a list user call.
* Thu Dec 11 2008 - thorben.betten@open-xchange.com
 - Bugfix ID#12585: Including mail attribute checks performed on user update on user
   creation, too
* Mon Dec 01 2008 - choeger@open-xchange.com
 - Bugfix ID#12643 API: listcontext does not work when authentication is disabled
* Tue Oct 28 2008 - marcus.klein@open-xchange.com
 - Bugfix #12392: Removed the creation of some tables only needed for OXEE.
* Tue Oct 28 2008 - dennis.sieben@open-xchange.com
 - guiPreferences can be set now through SOAP
* Mon Oct 27 2008 - choeger@open-xchange.com
 - Bugfix ID#12287 JAVA_OXCMD_OPTS option missing after upgrade from SP3 to
 SP4 in ox-admin-scriptconf.sh
* Thu Oct 23 2008 - choeger@open-xchange.com
 - Bugfix ID#12286: connection timeouts not added for admin configdb.properties
* Wed Oct 22 2008 - choeger@open-xchange.com
 - Bugfix ID#12288: admin system.properties not needed options kept
   from upgrade SP3 to SP3
 - Bugfix ID#12289: DEFAULT_PASSWORD_MECHANISM=SHA added to AdminDaemon.properties
* Tue Sep 23 2008 - marcus.klein@open-xchange.com
 - Bugfix #12207: Removed OX connection given to context storage.
* Tue Sep 09 2008 - choeger@open-xchange.com
 - Setting writeOnly to true per default on new and updated installations (postinst)
   (see Bug #11595)
* Tue Sep 09 2008 - thorben.betten@open-xchange.com
 - Bugfix ID#11526: Using javax.mail.InternetAddress class to parse address strings
* Wed Sep 03 2008 - choeger@open-xchange.com
 - added new option writeOnly to configdb to be able to
   eleminate any connections to database slave within server api calls
   (see Bug #11595)
* Mon Aug 25 2008 - choeger@open-xchange.com
 - Bugfix ID#12052 listuser on non existent context returns SQL error
* Tue Aug 12 2008 - choeger@open-xchange.com
 - 11722 update from SP3, wrong cache.ccf file for admin in system.properties
 - Bugfix ID#11855 default for access-edit-group access-edit-resource access-edit-password
  is on in cmdline help output
* Mon Aug 11 2008 - choeger@open-xchange.com
 - Bugfix ID#11892 ModuleAccessDefinitions.properties wrong for pim_plus
* Wed Aug 06 2008 - dennis.sieben@open-xchange.com
 - Bugfix #11847: rmi: NULL not accepted any more for auth
* Tue Jul 29 2008 - marcus.klein@open-xchange.com
 - Bugfix #11681: Removed a lot of .toString() in debug messages to prevent
   NullPointerExceptions.
 - Bugfix #11740: Checking for possible null value for guiPreferences attribute
   in User.equals method.
* Fri Jul 18 2008 - choeger@open-xchange.com
 - Bugfix ID#11682 [L3] NullPointerException when switching to debug mode for admin daemon
* Tue Jul 15 2008 - choeger@open-xchange.com
 - Bugfix #11642 RHEL5 Packages don't depend on Sun Java 1.5 and mysql-server
  Packages
 - Bugfix ID#11640 SP3->SP4 update fails for package open-xchange-admin-doc
* Thu Jul 10 2008 - choeger@open-xchange.com
 - RMI API Change:
   User.setTimezone and User.getTimezone now uses java.lang.String instead of java.util.TimeZone
 - Bugfix ID#11594 Unable to create a user via commandline tool when setting a timezone
 - Bugfix ID#11596 Installation fails on SLES10 64Bit
* Mon Jun 30 2008 - choeger@open-xchange.com
 - Bugfix ID#11401 module access changes only take affect after restarting the groupware
* Mon Jun 23 2008 - choeger@open-xchange.com
 - Bugfix ID#11437 ClassNotFoundException instead of real error code on SLES10
   nothing SLES specific; commandline clients do not know anything about mysql
   internal classes; fix: Do not wrap SQLExceptions.
* Wed Jun 11 2008 - choeger@open-xchange.com
 - Bugfix ID#11344 listuser fails with NoClassDefFoundError
 - Bugfix ID#11405 unable to set the password mechanism on commandline
* Mon Jun 02 2008 - marcus.klein@open-xchange.com
 - Bugfix #11327: Checking for possible null values in GUI configuration.
* Mon Jun 02 2008 - manuel.kraft@open-xchange.com
 - Bugfix #11094: no error message when cid is in remove lmappings remove list using changecontext
* Mon Apr 28 2008 - choeger@open-xchange.com
  - Bugfix ID#11139 "No admin user found in context" on changeuser execution
  - Bugfix ID#11179 deleteuser doesn't delete user configuration
  - Bugfix ID#11147 "Last modified from" should not be 0
  - Bugfix ID#11185 No protocol identifier created when adding a user with --imap/smtpserver attribute
* Mon Jan 21 2008 - dennis.sieben@open-xchange.com
  - Bugfix ID#10805 One PreparedStatement isn't closed in OXToolMySQLStorage
* Thu Dec 20 2007 - choeger@open-xchange.com
  - Bugfix ID#10659 [HEAD] "Object was not returned" in database pool after context operations
* Tue Dec 11 2007 - choeger@open-xchange.com
  - Bugfix ID#10596 using read connections results into permanent problems in replication scenarios
* Fri Dec 07 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#10577 [HEAD ]admin does breake Database replication
  - Bugfix ID#10578 [HEAD] setDefaultSenderAddress does not work in changeUser
* Tue Nov 13 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#10180 RuntimeExceptions aren't logged
  - Bugfix ID#10188 Everytime a write connection is used it should be checked if a rollback is made there
* Mon Nov 12 2007 - choeger@open-xchange.com
  - Bugfix ID#9835 [L3] hanging or long taking command line tools
* Thu Nov 08 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#10125 No rollback if filestore creation fails during createuser
* Wed Nov 07 2007 - manuel.kraft@open-xchange.com
  - Bugfix ID#10050 Database leftovers of deleted contexts
* Tue Nov 06 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#10072 L3: display name of contact blocks creation of new user
* Wed Oct 31 2007 - manuel.kraft@open-xchange.com
   - Bugfix ID#10005 [HEAD] Connections to database not returned in admindaemon
* Mon Oct 29 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9983 Changing user by name isn't running any more
* Tue Oct 23 2007 - manuel.kraft@open-xchange.com
   - Bugfix ID#9938 [HEAD] cache does not get invalidated when users are added to or removed from groups
* Tue Oct 23 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9620 RMI Api documentation lacks proper language handling description
* Thu Oct 18 2007 - manuel.kraft@open-xchange.com
   - Bugfix ID#9860 Unable to delete Contact: Context 30 Contact 2 on delete context
* Mon Oct 15 2007 - manuel.kraft@open-xchange.com
  - Bugfix ID#9806 [HEAD] username can't be changed
  - Bugfix ID#9805 [HEAD] No error message when username is going to be changed
* Fri Oct 12 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9786 L3: IMAP port is stripped from commandline
* Thu Oct 11 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9777 no adequate description of parameters
* Wed Oct 10 2007 - choeger@open-xchange.com
 - Bugfix ID#9767 [L3] changing admin password with disabled authentication does not work
* Mon Oct 08 2007 - manuel.kraft@open-xchange.com
 - Bugfix ID#9616 Deleted users are not removed from Global Addressbook in Outlook
* Wed Sep 26 2007 - choeger@open-xchange.com
  - Bugfix ID#9582 osgi/config.ini does not exist on upgrading the
  open-xchange-admin
* Thu Sep 20 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9592 Language is not in the output of listuser --csv CLT
* Tue Sep 11 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9362 <addmembers> should be <userid>
* Fri Sep 07 2007 - choeger@open-xchange.com
 - Bugfix #9235 Crypt implementation should be able to handle UTF-8
* Wed Sep 05 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9254 showruntimestats gives NullPointerException
* Fri Aug 31 2007 - choeger@open-xchange.com
  - Bugfix ID#9156 Malformed path to HTMLEntities.properties
* Wed Aug 22 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#9023 createcontext name should be added to lmappings
  - Bugfix ID#9047 createuser not needed parameter --name
  - Bugfix ID#9046 createuser text for --extendedoptions printed on sterr
  - Bugfix ID#9034 createcontext null printed instead of cid in case of error
  - Bugfix ID#8735 Some code clean open-xchange-admin
* Tue Aug 21 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#8998 --nonl not consistent
  - Bugfix ID#8985 createuser doesn't check --timezone format
* Tue Aug 21 2007 - choeger@open-xchange.com
  - Bugfix ID#8995 oxinstaller return value is always 0
    ox_set_property now checks whether propfile exists
* Mon Aug 20 2007 - manuel.kraft@open-xchange.com
 - Bugfix ID#8875 No email validation for /opt/open-xchange/sbin/createcontext
* Thu Aug 16 2007 - choeger@open-xchange.com
  - Bugfix ID#8895 Misleading server response if "listuser --csv" doesn't find any match
* Thu Aug 16 2007 - manuel.kraft@open-xchange.com
 - Bugfix ID#8839 "Virtual" PIM folders are not updated when changing users displayname
* Thu Aug 16 2007 - dennis.sieben@open-xchange.com
 - Bugfix ID#8830 if user is deleted and plugin error occures, no message is shown.
* Tue Aug 14 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#8802 no error message when display_name is changed
  - Bugfix ID#8837 'createuser' command line tool shows wrong default settings for modularization
* Tue Aug 07 2007 - choeger@open-xchange.com
 - Bugfix ID#8679 new admin does not work with log4j
* Tue Aug 07 2007 - dennis.sieben@open-xchange.com
  - Bugfix ID#8593 Operations by name not possible
  - Bugfix ID#8571 Problems with multiple unique displaynames for internal users
  - Bugfix ID#8703 listcontext has incorrect data-mapping
* Mon Aug 06 2007 - manuel.kraft@open-xchange.com
 - Bugfix ID#8694: Users which are downgraded to "Basic" are still able to create public folders.
* Thu Aug 02 2007 - choeger@open-xchange.com
  - Bugfix ID#8666 imapLogin field get lost after changing module access
  - Bugfix ID#8611 admindaemon must use groupware config files
    now only system.properties, configdb.properties and cache.ccf is part of
    open-xchange-admin. The rest is used from the groupware config files (see system.properties)
* Thu Jul 26 2007 - dennis.sieben@open-xchange.com
 - Bugfix ID#8553 CLT: After running CLT no reasonable message on console appear for user
* Wed Jul 25 2007 - choeger@open-xchange.com
 - Bugfix ID#8556 CLTs: <datevalue> not working in "createuser"
   fixed parsing of dates and added dateformat format environment options,
   see --environment commandline parameter for known options
* Wed Jul 11 2007 - choeger@open-xchange.com
 - Bugfix ID#8397 listgroup: "email" in csv output
* Wed Jul 11 2007 - manuel.kraft@open-xchange.com
 - Bugfix ID#8400 listresource: attribute available not in csv output
* Mon Jul 09 2007 - choeger@open-xchange.com
 - Bugfix ID#8336 Unable to change user using the changeuser script
* Thu Jul 05 2007 - choeger@open-xchange.com
 - Bugfix ID#7682 (user setup) deleted user is not automatically logged off (syntax error message is displayed)
* Mon Jul 02 2007 - choeger@open-xchange.com
 - Bugfix ID#8254 Cryptic error message when updatetask is started
* Wed Jun 27 2007 - manuel.kraft@open-xchange.com
  - Bugfix ID#8122 	RMI Authentication must be able to be switched off!
* Wed Jun 20 2007 - choeger@open-xchange.com
  - Bugfix ID#7310 createuser is not able to set imapLogin in user table
* Tue Jun 19 2007 - choeger@open-xchange.com
  - Bugfix ID#8076 German user created with english folders
* Mon Jun 18 2007 - choeger@open-xchange.com
 - Bugfix ID#7843 admin can only handle unix crypt in RMI auth
 - Bugfix ID#7757 (spam) spam training in GUI is available if spam is disabled for user
   added missing spam_trainer disable method
* Mon Jun 18 2007 - manuel.kraft@open-xchange.com
 - Bugfix #7833	  	Renaming a resource with the same mail address doesn't work
* Fri Jun 15 2007 - manuel.kraft@open-xchange.com
 - Bugfix #8019  	OXEE password of new created contexts is always secret
* Wed Jun 13 2007 - choeger@open-xchange.com
 - Bugfix ID#7972 Fresh install - admin cannot login
 - Bugfix ID#7803 FQDN is replaced by a DHCP value after installation
* Tue Jun 12 2007 - manuel.kraft@open-xchange.com
 - Bugfix #7886:  	Translation of "Spam"
* Tue Jun 12 2007 - dennis.sieben@open-xchange.com
 - Bugfix #7816: User: Error when explicitly adding a new user to Group users
* Mon Jun 11 2007 - dennis.sieben@open-xchange.com
 - Bugfix #7855: (umin) changing password of user imap is no longer available for user
* Tue Jun 05 2007 - choeger@open-xchange.com
 - Implemented context admin authentication caching
* Wed May 30 2007 - thorben.betten@open-xchange.com
 - Bugfix #7615: Setting equal size to VARCHAR field 'fname' in both tables
   'oxfolder_tree' and 'del_oxfolder_tree'
* Fri May 25 2007 - choeger@open-xchange.com
  - Bugfix ID#7568 alias can't be set without the need to set PRIMARY_MAIL or EMAIL1
* Mon May 21 2007 - choeger@open-xchange.com
  - Bugfix ID#7340 user create -> can add aliases which are not acceptable
  - Bugfix ID#7342 can create a group with invalid email address
* Fri May 18 2007 - manuel.kraft@open-xchange.com
  -  Bugfix ID#7345 After update, login as admin not possible
* Mon May 14 2007 - manuel.kraft@open-xchange.com
  -  Fixed check for invalid locate data in users language in user.Change()
* Fri May 11 2007 - manuel.kraft@open-xchange.com
  -  Bugfix ID#7186 Fixed property in foldercache.properties that a user can edit his own personal data via groupware interface!
  -	 Fixed invalid alias creation when client sends an alias array with "" data entries.
