/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.admin.console.util;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.openexchange.admin.console.AbstractTest;
import com.openexchange.admin.console.BasicCommandlineOptions;
import com.openexchange.admin.console.util.reason.CreateReason;

/**
 * @author cutmasta
 *
 */
public class CreateReasonTest extends AbstractTest {

    @Test
    public void testAddReason() {
        
        resetBuffers();
        new CreateReason(getAllOptionData()){
            protected void sysexit(int exitCode) {
                CreateReasonTest.this.returnCode = exitCode;
            }
        };
        
        assertTrue("Expected 0 as return code!",0==this.returnCode);
    }
    
    @Test
    public void testAddReasonWithInvalidCredentials() {
        
        resetBuffers();
        new CreateReason(getAllOptionDataWithInvalidCredentials()){
            protected void sysexit(int exitCode) {
                CreateReasonTest.this.returnCode = exitCode;
            }
        };
        
        assertTrue("Expected invalid credentials as return code!",BasicCommandlineOptions.SYSEXIT_INVALID_CREDENTIALS==this.returnCode);
    }
    
    @Test
    public void testAddReasonWithMissingOption() {
        
        resetBuffers();
        new CreateReason(getMissingOptionData()){
            protected void sysexit(int exitCode) {
                CreateReasonTest.this.returnCode = exitCode;
            }
        };
        
        assertTrue("Expected missing option as return code!",BasicCommandlineOptions.SYSEXIT_MISSING_OPTION==this.returnCode);
    }
    
    @Test
    public void testAddReasonWithUnknownOption() {
        
        resetBuffers();
        new CreateReason(getUnknownOptionData()){
            protected void sysexit(int exitCode) {
                CreateReasonTest.this.returnCode = exitCode;
            }
        };
        
        assertTrue("Expected unknown option as return code!",BasicCommandlineOptions.SYSEXIT_UNKNOWN_OPTION==this.returnCode);
    }
    
    public static String[] getAllOptionData(){
        String[] tmp = {OPTION_SUPER_ADMIN_USER, 
                OPTION_SUPER_ADMIN_PWD,
                "--reasontext=testcase-reason-"+System.currentTimeMillis()               
                };
        return tmp;
    }
    
    public static String[] getAllOptionDataWithInvalidCredentials(){
        String[] tmp = {OPTION_SUPER_ADMIN_USER+"_xyzfioiobar", 
                OPTION_SUPER_ADMIN_PWD+"_xyzfoobar",
                "--reasontext=testcase-reason-"+System.currentTimeMillis()               
                };
        return tmp;
    }
    
}
