/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FacebookException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlHelper {
    public static void printDom(Node n, String prefix, StringBuilder sb) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? outString + "'" + n.getTextContent().trim() + "'" : outString + n.getNodeName();
        sb.append(outString);
        sb.append("\n");
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            XmlHelper.printDom(children.item(i), prefix + "  ", sb);
        }
    }

    public static String extractString(Node d) {
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    public static int extractInt(Node doc) {
        if (doc == null) {
            return 0;
        }
        return Integer.parseInt(doc.getFirstChild().getTextContent());
    }

    public static Long extractLong(Node doc) {
        if (doc == null) {
            return 0L;
        }
        return Long.parseLong(doc.getFirstChild().getTextContent());
    }

    public static boolean extractBoolean(Node result) {
        if (result == null) {
            return false;
        }
        return 1 == XmlHelper.extractInt(result);
    }

    public static Document parseCallResult(Object rawResponse, DocumentBuilderFactory factory) throws FacebookException {
        if (rawResponse == null) {
            return null;
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader((String)rawResponse)));
            doc.normalizeDocument();
            XmlHelper.stripEmptyTextNodes(doc);
            return XmlHelper.parseCallResult(doc);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Trouble configuring XML Parser", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Trouble parsing XML from facebook", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Trouble parsing XML from facebook", ex);
        }
    }

    public static void stripEmptyTextNodes(Node n) {
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node c = children.item(i);
            if (!c.hasChildNodes() && c.getNodeType() == 3 && c.getTextContent().trim().length() == 0) {
                n.removeChild(c);
                --i;
                --length;
                children = n.getChildNodes();
                continue;
            }
            XmlHelper.stripEmptyTextNodes(c);
        }
    }

    public static Document parseCallResult(Document doc) throws FacebookException {
        NodeList errors = doc.getElementsByTagName("error_response");
        if (errors.getLength() > 0) {
            int errorCode = Integer.parseInt(errors.item(0).getFirstChild().getFirstChild().getTextContent());
            String message = errors.item(0).getFirstChild().getNextSibling().getTextContent();
            throw new FacebookException(errorCode, message);
        }
        return doc;
    }
}

