/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

var oUnreadCounterStorage = null;
var newFolderJson = new JSON();
var disableNodeActions = false; //Edit modus
var folderTreeFolderToMove = -1;
var configfolder;
var oMainFolderTree;
var nSelectedIdStorage = null;
var virtualFolderId = "__ox_virtualFolderNode";
var importFolderDestination = null;

function quickTreeUpdate() {
	oMainFolderTree.update();
	if (oUnreadCounterStorage) {
		oUnreadCounterStorage.update();
	}
}

function saveFolderStateInConfig(id) {      
    configSetKey('gui.FolderTreeState', oMainFolderTree.getState());
}

register("OX_Configuration_Load_Foldertree", loadFolderTree);
register('OX_Refresh', quickTreeUpdate);
registerView("configuration",
	function() {
		$("folder_tree").style.display="none";
	},
	null,
	function() {
		$("folder_tree").style.display="block";
	},
	null
);

var nTimeOutScrollTree;
function loadFolderTree(stateTree,nSelectedIdStorage) {
	var aFolderViewSettings = new Object();
	var aFolderViewSettingsBM = new Object();
	var disableOther=false;
	var oFolderTreeState = new Object();
	if (configContainsKey('gui.FolderTreeState')) oFolderTreeState = configGetKey('gui.FolderTreeState');	

	/**
	 * key handler, used to remove the virtual node if ESC
	 * has been pressed while entering a name!
	 */
	var fn_subfolder_keyHandler = function(event) {
		if (event == undefined || event.keyCode != 27) return;		
		var parentFolder = removeVirtualFolder(virtualFolderId);
		if (parentFolder) {
			oMainFolderTree.update_sub_tree(parentFolder);			
		}
	}	
    register("OX_Dummy", fn_subfolder_keyHandler);
	
    var submenu = new PopupMenu();
    
    var PIM = { calendar: 1, tasks: 1, contacts: 1, system: 1 };
    var mail = { mail: 1 };
    if (configContainsKey("modules.folderstorage")) {
    	PIM["mail"] = 1;
    	mail = PIM;
    }
    var items = {
        mail:      { name: "E-Mail"    /*i18n*/, when: mail },
        calendar:  { name: "Calendar"  /*i18n*/, when: PIM },
        tasks:     { name: "Tasks"     /*i18n*/, when: PIM },
        contacts:  { name: "Contacts"  /*i18n*/, when: PIM },
        infostore: { name: "InfoStore" /*i18n*/, when: { infostore: 1 } }
    };
    
    
    for (var i in items) (function(type) {
        var def = items[type];
        var key = "modules." + type + ".module";
        var item = new MenuItem(def.name,
            function() { contextAction(1, 0, this.getContext().data, type); });
        item.onShow = function() {
            this.setEnabled(   (this.getContext().type in def.when)
                            && configGetKey(key));
        };
        submenu.addItem(item);
    })(i);
    
    var menu = globalContextMenus.folders = new ContextMenu();
    var new_folder = new MenuItem("New subfolder"/*i18n*/, submenu);
    new_folder.setIcon("img/folder/newfolder.gif",
                       "img/folder/newfolder_d.gif");
    menu.addItem(new_folder);
    
    var subscribe = new MenuItem("Subscribe folder", /*i18n*/
        function() { SubscribeFolder.openWindow(); });
    menu.addItem(subscribe);    

    var link = new MenuItem("Send as link", /*i18n*/
        function() {           
            var myfolder=oMainFolderTree.get_folder_by_node_id(
                this.getContext().data.id);
            if (myfolder && myfolder.oxfolder.data) {       
                infostore_sendLink([{ data: {
                    folder_id: myfolder.oxfolder.data.id,
                    module: myfolder.oxfolder.data.module
                }}]);
            }
        });
    menu.addItem(link);
    
    // "Extended" (submenu)
    extended_folder_menu = new PopupMenu();
        // Import
        var import_data = new MenuItem("Import",
    			function() { 
        			importFolderDestination = oMainFolderTree.get_folder_by_node_id(this.getContext().data.id);
        			triggerEvent("OX_Switch_View","configuration/import");
        		});
        extended_folder_menu.addItem(import_data);
        // Export (Submenu)
    	var export_submenu = new PopupMenu();
            var export_submenu_vcard = new MenuItem("vCard", 
                    	function() { exportContacts(this.getContext().data, "VCARD");
                    	});
           	export_submenu.addItem(export_submenu_vcard);
            var export_submenu_csv = new MenuItem("CSV",
            			function() { exportContacts(this.getContext().data, "CSV");
            		});
           	export_submenu.addItem(export_submenu_csv);
        var export_contact = new MenuItem("Export", /*i18n*/
                export_submenu);
        extended_folder_menu.addItem(export_contact);
    // add to menu
    var extended = new MenuItem("Extended" /*i18n*/, extended_folder_menu);
    menu.addItem(extended);
    
    // separator
    menu.addItem(new MenuSeparator());
    
    var del = new MenuItem("Delete", /*i18n*/
        function() { contextAction(2, 0, this.getContext().data); });
    del.setIcon("img/menu/delete_folder.gif", "img/menu/delete_folder_d.gif");
    menu.addItem(del);
    
    var rename = new MenuItem("Rename", /*i18n*/
        function() { contextAction(3, 0, this.getContext().data); });
    rename.setIcon("img/folder/renamefolder.gif",
                   "img/folder/renamefolder_d.gif");
    menu.addItem(rename);
    
    var cut = new MenuItem("Cut", /*i18n*/
        function() { contextAction(5, 0, this.getContext().data); });
    cut.setIcon("img/folder/cutfolder.gif", "img/folder/cutfolder_d.gif");
    menu.addItem(cut);
    
    var paste = new MenuItem("Paste", /*i18n*/
        function() { contextAction(6, 0, this.getContext().data); });
    paste.setIcon("img/folder/pastefolder.gif", "img/folder/pastefolder_d.gif");
    menu.addItem(paste);
      
    menu.addItem(new MenuSeparator);
    
    var empty = new MenuItem("Empty folder", /*i18n*/
        function() { contextAction(8, 0, this.getContext().data); });
    empty.setIcon("img/folder/empty_folder.gif",
                  "img/folder/propertiesfolder_d.gif");
    menu.addItem(empty);
    
    var sep1 = new MenuSeparator();
    menu.addItem(sep1);
    
    var props = new MenuItem("Properties", /*i18n*/
        function() { contextAction(7, 0, this.getContext().data); });
    props.setIcon("img/folder/propertiesfolder.gif",
                 "img/folder/propertiesfolder_d.gif");
    menu.addItem(props);
    
    menu.onShow = function() {
        var folder = oMainFolderTree.get_folder_by_node_id(
            this.getContext().data.id);
        if (folder) {
            var oxfolder = folder.oxfolder.data;
            new_folder.setEnabled((oxfolder.own_rights & 127) >= 4);
            // module system and name default is the parent root mail folder
            this.context.type = (   oxfolder.module == "system"
                                 && String(oxfolder.id).match(/^default(\d+)?/))
                ? "mail" : oxfolder.module;
            subscribe.setVisible(oxfolder.module == "mail");
            link.setEnabled(oxfolder.own_rights & (127 << 7) && oxfolder.module != "mail" && ("infostore_sendLink" in window));
            link.setVisible(!(oxfolder.module == "mail" || (oxfolder.module == "system" && this.context.type == "mail")));
            del.setEnabled(deleteAllowed(folder.oxfolder));
            rename.setEnabled(renamingAllowed(folder.oxfolder));
            cut.setEnabled(del.enabled && (folderTreeFolderToMove == -1
            				 || folderTreeFolderToMove != folder));
            paste.setEnabled(   folderTreeFolderToMove != -1
                             && moveAllowed(folderTreeFolderToMove.parent, 
                                            folderTreeFolderToMove, folder));
            empty.setVisible(   oxfolder.module == "mail"
                            && oxfolder.own_rights >> 21 & 127);
            sep1.setVisible(empty.visible);
            
            import_data.setEnabled(
                    (oxfolder.own_rights & 127) >= 2 && 
                    (oxfolder.module == "calendar" || oxfolder.module == "contacts" || oxfolder.module == "tasks")
            );
            export_contact.setEnabled(
                    oxfolder.type != 3 && oxfolder.module == "contacts" && 
                    !(oxfolder.module != "contacts" || oxfolder.type == 3)
            );
        } else {
            new_folder.setEnabled(false);
            subscribe.setEnabled(false);
            link.setEnabled(false);
            del.setEnabled(false);
            rename.setEnabled(false);
            cut.setEnabled(false);
            paste.setEnabled(false);
            import_data.setEnabled(false);
            export_contact.setEnabled(false);
            empty.setVisible(false);
            sep1.setVisible(false);
        }
    };

	if(!oMainFolderTree) {
        var cache = new ox_folder_cache();
		oMainFolderTree = new cFolderTree($('folder_tree'), folderAction, true,
                                          cache, oFolderTreeState);
		oMainFolderTree.select_for_action = true;
		oMainFolderTree.inplace_enabled = true;
		oMainFolderTree.show_new_messages = true;
		oMainFolderTree.enable_quick_info = true;
		oMainFolderTree.toggle_cursor = true;	
		oMainFolderTree.context_menu_enabled = true;
		oMainFolderTree.register_update = true;
		oMainFolderTree.load();
		oUnreadCounterStorage = new unreadCounterStorage(oMainFolderTree);
		oUnreadCounterStorage.events.register("Count_Changed",setUnreadNumber);		
		triggerEvent("updateAllNewMailNumbers_Created");
        var translateSpecialFolders = false;
        register("LanguageChanged",
                 function() { translateSpecialFolders = true; });
        register("OX_Configuration_Changed", function() {
            if (!translateSpecialFolders) return;
            translateSpecialFolders = false;
            cache.updateFolders(
                cache.search(function(folder) { return folder.type == 5; }),
                function() {
                    oMainFolderTree.load_view(cache.folders.root,
                        oMainFolderTree.tree, true, false);
                });
        });
	}

	if (oUnreadCounterStorage) {
		oUnreadCounterStorage.update();		
	}

	oMainFolderTree.tree.events.register("OX_Tree_State_Changed", saveFolderStateInConfig);
	//register scrolling targets
	var oFolderTreeScrollDiv = $('folder_tree');
	function treeScrollUp()
	{		
		if(!oFolderTreeScrollDiv.scrollTop && oFolderTreeScrollDiv.scrollTop!=0)
		{
			oFolderTreeScrollDiv.scrollTop = 0;
		}
		else (oFolderTreeScrollDiv.scrollTop-15 < 0)
	 	{
			oFolderTreeScrollDiv.scrollTop = oFolderTreeScrollDiv.scrollTop - 15;
	 	}
		nTimeOutScrollTree = setTimeout(treeScrollUp,150);
	}
	function treeScrollDown() {				
		if (!oFolderTreeScrollDiv.scrollTop && oFolderTreeScrollDiv.scrollTop != 0) {
			oFolderTreeScrollDiv.scrollTop = 0;
		} else {
			oFolderTreeScrollDiv.scrollTop = oFolderTreeScrollDiv.scrollTop + 15;
	 	}
		nTimeOutScrollTree = setTimeout(treeScrollDown,150);		
	}
	var emptyfunction = function() {}
	var callbacks = new Object();
	callbacks["folder/1"]=emptyfunction;
	callbacks["folder/2"]=emptyfunction;
	callbacks["folder/3"]=emptyfunction;
	callbacks["folder/7"]=emptyfunction;
	callbacks["mailaddress"]=emptyfunction;
	callbacks["calendar"]=emptyfunction;
	callbacks["tasks"]=emptyfunction;
	callbacks["infostore"]=emptyfunction;
	callbacks["mail"]=emptyfunction;
	callbacks["contacts"]=emptyfunction;
	callbacks["CALENDAR_MONTH"]=emptyfunction;	

	registerTarget($("test0008"),callbacks,null,null,treeScrollUp);
	registerTarget($("test0009"),callbacks,null,null,treeScrollDown);	
	function cleartreeScrollTimeOut() {
		if(nTimeOutScrollTree != undefined)
			clearTimeout(nTimeOutScrollTree);		
	}
	addDOMEvent($("test0008"), "mouseout", cleartreeScrollTimeOut);
	addDOMEvent($("test0009"), "mouseout", cleartreeScrollTimeOut);	
	//addDOMEvent($("test0008"), "mousedown", cleartreeScrollTimeOut);
	//addDOMEvent($("test0009"), "mousedown", cleartreeScrollTimeOut);		
}

/**
 * Execute if folder clicked
 */
function folderAction(cacheFolder, treeNode) {
	var OXFolder = cacheFolder.oxfolder;
	var sameFolder = false;
	var sModule =  OXFolder.data.module;
	treeNode = treeNode || oMainFolderTree.nodes[oMainFolderTree.getDOMID(OXFolder.data.id)];
	
	if (sModule == "system" && String(OXFolder.data.id).match(/^default(\d+)?/)) {
		// If user clicks on the root folder 'E-Mail' we directly jump to the inbox 
		var jmp = "default" + getMailAccountIdByFolder(OXFolder.data.id);
		oMainFolderTree.cache.do_load_subfolders(jmp, oMainFolderTree.cache.find_folder(jmp),{},
			function(cb) { 
				activemodule = "mail";
				if (treeNode && !treeNode.open) treeNode.setOpen(!treeNode.open);
		        setActiveFolder(jmp + "/INBOX", 
	        		function() {
		        	   triggerEvent("OX_Switch_Module", "mail");
		        	}
		        );
			}
		);
        return;
	} else if (onlyParentFunc(OXFolder)) {
		// folder has no read permission, so we just open/close it	
		treeNode.setOpen(!treeNode.open);
		return;		
	}
	
	// select folder, change module and so on ...
	sameFolder = (activefolder == OXFolder.data.id);
	activemodule = sModule;
	activefolder = OXFolder.data.id;	
	triggerEvent("OX_Switch_Module", sModule, (sameFolder ? "samefolder" : "newfolder"), activefolder);
}

//Execute if context menu item clicked
function contextAction(nNumber,evt,node,type) {
	var oTreeNode = node;
	var aTmp2 = oTreeNode.id.split('$');

	var sFolderId = node.data.sId;
	var sModule = node.data.sModule;

	switch (nNumber) {
		case 1:
			//var bNew = true;
			//viewProperties(node,bNew);
			createNewFolderInpl(node,type);
			break;
		case 4:
			editFolder(node.widgetId);
			break;
		case 3:
			node.inpl_edit.on();		
			break;												
		case 2:
			//if the parent does not contain timestamp (oldnamespace imap), use lattest timestamp from tree	
			//nTimeStampRem = oTreeNode.data.timestamp;			
			removeFolder(oMainFolderTree.getFolderID(oTreeNode.id));
			break;
		case 7:
			var bNew = false;
			viewProperties(oTreeNode,bNew);
			break;		
		case 5:
			cutFolder(oTreeNode);
			break;					
		case 6:
			insertFolder(node);
			break;		
		case 8:
			emptyFolder(node);	   							
	}
}

/*function to create new folders with inplace method*/
function createNewFolderInpl(parentFolderNode,type) {
	var parentId = parentFolderNode.id.replace(/\$link$/,"");
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(parentId);	
	function uniqueName(aChildren,sName) {
		for (var nChild in aChildren) {			
			var oCurrChild = oMainFolderTree.get_folder_by_node_id(parentFolderNode.children[nChild].id)			
			if(sName == oCurrChild.oxfolder.data.title)
				return false;		
		}
		return true;
	}
	// inherit rights only if folder isn't a sytem folder (type 5)
	var inheritRights = oCacheFolder.oxfolder.data.type != 5;	
	var aPermissionArray = getNewFolderPerms(oCacheFolder.oxfolder,inheritRights);
	
	/*
	 * give admin permissions to the creator of a folder
	 * if its _not_ a shared folder! then we just inherit the
	 * permissions from the parent folder.
	 */
	if (oCacheFolder.oxfolder.data.type != 3) {
		for (i in aPermissionArray) {
			if (aPermissionArray[i].entity == configGetKey("identifier")) {        
	            aPermissionArray.splice(i,1);
			}
		}
		aPermissionArray.push({ group : false,
		                        bits  : Math.pow(2,6) + Math.pow(2,13) + Math.pow(2,20) + Math.pow(2,27) + Math.pow(2,28),                   
	                            entity: configGetKey("identifier") });
	}
	
	var oFolder  = new Object();
	oFolder['title'] = _("New Folder");
	oFolder["module"]=type;     
    oFolder["id"] = virtualFolderId;
	oFolder['permissions'] = aPermissionArray;		
	oFolder['subscribed'] = 1;
	oFolder["subfolder"] = false;
	oFolder["subscr_subflds"] = false;
	oFolder["summary"] = null;
	oFolder["unread"] = null;		
    oMainFolderTree.display_folder(oCacheFolder.oxfolder.data.id, function() {
    	parentFolderNode = oMainFolderTree.nodes[parentFolderNode.id.replace(/\$link$/,"")];
        oMainFolderTree.scroll_to(parentFolderNode);
        oMainFolderTree.expand_node(parentFolderNode, function() {
        	function cb_final() {
        		// hack to get childrens of main infostore folder
        		// instead of the my-infostore folder
        		if (parentId.match(/^folder_tree\$60/)) {
        			oCacheFolder = oMainFolderTree.get_folder_by_node_id(parentId);
        		}
                var nCounter = 1;
                while(!uniqueName(parentFolderNode.children, oFolder['title'])) {
                	oFolder['title'] = _("New Folder") + " " + nCounter;     
                    nCounter++;
                }
                if (oCacheFolder.children == undefined) oCacheFolder.children = new Object();	                
                oCacheFolder.children[oFolder["id"]] = { 
                              oxfolder: { data: oFolder, ENABLED: true, timestamp: null }, 
                              parent: parentFolderNode, children: null 
                          };
                          
                oMainFolderTree.cache.fast_access[oFolder["id"]] = oCacheFolder.children[oFolder["id"]];  
                oMainFolderTree.update_sub_tree(oCacheFolder);
                oMainFolderTree.set_selected(oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])]);
                oMainFolderTree.set_dashed(oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])]);
                setTimeout(function() {
                    oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])].inpl_edit.really_edit_check=false;
                    oMainFolderTree.nodes[oMainFolderTree.getDOMID(oFolder["id"])].inpl_edit.on();
                }, 0);
            }
            if (!parentFolderNode.open) parentFolderNode.setOpen(true);
            setTimeout(cb_final, 0);
        });
    });	
}

function cutFolder(node) {	
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(node.id);
    if (folderTreeFolderToMove != oCacheFolder) {
        if(folderTreeFolderToMove != -1) {
            var oldNode = folderTreeFolderNodeToMove;
            oldNode.closedIcon = enableIcon(oldNode.closedIcon);
            oldNode.openIcon = enableIcon(oldNode.openIcon);
            oldNode.updateIcon();
        }
        //store id
        folderTreeFolderToMove = oCacheFolder;
        folderTreeFolderNodeToMove = node;
        //change image
        node.closedIcon = disableIcon(node.closedIcon);
        node.openIcon = disableIcon(node.openIcon);	
        node.updateIcon();
        //TODO Cancel
    }
}

function enableIcon(sIcon) {
	var sOldIcon = sIcon;	
	var aTMP = sOldIcon.split('/');
	var newIcon = '';
	for (nInd = 0; nInd < aTMP.length; nInd++) {
		if (nInd < aTMP.length-1) {
			newIcon += aTMP[nInd] + '/';
		} else {
			var aTMP2 = aTMP[nInd].split('.');
			var sEnd = aTMP2[1];
			var aTMP3 = aTMP2[0].split('_');
			for (ind2 = 0; ind2 < aTMP3.length; ind2++){
				if(ind2 < aTMP3.length-1 && ind2 == 0) {
					newIcon += aTMP3[ind2];
				} else if (ind2 < aTMP3.length-1) {
					newIcon += '_' + aTMP3[ind2];
				} else {
					newIcon += '.'+sEnd;
				}
			}
		}
	}	
	return newIcon;					
}

function insertFolder(node) {	
	var targetFolder = oMainFolderTree.get_folder_by_node_id(node.id);
	//reset image
	if (folderTreeFolderToMove != -1) {
		var	currFolder = folderTreeFolderToMove;
		var sImageSRC = getFullImgSrc("img/folder/folder_closed.gif");									
		node.closedIcon = sImageSRC;
		folderServerMove(currFolder.parent,currFolder,targetFolder,false);
	}
}

function emptyFolder(node) {
	var targetNode = node;
	var text="";
	if(!configGetKey("mail.deletemail") && oMainFolderTree.getFolderID(node.id) != configGetKey("mail.folder.trash")) {
		text="Are you sure you want to delete all E-Mails? Deleted E-Mails will be moved to the Trash."; /*i18n*/
	} else {
		text="Are you sure you want to permanently delete all E-Mails? Permanently deleted E-Mails can not be recovered."; /*i18n*/
	}
	function cbok() {
		var id;
		var folderobject;
		function cbcache(myid) {
			folderobject=myid
			newFolderJson.put(AjaxRoot + "/mail?action=clear&session="+session, [id],null,
			function(cb){
				if (cb.data.length) { }
				oMainFolderTree.update(null,true,function () {
                    if (oUnreadCounterStorage) oUnreadCounterStorage.update();
                });
				triggerEvent("OX_Folder_Cleared",id);	
			});
		}
		id=oMainFolderTree.getFolderID(node.id);
		oMainFolderTree.cache.get_folder(id,cbcache);
	}
	newConfirm(_("Empty folder"),_(text),AlertPopup.YESNO,null,null,cbok,null,null);
}

function editFolder(node) {
	propertiesPopUp = newWindow("editProps.html", getWindowOptions());
	propertiesPopUp.focus();
}

var oChangedParentFolder = null;
function viewProperties(node,bNew) {		
	var oCacheFolder = oMainFolderTree.get_folder_by_node_id(node.id);
	var OXFolder = oCacheFolder.oxfolder;
	var sFolderId = OXFolder.data.id;	
	setActiveFolder(sFolderId);
	activemodule = 'configuration';			
	configparentfolder = (bNew)?sFolderId:-1;
	oChangedParentFolder = configparentfolder;
	configfolder = sFolderId;
	if(configparentfolder != -1) {
		var bRightsSupported = true;
		if ((oCacheFolder.oxfolder.data.module == "mail" || String(oCacheFolder.oxfolder.data.id).match(/^default(\d+)?/))	 //check capabilities here
										 && !(oCacheFolder.oxfolder.data.capabilities & Math.pow(2,0)))
			bRightsSupported = false;		
		if (bRightsSupported) {
			openNewDialog(function (bY) {openJumpToNewForm(oCacheFolder,bY,true);}, oCacheFolder);
		} else {
			openJumpToNewForm(oCacheFolder,false,true)
		}
	} else {
		fn_actionFolder(oCacheFolder);
	}	
}

/**
 * Renaming folder part 
 */
var editableNode;
function renameFolder(sId,oFolder) {	
	oMainFolderTree.cache.get_folder(sId, function(oCacheFolder) {
		function cb_rename_fd(arg) {
            removeVirtualFolder(virtualFolderId);			
			if (!arg.error) {				
				// redraw view and, if possible, scroll to new position
                oMainFolderTree.update(null, (oCacheFolder.oxfolder.data.module=="mail"), function() {
				    if (arg.data) {				    	
				    	oMainFolderTree.display_folder(arg.data, function() {				    		
				    		if (activefolder && sId && sId == activefolder) {
	                            oMainFolderTree.scroll_to(
	                                oMainFolderTree.nodes[oMainFolderTree.getDOMID(arg.data)]
	                            );	                           
	                            setActiveFolder(arg.data, null, true);
	                            folderAction(oMainFolderTree.cache.fast_access[arg.data]);
				    		}
				    	});
				    }
				});
			}
		}
		if (oCacheFolder != undefined) {
			// if it's the virtual folder node we do have to fire-up a new call 
			// instead of an update
		    if (sId && sId == virtualFolderId) {		    	
		    	var parentId = oMainFolderTree.get_folder_by_node_id(oCacheFolder.parent.id.replace(/\$link$/,"")).oxfolder.data.id;
		    	// prepare folder object for the new request
		    	var nFolder = clone(oCacheFolder.oxfolder.data);
		    	nFolder.title = oFolder.title;
		    	delete(nFolder.id);
		    	delete(nFolder.subscr_subflds);
		    	delete(nFolder.subfolder);
		    	delete(nFolder.summary);
		    	delete(nFolder.unread);
		    	delete(nFolder.type);
	            doAjaxNewFolderRequest(parentId, nFolder, cb_rename_fd, cb_rename_fd);	        
	        } else {
	        	// if the parent does not contain timestamp (oldnamespace imap), 
                // use lattest timestamp from tree
                var nTimeStampRename = oCacheFolder.oxfolder.timestamp || oMainFolderTree.cache.timestamp;
	        	doAjaxUpdateRequest(sId,oFolder, nTimeStampRename, cb_rename_fd);
	        }
		}
	});
}

/**
 * Deleting folder part
 */
function removeFolder(folderId, optional_fn) {
	function cbyes() {
		oMainFolderTree.cache.get_folder(folderId, function(oCacheFolder) {
			function cb_remove_fd(arg) {
				if (!arg.error) {
					oMainFolderTree.delete_node(folderId); // manually remove anything before updating!
	                oMainFolderTree.update(null, (oCacheFolder.oxfolder.data.module=="mail"), function() {
	                	var parentFolder = oCacheFolder.parent.id ? 
                                oMainFolderTree.get_folder_by_node_id(oCacheFolder.parent.id) : 
                                oCacheFolder.parent;
                        // We select the parent folder of the prior deleted folder ONLY if the user 
                        // isn't on the portal and the prior deleted folder is still selected.
	                	if (parentFolder && activemodule != "portal" && activefolder == folderId) {
	                        // If the parent is one of the system folder on the root level, we take 
	                        // one of the default folders of the current active module. 		
	                        var pId = parentFolder.oxfolder.data.id;	                        
	                        if (parentFolder.oxfolder.data.module=="system" && 
	                            configContainsKey("folder."+activemodule)) {
	                           pId = configGetKey("folder."+activemodule);
	                           parentFolder = oMainFolderTree.cache.fast_access[pId];
	                        }
	                        setActiveFolder(pId, null, true);
	                        folderAction(parentFolder);
	                	}	                	
	                });
					if(optional_fn) optional_fn();
				} else {
					newServerError(arg);
				}
			}
			var nTimeStamp = oCacheFolder.oxfolder.timestamp || oMainFolderTree.cache.timestamp;
			doAjaxRemoveFolderRequest([ oCacheFolder.oxfolder.data.id ], nTimeStamp, cb_remove_fd);	
		});
	}
	newConfirm(_("Delete Folder"),
	       _('Are you sure you want to delete the selected folder?'),
	       AlertPopup.YESNO, null, null, cbyes, null);
}

/**
 * Removing the virtual folder node
 * @param {String} The folder id
 * @return null, or the parent folder object
 */
function removeVirtualFolder(folderID) {
	 return oMainFolderTree.delete_node(folderID);
}

function exportContacts(node, action){
	var tF = $("dlIframe");	
	var n_url = AjaxRoot + '/export?action=' + action
		+ '&session=' + session
		+ '&folder=' + oMainFolderTree.get_folder_by_node_id(node.id).oxfolder.data.id;
	tF.src = n_url;
}
 
fileloaded();