/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

registerView("configuration",
    function() {
        $("config_folder_tree").style.display = "block";
        $("configComplete").style.display = "block";
    },
    function() {     	    	
        if(!bConfigTreeCreated) {
            createConfigTree();
        } else {
            oConfigFolderTree.update();
        }
        bConfigTreeCreated=true;
        if(folderTreeNode) {
            folderTreeNode.open=true;
            folderTreeNode.setOpen(true);
        }
        markConfigTreeNode(currentpath2.toString().replace(/,/g,'/'));
    },
    null,
    function() {
        $('config_folder_tree').style.display = "none";
        $("configComplete").style.display = "none";
        $('folder_tree').style.display = "block";
    },
    null
);  
var bConfigTreeCreated = false;
var c;

function deleteFolderConfig()
{
    oMainFolderTree.cache.get_folder(configfolder,function (oFolder){
        if(!deleteAllowed(oFolder.oxfolder))
        {
            return;
        }
        removeFolder(configfolder,function (){fn_actionFolder(oFolder.parent);});
    });
}
function cConfigObject(sIdParam,sTitleParam,bFolderParam)
{
    this.sName = sTitleParam;
    this.sId = sIdParam;
    this.bFolder = bFolderParam;
    this.aObjects = new Array();

    this.pushObject = function(obj) { this.aObjects.push(obj); }
}
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//Config Tree Definition
var oConfigTreeDef;
//Root
oConfigTreeDef = new cConfigObject('configuration','Configuration', /*i18n*/
                        true);
    
var oMod  = new cConfigObject('configuration/import','Import',  /*i18n*/
                    false);
oConfigTreeDef.pushObject(oMod);

var oSubMod  = new cConfigObject('configuration/settings','Options', /*i18n*/
                        false);
oConfigTreeDef.pushObject(oSubMod);

var oSubMod  = new cConfigObject('configuration/tags','Tags', /*i18n*/
                        false);
oConfigTreeDef.pushObject(oSubMod);

//Module Portal
if(configGetKey("modules.portal.module")) {
    oMod  = new cConfigObject('configuration/portal','Start Page', /*i18n*/
                true);      
    oSubMod  = new cConfigObject('configuration/portal/layout','Layout',false);     
    oMod.pushObject(oSubMod);
//  oConfigTreeDef.pushObject(oMod);    
    if(bUWAEnabled)
    {
        oSubMod  = new cConfigObject('configuration/portal/external','UWA Modules', /*i18n*/
                        false);     
        oMod.pushObject(oSubMod);
    }
    oConfigTreeDef.pushObject(oMod);    
}

//Module Mail
if (configGetKey("modules.mail.module") == true || (configGetKey("modules.mail.module") != null && configGetKey("modules.mailaccount.module"))) {
	oMod  = new cConfigObject('configuration/mail','E-Mail',true);
	if (configGetKey("modules.mail.module")) {
	    oSubMod  = new cConfigObject('configuration/mail/preferences','Preferences', /*i18n*/
	                    false);     
	    oMod.pushObject(oSubMod);   
	    oSubMod  = new cConfigObject('configuration/mail/signatures','Signatures', /*i18n*/
	                    false);     
	    oMod.pushObject(oSubMod);       
	}
	oConfigTreeDef.pushObject(oMod);
}

//Module Calendar
if(configGetKey("modules.calendar.module")) {
    oMod  = new cConfigObject('configuration/calendar','Calendar',true);        
    oSubMod  = new cConfigObject('configuration/calendar/preferences','Preferences',false);     
    oMod.pushObject(oSubMod);   
    if(configGetKey("modules.calendar.calendar_teamview")) {
        oSubMod  = new cConfigObject('configuration/calendar/teams','Teams', /*i18n*/
                        false);     
        oMod.pushObject(oSubMod);
    }       
    oConfigTreeDef.pushObject(oMod);
}

//Module Contacts
if(configGetKey("modules.contacts.module")) {   
    oMod  = new cConfigObject('configuration/contacts','Contacts',true);
        oSubMod = new cConfigObject('configuration/contacts/preferences','Preferences',false);      
        oMod.pushObject(oSubMod);
    oConfigTreeDef.pushObject(oMod);
}
//Module Tasks
if(configGetKey("modules.tasks.module")) {  
    oMod  = new cConfigObject('configuration/tasks','Tasks',true);
        var oSubMod  = new cConfigObject('configuration/tasks/preferences','Preferences',false);
        oMod.pushObject(oSubMod);
    oConfigTreeDef.pushObject(oMod);
}

//Module InfoStore
if(configGetKey("modules.infostore.module")) {
    oMod  = new cConfigObject('configuration/infostore','InfoStore',true);      
        var oSubMod  = new cConfigObject('configuration/infostore/preferences','Preferences',false);        
    oMod.pushObject(oSubMod);
    oConfigTreeDef.pushObject(oMod);
}

//Module Folder
//oMod  = new cConfigObject('configuration/folders','Folder preferences', /*i18n*/
//            true);          
//oConfigTreeDef.pushObject(oMod);
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

var configTree;

function createConfigTree()
{
    var treeDiv = $('config_folder_tree');
    var state = { configuration: { config_7: {} } };
    configTree = new Tree(treeDiv, state, 'config_tree_id');                                        
    configTree.events.register ("OX_Tree_Node_Click",fn_on_tree_click);
    function fn_on_tree_click(node, tree_id)
    {
        if(configTree.id == tree_id)
        {
            if(!node.hasChildren)
            {
                if (node.onClick) {
                    if (node.onClick() !== false)
                        markConfigTreeNode(node.id,true);
                } else {
                    markConfigTreeNode(node.id,true);
                    configuration_askforSave(function (){
                        triggerEvent("OX_Switch_View",node.id); 
                    });     
                }                   
            }
            else
            {
                if(!node.open)
                {
                    node.setOpen(true);
                }           
            }
        }           
    }
    drawTreeNode(configTree,oConfigTreeDef);
    appendFolderTree(oAllConfigTreeNodes["configuration/folders"]);
}

var oAllConfigTreeNodes = new Object();
var oldSelection;

function drawTreeNode(parentNode,currConfig)
{               
    if(currConfig.bFolder)  
    {
        sImageSRCOp = getFullImgSrc("img/folder/settings_folder_open.gif"); 
        sImageSRCCl = getFullImgSrc("img/folder/settings_folder_closed.gif");   
    }
    else
    {
        sImageSRCOp = getFullImgSrc("img/folder/settings.gif");     
        sImageSRCCl = sImageSRCOp;          
    }

    var currentNode = new TreeNode(parentNode, currConfig.bFolder,
                             sImageSRCCl, sImageSRCOp,
                             typeof currConfig.sName == "string"
                                ? addTranslated(currConfig.sName)
                                : currConfig.sName,
                             currConfig.sId, currConfig,'');
    if (currConfig.onClick) currentNode.onClick = currConfig.onClick;
    oAllConfigTreeNodes[currConfig.sId] = currentNode;
    parentNode.addChild(currentNode);
    if(currentNode.data.bFolder)
    {
        currentNode.events.register("NodeOpen", function (nodeParam){
                                nodeParam.icon.style.cursor = "default";
                                nodeParam.text.style.cursor = "default";        
                                    }); 
        currentNode.events.register("NodeClose", function (nodeParam){
                                nodeParam.icon.style.cursor = "pointer";
                                nodeParam.text.style.cursor = "pointer";        
                                    });     
    }
    if(currConfig.bFolder)
    {
        for(var nIndex=0;nIndex<currConfig.aObjects.length;nIndex++)
            drawTreeNode(currentNode,currConfig.aObjects[nIndex]);
    }
}
var oChangedFolder;

function fn_actionFolder(ofolder)
{
    var OXFolder = ofolder.oxfolder;
    showNode("folder_props");
    configuration_askforSave(function (){
        configfolder = OXFolder.data.id;    
        configparentfolder = -1;
        triggerEvent("OX_Switch_View","configuration/folder/overview"); 
        unLoadFolderProps();
        loadFolderProps();
    });
}
function fn_realActionFolder(ofolder)
{
    var OXFolder = ofolder.oxfolder;
    showNode("folder_props");
    configuration_askforSave(function (){
        configfolder = OXFolder.data.id;    
        configparentfolder = -1;
        triggerEvent("OX_Switch_View","configuration/folder/overview"); 
        unLoadFolderProps();
        loadFolderProps(false,true);
    });
}
var changedFolderId;
function openNewDialog(executeact, ofolder)
{
    if (ofolder && ofolder.oxfolder.data.id == 1) {
        executeact(false)
    } else { 
        newConfirm(_("New Folder"),_("You create a new subfolder, do you want to add rights of the superior folder?"),
                    14,null,function (){},function (){executeact(true);},
                            function (){executeact(false);});
    }
}
function openJumpToNewForm(node,bPermPropagation,bDisableScrollTo)
{
    
    showNode("folder_props");
    configuration_askforSave(function (){
        configparentfolder =  node.oxfolder.data.id;
        configfolder = configparentfolder;
        triggerEvent("OX_Switch_View","configuration/folder/overview"); 
        unLoadFolderProps();
        loadFolderProps(bPermPropagation,bDisableScrollTo);
    });
    //oChangedParentFolder =  node.data.sId;
}

var oConfigFolderTree;
function appendFolderTree(parentNode) {
	folderTreeNode = oAllConfigTreeNodes["configuration/folders"];
	
	var domdiv = newnode('div', {display: 'none'}, {id: 'configfoldertempl'});
	addTMPId(domdiv);
	$('config_folder_tree').appendChild(domdiv);
	//var oTreeContextMenu = new Popup(null,"popupConfigFolderTree_");
	oConfigFolderTree = new cFolderTree(domdiv,fn_realActionFolder,false, oMainFolderTree.cache);
	oConfigFolderTree.select_for_action = true;
	oConfigFolderTree.show_unsubscribed = false;
	oConfigFolderTree.context_menu_enabled = false;  
	oConfigFolderTree.register_update = true;
	oConfigFolderTree.check_read_right = false;
	oConfigFolderTree.load();                    
}

function markEditFolder(sFolderId,fn_PARAM_,bDisableScrollTo)
{
    function cb_load_path(node)
    {
        if(fn_PARAM_)
            fn_PARAM_();
        markConfigTreeNode(sFolderId);
        oConfigFolderTree.set_selected(node);
        if(!bDisableScrollTo)
            oConfigFolderTree.scroll_to(node);      
    }
    oConfigFolderTree.display_folder(sFolderId,cb_load_path);
}

function markConfigTreeNode(id,bNoScroll)
{   
    var oCurNode = oAllConfigTreeNodes[id];
    if(oldSelection)
        oldSelection.text.className = removeStyleClass(oldSelection.text.className,'background-color-PMG-selection-elements');
    if(oCurNode)
    {
        oCurNode.text.className += ' background-color-PMG-selection-elements';
        if(oCurNode.parent.open == false)
            oCurNode.parent.setOpen(true);
        oldSelection = oCurNode;
        oConfigFolderTree.set_selected();
        triggerEvent("OX_Config_Node_Selected_Path",getconfigPathByNode(oCurNode));
    }   
}

function getconfigPathByNode(oConfigNode)
{
    var sPath = "";
    if(oConfigNode == null) 
        return sPath;
    var oConfigNodeLoc = oConfigNode;
    while(oConfigNodeLoc.parent)
    {
        sPath = '/' + _(oConfigNodeLoc.data.sName) + sPath;     
        oConfigNodeLoc = oConfigNodeLoc.parent;
    }   
    return sPath;
}
function getconfigPathSelected()
{
    var sPath;
    if(oldSelection)
        sPath = getconfigPathByNode(oldSelection);
    else
        sPath = getconfigPathByNode(oConfigFolderTree.selected_node);       
    return sPath;
}
fileloaded();   