/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
function cPortal(){
	this.all_areas = new Object();
	this.matrix = new portalMatrix($('portal_horiz_content'));
	
	this.init();
}
var tempViewPortalObj = null;
var oPortalIndepObj = null;
var objDND_Obj = null;
var offsetIconX = 0;
cPortal.setMovingClass = classNameSetter("moving");
cPortal.prototype = {
	init: function (){
		var objInternalCont = configGetKey("gui.portal.internalcontents");
		for(var nIndx=0;nIndx< objInternalCont.length;nIndx++)
		{
			var oModule = objInternalCont[nIndx];
			if(oModule.adj == undefined)
			{
				continue;	
			}
			if(oModule.module == "mail" && configGetKey('mail.folder.inbox')==null)
				oModule.visible = false;
			if(!oModule.visible)
				continue;		
			this.all_areas[oModule.module] = this.get_section(oModule.module,0,oModule.params.limit,oModule.adj);
		}
		this.get_all_data(this.all_areas,true);	

		if(bUWAEnabled && !(url["external"] && url["external"]==0))
		{
			var aExtContents = configGetKey("gui.portal.externalcontents");
			for(var indx=0;indx < aExtContents.length;indx++)			
			{				
				var sId =  (aExtContents[indx]["id"])?aExtContents[indx]["id"]:aExtContents[indx]["title"];
				if(!aExtContents[indx].visible)
					continue;						
				this.all_areas[sId] = this.get_ext_section(aExtContents[indx],sId);		
			}
		}

	//	this.resize($('portal').offsetWidth);
		this.register_dnd(null,null, null,true);		
	},
	//set bInitialize true for intiialization and false for update
	get_all_data : function (aPortalAreas,bInitialize){
		var Self = this;
		var aReqAssoc = new Array();
		//create multiple request...
		var aRequests = new Array();
		for(var nIndx in aPortalAreas)
		{
			if(!aPortalAreas[nIndx].extern)
			{
				var aModReq = aPortalAreas[nIndx].getRequests();
				for(var nr=0;nr<aModReq.length;nr++)
				{
					aReqAssoc.push({id:aPortalAreas[nIndx].id,indx:nr});
					aRequests.push(aModReq[nr]);
				}
			}
		}
		//set received data in portal objects, and draw contents
		function cb_portal_mult(arg)
		{		
			if(currentpath2[0] != "portal")
				return;
			for(var nIndx=0;nIndx<arg.length;nIndx++)
			{
				var currArg = arg[nIndx];
				if(currArg) {
					if(currArg.error)
						Self.all_areas[aReqAssoc[nIndx].id].setError(currArg);
					else				
						Self.all_areas[aReqAssoc[nIndx].id].setData(currArg.data,aReqAssoc[nIndx].indx,currArg.timestamp);			
				}
			}

			for(var nIndx in aPortalAreas)
			{
				if(!aPortalAreas[nIndx].extern)
				{
					/*
					if(bInitialize)
						aPortalAreas[nIndx].getHTML();
					else*/
						aPortalAreas[nIndx].update();
				}
			}
			Self.resize($('portal').offsetWidth);
		}
		//send multiple request
		doAjaxMultiplePortalRequest(aRequests,cb_portal_mult);		
	},
	disable : function (){
		for(var indx in this.all_areas)
		{
			this.all_areas[indx].disable();
		}					
	},
	resize : function (sWidth){
		this.matrix.resize(sWidth,$('portal_new_top_dyn').offsetHeight);
	},
	update : function (){
		//delete old data
		for(var nIndx in this.all_areas)
		{
			this.all_areas[nIndx].error = undefined;
			this.all_areas[nIndx].data = undefined;		
			if(this.all_areas[nIndx].extern)
			{
				this.all_areas[nIndx].update();
			}
		}
		//using the method for asynchrounus data handling
		this.get_all_data(this.all_areas,false);				
		
	},	
	remove_section : function (sId){
		this.matrix.remove(this.all_areas[sId].oDOMTD);
		delete this.all_areas[sId];
		this.resize($('portal').offsetWidth);					
	},
	/*should be used after configuration change*/
	rebuild_page : function (){	
		var objInternalCont = configGetKey("gui.portal.internalcontents");		
		var newAreas = new Array();
		for(var nIndx=0;nIndx< objInternalCont.length;nIndx++)
		{		
			if(this.all_areas[objInternalCont[nIndx].module] != undefined && !objInternalCont[nIndx].visible)
			{
				this.remove_section(objInternalCont[nIndx].module);	
			}			
			else if(this.all_areas[objInternalCont[nIndx].module] == undefined 
																&& objInternalCont[nIndx].visible)
			{
				var nY = (this.matrix.nodes.length == 0)?0:(this.matrix.nodes.length-1);
				var nX = (nY==0)?0:this.matrix.nodes[nY].length;
				this.all_areas[objInternalCont[nIndx].module] = 
						this.get_section(objInternalCont[nIndx].module,0,objInternalCont[nIndx].params.limit,
							{x:nX,y:nY,ww:1,hw:1});
				newAreas.push(this.all_areas[objInternalCont[nIndx].module]);				
			}
		}
		if(bUWAEnabled){			
			var objExternalCont = configGetKey("gui.portal.externalcontents");	
			for(var nIndx=0;nIndx< objExternalCont.length;nIndx++)		
			{	
				var sId = (objExternalCont[nIndx]["id"])?objExternalCont[nIndx]["id"]:objExternalCont[nIndx]["title"];
				if(this.all_areas[sId] != undefined && !objExternalCont[nIndx].visible)
				{
					this.remove_section(sId);	
				}			
				else if(this.all_areas[sId] == undefined 
														&& objExternalCont[nIndx].visible)
				{
						var nLastRow = this.matrix.nodes.length-1;
						var nLengthLastRow = this.matrix.nodes[nLastRow].length;
						if(nLengthLastRow > 3)
						{
							nLastRow++;
							var newAdj = {x:0,y:nLastRow,ww:1,hw:1};
						}else
						{
							var newAdj = {x:nLengthLastRow,y:nLastRow,ww:1,hw:1};							
						}						
						objExternalCont[nIndx].adj = newAdj;
						this.all_areas[sId] = this.get_ext_section(objExternalCont[nIndx],sId);						
				}				
			}
			//remove deleted items
			for(var nre in this.all_areas)
			{				
				if(this.all_areas[nre].extern === true)
				{
					var bfound = false;
					for(var nIndx=0;nIndx< objExternalCont.length;nIndx++)
					{
						var sId = (objExternalCont[nIndx]["id"])?objExternalCont[nIndx]["id"]:objExternalCont[nIndx]["title"];
						if(sId == this.all_areas[nre].id)
						{
							bfound = true;
						}
					}
					if(!bfound)
						this.remove_section(this.all_areas[nre].id);
				}
			}
		}		
		if(newAreas.length > 0)
			this.get_all_data(newAreas,true);			

		this.resize($('portal').offsetWidth);		
	},
	get_ext_section : function (oObj,sId){
		var nItem = this.get_section(oObj.title,null,null,oObj.adj,oObj,sId);	
		return nItem;
	},
	header_action : function (sModule){
		if(sModule == "mail")
		{
			var oFoldersMail = configGetKey("mail.folder");
			var sfolderId = oFoldersMail["inbox"];
		}
		else
			var sfolderId = configGetKey("folder." +sModule);
		var sdefView = configGetKey("gui." +sModule+".view");		
		setActiveFolder(sfolderId,function (){
				activemodule = sModule;
				triggerEvent("OX_Switch_Module",sModule, "newfolder");
		});
	},
	close_section : function (sModule,sId){
		//handle external portlets here
		if(sId)
		{
			this.matrix.remove(this.all_areas[sId].oDOMTD);
			delete this.all_areas[sId];
			var objExternalCont = configGetKey("gui.portal.externalcontents");	
			for(var nIndx=0;nIndx< objExternalCont.length;nIndx++)		
			{		
				var sStoredId = (objExternalCont[nIndx]["id"])?objExternalCont[nIndx]["id"]:objExternalCont[nIndx]["title"];
				if(sStoredId == sId)
				{
					objExternalCont[nIndx].visible = false;
					break;
				}				
			}
			configSetKey("gui.portal.externalcontents",objExternalCont);
			configuration_changed_fields["gui"]=true;
		}
		else
		{
			this.matrix.remove(this.all_areas[sModule].oDOMTD);
			delete this.all_areas[sModule];
			var objInternalCont = configGetKey("gui.portal.internalcontents");
			for(var nIndx=0;nIndx< objInternalCont.length;nIndx++)
			{
				if(objInternalCont[nIndx].module == sModule)
				{
					objInternalCont[nIndx].visible = false;
					objInternalCont[nIndx]["params"]["limit"] = 0;
					break;
				}
			}
			configSetKey("gui.portal.internalcontents",objInternalCont);
			configuration_changed_fields["gui"]=true;
		}
		this.resize($('portal').offsetWidth);	
	},
	get_section : function (sModule,nIndx,nLimit,oAdj,oObjExt,sId){
		var Self = this;
		function getPortalSizeCallback(split,previous)
		{
			return function(e) {
				/*
				 * checking the clicked mouse button. anything else then a left click
				 * won't be allowed. can't handle this in the addDomEvent as we need
				 * the mousedown event which will be fired before the other events.
				 */
				var clButton = e.which || e.button || 1;
                if (clButton != 1) {
                    cancelDefault(e);
                    return false;
                }
				Self.matrix.hideshow_iframes("hide");
				var oCoords = Self.matrix.getXY(previous);
				var oldLeft = split.offsetLeft;
				var nNextWidth = Self.matrix.nodes[oCoords.y][oCoords.x+1].div.offsetWidth;
				function getPixels(value) {
					if (!value) return value;
					var match = /^([0-9.]+)(em|px)$/.exec(value);
					if (!match) alert(format("Invalid ox:min or ox:max at id=\"%2\".", split.id));
					var num = parseFloat(match[1]);
					switch (match[2]) {
						case "px": return num;
						case "em": return pxPerEm * num;
					}
				}
				var displayOffset;
				var min = 140;
				var max = previous.offsetWidth + (Self.matrix.nodes[oCoords.y][oCoords.x+1].div.clientWidth-120);
				var sizeF = {
					left: function() {
						displayOffset = previous.offsetLeft;
						var offset = previous.offsetWidth - e.clientX;
					return function(x, y) {	
							return Math.min(max, Math.max(min, offset + x));
						};
					}
				}["left"]();
				function m(e) {
					stopEvent(e);
					size = sizeF(e.clientX, e.clientY);
					split.style.left = (displayOffset + size) + "px";				
				};
				function u() {
					Self.matrix.hideshow_iframes("show");
					removeDOMEvent(body, "mousemove", m);
					removeDOMEvent(body, "mouseup", u);
                    cPortal.setMovingClass(split, false);
					var nXCoord = getPixels(split.style.left) - previous.offsetLeft;		
					var nOldWeights = Self.matrix.nodes[oCoords.y][oCoords.x+1].portlet.adjust.ww + Self.matrix.nodes[oCoords.y][oCoords.x].portlet.adjust.ww;
					var nFullLength = previous.offsetWidth + Self.matrix.nodes[oCoords.y][oCoords.x+1].div.offsetWidth;
					var nLeftNewX = (Math.round(((nOldWeights/nFullLength) * nXCoord)*1000)/1000);
					var nRightNewX = nOldWeights - nLeftNewX;
					Self.matrix.nodes[oCoords.y][oCoords.x+1].portlet.adjust.ww = nRightNewX;
					Self.matrix.nodes[oCoords.y][oCoords.x].portlet.adjust.ww = nLeftNewX;
					Self.resize($('portal').offsetWidth);	
					Self.matrix.setConfig();
				};
				addDOMEvent(body, "mousemove", m);
				addDOMEvent(body, "mouseup", u);
                cPortal.setMovingClass(split, true);
				cancelDefault(e);					
			}
		}
		var oNewCell = newnode("div",{flt:"left",paddingLeft:"7px"});
		var oDOMresize = newnode("div",{zIndex:"5",verticalAlign:"middle",cursor:"e-resize",position:"absolute",
							height:"40px",width:"7px",borderLeft:"1px solid #FFFFFF",borderRight:"1px solid #FFFFFF"});
		var oResIm = newnode('img',0,{src:getFullImgSrc("img/grip_bg_vertical.gif")});
		var oResTable = newnode('table',{borderCollapse:"collapse",height:"100%",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var oResBody = newnode('tbody');	
		var oResTR = newnode('tr');	
		var oResTD = newnode('td',{verticalAlign:"middle"});	
		oResTD.appendChild(oResIm);
		oResTR.appendChild(oResTD);
		oResBody.appendChild(oResTR);		
		oResTable.appendChild(oResBody);		
		oDOMresize.appendChild(oResTable);
		addDOMEvent(oDOMresize, "mousedown", getPortalSizeCallback(oDOMresize,oNewCell));
		var sHeight = $('portal_new_top_dyn').offsetHeight + 'px';
		var contentTable = newnode('table',{borderCollapse:"collapse",height:"90%",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var oDOMTD = newnode('td',{verticalAlign:"top"});		
		oDOMTD.appendChild(contentTable);
		var bodyTable = newnode('tbody');		
		contentTable.appendChild(bodyTable);		
		var oDOMTH = newnode('th');		
		var dndIm = newnode("img",{cursor:"move"},{src:getFullImgSrc("img/portal/move_n.gif")});
		var header = newnode('div',0,{className:"mozSelected"});
		function get_closed_actionfn(){
			return function (){
				Self.header_action(sModule);
			}
		}
		//enable action for internal module change
		if(oObjExt == undefined)		
		{
			addDOMEvent(header,"click",get_closed_actionfn());
			header.style.cursor = "pointer";
		}
		bodyTable.appendChild(newnode('tr',{height:"1.6em"},0,[oDOMTH,newnode('th',{verticalAlign:"top"},0,[oDOMresize])]));		

		var moveDiv = newnode('div',{height:"14px"},{className:"mozSelected"},[dndIm]);		
        var oCloseImg = newnode("img",{cursor:"pointer"},{src:getFullImgSrc("img/portal/btn_close.gif")});
        var closeDiv = newnode('div',{height:"14px"},{className:"mozSelected"},[oCloseImg]);            

		function get_closed_closefn(){
			return function (){
				Self.close_section(sModule,sId);
			}
		}
        addDOMEvent(oCloseImg,"click",get_closed_closefn());
		var oDOMHeaderTable = newnode('div',{paddingLeft:"8px"},0,[
								newnode("table",{width:"100%",lineHeight:"1.5em",
											borderCollapse:"collapse"},
													{cellPadding: "0", cellSpacing: "0", className: "portal-header-box-background background-color-additional-content"},[
									newnode("tbody",0,0,[
										newnode("tr",0,0,[
											newnode("td",0,0,[header]),
											newnode("td",{verticalAlign:"middle",paddingLeft:"2px",width:"18px"},0,[moveDiv]),											
											newnode("td",{verticalAlign:"middle",paddingRight:"4px",width:"28px",textAlign:"right"},0,[closeDiv])												
										
										])])])]);
		oDOMTH.appendChild(oDOMHeaderTable);
//		oDOMTH.appendChild(closeDiv);
		var container = newnode('div',{position:"relative",paddingLeft:"10px",paddingRight:"10px",overflowX:"hidden",overflowY:"auto"});
		bodyTable.appendChild(newnode('tr',0,0,[newnode('td',{verticalAlign:"top"},0,[container])]));	
		oNewCell.appendChild(contentTable);
		this.register_dnd(oNewCell,dndIm,oDOMHeaderTable);
		if(oObjExt == undefined)
			var newItem = new portalItem(sModule,container,header,nLimit,oAdj,oNewCell,oDOMresize);
		else
		{
			var newItem = new portalExternalItem(sId,sModule,container,header,oObjExt.parameter,oAdj,oNewCell,oDOMresize,oObjExt.url);
			newItem.autorefresh = oObjExt.autorefresh;
			newItem.standalone = oObjExt.standalone
		}
			
		this.matrix.add(newItem,oNewCell,oAdj.x,oAdj.y);		
		newItem.getHTML();
		return newItem;		
	},
	register_dnd : function (oNewCell,oDragPoint,header,bPortalBorder){
		var Self = this;


		if(header)
		{
			addDOMEvent(header, "selectstart", function (e){stopEvent(e);return false;});
			addDOMEvent(header, "drag", function (e){stopEvent(e);return false;});										
		}
		var timeoutPortal;		
		function clearPortalSelection(e,dragType,draggedObjects,mouseposition,OutOpen,dropNode) {			
		clearTimeout(timeoutPortal);			
		if(dropNode) {
				dropNode.className = removeClass(dropNode.className, "dndOver");	
			}
			else if(e) {
				var mynode = e.currentTarget || e.srcElement || false;
				if(mynode) { 	mynode.className = removeClass(mynode.className, "dndOver");  }
			}
	
		}
	
		function portalenable(e,dragType,draggedObjects,mouseposition,targetNode,node){				
				if (objDND_Obj == null)
				{
					Self.matrix.hideshow_iframes("hide");
					var sStrWidth = draggedObjects.div.style.width;
					var nNumWidth = sStrWidth.replace(/px/,'');
					var objDND_Header = draggedObjects.header.firstChild.cloneNode(true);
					objDND_Header.style.width = "99%";
					objDND_Obj = newnode('div',{paddingTop:"3px",paddingRight:"10px",paddingLeft:"10px",position:"absolute",border:"1px dotted #000000",width:sStrWidth,height:draggedObjects.div.style.height},0,[objDND_Header])
					addDOMEvent(objDND_Obj, "selectstart", function (e){stopEvent(e);return false;});
					addDOMEvent(objDND_Obj, "drag", function (e){stopEvent(e);return false;});							
					$('mailDnDPortal_anchor').appendChild(objDND_Obj);
					if(offsetIconX == 0)
					{
						var absPos = draggedObjects.div.offsetLeft;
						offsetIconX = getAbsolutePositionLeft(draggedObjects.div) - mouseposition.clientX;					
					}
				}					
				var iconNode = objDND_Obj;
				iconNode.style.left = (e.clientX + offsetIconX) + "px";
				iconNode.style.top = (e.clientY+1)+ "px";
		}
		function poralPreview(node,bPortalBordersOpt,DirectOpt){return function(e,dragType,draggedObjects,mouseposition,targetNode) {
								var saveX = e.clientX;
								var saveY = e.clientY;		
								portalenable(e,dragType,draggedObjects,mouseposition,targetNode,node);
								function local_tempst(){	
									if(bPortalBorder)							
										showPreviewBorder(e,dragType,draggedObjects,mouseposition,targetNode,node,saveX,saveY,DirectOpt);
									else
										showPreview(e,dragType,draggedObjects,mouseposition,targetNode,node,saveX,saveY);
									
								}					
								clearTimeout(timeoutPortal);
								timeoutPortal = setTimeout(local_tempst,100);
							}
		}
	
		function showPreview(e,dragType,draggedObjects,mouseposition,targetNode,node,saveX,saveY){
			clearTimeout(timeoutPortal);
			if(node == tempViewPortalObj){
				return;			
			}
			var absolutX = getAbsolutePositionLeft(node)
			var sNewPosition;
			
			//coordinate system transformation
			var x_ = saveX-absolutX - node.offsetWidth/2;
			var y_ = saveY-getAbsolutePositionTop(node) - node.offsetHeight/2;		
			//working with polar coordinates
			var nDEGAngl = getPolarAngle(x_,y_) * 180 / Math.PI;
			if(nDEGAngl <= 135 && nDEGAngl >=45)
			{
				sNewPosition = "bottom";
			}
			else if(nDEGAngl <= 180 && nDEGAngl > 135 || nDEGAngl >= -180 && nDEGAngl < -135)
			{
				sNewPosition = "left";
			}
			else if(nDEGAngl >= -135 && nDEGAngl <= -45)
			{
				sNewPosition = "top";
			}		
			else if(nDEGAngl >-45 && nDEGAngl <= 0 || nDEGAngl > 0 && nDEGAngl < 45)
			{
				sNewPosition = "right";
			}		
			showPreviewAt(sNewPosition,mouseposition,draggedObjects,node,nDEGAngl);
		}
		var tObj = new Object();	
		tObj["portal_dnd"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
							clearTimeout(timeoutPortal);
							if(!oPortalIndepObj)
								return;
							if(oPortalIndepObj.portlet.uwa === null)
								oPortalIndepObj.portlet.appendFrame();							
							Self.matrix.hideshow_iframes("show");
							Self.matrix.replace(oPortalIndepObj.portlet,oPortalIndepObj.div,tempViewPortalObj);
							Self.resize($('portal').offsetWidth);	
							Self.matrix.setConfig();
							tempViewPortalObj = null;
							oPortalIndepObj = null;
							if(objDND_Obj != null){
								$('portal_mi_anchor').removeChild(objDND_Obj);
								objDND_Obj = null;
								offsetIconX = 0;
							}
							//clearPortalSelection(event,dragType,draggedObjects,mouseposition,null,dropNode);
							};
		function showPreviewAt(sNewPosition,mouseposition,draggedObjects,node,nDEGAngl){
			var sameDiv = (draggedObjects.div == node);			

			if(tempViewPortalObj == null)
			{			
				if(sameDiv && (sNewPosition == "left" || sNewPosition == "right"))				
					oPortalIndepObj = Self.matrix.get(draggedObjects.div);
				else					
					oPortalIndepObj = Self.matrix.remove(draggedObjects.div);

				if(oPortalIndepObj.portlet.uwa)
					oPortalIndepObj.portlet.deleteFrame();
					
				var tempContainer = newnode("div",{border: "1px dotted black",position:"absolute",paddingLeft:"10px",
																						paddingRight:"10px",overflow:"hidden"});
				tempViewPortalObj = newnode("div",{flt:"left",paddingLeft:"9px"});
				tempViewPortalObj.appendChild(tempContainer);
				Self.register_dnd(tempViewPortalObj);			
			}
			else
			{
				Self.matrix.remove(tempViewPortalObj);	
				var tempContainer = tempViewPortalObj.firstChild;						
			}		
			switch(sNewPosition){
				case "left":		
							if(node.previousSibling == draggedObjects.div) 
								return;			
							if(sameDiv)				
								Self.matrix.replace({container:tempContainer},tempViewPortalObj, node);
							else
								Self.matrix.insertBefore({container:tempContainer},tempViewPortalObj, node);
							Self.resize($('portal').offsetWidth);	
							break;		
				case "top": 
							var oCoor = Self.matrix.getXY(node);
							Self.matrix.insert_rowBefore({container:tempContainer},tempViewPortalObj,oCoor.y);						
							Self.resize($('portal').offsetWidth);							
							break;	
				case "bottom_border": 		
							var nYCoord = Self.matrix.nodes.length;
							Self.matrix.add({container:tempContainer},tempViewPortalObj,0,nYCoord);
							Self.resize($('portal').offsetWidth);								
							break;														
				case "bottom": 		
							var oCoor = Self.matrix.getXY(node);
							if(Self.matrix.nodes[oCoor.y+1] == undefined)
							{		
								Self.matrix.add({container:tempContainer},tempViewPortalObj,0,(oCoor.y+1));
								Self.resize($('portal').offsetWidth);	
							}		
							else
							{
								Self.matrix.insert_rowBefore({container:tempContainer},tempViewPortalObj,(oCoor.y+1));						
								Self.resize($('portal').offsetWidth);	
							}
							break;																						
				case "right":
							if(node.nextSibling == draggedObjects.div) 
								return;
							if(sameDiv)				
								Self.matrix.replace({container:tempContainer},tempViewPortalObj, node);
							else				
								Self.matrix.insert({container:tempContainer},tempViewPortalObj, node);
							Self.resize($('portal').offsetWidth);					
							break;			
			}

		}	
		function showPreviewBorder(e,dragType,draggedObjects,mouseposition,targetNode,node,saveX,saveY,sDirect)
		{
			if(sDirect == "top" && Self.matrix.nodes[0][0].div)
				showPreviewAt(sDirect,mouseposition,draggedObjects,Self.matrix.nodes[0][0].div);	
			if(sDirect == "bottom" && Self.matrix.nodes[(Self.matrix.nodes.length-1)][0].div)
				showPreviewAt("bottom_border",mouseposition,draggedObjects,Self.matrix.nodes[(Self.matrix.nodes.length-1)][0].div);				
		}
		
		if(bPortalBorder)
		{
			addDOMEvent($("portal_border_top"), "selectstart", function (e){stopEvent(e);return false;});
			addDOMEvent($("portal_border_top"), "drag", function (e){stopEvent(e);return false;});							
			addDOMEvent($("portal_border_bottom"), "selectstart", function (e){stopEvent(e);return false;});
			addDOMEvent($("portal_border_bottom"), "drag", function (e){stopEvent(e);return false;});									
			registerTarget($("portal_border_top"), tObj,null,null,function (){},
									poralPreview($("portal_border_top"),true,"top"),clearPortalSelection,true);
			registerTarget($("portal_border_bottom"), tObj,null,null,function (){},
									poralPreview($("portal_border_bottom"),true,"bottom"),clearPortalSelection,true);								
		}
		else
			registerTarget(oNewCell, tObj,null,null,function (){},
									poralPreview(oNewCell),clearPortalSelection,true);
	
		function getPolarAngle(x,y){
			var r = Math.pow((x*x+y*y),0.5);
			if(y >= 0)
				return Math.acos(x/r);
			else
				return (Math.acos(-1 * (x/r)) - Math.PI);
		}
		function fn(sPortalId)
		{
			return function ()
			{
				var dwi = sPortalId;
				return dwi;
			}
		}			
		function leaveSourcePortal(){
			if(objDND_Obj != null){
				$('mailDnDPortal_anchor').removeChild(objDND_Obj);
				objDND_Obj = null;				
				offsetIconX = 0;
				Self.matrix.hideshow_iframes("show");							
			}		
			if(oPortalIndepObj == null || tempViewPortalObj == null)
				return;
			if(oPortalIndepObj.portlet.uwa === null)
					oPortalIndepObj.portlet.appendFrame();
			Self.matrix.replace(oPortalIndepObj.portlet,oPortalIndepObj.div,tempViewPortalObj);
			Self.resize($('portal').offsetWidth);	
			Self.matrix.setConfig();
			tempViewPortalObj = null;
			oPortalIndepObj = null;
		}
		if(oDragPoint)
			registerSource(oDragPoint, "portal_dnd", fn({header:header,div:oNewCell}),null,null, 
																		function(e,dragType,draggedObjects,mouseposition,targetNode) {
																					portalenable(e,dragType,draggedObjects,mouseposition,targetNode,header);
																		}
	, 
																			leaveSourcePortal);																									
			
		}

}