/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
registerModule("portal", "Start Page",1); /*i18n*/

var	bPortalConfigChanged = false;

var oPortalObject = null;

registerView("portal",
	function() { showNode("portal") }, 
	function() { 
		if(oPortalObject != null)			
		{	
			if(bPortalConfigChanged)
			{
				oPortalObject.rebuild_page();
			}
			else
			{
				resizePortalHeaders();
				oPortalObject.update();			
			}
			oMainFolderTree.set_selected();
		}
		else
		{			
			oPortalObject = new cPortal();
			register("OX_Refresh",portalUpdate);
		}
		window.onbeforeunload = unloadMessageMainLogin;		
		resizeEvents.register("Resized",resizePortalHeaders);	
	 }, 
	function() {
		window.onbeforeunload = unloadMessageMainLogin;
		resizeEvents.unregister("Resized",resizePortalHeaders);			
	},
	function() {		
		oPortalObject.disable();
		hideNode("portal");
	},function () {	
	});

function portalUpdate(){
	oPortalObject.update();
}
register('OX_Portal_Click_Item',fn_clickedItem);


register('OX_Configuration_Changed',function (param)
									{
										if(param && (param == 'configuration/portal/layout'))	
												bPortalConfigChanged = true;
									});

function fn_clickedItem(sModule,oObj)
{
	triggerEvent("OX_Direct_Linking",sModule,oObj)
}

function resizePortalHeaders()
{		
	if(oPortalObject != null)
		oPortalObject.resize($('portal').offsetWidth);
}

function doAjaxMultiplePortalRequest(aRequests,callback)
{
	var multJson = new JSON();	
	var sAjaxRequest = AjaxRoot + '/multiple?session='+session;
	multJson.put(sAjaxRequest,aRequests,null,callback);
}

fileloaded();