/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

registerView("infostore_new",null,null,null,null);
register("OX_SAVE_OBJECT", writeNewInfoItem);
register("OX_Cancel_Object", cancelNewInfoItem);

var newInfoJson = new JSON();
var bCreated = false;
var bEditId = -1;
var clickedItem = -1;	
var bDetachFile = false;
var oCategories;
var treeVisible = false;
var oAttachModule = false;
var configGetKey=window.opener.configGetKey;
var configSetKey=window.opener.configSetKey;
var configContainsKey=window.opener.configContainsKey;
var setEditedFolder = false;
var savePending = false;
if(url['edit_id'] != -1)
{
	bEditId = {id:url['edit_id'],folder:url['folder']};
}

function infoFormChanged()
{
	setBeforeUnload(true);
}
function appendCombo()
{
	if(window.opener.configGetKey("global_categories"));
	{
		oCategories = new Categories(window.opener.configGetKey("global_categories"),window.opener.configGetKey("gui.private_categories"),'but_cat',
									document.forms.newInfoForm4.categories,'but_catregories','newinfoitem_categories_divContent');
		oCategories.getHTML();		
	}
}
var messageOnCancel = false;
var messageCloseWindow = _("Do you really want to discard your changes and close the window?");
/********************************** before on unload window *****************************************************************/
function unloadMessage(){
    return messageCloseWindow;
}

function setBeforeUnload(on){
    window.onbeforeunload = (on) ? unloadMessage : null;
    messageOnCancel = on;
}



/********************************** Ende before on unload *****************************************************************/

function detachFile()
{
	if(bActive)
	{
		document.forms.newInfoForm2.reset();
	}
	else
	{
		function cbyes() {
			document.forms.newInfoForm2.filedisplay.value = '';
			document.forms.newInfoForm3.document_type.value = '';				
			bDetachFile = true;
		}
		newConfirm(_("Detach file"),_('Are you sure you want to detach the file from current Info Item?\n (all versions of the file will be removed)'),AlertPopup.YESNO,null,null,cbyes);
	}
}

function doAjaxGetInfoItemObject(oId,callback)
{
	nId = parseInt(oId.id);
	var sAjaxRequest = AjaxRoot + "/infostore?action=get&id=" + nId + "&session=" + session;
	newInfoJson.get(sAjaxRequest, null,callback)
}
function fn_cb(sPAth)
{
	document.getElementById('folder').value = sPAth;
}
function newInfoItemOnLoad()
{
	activemodule="infostore_new";
	initContents(activemodule);
	appendCombo();
	initAll();
	window.setTimeout(function() {
		initNewInfoStore();
	},0);
}
var config;
var oMailInfo = null;
var configGetKey;

function initNewInfoStore() {
	loadingComplete();
	config = window.opener.config;
	configGetKey = window.opener.configGetKey;
	internalCache = window.opener.internalCache;
	session = window.opener.session;	
	
	var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };
    removeCSSFilesForNewWindow(themeStyle.path);
	loadCSSFileForNewWindow("themes/"+themeStyle.path+"/css/popup.css");
	
	document.forms.newInfoForm.folder.disabled = true;
	document.forms.newInfoForm3.document_type.disabled = true;		
	
	if(url['attachmodule'] && url['attid']>0 && url['attobjid']>0
														 && url['attobjfolder']>0)
	{
		oAttachModule = {objid:url['attobjid'],
						objfolder:url['attobjfolder'],
						attach:url['attid'],
						module:url['attachmodule']						
						};	
		var currForm  = document.forms.newInfoForm2;		
		currForm.filedisplay.value = url['filename'];			
		bEditId.folder = configGetKey("folder.infostore");
		
		window.opener.oMainFolderTree.get_folder_path(configGetKey("folder.infostore"),fn_cb);
		clickedItem = configGetKey("folder.infostore");
			
		// disable loading screen
        $("loading_data_bg").style.display="none";		
	}
	else if(url['attachmail'] && url['attachmail']>0)
	{
		var currForm  = document.forms.newInfoForm2;	
		currForm.filedisplay.value = url['filename'];
		oMailInfo = {mailid:url['mailid'],
						mailfolder:url['mailfolder'],
						attachmail:url['attachmail']};	
		bEditId.folder = configGetKey("folder.infostore");
		window.opener.oMainFolderTree.get_folder_path(configGetKey("folder.infostore"),fn_cb);
		clickedItem = configGetKey("folder.infostore");
		  
        // disable loading screen
        $("loading_data_bg").style.display="none";
	}
	else if(bEditId != -1)
	{
		initForm(bEditId);
		clickedItem = (bEditId!=-1)?bEditId.folder:url['folder'];		
	}
	else	
	{
		window.opener.oMainFolderTree.get_folder_path((bEditId!=-1)?bEditId.folder:url['folder'],fn_cb);
		clickedItem = (bEditId!=-1)?bEditId.folder:url['folder'];
		  
        // disable loading screen
        $("loading_data_bg").style.display="none";
	}
//	triggerEvent("OX_Configuration_Loaded");
	triggerEvent("OX_Switch_View","infostore_new");
	setTimeout(function (){triggerEvent("OX_menu_Change_Height",true)},0);;

}
registerView("infostore_new",
	null,
	function () {
		try {
			setTimeout(function() {	
				    if ($("title")) $("title").focus();	
				}, 50);
		} catch (e) { }	
	},
	null,
	null,
	function () {
		try {
			setTimeout(function() {  
                    if ($("title")) $("title").focus(); 
                }, 50);
		} catch (e) { }
	});

function cancelNewInfoItem() {
	function cbyes() {
		window.onbeforeunload=null;
		window.close();			
	}
	if (messageOnCancel)
		newConfirm(_("Close Window"),_(messageCloseWindow),AlertPopup.YESNO,null,null,cbyes,null);
	else
		cbyes();
}

function initForm(sId)
{
	var nTimeStamp;
	var aObjectContent;
	function cb_get_info_o(arg)
	{
		if(arg && arg.error)
		{
			return;
		}
		nTimeStamp = arg.timestamp;
		aObjectContent = arg.data;
		//activate detach button
		if(aObjectContent.filename && aObjectContent.filename.length > 0)
			document.getElementById('but_detach').style.display = 'block';
		populateForm(nTimeStamp,aObjectContent);
	}
	doAjaxGetInfoItemObject(sId,cb_get_info_o);
}


var nObjectTimeStamp;
var objectVersion;
function populateForm(nTimeStamp,aObjectContent)
{
	nObjectTimeStamp = nTimeStamp;	
	var currForm  = document.forms.newInfoForm;
	currForm.title.value = aObjectContent.title || "";
	currForm.url.value = aObjectContent.url || "";		
	window.opener.oMainFolderTree.get_folder_path(aObjectContent.folder_id,fn_cb);					
	var currForm  = document.forms.newInfoForm2;	
	currForm.filedisplay.value = aObjectContent.filename || "";
	currForm  = document.forms.newInfoForm3;
	currForm.document_type.value = aObjectContent.file_mimetype;
	currForm  = document.forms.newInfoForm4;
	currForm.categories.value = aObjectContent.categories;
	currForm  = document.forms.newInfoForm5;
	currForm.description.value = aObjectContent.description || "";	
	currForm.description.value = aObjectContent.description || ""; //ie7 fix #7577
    objectVersion = aObjectContent.version;
    
    // disable loading screen
    $("loading_data_bg").style.display="none";
}

var bActive = false;
function activateUpload()
{
	//disable dialog if mail attachment will saved
	if(oMailInfo)
		return ;
	if(!bActive)
	{
		document.getElementById('divfu2').style.display = 'none';
		document.getElementById('divfu1').style.display = 'inline';	
		document.getElementById('but_detach').style.display = 'block';					
		bActive = true;
	}
	else
	{
		document.getElementById('divfu1').style.display = 'none';
		document.getElementById('divfu2').style.display = 'inline';			
		bActive = false;
	}
}

function showTreeDialog()
{	
	document.getElementById("TreeDialogNewInfoStore").style.display = "block";
	if(!bCreated)
		loadFolderTreeInfo();
}

function hideTree(){
	document.getElementById("TreeDialogNewInfoStore").style.display = "none";	
}

function toggleTreeDialog()
{	
	if(!treeVisible){
		document.getElementById("TreeDialogNewInfoStore").style.display = "block";
		treeVisible = true;
		if(!bCreated) 
			{
			loadFolderTreeInfo();
			bCreated = true;
			}
	}
	else {
		document.getElementById("TreeDialogNewInfoStore").style.display = "none";
		treeVisible = false;
	}
}

function folderAction(ofolder)
{
	var setEditedFolder = true;
	hideTree();
	clickedItem = ofolder.oxfolder.data.id;
	window.opener.oMainFolderTree.get_folder_path(clickedItem,fn_cb);						
	infoFormChanged();
}


var aContextMenu = new Array();
var aFolderViewSettings = new Object();
var aFolderViewSettingsBM = new Object();
//Disable Email... 
aFolderViewSettings["default"] = 4;
aFolderViewSettingsBM["infostore"] = 8;
var disableOther=true;

function loadFolderTreeInfo()
{

	var oFolderTree = new cFolderTree($('folder_tree_info'),folderAction, false,
												window.opener.oMainFolderTree.cache,
												window.opener.optFolderState.getState('folder_tree_info'));
	oFolderTree.enabled_modules = {infostore:true};													
	oFolderTree.setSaveConfiguration(window.opener.optFolderState);
	oFolderTree.load();
	bCreated = true;
}


function callback_new(arg) {
	window.onbeforeunload=null;		
	if (arg.error) {
		savePending = false;
		newServerError(arg);
	} else {
		corewindow.OXInfoStoreMapping.createObject(newInfoItemToWrite);
		corewindow.triggerEvent("OX_Quota_Update");
		setTimeout(corewindow.closeInfoPopUp,50);
	}			
}

function callback_update(arg) {
	window.onbeforeunload=null;			
	if (arg.error) {
		savePending = false;
		newServerError(arg);
	} else {
		corewindow.OXCache.newRequest(null, "infostore", { columns: null,
            objects: [corewindow.OXInfoStoreMapping.createKeyFromObject({
                module: "infostore", folder_id: bEditId.folder,
                id: bEditId.id
            })] }, null, emptyFunction, true);
        corewindow.triggerEvent("OX_Quota_Update");
        setTimeout(corewindow.closeInfoPopUp,50);
	}
}

var newInfoItemToWrite;
function writeNewInfoItem() {	
	if(savePending) return;
	else savePending = true;
	
	var currForm  = document.forms.newInfoForm;
	var oObject = new Object();	
	oObject = getFormDataAsObject(currForm,oObject);
	currForm  = document.forms.newInfoForm2;	
	oObject = getFormDataAsObject(currForm,oObject);
	currForm  = document.forms.newInfoForm3;	
	oObject = getFormDataAsObject(currForm,oObject);
	currForm  = document.forms.newInfoForm4;	
	oObject = getFormDataAsObject(currForm,oObject);	
	currForm  = document.forms.newInfoForm5;	
	newInfoItemToWrite = getFormDataAsObject(currForm,oObject);	

	if(document.forms.newInfoForm2.file.value.length > 0 || oMailInfo || oAttachModule) {
		displayInputNoticeDialog();
        objectVersion++;
	} else {
		doStoreInfoItem();
        objectVersion = null;
    }
}

function displayInputNoticeDialog()
{
	newInput(_("Version comment"),"",_("Enter your version comment:"),null,			CreatePopup.VERSION,
											OKInputNotice,cancelInputNotice,null,cancelInputNotice,'textarea',NOCommentInput);
	//document.getElementById('inputNoticeDialog').style.display ='block';
}

function closeInputNoticeDialog()
{
	savePending = false;
	//document.getElementById('inputNoticeDialog').style.display ='none';
	CreatePopup.close(); //todo: ask jan, this may isn't the best way to close it ;)
}

function cancelInputNotice()
{
	savePending = false;
	//closeInputNoticeDialog();
}
function NOCommentInput(){
	savePending = false;
	$("create_window_textarea_field").value = "";
	OKInputNotice();
}
function OKInputNotice()
{
	//newInfoItemToWrite['version_comment'] = document.forms.inputNoticeForm.notice.value;
	newInfoItemToWrite['version_comment'] = $("create_window_textarea_field").value;
	doStoreInfoItem();
	closeInputNoticeDialog();	
}
function CancelInputNotice()
{
	savePending = false;
	document.forms.inputNoticeForm.notice.value = "";
	doStoreInfoItem();
	closeInputNoticeDialog();	
}

function doStoreInfoItem()
{
	if(oMailInfo || oAttachModule)
	{
		if(!newInfoItemToWrite.folder_id)
		{
			savePending = false;
			alert(_('Please set valid folder!'));
			return;
		}		
		function callback_attach(arg)
		{
			window.onbeforeunload=null;			
			if(arg.error)
			{
				savePending = false;
				newServerError(arg);
			}
			else
			{	
				setTimeout(window.opener.closeInfoPopUp,50);
			}
		}
		if(oAttachModule)
			doAjaxRequestAttachInfoMail(oAttachModule,clickedItem,callback_attach);
		else			
			doAjaxRequestAttachInfoMail(oMailInfo,clickedItem,callback_attach);			
	}
	else if(bEditId != -1)
	{
		nId = parseInt(bEditId.id);
		function cb_detach_files(arg)
		{	
			window.onbeforeunload=null;						
			if(arg && arg.error)
			{
				savePending = false;
				newServerError(arg);				
			}
			else
			{	
				document.forms.newInfoForm2.action = AjaxRoot + "/infostore?action=update&id="+nId+"&timestamp="+arg.timestamp+"&session=" + session;		
				document.forms.newInfoForm2.json.value = JSON.serialize(newInfoItemToWrite);			
				document.forms.newInfoForm2.submit();
			}
		}
		if(bDetachFile)
		{
			bDetachFile = false;
			doAjaxDetachInfoFile(bEditId, nObjectTimeStamp, cb_detach_files);
		}
		else
		{
			var obj = new Object();
			obj['timestamp'] = nObjectTimeStamp;
			cb_detach_files(obj);
		}
	}
	else
	{
		document.forms.newInfoForm2.action = AjaxRoot + '/infostore?action=new'+"&timestamp="+nObjectTimeStamp+"&session=" + session;
		document.forms.newInfoForm2.json.value = JSON.serialize(newInfoItemToWrite);		
		document.forms.newInfoForm2.submit();
	}	
}

function doAjaxDetachInfoFile(oObj, nTimeStamp, callback) {
	var sAjaxRequest = AjaxRoot + "/infostore?action=revert&id="+oObj.id+"&folder="+oObj.folder+"&timestamp="+nTimeStamp+"&session=" + session;
	newInfoJson.get(sAjaxRequest, null,callback);			
}

function doAjaxRequestAttachInfoMail(mailinfo,folder,callback) {
	delete newInfoItemToWrite.filename;	
	var sAjaxRequest;	
	if (mailinfo.mailid != undefined)	{
		sAjaxRequest = AjaxRoot + "/mail?action=attachment"
		      + "&id=" + mailinfo.mailid
		      + "&folder=" + mailinfo.mailfolder 
		      + "&dest_folder=" + folder
		      + "&attachment=" + mailinfo.attachmail
		      + "&session=" + session;
	} else {						
		sAjaxRequest = AjaxRoot + "/infostore?action=saveAs"
		      + "&attached=" + mailinfo.objid
		      + "&folder=" + mailinfo.objfolder
		      + "&attachment=" + mailinfo.attach
		      + "&module=" + mailinfo.module
		      + "&session=" + session;
	}	
	newInfoJson.put(sAjaxRequest, newInfoItemToWrite, null,callback);		
}

/*
function doAjaxRequestCreateNewInfo(newInfoItem,callback)
{
	var sAjaxRequest = AjaxRoot + "/infostore?action=new&session=" + session;
	newInfoJson.put(sAjaxRequest, newInfoItem, null,callback);		
}
*/
function getFormDataAsObject(currForm,oParamObj)  
{
	for(var nIndex=0;nIndex < currForm.elements.length;nIndex++)
	{
		var currElement = currForm.elements[nIndex];
		var aTMP = currElement.id.split('_');
		var sId = currElement.id;
		//disable buttons, folderpath; section categories must be implemented
		if(aTMP[0] == 'but' || sId == 'folderpath' || sId == 'document_type'
							|| sId == 'displfile' || sId == 'json' || sId == 'file' || sId == 'cancelNewAppointmentTreeButton')
			continue;	
		var sValue = currElement.value;
		if(sId == 'folder')
		{
			sId = 'folder_id';
			// please check the conditions! if you uncomment this, you can't move
			// the object to any other folder at the new window as it's always true!?
			//if(clickedItem == -1 || (!setEditedFolder && bEditId != -1))
			//	continue;
			sValue = clickedItem;
		}
		if(sId == 'filepath')
		{
			sId = 'filename';	
			sValue = separateFilenameFromPath(sValue);
		}
		if(sId == 'categories')
		{
			 sValue = getCatArrayFromString(sValue);
		}
		if(sValue && sValue.length == 0)
			continue;
		oParamObj[sId] = sValue;	
	}
	return oParamObj;
}