/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var config_tags_categories_private=new Array();
var config_tags_currentcategory=-1;

registerView("configuration/tags",
	function() { 
		showNode("config_tags"); 
		$("config_tags").style.display="block"; },
	function() { 
 	    register("OX_SAVE_OBJECT",config_tags_saveConfiguration);
		register("OX_Cancel_Object",config_tags_cancelConfiguration);
		register("OX_Configuration_Categories_Add",config_tags_addCategory);
		register("OX_Configuration_Categories_Edit",config_tags_editCategory);
		register("OX_Configuration_Categories_Remove",config_tags_removeCategory);
		resizeEvents.register("Resized",setDynamicHeighConfigTag);
		config_tags_enter(); 
	},
	function() { 
		//configuration_askforSave();
 	    unregister("OX_SAVE_OBJECT",config_tags_saveConfiguration);
		unregister("OX_Cancel_Object",config_tags_cancelConfiguration);
		unregister("OX_Configuration_Categories_Add",config_tags_addCategory);
		unregister("OX_Configuration_Categories_Edit",config_tags_editCategory);
		unregister("OX_Configuration_Categories_Remove",config_tags_removeCategory);
		resizeEvents.unregister("Resized",setDynamicHeighConfigTag);

		config_tags_leave();
	},
	function() { 
		hideNode("config_tags"); 
		$("config_tags").style.display="none"; },
	function() { config_tags_enter(); }
);

function config_tags_saveConfiguration() {
	if(configuration_changed_fields["gui"]) {
 		configSetKey("gui.private_categories",config_tags_categories_private.join(","));
	}
	triggerEvent("OX_Save_Configuration",false,false);
} 
function config_tags_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	config_tags_enter();
} 
function config_tags_enter () {
	config_tags_categories_private=new Array();
	if(configContainsKey("gui.private_categories") && configGetKey("gui.private_categories")!="") {
		config_tags_categories_private=configGetKey("gui.private_categories").split(",");
	}
	config_tags_fillCategory();
	if(config_tags_categories_private.length>0) {
		config_tags_selectCategory(document.getElementById("Tag-0"));
	}
	$("config_tags_header").firstChild.nodeValue=getconfigPathSelected().substring(1);
}
function config_tags_leave() {
}
function setDynamicHeighConfigTag() {
	$("cs_parenttable_categories_private").style.height = $("cs_parenttable_categories_private").parentNode.offsetHeight -1 + "px";
}
function checkDuplicate(myname) {
	for(var i=0;i<config_tags_categories_private.length;i++) {
		if(config_tags_categories_private[i]==myname) return true;
	}
	return false;
}
function config_tags_addCategory() {	
	openTagsWindow("",config_tags_newCategory, null, true);
}
function config_tags_editCategory() {	
	openTagsWindow(config_tags_categories_private[config_tags_currentcategory],config_tags_changeCategory);
}
function ConfigTags() {
	this.cbok;
	this.cbcancel;
}
ConfigTags.open = function () {
	showNode("disable_background_window");
	$("disable_background_window").style.display="block";
	showNode("config_popups_win");
	$("config_popups_win").style.display="block";
	showNode("window_tags");
	centerPopupWindow($("window_tags"));
	$("window_tags").style.display="block";
	$("tags_window_tags_input").focus();
}
ConfigTags.close = function () {
	if(this.closecb) { globalalert.cbclose(); }
	hideNode("window_tags");
	$("window_tags").style.display="none";
	hideNode("config_popups_win");
	$("config_popups_win").style.display="none";
	var childs=	$("disable_background_window").childNodes;
	var closeall=true;
	for(var i=0;i<childs.length;i++) {
		if(childs[i].tagName && childs[i].tagName == "DIV") {
			if(childs[i].style.display && childs[i].style.display!= "none" ) {
				closeall=false;
			}
		}
	}
	if(closeall) {
		hideNode("disable_background_window");
		$("disable_background_window").style.display="none";
	}
}
ConfigTags.commitcancel = function () {
	if(configtags.cbcancel) { configtags.cbcancel(); }
	ConfigTags.close();
}
ConfigTags.commitok = function () {
	if (!$("tags_window_tags_input").value) return;
	if(configtags.cbok) { configtags.cbok(); }
	ConfigTags.close();
}

ConfigTags.change = function() {
	setTimeout(function() {
		$("tags_window_tags_ok").style.color =
			$("tags_window_tags_input").value ? "black" : "#aaaaaa";
	}, 0);
}

register("Loaded", function () {
	addOnClose($("window_tags"),function() { ConfigTags.close() }); 
	}
);
var configtags=new ConfigTags();
function openTagsWindow(tagnamevalue,cbok,cbcancel, isNew) {
	$("tags_window_tags_input").value=tagnamevalue;
	ConfigTags.change();
	$("window_tags.prompt").firstChild.data = isNew ? _("New Tag:")
	                                                : _("Edit Tag:");
	configtags.cbok=cbok;
	configtags.cbcancel=cbcancel;
	ConfigTags.open();
} 
function config_tags_newCategory() {
	var tmptag=$("tags_window_tags_input").value;
	if(checkDuplicate(tmptag)) {
		triggerEvent("OX_New_Error",4,_("This Tag already exists in your private tag list"));
	} else {
		config_tags_categories_private.push(tmptag);
		configuration_changed_fields["gui"]=true;
		config_tags_fillCategory();
		config_tags_selectCategory(document.getElementById("Tag-"+(config_tags_categories_private.length-1)));
	}
}
function config_tags_changeCategory() {
	var tmptag=$("tags_window_tags_input").value;
	if(checkDuplicate(tmptag)) {
		if(tmptag!=config_tags_categories_private[config_tags_currentcategory]) {
			triggerEvent("OX_New_Error",4,_("This Tag already exists in your private tag list"));
		}
	} else {
		config_tags_categories_private[config_tags_currentcategory]=tmptag;
		configuration_changed_fields["gui"]=true;
		config_tags_fillCategory();
		config_tags_selectCategory(document.getElementById("Tag-"+(config_tags_currentcategory)));
	}
}
function config_tags_removeCategory() {
	config_tags_categories_private.splice(parseInt(config_tags_currentcategory),1);
	config_tags_fillCategory();
	if(config_tags_categories_private.length>0) {
		config_tags_selectCategory(document.getElementById("Tag-0"));
	}
	configuration_changed_fields["gui"]=true;
}

function config_tags_fillCategory() {
	removeChildNodes($("cs_categories_private"));
	for(var i=0;i<config_tags_categories_private.length;i++) {
		var newcat=$("cs_template_private_row").cloneNode("false");
		var textnode=document.createTextNode(config_tags_categories_private[i]);
		newcat.id="Tag-"+i;
		newcat.appendChild(textnode);
		$("cs_categories_private").appendChild(newcat);	
	}
	triggerEvent("SubSelected",0);	
}
function config_tags_selectCategory(param) {
	var allcategories = param.parentNode.getElementsByTagName("div");
	for (var i=0;i<allcategories.length;i++) {
		allcategories[i].className = removeClass(allcategories[i].className,"background-color-PMG-selection-elements");
	}
	param.className += " background-color-PMG-selection-elements";
	config_tags_currentcategory=param.id.split("-")[1];
	triggerEvent("SubSelected",1);	
}
fileloaded();