/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

/**
 * Creates a categories widget inside the specified DOM element.
 * @class A basic categories class.
 * @param {Array} Array filled with entries fo selection box
 * @param {Object} id of the DOM element to which the categories will be attached
 * @param {Object] id of the DOM Input text element which be filled with categorie strings
 * @param {Object] id of the DOM Input button which be clicked
 * {@link getState}.
 * will be added.
 */

function Categories(globalList,privateList,sDomElementId,DOMInput,sDomButtonId, divForOverflow)
{
	this.aGlobal = (globalList.length>0)?globalList.split(','):new Array();
	this.aPrivate = (privateList.length>0)?privateList.split(','):new Array();	
	this.aObjectReferItems = new Array();

	this.aRefDiv = new Array();
	
	this.aSelected = new Object();
		
	this.aIdAssoc = new Object();
		
	this.sContainerId = sDomElementId;
	this.sButtonId = sDomButtonId;
	this.mainDiv = null;
	this.inputField = DOMInput;
	this.divForOverflow = divForOverflow;
}

Categories.prototype = {
	getList : function ()
	{
		return this.aGlobal;
	},
	getHTML : function ()
	{		
		var thisSelf = this;	
		thisSelf.createMenu();
		function openDialog()
		{			
			var sString = thisSelf.inputField.value;
			var aEntries = sString.split(',');

			//trim blanks and match entries in main list
			for(var ind=0;ind < aEntries.length;ind++)
			{
				aEntries[ind]= trimStr(aEntries[ind]);		
				var bMatch = false;				
				for(var nMatchInd=0;nMatchInd<thisSelf.aGlobal.length;nMatchInd++)
				{
					if(aEntries[ind] == thisSelf.aGlobal[nMatchInd])
					{			
						var sId = 'sel_'+nMatchInd;
						thisSelf.aSelected[sId] = true;
						document.getElementById(sId).className += ' background-color-PMG-selection-elements';
						bMatch = true;
						break;
					}
				}
				for(var nMatchInd=0;nMatchInd<thisSelf.aPrivate.length;nMatchInd++)
				{
					if(aEntries[ind] == thisSelf.aPrivate[nMatchInd])
					{			
						var sId = 'sel_'+(nMatchInd + thisSelf.aGlobal.length);
						thisSelf.aSelected[sId] = true;
						document.getElementById(sId).className += ' background-color-PMG-selection-elements';
						bMatch = true;
						break;
					}
				}
				if(!bMatch && aEntries[ind].length>0 && !inArray(aEntries[ind],thisSelf.aObjectReferItems))
				{					
					var addTR = thisSelf.getTR (aEntries[ind],(thisSelf.aObjectReferItems.length + thisSelf.aGlobal.length + thisSelf.aPrivate.length),'background-color-PMG-selection-elements');
					var sNewId = 'sel_'+(thisSelf.aObjectReferItems.length + thisSelf.aGlobal.length + thisSelf.aPrivate.length);
					thisSelf.aObjectReferItems.push(aEntries[ind]);					
					thisSelf.tableSt.appendChild(addTR);	
					thisSelf.aSelected[sNewId] = true;	
				}
				else if(!bMatch && aEntries[ind].length>0)
				{
					for(nIndx=0;nIndx<thisSelf.aObjectReferItems.length;nIndx++)
					{						
						var sId = 'sel_' + (nIndx + thisSelf.aGlobal.length + thisSelf.aPrivate.length);
						if(aEntries[ind] == thisSelf.aObjectReferItems[nIndx])
						{																											
							thisSelf.aSelected[sId] = true;
							document.getElementById(sId).className += ' background-color-PMG-selection-elements';							
							break;							
						}			
					}
				}				
			}							
			document.getElementById(thisSelf.sContainerId).style.display = 'block';
			document.getElementById(thisSelf.divForOverflow).className = 'listDialogueDivOverflow background-color-content';
			var posDif = 18*pxPerEm - document.getElementById(thisSelf.sContainerId).offsetTop;
			if(posDif < 0)
			{
				document.getElementById(thisSelf.sContainerId).style.top = 
							(document.getElementById(thisSelf.sContainerId).offsetTop - 18*pxPerEm) + "px";
			}
		}		
		var bButton = document.getElementById(this.sButtonId);
		addDOMEvent(bButton, "click", openDialog);		
	},
	createMenu: function ()
	{
		var oTableMain = document.getElementById("categoryTbody");
		this.tableSt = oTableMain;
		for(var nIndex=0;nIndex<this.aGlobal.length;nIndex++)
		{
			oCurrentTR = this.getTR(this.aGlobal[nIndex],nIndex,'');
			oTableMain.appendChild(oCurrentTR);								
		}
		for(var nIndex=0;nIndex<this.aPrivate.length;nIndex++)
		{
			oCurrentTR = this.getTR(this.aPrivate[nIndex],nIndex+this.aGlobal.length,'');
			oTableMain.appendChild(oCurrentTR);								
		}
		var thisSelf = this;		
		function addItems()
		{		
			var sDisplayCatString = '';
			for(key in thisSelf.aSelected)
			{
				if(thisSelf.aSelected[key])
					sDisplayCatString += thisSelf.getEntryById(key) + ', ';	
			}			

			thisSelf.inputField.value = sDisplayCatString.slice(0,sDisplayCatString.length-2);
			document.getElementById(thisSelf.sContainerId).style.display = 'none';
			thisSelf.inputField.focus();
			thisSelf.resetSelection();
		}
		addDOMEvent(document.getElementById("addNewInfoListButton"), "click", addItems);			
	},
	getTR : function (sLabel,nIndex,CSSClass)
	{
		var thisSelf = this;
		var oCurrentDIV = newnode('div',{cursor: "pointer"},{className: ' '+ CSSClass,id:sId});		
		var oCurrentTR = newnode('tr');		
		var sTRId = 'seltr_'+nIndex;		
		oCurrentTR.id = sTRId;
		var oCurrentTD = newnode('td');					
		var sId = 'sel_'+nIndex;
		oCurrentDIV.id = sId;		
		this.aIdAssoc[sId] = sLabel;
		function handleItem(e)
		{
			var DOMTarget = (e.target)?e.target:e.srcElement;		
			if(!thisSelf.aSelected[DOMTarget.id])
			{
				thisSelf.aSelected[DOMTarget.id] = true;			
				DOMTarget.className += ' background-color-PMG-selection-elements';
			}
			else							
			{							
				DOMTarget.className = removeClass(DOMTarget.className,'background-color-PMG-selection-elements');
				thisSelf.aSelected[DOMTarget.id] = false;
			}				
		}		
		addDOMEvent(oCurrentDIV, "click", handleItem);						
		oCurrentDIV.innerHTML = sLabel;
		oCurrentTD.appendChild(oCurrentDIV);
		oCurrentTR.appendChild(oCurrentTD);
		this.aRefDiv.push(oCurrentDIV);
		return oCurrentTR;
	},
	resetSelection: function ()
	{
		this.aSelected = new Object();	
		for(nIndex=0;nIndex<this.aRefDiv.length;nIndex++)
		{
			this.aRefDiv[nIndex].className = removeClass(this.aRefDiv[nIndex].className,'background-color-PMG-selection-elements');
		}
	},
	getEntryById: function (sId)
	{
		return this.aIdAssoc[sId];
	}
}
function inArray(value, array)
{
	for(var i=0;i<array.length;i++)
	{
		if(array[i] == value)
			return true;
	}
	return false;
}

function getCatArrayFromString(sString)
{
	var aEntries = sString.split(',');
	var aNew = new Array();
	for(var ind=0;ind < aEntries.length;ind++)
	{
		var sStr = trimStr(aEntries[ind]);
		if(sStr.length > 0)
			aNew[aNew.length]= sStr;	
	}
	return aNew;
}
